
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class ChatBannedRights(TLObject, family='TypeChatBannedRights'):
    """
    Represents the rights of a normal user in a [supergroup/channel/chat](https://core.telegram.org/api/channel). In this case, the flags are inverted: if set, a flag does not allow a user to do X.
    """

    _id = 0X9F120418
    _group_id = 0XDB47663A

    def __init__(
        self,
        until_date: int,
        view_messages: bool = False,
        send_messages: bool = False,
        send_media: bool = False,
        send_stickers: bool = False,
        send_gifs: bool = False,
        send_games: bool = False,
        send_inline: bool = False,
        embed_links: bool = False,
        send_polls: bool = False,
        change_info: bool = False,
        invite_users: bool = False,
        pin_messages: bool = False,
        manage_topics: bool = False,
        send_photos: bool = False,
        send_videos: bool = False,
        send_roundvideos: bool = False,
        send_audios: bool = False,
        send_voices: bool = False,
        send_docs: bool = False,
        send_plain: bool = False
    ):

        """
        Represents the rights of a normal user in a [supergroup/channel/chat](https://core.telegram.org/api/channel). In this case, the flags are inverted: if set, a flag does not allow a user to do X.

        Args:
            until_date (int): Validity of said permissions (it is considered forever any value less then 30 seconds or more then 366 days).
            view_messages (bool, optional): If set, does not allow a user to view messages in a [supergroup/channel/chat](https://core.telegram.org/api/channel)
            send_messages (bool, optional): If set, does not allow a user to send messages in a [supergroup/chat](https://core.telegram.org/api/channel)
            send_media (bool, optional): If set, does not allow a user to send any media in a [supergroup/chat](https://core.telegram.org/api/channel)
            send_stickers (bool, optional): If set, does not allow a user to send stickers in a [supergroup/chat](https://core.telegram.org/api/channel)
            send_gifs (bool, optional): If set, does not allow a user to send gifs in a [supergroup/chat](https://core.telegram.org/api/channel)
            send_games (bool, optional): If set, does not allow a user to send games in a [supergroup/chat](https://core.telegram.org/api/channel)
            send_inline (bool, optional): If set, does not allow a user to use inline bots in a [supergroup/chat](https://core.telegram.org/api/channel).
            embed_links (bool, optional): If set, does not allow a user to embed links in the messages of a [supergroup/chat](https://core.telegram.org/api/channel)
            send_polls (bool, optional): If set, does not allow a user to send polls in a [supergroup/chat](https://core.telegram.org/api/channel)
            change_info (bool, optional): If set, does not allow any user to change the description of a [supergroup/chat](https://core.telegram.org/api/channel)
            invite_users (bool, optional): If set, does not allow any user to invite users in a [supergroup/chat](https://core.telegram.org/api/channel)
            pin_messages (bool, optional): If set, does not allow any user to pin messages in a [supergroup/chat](https://core.telegram.org/api/channel)
            manage_topics (bool, optional): If set, does not allow any user to create, delete or modify [forum topics](https://core.telegram.org/api/forum#forum-topics).
            send_photos (bool, optional): If set, does not allow a user to send photos in a [supergroup/chat](https://core.telegram.org/api/channel).
            send_videos (bool, optional): If set, does not allow a user to send videos in a [supergroup/chat](https://core.telegram.org/api/channel).
            send_roundvideos (bool, optional): If set, does not allow a user to send round videos in a [supergroup/chat](https://core.telegram.org/api/channel).
            send_audios (bool, optional): If set, does not allow a user to send audio files in a [supergroup/chat](https://core.telegram.org/api/channel).
            send_voices (bool, optional): If set, does not allow a user to send voice messages in a [supergroup/chat](https://core.telegram.org/api/channel).
            send_docs (bool, optional): If set, does not allow a user to send documents in a [supergroup/chat](https://core.telegram.org/api/channel).
            send_plain (bool, optional): If set, does not allow a user to send text messages in a [supergroup/chat](https://core.telegram.org/api/channel).
        """

        self.until_date = until_date
        self.view_messages = view_messages
        self.send_messages = send_messages
        self.send_media = send_media
        self.send_stickers = send_stickers
        self.send_gifs = send_gifs
        self.send_games = send_games
        self.send_inline = send_inline
        self.embed_links = embed_links
        self.send_polls = send_polls
        self.change_info = change_info
        self.invite_users = invite_users
        self.pin_messages = pin_messages
        self.manage_topics = manage_topics
        self.send_photos = send_photos
        self.send_videos = send_videos
        self.send_roundvideos = send_roundvideos
        self.send_audios = send_audios
        self.send_voices = send_voices
        self.send_docs = send_docs
        self.send_plain = send_plain

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x18\x04\x12\x9f' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.view_messages, 0)
                flags(self.send_messages, 1)
                flags(self.send_media, 2)
                flags(self.send_stickers, 3)
                flags(self.send_gifs, 4)
                flags(self.send_games, 5)
                flags(self.send_inline, 6)
                flags(self.embed_links, 7)
                flags(self.send_polls, 8)
                flags(self.change_info, 10)
                flags(self.invite_users, 15)
                flags(self.pin_messages, 17)
                flags(self.manage_topics, 18)
                flags(self.send_photos, 19)
                flags(self.send_videos, 20)
                flags(self.send_roundvideos, 21)
                flags(self.send_audios, 22)
                flags(self.send_voices, 23)
                flags(self.send_docs, 24)
                flags(self.send_plain, 25)
                writer.int(self.until_date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        until_date_ = reader.int()

        return cls(
            until_date=until_date_,
            view_messages=flags(0),
            send_messages=flags(1),
            send_media=flags(2),
            send_stickers=flags(3),
            send_gifs=flags(4),
            send_games=flags(5),
            send_inline=flags(6),
            embed_links=flags(7),
            send_polls=flags(8),
            change_info=flags(10),
            invite_users=flags(15),
            pin_messages=flags(17),
            manage_topics=flags(18),
            send_photos=flags(19),
            send_videos=flags(20),
            send_roundvideos=flags(21),
            send_audios=flags(22),
            send_voices=flags(23),
            send_docs=flags(24),
            send_plain=flags(25)
        )

TypeChatBannedRights = ChatBannedRights