
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .business_bot_rights import TypeBusinessBotRights
    from ...gadgets.byteutils import Reader
    from .business_bot_recipients import TypeBusinessBotRecipients


class ConnectedBot(TLObject, family='TypeConnectedBot'):
    """
    Contains info about a [connected business bot](https://core.telegram.org/api/business#connected-bots).
    """

    _id = 0XCD64636C
    _group_id = 0X3773058C

    def __init__(
        self,
        bot_id: int,
        recipients: 'TypeBusinessBotRecipients',
        rights: 'TypeBusinessBotRights'
    ):

        """
        Contains info about a [connected business bot](https://core.telegram.org/api/business#connected-bots).

        Args:
            bot_id (int): ID of the connected bot
            recipients ('TypeBusinessBotRecipients'): Specifies the private chats that a [connected business bot](https://core.telegram.org/api/business#connected-bots) may receive messages and interact with.
            rights ('TypeBusinessBotRights'): ...
        """

        self.bot_id = bot_id
        self.recipients = recipients
        self.rights = rights

    def to_bytes(self, boxed: bool=True):
        with Writer(b'lcd\xcd' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.bot_id)
                writer.object(
                    self.recipients,
                    group_id=0XBB9249E9
                )
                writer.object(
                    self.rights,
                    group_id=0XD14AA447
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        bot_id_ = reader.long()
        recipients_ = reader.object(
            group_id=0XBB9249E9
        )

        rights_ = reader.object(
            group_id=0XD14AA447
        )

        return cls(
            bot_id=bot_id_,
            recipients=recipients_,
            rights=rights_
        )

TypeConnectedBot = ConnectedBot