
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Union
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..user import TypeUser
    from ..contact import TypeContact
    from ....gadgets.byteutils import Reader


class ContactsNotModified(TLObject, family='TypeContactsContacts'):
    """
    Contact list on the server is the same as the list on the client.
    """

    _id = 0XB74BA9D2
    _group_id = 0XB3FAC2EB


    def to_bytes(self, boxed: bool=True):
        return b'\xd2\xa9K\xb7' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class Contacts(TLObject, family='TypeContactsContacts'):
    """
    The current user's contact list and info on users.
    """

    _id = 0XEAE87E42
    _group_id = 0XB3FAC2EB

    def __init__(
        self,
        contacts: List['TypeContact'],
        saved_count: int,
        users: List['TypeUser']
    ):

        """
        The current user's contact list and info on users.

        Args:
            contacts (List['TypeContact']): Contact list
            saved_count (int): Number of contacts that were saved successfully
            users (List['TypeUser']): User list
        """

        self.contacts = contacts
        self.saved_count = saved_count
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'B~\xe8\xea' if boxed else b'') as writer:
            writer.vector(
                self.contacts,
                lambda value: writer.object(
                    value,
                    group_id=0XDFA7DCC8
                )
            )
            writer.int(self.saved_count)
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        contacts_ = reader.vector(
            lambda: reader.object(
                group_id=0XDFA7DCC8
            )
        )

        saved_count_ = reader.int()
        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            contacts=contacts_,
            saved_count=saved_count_,
            users=users_
        )

TypeContactsContacts = Union[
    ContactsNotModified,
    Contacts
]