
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ....gadgets.byteutils import Reader


class CollectibleInfo(TLObject, family='TypeFragmentCollectibleInfo'):
    """
    Info about a [fragment collectible](https://core.telegram.org/api/fragment).
    """

    _id = 0X6EBDFF91
    _group_id = 0X7729CB9D

    def __init__(
        self,
        purchase_date: int,
        currency: str,
        amount: int,
        crypto_currency: str,
        crypto_amount: int,
        url: str
    ):

        """
        Info about a [fragment collectible](https://core.telegram.org/api/fragment).

        Args:
            purchase_date (int): Purchase date (unixtime)
            currency (str): Three-letter ISO 4217 [currency](https://core.telegram.org/bots/payments#supported-currencies) code for amount
            amount (int): Total price in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
            crypto_currency (str): Cryptocurrency name.
            crypto_amount (int): Price, in the smallest units of the cryptocurrency.
            url (str): [Fragment](https://fragment.com) URL with more info about the collectible
        """

        self.purchase_date = purchase_date
        self.currency = currency
        self.amount = amount
        self.crypto_currency = crypto_currency
        self.crypto_amount = crypto_amount
        self.url = url

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x91\xff\xbdn' if boxed else b'') as writer:
            writer.int(self.purchase_date)
            writer.string(self.currency)
            writer.long(self.amount)
            writer.string(self.crypto_currency)
            writer.long(self.crypto_amount)
            writer.string(self.url)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        purchase_date_ = reader.int()
        currency_ = reader.string()
        amount_ = reader.long()
        crypto_currency_ = reader.string()
        crypto_amount_ = reader.long()
        url_ = reader.string()

        return cls(
            purchase_date=purchase_date_,
            currency=currency_,
            amount=amount_,
            crypto_currency=crypto_currency_,
            crypto_amount=crypto_amount_,
            url=url_
        )

TypeFragmentCollectibleInfo = CollectibleInfo