
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer_color_set import TypeHelpPeerColorSet
    from ....gadgets.byteutils import Reader


class PeerColorOption(TLObject, family='TypeHelpPeerColorOption'):
    """
    Contains info about a [color palette](https://core.telegram.org/api/colors).
    """

    _id = 0XADEC6EBE
    _group_id = 0X77C6DB76

    def __init__(
        self,
        color_id: int,
        hidden: bool = False,
        colors: Optional['TypeHelpPeerColorSet'] = None,
        dark_colors: Optional['TypeHelpPeerColorSet'] = None,
        channel_min_level: Optional[int] = None,
        group_min_level: Optional[int] = None
    ):

        """
        Contains info about a [color palette](https://core.telegram.org/api/colors).

        Args:
            color_id (int): Palette ID.
            hidden (bool, optional): Whether this palette should not be displayed as an option to the user when choosing a palette to apply to profile pages or message accents.
            colors (Optional['TypeHelpPeerColorSet'], optional): Light mode palette. Will be empty for IDs 0 to 6 inclusive, in which case a palette containing a single color from the following colors should be used: red, orange, violet, green, cyan, blue, pink for indexes 0 to 6 (i.e. the same colors used for randomized fallback [message accent colors](https://core.telegram.org/api/colors)).
            dark_colors (Optional['TypeHelpPeerColorSet'], optional): Dark mode palette. Optional, defaults to the palette in colors (or the autogenerated palette for IDs 0 to 6) if absent.
            channel_min_level (Optional[int], optional): Channels can use this palette only after reaching at least the [boost level](https://core.telegram.org/api/boost) specified in this field.
            group_min_level (Optional[int], optional): Supergroups can use this palette only after reaching at least the [boost level](https://core.telegram.org/api/boost) specified in this field.
        """

        self.color_id = color_id
        self.hidden = hidden
        self.colors = colors
        self.dark_colors = dark_colors
        self.channel_min_level = channel_min_level
        self.group_min_level = group_min_level

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xben\xec\xad' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.hidden, 0)
                writer.int(self.color_id)

                if flags(self.colors, 1):
                    writer.object(
                        self.colors,
                        group_id=0XE655D80C
                    )

                if flags(self.dark_colors, 2):
                    writer.object(
                        self.dark_colors,
                        group_id=0XE655D80C
                    )

                if flags(self.channel_min_level, 3):
                    writer.int(self.channel_min_level)

                if flags(self.group_min_level, 4):
                    writer.int(self.group_min_level)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        color_id_ = reader.int()
        colors_ = (
            reader.object(
                group_id=0XE655D80C
            )
            if flags(1) else None
        )

        dark_colors_ = (
            reader.object(
                group_id=0XE655D80C
            )
            if flags(2) else None
        )

        channel_min_level_ = (
            reader.int()
            if flags(3) else None
        )

        group_min_level_ = (
            reader.int()
            if flags(4) else None
        )

        return cls(
            color_id=color_id_,
            hidden=flags(0),
            colors=colors_,
            dark_colors=dark_colors_,
            channel_min_level=channel_min_level_,
            group_min_level=group_min_level_
        )

TypeHelpPeerColorOption = PeerColorOption