
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader
    from .input_business_recipients import TypeInputBusinessRecipients


class InputBusinessGreetingMessage(TLObject, family='TypeInputBusinessGreetingMessage'):
    """
    Describes a [Telegram Business greeting](https://core.telegram.org/api/business#greeting-messages), automatically sent to new users writing to us in private for the first time, or after a certain inactivity period.
    """

    _id = 0X194CB3B
    _group_id = 0X604B1D32

    def __init__(
        self,
        shortcut_id: int,
        recipients: 'TypeInputBusinessRecipients',
        no_activity_days: int
    ):

        """
        Describes a [Telegram Business greeting](https://core.telegram.org/api/business#greeting-messages), automatically sent to new users writing to us in private for the first time, or after a certain inactivity period.

        Args:
            shortcut_id (int): ID of a [quick reply shorcut, containing the greeting messages to send, see here  for more info](https://core.telegram.org/api/business#quick-reply-shortcuts).
            recipients ('TypeInputBusinessRecipients'): Allowed recipients for the greeting messages.
            no_activity_days (int): The number of days after which a private chat will be considered as inactive; currently, must be one of 7, 14, 21, or 28.
        """

        self.shortcut_id = shortcut_id
        self.recipients = recipients
        self.no_activity_days = no_activity_days

    def to_bytes(self, boxed: bool=True):
        with Writer(b';\xcb\x94\x01' if boxed else b'') as writer:
            writer.int(self.shortcut_id)
            writer.object(
                self.recipients,
                group_id=0XC866F2F0
            )
            writer.int(self.no_activity_days)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        shortcut_id_ = reader.int()
        recipients_ = reader.object(
            group_id=0XC866F2F0
        )

        no_activity_days_ = reader.int()

        return cls(
            shortcut_id=shortcut_id_,
            recipients=recipients_,
            no_activity_days=no_activity_days_
        )

TypeInputBusinessGreetingMessage = InputBusinessGreetingMessage