
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .input_peer import TypeInputPeer
    from ...gadgets.byteutils import Reader


class InputChannelEmpty(TLObject, family='TypeInputChannel'):
    """
    Represents the absence of a channel
    """

    _id = 0XEE8C1E86
    _group_id = 0X42691CEF


    def to_bytes(self, boxed: bool=True):
        return b'\x86\x1e\x8c\xee' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputChannel(TLObject, family='TypeInputChannel'):
    """
    Represents a channel
    """

    _id = 0XF35AEC28
    _group_id = 0X42691CEF

    def __init__(
        self,
        channel_id: int,
        access_hash: int
    ):

        """
        Represents a channel

        Args:
            channel_id (int): Channel ID
            access_hash (int): Access hash taken from the [channel](https://core.telegram.org/constructor/channel) constructor
        """

        self.channel_id = channel_id
        self.access_hash = access_hash

    def to_bytes(self, boxed: bool=True):
        with Writer(b'(\xecZ\xf3' if boxed else b'') as writer:
            writer.long(self.channel_id)
            writer.long(self.access_hash)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        channel_id_ = reader.long()
        access_hash_ = reader.long()

        return cls(
            channel_id=channel_id_,
            access_hash=access_hash_
        )

class InputChannelFromMessage(TLObject, family='TypeInputChannel'):
    """
    Defines a [min](https://core.telegram.org/api/min) channel that was seen in a certain message of a certain chat.
    """

    _id = 0X5B934F9D
    _group_id = 0X42691CEF

    def __init__(
        self,
        peer: 'TypeInputPeer',
        msg_id: int,
        channel_id: int
    ):

        """
        Defines a [min](https://core.telegram.org/api/min) channel that was seen in a certain message of a certain chat.

        Args:
            peer ('TypeInputPeer'): The chat where the channel was seen
            msg_id (int): The message ID in the chat where the channel was seen
            channel_id (int): The channel ID
        """

        self.peer = peer
        self.msg_id = msg_id
        self.channel_id = channel_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9dO\x93[' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X995DB9DF
            )
            writer.int(self.msg_id)
            writer.long(self.channel_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0X995DB9DF
        )

        msg_id_ = reader.int()
        channel_id_ = reader.long()

        return cls(
            peer=peer_,
            msg_id=msg_id_,
            channel_id=channel_id_
        )

TypeInputChannel = Union[
    InputChannelEmpty,
    InputChannel,
    InputChannelFromMessage
]