
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Optional, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .poll import TypePoll
    from .invoice import TypeInvoice
    from .data_json import TypeDataJSON
    from .todo_list import TypeTodoList
    from .input_file import TypeInputFile
    from .input_game import TypeInputGame
    from .input_peer import TypeInputPeer
    from .input_photo import TypeInputPhoto
    from .input_document import TypeInputDocument
    from .message_entity import TypeMessageEntity
    from .input_geo_point import TypeInputGeoPoint
    from .document_attribute import TypeDocumentAttribute
    from .input_web_document import TypeInputWebDocument
    from ...gadgets.byteutils import Reader


class InputMediaEmpty(TLObject, family='TypeInputMedia'):
    """
    Empty media content of a message.
    """

    _id = 0X9664F57F
    _group_id = 0XCEC6DE21


    def to_bytes(self, boxed: bool=True):
        return b'\x7f\xf5d\x96' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputMediaUploadedPhoto(TLObject, family='TypeInputMedia'):
    """
    Photo
    """

    _id = 0X1E287D04
    _group_id = 0XCEC6DE21

    def __init__(
        self,
        file: 'TypeInputFile',
        spoiler: bool = False,
        stickers: Optional[List['TypeInputDocument']] = None,
        ttl_seconds: Optional[int] = None
    ):

        """
        Photo

        Args:
            file ('TypeInputFile'): The [uploaded file](https://core.telegram.org/api/files)
            spoiler (bool, optional): Whether this media should be hidden behind a spoiler warning
            stickers (Optional[List['TypeInputDocument']], optional): Attached mask stickers
            ttl_seconds (Optional[int], optional): Time to live in seconds of self-destructing photo
        """

        self.file = file
        self.spoiler = spoiler
        self.stickers = stickers
        self.ttl_seconds = ttl_seconds

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x04}(\x1e' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.spoiler, 2)
                writer.object(
                    self.file,
                    group_id=0XB7247676
                )

                if flags(self.stickers, 0):
                    writer.vector(
                        self.stickers,
                        lambda value: writer.object(
                            value,
                            group_id=0X84313E
                        )
                    )

                if flags(self.ttl_seconds, 1):
                    writer.int(self.ttl_seconds)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        file_ = reader.object(
            group_id=0XB7247676
        )

        stickers_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X84313E
                )
            )
            if flags(0) else None
        )

        ttl_seconds_ = (
            reader.int()
            if flags(1) else None
        )

        return cls(
            file=file_,
            spoiler=flags(2),
            stickers=stickers_,
            ttl_seconds=ttl_seconds_
        )

class InputMediaPhoto(TLObject, family='TypeInputMedia'):
    """
    Forwarded photo
    """

    _id = 0XB3BA0635
    _group_id = 0XCEC6DE21

    def __init__(
        self,
        id: 'TypeInputPhoto',
        spoiler: bool = False,
        ttl_seconds: Optional[int] = None
    ):

        """
        Forwarded photo

        Args:
            id ('TypeInputPhoto'): Photo to be forwarded
            spoiler (bool, optional): Whether this media should be hidden behind a spoiler warning
            ttl_seconds (Optional[int], optional): Time to live in seconds of self-destructing photo
        """

        self.id = id
        self.spoiler = spoiler
        self.ttl_seconds = ttl_seconds

    def to_bytes(self, boxed: bool=True):
        with Writer(b'5\x06\xba\xb3' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.spoiler, 1)
                writer.object(
                    self.id,
                    group_id=0XB05DFB35
                )

                if flags(self.ttl_seconds, 0):
                    writer.int(self.ttl_seconds)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.object(
            group_id=0XB05DFB35
        )

        ttl_seconds_ = (
            reader.int()
            if flags(0) else None
        )

        return cls(
            id=id_,
            spoiler=flags(1),
            ttl_seconds=ttl_seconds_
        )

class InputMediaGeoPoint(TLObject, family='TypeInputMedia'):
    """
    Map.
    """

    _id = 0XF9C44144
    _group_id = 0XCEC6DE21

    def __init__(
        self,
        geo_point: 'TypeInputGeoPoint'
    ):

        """
        Map.

        Args:
            geo_point ('TypeInputGeoPoint'): GeoPoint
        """

        self.geo_point = geo_point

    def to_bytes(self, boxed: bool=True):
        with Writer(b'DA\xc4\xf9' if boxed else b'') as writer:
            writer.object(
                self.geo_point,
                group_id=0XF78B3873
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        geo_point_ = reader.object(
            group_id=0XF78B3873
        )

        return cls(
            geo_point=geo_point_
        )

class InputMediaContact(TLObject, family='TypeInputMedia'):
    """
    Phone book contact
    """

    _id = 0XF8AB7DFB
    _group_id = 0XCEC6DE21

    def __init__(
        self,
        phone_number: str,
        first_name: str,
        last_name: str,
        vcard: str
    ):

        """
        Phone book contact

        Args:
            phone_number (str): Phone number
            first_name (str): Contact's first name
            last_name (str): Contact's last name
            vcard (str): Contact vcard
        """

        self.phone_number = phone_number
        self.first_name = first_name
        self.last_name = last_name
        self.vcard = vcard

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xfb}\xab\xf8' if boxed else b'') as writer:
            writer.string(self.phone_number)
            writer.string(self.first_name)
            writer.string(self.last_name)
            writer.string(self.vcard)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        phone_number_ = reader.string()
        first_name_ = reader.string()
        last_name_ = reader.string()
        vcard_ = reader.string()

        return cls(
            phone_number=phone_number_,
            first_name=first_name_,
            last_name=last_name_,
            vcard=vcard_
        )

class InputMediaUploadedDocument(TLObject, family='TypeInputMedia'):
    """
    New document
    """

    _id = 0X37C9330
    _group_id = 0XCEC6DE21

    def __init__(
        self,
        file: 'TypeInputFile',
        mime_type: str,
        attributes: List['TypeDocumentAttribute'],
        nosound_video: bool = False,
        force_file: bool = False,
        spoiler: bool = False,
        thumb: Optional['TypeInputFile'] = None,
        stickers: Optional[List['TypeInputDocument']] = None,
        video_cover: Optional['TypeInputPhoto'] = None,
        video_timestamp: Optional[int] = None,
        ttl_seconds: Optional[int] = None
    ):

        """
        New document

        Args:
            file ('TypeInputFile'): The [uploaded file](https://core.telegram.org/api/files)
            mime_type (str): MIME type of document
            attributes (List['TypeDocumentAttribute']): Attributes that specify the type of the document (video, audio, voice, sticker, etc.)
            nosound_video (bool, optional): Whether the specified document is a video file with no audio tracks (a GIF animation (even as MPEG4), for example)
            force_file (bool, optional): Force the media file to be uploaded as document
            spoiler (bool, optional): Whether this media should be hidden behind a spoiler warning
            thumb (Optional['TypeInputFile'], optional): Thumbnail of the document, uploaded as for the file
            stickers (Optional[List['TypeInputDocument']], optional): Attached stickers
            video_cover (Optional['TypeInputPhoto'], optional): ...
            video_timestamp (Optional[int], optional): ...
            ttl_seconds (Optional[int], optional): Time to live in seconds of self-destructing document
        """

        self.file = file
        self.mime_type = mime_type
        self.attributes = attributes
        self.nosound_video = nosound_video
        self.force_file = force_file
        self.spoiler = spoiler
        self.thumb = thumb
        self.stickers = stickers
        self.video_cover = video_cover
        self.video_timestamp = video_timestamp
        self.ttl_seconds = ttl_seconds

    def to_bytes(self, boxed: bool=True):
        with Writer(b'0\x93|\x03' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.nosound_video, 3)
                flags(self.force_file, 4)
                flags(self.spoiler, 5)
                writer.object(
                    self.file,
                    group_id=0XB7247676
                )

                if flags(self.thumb, 2):
                    writer.object(
                        self.thumb,
                        group_id=0XB7247676
                    )
                writer.string(self.mime_type)
                writer.vector(
                    self.attributes,
                    lambda value: writer.object(
                        value,
                        group_id=0X9EBF3A46
                    )
                )

                if flags(self.stickers, 0):
                    writer.vector(
                        self.stickers,
                        lambda value: writer.object(
                            value,
                            group_id=0X84313E
                        )
                    )

                if flags(self.video_cover, 6):
                    writer.object(
                        self.video_cover,
                        group_id=0XB05DFB35
                    )

                if flags(self.video_timestamp, 7):
                    writer.int(self.video_timestamp)

                if flags(self.ttl_seconds, 1):
                    writer.int(self.ttl_seconds)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        file_ = reader.object(
            group_id=0XB7247676
        )

        thumb_ = (
            reader.object(
                group_id=0XB7247676
            )
            if flags(2) else None
        )

        mime_type_ = reader.string()
        attributes_ = reader.vector(
            lambda: reader.object(
                group_id=0X9EBF3A46
            )
        )

        stickers_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X84313E
                )
            )
            if flags(0) else None
        )

        video_cover_ = (
            reader.object(
                group_id=0XB05DFB35
            )
            if flags(6) else None
        )

        video_timestamp_ = (
            reader.int()
            if flags(7) else None
        )

        ttl_seconds_ = (
            reader.int()
            if flags(1) else None
        )

        return cls(
            file=file_,
            mime_type=mime_type_,
            attributes=attributes_,
            nosound_video=flags(3),
            force_file=flags(4),
            spoiler=flags(5),
            thumb=thumb_,
            stickers=stickers_,
            video_cover=video_cover_,
            video_timestamp=video_timestamp_,
            ttl_seconds=ttl_seconds_
        )

class InputMediaDocument(TLObject, family='TypeInputMedia'):
    """
    Forwarded document
    """

    _id = 0XA8763AB5
    _group_id = 0XCEC6DE21

    def __init__(
        self,
        id: 'TypeInputDocument',
        spoiler: bool = False,
        video_cover: Optional['TypeInputPhoto'] = None,
        video_timestamp: Optional[int] = None,
        ttl_seconds: Optional[int] = None,
        query: Optional[str] = None
    ):

        """
        Forwarded document

        Args:
            id ('TypeInputDocument'): The document to be forwarded.
            spoiler (bool, optional): Whether this media should be hidden behind a spoiler warning
            video_cover (Optional['TypeInputPhoto'], optional): ...
            video_timestamp (Optional[int], optional): ...
            ttl_seconds (Optional[int], optional): Time to live of self-destructing document
            query (Optional[str], optional): Text query or emoji that was used by the user to find this sticker or GIF: used to improve search result relevance.
        """

        self.id = id
        self.spoiler = spoiler
        self.video_cover = video_cover
        self.video_timestamp = video_timestamp
        self.ttl_seconds = ttl_seconds
        self.query = query

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb5:v\xa8' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.spoiler, 2)
                writer.object(
                    self.id,
                    group_id=0X84313E
                )

                if flags(self.video_cover, 3):
                    writer.object(
                        self.video_cover,
                        group_id=0XB05DFB35
                    )

                if flags(self.video_timestamp, 4):
                    writer.int(self.video_timestamp)

                if flags(self.ttl_seconds, 0):
                    writer.int(self.ttl_seconds)

                if flags(self.query, 1):
                    writer.string(self.query)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.object(
            group_id=0X84313E
        )

        video_cover_ = (
            reader.object(
                group_id=0XB05DFB35
            )
            if flags(3) else None
        )

        video_timestamp_ = (
            reader.int()
            if flags(4) else None
        )

        ttl_seconds_ = (
            reader.int()
            if flags(0) else None
        )

        query_ = (
            reader.string()
            if flags(1) else None
        )

        return cls(
            id=id_,
            spoiler=flags(2),
            video_cover=video_cover_,
            video_timestamp=video_timestamp_,
            ttl_seconds=ttl_seconds_,
            query=query_
        )

class InputMediaVenue(TLObject, family='TypeInputMedia'):
    """
    Can be used to send a venue geolocation.
    """

    _id = 0XC13D1C11
    _group_id = 0XCEC6DE21

    def __init__(
        self,
        geo_point: 'TypeInputGeoPoint',
        title: str,
        address: str,
        provider: str,
        venue_id: str,
        venue_type: str
    ):

        """
        Can be used to send a venue geolocation.

        Args:
            geo_point ('TypeInputGeoPoint'): Geolocation
            title (str): Venue name
            address (str): Physical address of the venue
            provider (str): Venue provider: currently only "foursquare" and "gplaces" (Google Places) need to be supported
            venue_id (str): Venue ID in the provider's database
            venue_type (str): Venue type in the provider's database
        """

        self.geo_point = geo_point
        self.title = title
        self.address = address
        self.provider = provider
        self.venue_id = venue_id
        self.venue_type = venue_type

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x11\x1c=\xc1' if boxed else b'') as writer:
            writer.object(
                self.geo_point,
                group_id=0XF78B3873
            )
            writer.string(self.title)
            writer.string(self.address)
            writer.string(self.provider)
            writer.string(self.venue_id)
            writer.string(self.venue_type)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        geo_point_ = reader.object(
            group_id=0XF78B3873
        )

        title_ = reader.string()
        address_ = reader.string()
        provider_ = reader.string()
        venue_id_ = reader.string()
        venue_type_ = reader.string()

        return cls(
            geo_point=geo_point_,
            title=title_,
            address=address_,
            provider=provider_,
            venue_id=venue_id_,
            venue_type=venue_type_
        )

class InputMediaPhotoExternal(TLObject, family='TypeInputMedia'):
    """
    New photo that will be uploaded by the server using the specified URL
    """

    _id = 0XE5BBFE1A
    _group_id = 0XCEC6DE21

    def __init__(
        self,
        url: str,
        spoiler: bool = False,
        ttl_seconds: Optional[int] = None
    ):

        """
        New photo that will be uploaded by the server using the specified URL

        Args:
            url (str): URL of the photo
            spoiler (bool, optional): Whether this media should be hidden behind a spoiler warning
            ttl_seconds (Optional[int], optional): Self-destruct time to live of photo
        """

        self.url = url
        self.spoiler = spoiler
        self.ttl_seconds = ttl_seconds

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1a\xfe\xbb\xe5' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.spoiler, 1)
                writer.string(self.url)

                if flags(self.ttl_seconds, 0):
                    writer.int(self.ttl_seconds)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        url_ = reader.string()
        ttl_seconds_ = (
            reader.int()
            if flags(0) else None
        )

        return cls(
            url=url_,
            spoiler=flags(1),
            ttl_seconds=ttl_seconds_
        )

class InputMediaDocumentExternal(TLObject, family='TypeInputMedia'):
    """
    Document that will be downloaded by the telegram servers
    """

    _id = 0X779600F9
    _group_id = 0XCEC6DE21

    def __init__(
        self,
        url: str,
        spoiler: bool = False,
        ttl_seconds: Optional[int] = None,
        video_cover: Optional['TypeInputPhoto'] = None,
        video_timestamp: Optional[int] = None
    ):

        """
        Document that will be downloaded by the telegram servers

        Args:
            url (str): URL of the document
            spoiler (bool, optional): Whether this media should be hidden behind a spoiler warning
            ttl_seconds (Optional[int], optional): Self-destruct time to live of document
            video_cover (Optional['TypeInputPhoto'], optional): ...
            video_timestamp (Optional[int], optional): ...
        """

        self.url = url
        self.spoiler = spoiler
        self.ttl_seconds = ttl_seconds
        self.video_cover = video_cover
        self.video_timestamp = video_timestamp

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf9\x00\x96w' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.spoiler, 1)
                writer.string(self.url)

                if flags(self.ttl_seconds, 0):
                    writer.int(self.ttl_seconds)

                if flags(self.video_cover, 2):
                    writer.object(
                        self.video_cover,
                        group_id=0XB05DFB35
                    )

                if flags(self.video_timestamp, 3):
                    writer.int(self.video_timestamp)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        url_ = reader.string()
        ttl_seconds_ = (
            reader.int()
            if flags(0) else None
        )

        video_cover_ = (
            reader.object(
                group_id=0XB05DFB35
            )
            if flags(2) else None
        )

        video_timestamp_ = (
            reader.int()
            if flags(3) else None
        )

        return cls(
            url=url_,
            spoiler=flags(1),
            ttl_seconds=ttl_seconds_,
            video_cover=video_cover_,
            video_timestamp=video_timestamp_
        )

class InputMediaGame(TLObject, family='TypeInputMedia'):
    """
    A game
    """

    _id = 0XD33F43F3
    _group_id = 0XCEC6DE21

    def __init__(
        self,
        id: 'TypeInputGame'
    ):

        """
        A game

        Args:
            id ('TypeInputGame'): The game to forward
        """

        self.id = id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf3C?\xd3' if boxed else b'') as writer:
            writer.object(
                self.id,
                group_id=0X189071EA
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.object(
            group_id=0X189071EA
        )

        return cls(
            id=id_
        )

class InputMediaInvoice(TLObject, family='TypeInputMedia'):
    """
    Generated invoice of a [bot payment](https://core.telegram.org/bots/payments)
    """

    _id = 0X405FEF0D
    _group_id = 0XCEC6DE21

    def __init__(
        self,
        title: str,
        description: str,
        invoice: 'TypeInvoice',
        payload: bytes,
        provider_data: 'TypeDataJSON',
        photo: Optional['TypeInputWebDocument'] = None,
        provider: Optional[str] = None,
        start_param: Optional[str] = None,
        extended_media: Optional['TypeInputMedia'] = None
    ):

        """
        Generated invoice of a [bot payment](https://core.telegram.org/bots/payments)

        Args:
            title (str): Product name, 1-32 characters
            description (str): Product description, 1-255 characters
            invoice ('TypeInvoice'): The actual invoice
            payload (bytes): Bot-defined invoice payload, 1-128 bytes. This will not be displayed to the user, use for your internal processes.
            provider_data ('TypeDataJSON'): JSON-encoded data about the invoice, which will be shared with the payment provider. A detailed description of required fields should be provided by the payment provider.
            photo (Optional['TypeInputWebDocument'], optional): URL of the product photo for the invoice. Can be a photo of the goods or a marketing image for a service. People like it better when they see what they are paying for.
            provider (Optional[str], optional): Payments provider token, obtained via [Botfather](https://t.me/botfather)
            start_param (Optional[str], optional): Unique [bot deep links start parameter](https://core.telegram.org/api/links#bot-links). If present, forwarded copies of the sent message will have a URL button with a [deep link](https://core.telegram.org/api/links#bot-links) to the bot (instead of a Pay button), with the value used as the start parameter. If absent, forwarded copies of the sent message will have a Pay button, allowing multiple users to pay directly from the forwarded message, using the same invoice.
            extended_media (Optional['TypeInputMedia'], optional): Deprecated
        """

        self.title = title
        self.description = description
        self.invoice = invoice
        self.payload = payload
        self.provider_data = provider_data
        self.photo = photo
        self.provider = provider
        self.start_param = start_param
        self.extended_media = extended_media

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\r\xef_@' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.title)
                writer.string(self.description)

                if flags(self.photo, 0):
                    writer.object(
                        self.photo,
                        group_id=0X1AFB92D5
                    )
                writer.object(
                    self.invoice,
                    group_id=0X3A02DB4
                )
                writer.bytes(self.payload)

                if flags(self.provider, 3):
                    writer.string(self.provider)
                writer.object(
                    self.provider_data,
                    group_id=0XE95B0798
                )

                if flags(self.start_param, 1):
                    writer.string(self.start_param)

                if flags(self.extended_media, 2):
                    writer.object(
                        self.extended_media,
                        group_id=0XCEC6DE21
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        title_ = reader.string()
        description_ = reader.string()
        photo_ = (
            reader.object(
                group_id=0X1AFB92D5
            )
            if flags(0) else None
        )

        invoice_ = reader.object(
            group_id=0X3A02DB4
        )

        payload_ = reader.bytes()
        provider_ = (
            reader.string()
            if flags(3) else None
        )

        provider_data_ = reader.object(
            group_id=0XE95B0798
        )

        start_param_ = (
            reader.string()
            if flags(1) else None
        )

        extended_media_ = (
            reader.object(
                group_id=0XCEC6DE21
            )
            if flags(2) else None
        )

        return cls(
            title=title_,
            description=description_,
            invoice=invoice_,
            payload=payload_,
            provider_data=provider_data_,
            photo=photo_,
            provider=provider_,
            start_param=start_param_,
            extended_media=extended_media_
        )

class InputMediaGeoLive(TLObject, family='TypeInputMedia'):
    """
    [Live geolocation](https://core.telegram.org/api/live-location)
    """

    _id = 0X971FA843
    _group_id = 0XCEC6DE21

    def __init__(
        self,
        geo_point: 'TypeInputGeoPoint',
        stopped: bool = False,
        heading: Optional[int] = None,
        period: Optional[int] = None,
        proximity_notification_radius: Optional[int] = None
    ):

        """
        [Live geolocation](https://core.telegram.org/api/live-location)

        Args:
            geo_point ('TypeInputGeoPoint'): Current geolocation
            stopped (bool, optional): Whether sending of the geolocation was stopped
            heading (Optional[int], optional): For [live locations](https://core.telegram.org/api/live-location), a direction in which the location moves, in degrees; 1-360.
            period (Optional[int], optional): Validity period of the current location
            proximity_notification_radius (Optional[int], optional): For [live locations](https://core.telegram.org/api/live-location), a maximum distance to another chat member for proximity alerts, in meters (0-100000)
        """

        self.geo_point = geo_point
        self.stopped = stopped
        self.heading = heading
        self.period = period
        self.proximity_notification_radius = proximity_notification_radius

    def to_bytes(self, boxed: bool=True):
        with Writer(b'C\xa8\x1f\x97' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.stopped, 0)
                writer.object(
                    self.geo_point,
                    group_id=0XF78B3873
                )

                if flags(self.heading, 2):
                    writer.int(self.heading)

                if flags(self.period, 1):
                    writer.int(self.period)

                if flags(self.proximity_notification_radius, 3):
                    writer.int(self.proximity_notification_radius)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        geo_point_ = reader.object(
            group_id=0XF78B3873
        )

        heading_ = (
            reader.int()
            if flags(2) else None
        )

        period_ = (
            reader.int()
            if flags(1) else None
        )

        proximity_notification_radius_ = (
            reader.int()
            if flags(3) else None
        )

        return cls(
            geo_point=geo_point_,
            stopped=flags(0),
            heading=heading_,
            period=period_,
            proximity_notification_radius=proximity_notification_radius_
        )

class InputMediaPoll(TLObject, family='TypeInputMedia'):
    """
    A poll
    """

    _id = 0XF94E5F1
    _group_id = 0XCEC6DE21

    def __init__(
        self,
        poll: 'TypePoll',
        correct_answers: Optional[List[bytes]] = None,
        solution: Optional[str] = None,
        solution_entities: Optional[List['TypeMessageEntity']] = None
    ):

        """
        A poll

        Args:
            poll ('TypePoll'): The poll to send
            correct_answers (Optional[List[bytes]], optional): Correct answer IDs (for quiz polls)
            solution (Optional[str], optional): Explanation of quiz solution
            solution_entities (Optional[List['TypeMessageEntity']], optional): [Message entities for styled text](https://core.telegram.org/api/entities)
        """

        self.poll = poll
        self.correct_answers = correct_answers
        self.solution = solution
        self.solution_entities = solution_entities

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf1\xe5\x94\x0f' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.poll,
                    group_id=0X9284C836
                )

                if flags(self.correct_answers, 0):
                    writer.vector(
                        self.correct_answers,
                        writer.bytes
                    )

                if flags(self.solution, 1):
                    writer.string(self.solution)

                if flags(self.solution_entities, 1):
                    writer.vector(
                        self.solution_entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        poll_ = reader.object(
            group_id=0X9284C836
        )

        correct_answers_ = (
            reader.vector(
                reader.bytes
            )
            if flags(0) else None
        )

        solution_ = (
            reader.string()
            if flags(1) else None
        )

        solution_entities_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3CDFF38A
                )
            )
            if flags(1) else None
        )

        return cls(
            poll=poll_,
            correct_answers=correct_answers_,
            solution=solution_,
            solution_entities=solution_entities_
        )

class InputMediaDice(TLObject, family='TypeInputMedia'):
    """
    Send a [dice-based animated sticker](https://core.telegram.org/api/dice)
    """

    _id = 0XE66FBF7B
    _group_id = 0XCEC6DE21

    def __init__(
        self,
        emoticon: str
    ):

        """
        Send a [dice-based animated sticker](https://core.telegram.org/api/dice)

        Args:
            emoticon (str): The emoji, for now ,  and  are supported
        """

        self.emoticon = emoticon

    def to_bytes(self, boxed: bool=True):
        with Writer(b'{\xbfo\xe6' if boxed else b'') as writer:
            writer.string(self.emoticon)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        emoticon_ = reader.string()

        return cls(
            emoticon=emoticon_
        )

class InputMediaStory(TLObject, family='TypeInputMedia'):
    """
    Forwarded story
    """

    _id = 0X89FDD778
    _group_id = 0XCEC6DE21

    def __init__(
        self,
        peer: 'TypeInputPeer',
        id: int
    ):

        """
        Forwarded story

        Args:
            peer ('TypeInputPeer'): Peer where the story was posted
            id (int): Story ID
        """

        self.peer = peer
        self.id = id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'x\xd7\xfd\x89' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X995DB9DF
            )
            writer.int(self.id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0X995DB9DF
        )

        id_ = reader.int()

        return cls(
            peer=peer_,
            id=id_
        )

class InputMediaWebPage(TLObject, family='TypeInputMedia'):
    """
    Specifies options that will be used to generate the link preview for the caption, or even a standalone link preview without an attached message.
    """

    _id = 0XC21B8849
    _group_id = 0XCEC6DE21

    def __init__(
        self,
        url: str,
        force_large_media: bool = False,
        force_small_media: bool = False,
        optional: bool = False
    ):

        """
        Specifies options that will be used to generate the link preview for the caption, or even a standalone link preview without an attached message.

        Args:
            url (str): The URL to use for the link preview.
            force_large_media (bool, optional): If set, specifies that a large media preview should be used.
            force_small_media (bool, optional): If set, specifies that a small media preview should be used.
            optional (bool, optional): If not set, a WEBPAGE_NOT_FOUND RPC error will be emitted if a webpage preview cannot be generated for the specified url; otherwise, no error will be emitted (unless the provided message is also empty, in which case a MESSAGE_EMPTY will be emitted, instead).
        """

        self.url = url
        self.force_large_media = force_large_media
        self.force_small_media = force_small_media
        self.optional = optional

    def to_bytes(self, boxed: bool=True):
        with Writer(b'I\x88\x1b\xc2' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.force_large_media, 0)
                flags(self.force_small_media, 1)
                flags(self.optional, 2)
                writer.string(self.url)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        url_ = reader.string()

        return cls(
            url=url_,
            force_large_media=flags(0),
            force_small_media=flags(1),
            optional=flags(2)
        )

class InputMediaPaidMedia(TLObject, family='TypeInputMedia'):
    """
    [Paid media, see here](https://core.telegram.org/api/paid-media) for more info.
    """

    _id = 0XC4103386
    _group_id = 0XCEC6DE21

    def __init__(
        self,
        stars_amount: int,
        extended_media: List['TypeInputMedia'],
        payload: Optional[str] = None
    ):

        """
        [Paid media, see here](https://core.telegram.org/api/paid-media) for more info.

        Args:
            stars_amount (int): The price of the media in [Telegram Stars](https://core.telegram.org/api/stars).
            extended_media (List['TypeInputMedia']): Photos or videos.
            payload (Optional[str], optional): Bots only, specifies a custom payload that will then be passed in [updateBotPurchasedPaidMedia](https://core.telegram.org/constructor/updateBotPurchasedPaidMedia) when a payment is made (this field will not be visible to the user)
        """

        self.stars_amount = stars_amount
        self.extended_media = extended_media
        self.payload = payload

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x863\x10\xc4' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.stars_amount)
                writer.vector(
                    self.extended_media,
                    lambda value: writer.object(
                        value,
                        group_id=0XCEC6DE21
                    )
                )

                if flags(self.payload, 0):
                    writer.string(self.payload)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        stars_amount_ = reader.long()
        extended_media_ = reader.vector(
            lambda: reader.object(
                group_id=0XCEC6DE21
            )
        )

        payload_ = (
            reader.string()
            if flags(0) else None
        )

        return cls(
            stars_amount=stars_amount_,
            extended_media=extended_media_,
            payload=payload_
        )

class InputMediaTodo(TLObject, family='TypeInputMedia'):
    _id = 0X9FC55FDE
    _group_id = 0XCEC6DE21

    def __init__(
        self,
        todo: 'TypeTodoList'
    ):

        self.todo = todo

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xde_\xc5\x9f' if boxed else b'') as writer:
            writer.object(
                self.todo,
                group_id=0XC0516EC3
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        todo_ = reader.object(
            group_id=0XC0516EC3
        )

        return cls(
            todo=todo_
        )

TypeInputMedia = Union[
    InputMediaEmpty,
    InputMediaUploadedPhoto,
    InputMediaPhoto,
    InputMediaGeoPoint,
    InputMediaContact,
    InputMediaUploadedDocument,
    InputMediaDocument,
    InputMediaVenue,
    InputMediaPhotoExternal,
    InputMediaDocumentExternal,
    InputMediaGame,
    InputMediaInvoice,
    InputMediaGeoLive,
    InputMediaPoll,
    InputMediaDice,
    InputMediaStory,
    InputMediaWebPage,
    InputMediaPaidMedia,
    InputMediaTodo
]