
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Optional, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .input_user import TypeInputUser
    from .request_peer_type import TypeRequestPeerType
    from ...gadgets.byteutils import Reader
    from .inline_query_peer_type import TypeInlineQueryPeerType


class KeyboardButton(TLObject, family='TypeKeyboardButton'):
    """
    Bot keyboard button
    """

    _id = 0XA2FA4880
    _group_id = 0X89563B88

    def __init__(
        self,
        text: str
    ):

        """
        Bot keyboard button

        Args:
            text (str): Button text
        """

        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x80H\xfa\xa2' if boxed else b'') as writer:
            writer.string(self.text)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.string()

        return cls(
            text=text_
        )

class KeyboardButtonUrl(TLObject, family='TypeKeyboardButton'):
    """
    URL button
    """

    _id = 0X258AFF05
    _group_id = 0X89563B88

    def __init__(
        self,
        text: str,
        url: str
    ):

        """
        URL button

        Args:
            text (str): Button label
            url (str): URL
        """

        self.text = text
        self.url = url

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x05\xff\x8a%' if boxed else b'') as writer:
            writer.string(self.text)
            writer.string(self.url)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.string()
        url_ = reader.string()

        return cls(
            text=text_,
            url=url_
        )

class KeyboardButtonCallback(TLObject, family='TypeKeyboardButton'):
    """
    Callback button
    """

    _id = 0X35BBDB6B
    _group_id = 0X89563B88

    def __init__(
        self,
        text: str,
        data: bytes,
        requires_password: bool = False
    ):

        """
        Callback button

        Args:
            text (str): Button text
            data (bytes): Callback data
            requires_password (bool, optional): Whether the user should verify his identity by entering his [2FA SRP parameters](https://core.telegram.org/api/srp) to the [messages.getBotCallbackAnswer](https://core.telegram.org/method/messages.getBotCallbackAnswer) method. NOTE: telegram and the bot WILL NOT have access to the plaintext password, thanks to [SRP](https://core.telegram.org/api/srp). This button is mainly used by the official [@botfather](https://t.me/botfather) bot, for verifying the user's identity before transferring ownership of a bot to another user.
        """

        self.text = text
        self.data = data
        self.requires_password = requires_password

    def to_bytes(self, boxed: bool=True):
        with Writer(b'k\xdb\xbb5' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.requires_password, 0)
                writer.string(self.text)
                writer.bytes(self.data)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        text_ = reader.string()
        data_ = reader.bytes()

        return cls(
            text=text_,
            data=data_,
            requires_password=flags(0)
        )

class KeyboardButtonRequestPhone(TLObject, family='TypeKeyboardButton'):
    """
    Button to request a user's phone number
    """

    _id = 0XB16A6C29
    _group_id = 0X89563B88

    def __init__(
        self,
        text: str
    ):

        """
        Button to request a user's phone number

        Args:
            text (str): Button text
        """

        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b')lj\xb1' if boxed else b'') as writer:
            writer.string(self.text)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.string()

        return cls(
            text=text_
        )

class KeyboardButtonRequestGeoLocation(TLObject, family='TypeKeyboardButton'):
    """
    Button to request a user's geolocation
    """

    _id = 0XFC796B3F
    _group_id = 0X89563B88

    def __init__(
        self,
        text: str
    ):

        """
        Button to request a user's geolocation

        Args:
            text (str): Button text
        """

        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'?ky\xfc' if boxed else b'') as writer:
            writer.string(self.text)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.string()

        return cls(
            text=text_
        )

class KeyboardButtonSwitchInline(TLObject, family='TypeKeyboardButton'):
    """
    Button to force a user to switch to inline mode: pressing the button will prompt the user to select one of their chats, open that chat and insert the bot's username and the specified inline query in the input field.
    """

    _id = 0X93B9FBB5
    _group_id = 0X89563B88

    def __init__(
        self,
        text: str,
        query: str,
        same_peer: bool = False,
        peer_types: Optional[List['TypeInlineQueryPeerType']] = None
    ):

        """
        Button to force a user to switch to inline mode: pressing the button will prompt the user to select one of their chats, open that chat and insert the bot's username and the specified inline query in the input field.

        Args:
            text (str): Button label
            query (str): The inline query to use
            same_peer (bool, optional): If set, pressing the button will insert the bot's username and the specified inline query in the current chat's input field.
            peer_types (Optional[List['TypeInlineQueryPeerType']], optional): Filter to use when selecting chats.
        """

        self.text = text
        self.query = query
        self.same_peer = same_peer
        self.peer_types = peer_types

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb5\xfb\xb9\x93' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.same_peer, 0)
                writer.string(self.text)
                writer.string(self.query)

                if flags(self.peer_types, 1):
                    writer.vector(
                        self.peer_types,
                        lambda value: writer.object(
                            value,
                            group_id=0X6AF2CA99
                        )
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        text_ = reader.string()
        query_ = reader.string()
        peer_types_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X6AF2CA99
                )
            )
            if flags(1) else None
        )

        return cls(
            text=text_,
            query=query_,
            same_peer=flags(0),
            peer_types=peer_types_
        )

class KeyboardButtonGame(TLObject, family='TypeKeyboardButton'):
    """
    Button to start a game
    """

    _id = 0X50F41CCF
    _group_id = 0X89563B88

    def __init__(
        self,
        text: str
    ):

        """
        Button to start a game

        Args:
            text (str): Button text
        """

        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xcf\x1c\xf4P' if boxed else b'') as writer:
            writer.string(self.text)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.string()

        return cls(
            text=text_
        )

class KeyboardButtonBuy(TLObject, family='TypeKeyboardButton'):
    """
    Button to buy a product
    """

    _id = 0XAFD93FBB
    _group_id = 0X89563B88

    def __init__(
        self,
        text: str
    ):

        """
        Button to buy a product

        Args:
            text (str): Button text
        """

        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xbb?\xd9\xaf' if boxed else b'') as writer:
            writer.string(self.text)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.string()

        return cls(
            text=text_
        )

class KeyboardButtonUrlAuth(TLObject, family='TypeKeyboardButton'):
    """
    Button to request a user to authorize via URL using [Seamless Telegram Login](https://telegram.org/blog/privacy-discussions-web-bots#meet-seamless-web-bots). When the user clicks on such a button, [messages.requestUrlAuth](https://core.telegram.org/method/messages.requestUrlAuth) should be called, providing the button_id and the ID of the container message. The returned [urlAuthResultRequest](https://core.telegram.org/constructor/urlAuthResultRequest) object will contain more details about the authorization request ( request_write_access if the bot would like to send messages to the user along with the username of the bot which will be used for user authorization). Finally, the user can choose to call [messages.acceptUrlAuth](https://core.telegram.org/method/messages.acceptUrlAuth) to get a [urlAuthResultAccepted](https://core.telegram.org/constructor/urlAuthResultAccepted) with the URL to open instead of the url of this constructor, or a [urlAuthResultDefault](https://core.telegram.org/constructor/urlAuthResultDefault), in which case the url of this constructor must be opened, instead. If the user refuses the authorization request but still wants to open the link, the url of this constructor must be used.
    """

    _id = 0X10B78D29
    _group_id = 0X89563B88

    def __init__(
        self,
        text: str,
        url: str,
        button_id: int,
        fwd_text: Optional[str] = None
    ):

        """
        Button to request a user to authorize via URL using [Seamless Telegram Login](https://telegram.org/blog/privacy-discussions-web-bots#meet-seamless-web-bots). When the user clicks on such a button, [messages.requestUrlAuth](https://core.telegram.org/method/messages.requestUrlAuth) should be called, providing the button_id and the ID of the container message. The returned [urlAuthResultRequest](https://core.telegram.org/constructor/urlAuthResultRequest) object will contain more details about the authorization request ( request_write_access if the bot would like to send messages to the user along with the username of the bot which will be used for user authorization). Finally, the user can choose to call [messages.acceptUrlAuth](https://core.telegram.org/method/messages.acceptUrlAuth) to get a [urlAuthResultAccepted](https://core.telegram.org/constructor/urlAuthResultAccepted) with the URL to open instead of the url of this constructor, or a [urlAuthResultDefault](https://core.telegram.org/constructor/urlAuthResultDefault), in which case the url of this constructor must be opened, instead. If the user refuses the authorization request but still wants to open the link, the url of this constructor must be used.

        Args:
            text (str): Button label
            url (str): An HTTP URL to be opened with user authorization data added to the query string when the button is pressed. If the user refuses to provide authorization data, the original URL without information about the user will be opened. The data added is the same as described in [Receiving authorization data](https://core.telegram.org/widgets/login#receiving-authorization-data). NOTE: Services must always check the hash of the received data to verify the authentication and the integrity of the data as described in [Checking authorization](https://core.telegram.org/widgets/login#checking-authorization).
            button_id (int): ID of the button to pass to [messages.requestUrlAuth](https://core.telegram.org/method/messages.requestUrlAuth)
            fwd_text (Optional[str], optional): New text of the button in forwarded messages.
        """

        self.text = text
        self.url = url
        self.button_id = button_id
        self.fwd_text = fwd_text

    def to_bytes(self, boxed: bool=True):
        with Writer(b')\x8d\xb7\x10' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.text)

                if flags(self.fwd_text, 0):
                    writer.string(self.fwd_text)
                writer.string(self.url)
                writer.int(self.button_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        text_ = reader.string()
        fwd_text_ = (
            reader.string()
            if flags(0) else None
        )

        url_ = reader.string()
        button_id_ = reader.int()

        return cls(
            text=text_,
            url=url_,
            button_id=button_id_,
            fwd_text=fwd_text_
        )

class InputKeyboardButtonUrlAuth(TLObject, family='TypeKeyboardButton'):
    """
    Button to request a user to [authorize](https://core.telegram.org/method/messages.acceptUrlAuth) via URL using [Seamless Telegram Login](https://telegram.org/blog/privacy-discussions-web-bots#meet-seamless-web-bots).
    """

    _id = 0XD02E7FD4
    _group_id = 0X89563B88

    def __init__(
        self,
        text: str,
        url: str,
        bot: 'TypeInputUser',
        request_write_access: bool = False,
        fwd_text: Optional[str] = None
    ):

        """
        Button to request a user to [authorize](https://core.telegram.org/method/messages.acceptUrlAuth) via URL using [Seamless Telegram Login](https://telegram.org/blog/privacy-discussions-web-bots#meet-seamless-web-bots).

        Args:
            text (str): Button text
            url (str): An HTTP URL to be opened with user authorization data added to the query string when the button is pressed. If the user refuses to provide authorization data, the original URL without information about the user will be opened. The data added is the same as described in [Receiving authorization data](https://core.telegram.org/widgets/login#receiving-authorization-data). NOTE: You must always check the hash of the received data to verify the authentication and the integrity of the data as described in [Checking authorization](https://core.telegram.org/widgets/login#checking-authorization).
            bot ('TypeInputUser'): Username of a bot, which will be used for user authorization. See [Setting up a bot](https://core.telegram.org/widgets/login#setting-up-a-bot) for more details. If not specified, the current bot's username will be assumed. The url's domain must be the same as the domain linked with the bot. See [Linking your domain to the bot](https://core.telegram.org/widgets/login#linking-your-domain-to-the-bot) for more details.
            request_write_access (bool, optional): Set this flag to request the permission for your bot to send messages to the user.
            fwd_text (Optional[str], optional): New text of the button in forwarded messages.
        """

        self.text = text
        self.url = url
        self.bot = bot
        self.request_write_access = request_write_access
        self.fwd_text = fwd_text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd4\x7f.\xd0' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.request_write_access, 0)
                writer.string(self.text)

                if flags(self.fwd_text, 1):
                    writer.string(self.fwd_text)
                writer.string(self.url)
                writer.object(
                    self.bot,
                    group_id=0XB628962F
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        text_ = reader.string()
        fwd_text_ = (
            reader.string()
            if flags(1) else None
        )

        url_ = reader.string()
        bot_ = reader.object(
            group_id=0XB628962F
        )

        return cls(
            text=text_,
            url=url_,
            bot=bot_,
            request_write_access=flags(0),
            fwd_text=fwd_text_
        )

class KeyboardButtonRequestPoll(TLObject, family='TypeKeyboardButton'):
    """
    A button that allows the user to create and send a poll when pressed; available only in private
    """

    _id = 0XBBC7515D
    _group_id = 0X89563B88

    def __init__(
        self,
        text: str,
        quiz: bool = False
    ):

        """
        A button that allows the user to create and send a poll when pressed; available only in private

        Args:
            text (str): Button text
            quiz (bool, optional): If set, only quiz polls can be sent
        """

        self.text = text
        self.quiz = quiz

    def to_bytes(self, boxed: bool=True):
        with Writer(b']Q\xc7\xbb' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.quiz, 0):
                    writer.object(
                        self.quiz,
                        group_id=0X43B904E1
                    )
                writer.string(self.text)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        quiz_ = (
            reader.object(
                group_id=0X43B904E1
            )
            if flags(0) else None
        )

        text_ = reader.string()

        return cls(
            text=text_,
            quiz=quiz_
        )

class InputKeyboardButtonUserProfile(TLObject, family='TypeKeyboardButton'):
    """
    Button that links directly to a user profile
    """

    _id = 0XE988037B
    _group_id = 0X89563B88

    def __init__(
        self,
        text: str,
        user_id: 'TypeInputUser'
    ):

        """
        Button that links directly to a user profile

        Args:
            text (str): Button text
            user_id ('TypeInputUser'): User ID
        """

        self.text = text
        self.user_id = user_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'{\x03\x88\xe9' if boxed else b'') as writer:
            writer.string(self.text)
            writer.object(
                self.user_id,
                group_id=0XB628962F
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.string()
        user_id_ = reader.object(
            group_id=0XB628962F
        )

        return cls(
            text=text_,
            user_id=user_id_
        )

class KeyboardButtonUserProfile(TLObject, family='TypeKeyboardButton'):
    """
    Button that links directly to a user profile
    """

    _id = 0X308660C1
    _group_id = 0X89563B88

    def __init__(
        self,
        text: str,
        user_id: int
    ):

        """
        Button that links directly to a user profile

        Args:
            text (str): Button text
            user_id (int): User ID
        """

        self.text = text
        self.user_id = user_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc1`\x860' if boxed else b'') as writer:
            writer.string(self.text)
            writer.long(self.user_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.string()
        user_id_ = reader.long()

        return cls(
            text=text_,
            user_id=user_id_
        )

class KeyboardButtonWebView(TLObject, family='TypeKeyboardButton'):
    """
    Button to open a [bot mini app](https://core.telegram.org/api/bots/webapps) using [messages.requestWebView](https://core.telegram.org/method/messages.requestWebView), sending over user information after user confirmation.
    """

    _id = 0X13767230
    _group_id = 0X89563B88

    def __init__(
        self,
        text: str,
        url: str
    ):

        """
        Button to open a [bot mini app](https://core.telegram.org/api/bots/webapps) using [messages.requestWebView](https://core.telegram.org/method/messages.requestWebView), sending over user information after user confirmation.

        Args:
            text (str): Button text
            url (str): [Web app url](https://core.telegram.org/api/bots/webapps)
        """

        self.text = text
        self.url = url

    def to_bytes(self, boxed: bool=True):
        with Writer(b'0rv\x13' if boxed else b'') as writer:
            writer.string(self.text)
            writer.string(self.url)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.string()
        url_ = reader.string()

        return cls(
            text=text_,
            url=url_
        )

class KeyboardButtonSimpleWebView(TLObject, family='TypeKeyboardButton'):
    """
    Button to open a [bot mini app](https://core.telegram.org/api/bots/webapps) using [messages.requestSimpleWebView](https://core.telegram.org/method/messages.requestSimpleWebView), without sending user information to the web app.
    """

    _id = 0XA0C0505C
    _group_id = 0X89563B88

    def __init__(
        self,
        text: str,
        url: str
    ):

        """
        Button to open a [bot mini app](https://core.telegram.org/api/bots/webapps) using [messages.requestSimpleWebView](https://core.telegram.org/method/messages.requestSimpleWebView), without sending user information to the web app.

        Args:
            text (str): Button text
            url (str): [Web app URL](https://core.telegram.org/api/bots/webapps)
        """

        self.text = text
        self.url = url

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\\P\xc0\xa0' if boxed else b'') as writer:
            writer.string(self.text)
            writer.string(self.url)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.string()
        url_ = reader.string()

        return cls(
            text=text_,
            url=url_
        )

class KeyboardButtonRequestPeer(TLObject, family='TypeKeyboardButton'):
    """
    Prompts the user to select and share one or more peers with the bot using [messages.sendBotRequestedPeer](https://core.telegram.org/method/messages.sendBotRequestedPeer)
    """

    _id = 0X53D7BFD8
    _group_id = 0X89563B88

    def __init__(
        self,
        text: str,
        button_id: int,
        peer_type: 'TypeRequestPeerType',
        max_quantity: int
    ):

        """
        Prompts the user to select and share one or more peers with the bot using [messages.sendBotRequestedPeer](https://core.telegram.org/method/messages.sendBotRequestedPeer)

        Args:
            text (str): Button text
            button_id (int): Button ID, to be passed to [messages.sendBotRequestedPeer](https://core.telegram.org/method/messages.sendBotRequestedPeer).
            peer_type ('TypeRequestPeerType'): Filtering criteria to use for the peer selection list shown to the user. The list should display all existing peers of the specified type, and should also offer an option for the user to create and immediately use one or more (up to max_quantity) peers of the specified type, if needed.
            max_quantity (int): Maximum number of peers that can be chosen.
        """

        self.text = text
        self.button_id = button_id
        self.peer_type = peer_type
        self.max_quantity = max_quantity

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd8\xbf\xd7S' if boxed else b'') as writer:
            writer.string(self.text)
            writer.int(self.button_id)
            writer.object(
                self.peer_type,
                group_id=0X459EEA1B
            )
            writer.int(self.max_quantity)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.string()
        button_id_ = reader.int()
        peer_type_ = reader.object(
            group_id=0X459EEA1B
        )

        max_quantity_ = reader.int()

        return cls(
            text=text_,
            button_id=button_id_,
            peer_type=peer_type_,
            max_quantity=max_quantity_
        )

class InputKeyboardButtonRequestPeer(TLObject, family='TypeKeyboardButton'):
    """
    Prompts the user to select and share one or more peers with the bot using [messages.sendBotRequestedPeer](https://core.telegram.org/method/messages.sendBotRequestedPeer).
    """

    _id = 0XC9662D05
    _group_id = 0X89563B88

    def __init__(
        self,
        text: str,
        button_id: int,
        peer_type: 'TypeRequestPeerType',
        max_quantity: int,
        name_requested: bool = False,
        username_requested: bool = False,
        photo_requested: bool = False
    ):

        """
        Prompts the user to select and share one or more peers with the bot using [messages.sendBotRequestedPeer](https://core.telegram.org/method/messages.sendBotRequestedPeer).

        Args:
            text (str): Button text
            button_id (int): Button ID, to be passed to [messages.sendBotRequestedPeer](https://core.telegram.org/method/messages.sendBotRequestedPeer).
            peer_type ('TypeRequestPeerType'): Filtering criteria to use for the peer selection list shown to the user. The list should display all existing peers of the specified type, and should also offer an option for the user to create and immediately use one or more (up to max_quantity) peers of the specified type, if needed.
            max_quantity (int): Maximum number of peers that can be chosen.
            name_requested (bool, optional): Set this flag to request the peer's name.
            username_requested (bool, optional): Set this flag to request the peer's @username (if any).
            photo_requested (bool, optional): Set this flag to request the peer's photo (if any).
        """

        self.text = text
        self.button_id = button_id
        self.peer_type = peer_type
        self.max_quantity = max_quantity
        self.name_requested = name_requested
        self.username_requested = username_requested
        self.photo_requested = photo_requested

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x05-f\xc9' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.name_requested, 0)
                flags(self.username_requested, 1)
                flags(self.photo_requested, 2)
                writer.string(self.text)
                writer.int(self.button_id)
                writer.object(
                    self.peer_type,
                    group_id=0X459EEA1B
                )
                writer.int(self.max_quantity)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        text_ = reader.string()
        button_id_ = reader.int()
        peer_type_ = reader.object(
            group_id=0X459EEA1B
        )

        max_quantity_ = reader.int()

        return cls(
            text=text_,
            button_id=button_id_,
            peer_type=peer_type_,
            max_quantity=max_quantity_,
            name_requested=flags(0),
            username_requested=flags(1),
            photo_requested=flags(2)
        )

class KeyboardButtonCopy(TLObject, family='TypeKeyboardButton'):
    """
    Clipboard button: when clicked, the attached text must be copied to the clipboard.
    """

    _id = 0X75D2698E
    _group_id = 0X89563B88

    def __init__(
        self,
        text: str,
        copy_text: str
    ):

        """
        Clipboard button: when clicked, the attached text must be copied to the clipboard.

        Args:
            text (str): Title of the button
            copy_text (str): The text that will be copied to the clipboard
        """

        self.text = text
        self.copy_text = copy_text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x8ei\xd2u' if boxed else b'') as writer:
            writer.string(self.text)
            writer.string(self.copy_text)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        text_ = reader.string()
        copy_text_ = reader.string()

        return cls(
            text=text_,
            copy_text=copy_text_
        )

TypeKeyboardButton = Union[
    KeyboardButton,
    KeyboardButtonUrl,
    KeyboardButtonCallback,
    KeyboardButtonRequestPhone,
    KeyboardButtonRequestGeoLocation,
    KeyboardButtonSwitchInline,
    KeyboardButtonGame,
    KeyboardButtonBuy,
    KeyboardButtonUrlAuth,
    InputKeyboardButtonUrlAuth,
    KeyboardButtonRequestPoll,
    InputKeyboardButtonUserProfile,
    KeyboardButtonUserProfile,
    KeyboardButtonWebView,
    KeyboardButtonSimpleWebView,
    KeyboardButtonRequestPeer,
    InputKeyboardButtonRequestPeer,
    KeyboardButtonCopy
]