
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class LabeledPrice(TLObject, family='TypeLabeledPrice'):
    """
    This object represents a portion of the price for goods or services.
    """

    _id = 0XCB296BF8
    _group_id = 0X1E1F1A68

    def __init__(
        self,
        label: str,
        amount: int
    ):

        """
        This object represents a portion of the price for goods or services.

        Args:
            label (str): Portion label
            amount (int): Price of the product in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
        """

        self.label = label
        self.amount = amount

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf8k)\xcb' if boxed else b'') as writer:
            writer.string(self.label)
            writer.long(self.amount)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        label_ = reader.string()
        amount_ = reader.long()

        return cls(
            label=label_,
            amount=amount_
        )

TypeLabeledPrice = LabeledPrice