
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .lang_pack_string import TypeLangPackString
    from ...gadgets.byteutils import Reader


class LangPackDifference(TLObject, family='TypeLangPackDifference'):
    """
    Changes to the app's localization pack
    """

    _id = 0XF385C1F6
    _group_id = 0XAA6D15ED

    def __init__(
        self,
        lang_code: str,
        from_version: int,
        version: int,
        strings: List['TypeLangPackString']
    ):

        """
        Changes to the app's localization pack

        Args:
            lang_code (str): Language code
            from_version (int): Previous version number
            version (int): New version number
            strings (List['TypeLangPackString']): Localized strings
        """

        self.lang_code = lang_code
        self.from_version = from_version
        self.version = version
        self.strings = strings

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf6\xc1\x85\xf3' if boxed else b'') as writer:
            writer.string(self.lang_code)
            writer.int(self.from_version)
            writer.int(self.version)
            writer.vector(
                self.strings,
                lambda value: writer.object(
                    value,
                    group_id=0X5EECD592
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        lang_code_ = reader.string()
        from_version_ = reader.int()
        version_ = reader.int()
        strings_ = reader.vector(
            lambda: reader.object(
                group_id=0X5EECD592
            )
        )

        return cls(
            lang_code=lang_code_,
            from_version=from_version_,
            version=version_,
            strings=strings_
        )

TypeLangPackDifference = LangPackDifference