
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..bot_app import TypeBotApp
    from ....gadgets.byteutils import Reader


class BotApp(TLObject, family='TypeMessagesBotApp'):
    """
    Contains information about a [direct link Mini App](https://core.telegram.org/api/bots/webapps#direct-link-mini-apps)
    """

    _id = 0XEB50ADF5
    _group_id = 0X72AACBBA

    def __init__(
        self,
        app: 'TypeBotApp',
        inactive: bool = False,
        request_write_access: bool = False,
        has_settings: bool = False
    ):

        """
        Contains information about a [direct link Mini App](https://core.telegram.org/api/bots/webapps#direct-link-mini-apps)

        Args:
            app ('TypeBotApp'): Bot app information
            inactive (bool, optional): Whether the web app was never used by the user, and confirmation must be asked from the user before opening it.
            request_write_access (bool, optional): The bot is asking permission to send messages to the user: if the user agrees, set the write_allowed flag when invoking [messages.requestAppWebView](https://core.telegram.org/method/messages.requestAppWebView).
            has_settings (bool, optional): Deprecated flag, can be ignored.
        """

        self.app = app
        self.inactive = inactive
        self.request_write_access = request_write_access
        self.has_settings = has_settings

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf5\xadP\xeb' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.inactive, 0)
                flags(self.request_write_access, 1)
                flags(self.has_settings, 2)
                writer.object(
                    self.app,
                    group_id=0XC9665A15
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        app_ = reader.object(
            group_id=0XC9665A15
        )

        return cls(
            app=app_,
            inactive=flags(0),
            request_write_access=flags(1),
            has_settings=flags(2)
        )

TypeMessagesBotApp = BotApp