
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..message import TypeMessage
    from ..forum_topic import TypeForumTopic
    from ....gadgets.byteutils import Reader


class ForumTopics(TLObject, family='TypeMessagesForumTopics'):
    """
    Contains information about multiple [forum topics](https://core.telegram.org/api/forum#forum-topics)
    """

    _id = 0X367617D3
    _group_id = 0X1C080881

    def __init__(
        self,
        count: int,
        topics: List['TypeForumTopic'],
        messages: List['TypeMessage'],
        chats: List['TypeChat'],
        users: List['TypeUser'],
        pts: int,
        order_by_create_date: bool = False
    ):

        """
        Contains information about multiple [forum topics](https://core.telegram.org/api/forum#forum-topics)

        Args:
            count (int): Total number of topics matching query; may be more than the topics contained in topics, in which case [pagination](https://core.telegram.org/api/offsets) is required.
            topics (List['TypeForumTopic']): Forum topics
            messages (List['TypeMessage']): Related messages (contains the messages mentioned by [forumTopic](https://core.telegram.org/constructor/forumTopic). top_message).
            chats (List['TypeChat']): Related chats
            users (List['TypeUser']): Related users
            pts (int): [Event count after generation](https://core.telegram.org/api/updates)
            order_by_create_date (bool, optional): Whether the returned topics are ordered by creation date; if set, pagination by offset_date should use [forumTopic](https://core.telegram.org/constructor/forumTopic). date; otherwise topics are ordered by the last message date, so paginate by the date of the [message](https://core.telegram.org/type/Message) referenced by [forumTopic](https://core.telegram.org/constructor/forumTopic). top_message.
        """

        self.count = count
        self.topics = topics
        self.messages = messages
        self.chats = chats
        self.users = users
        self.pts = pts
        self.order_by_create_date = order_by_create_date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd3\x17v6' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.order_by_create_date, 0)
                writer.int(self.count)
                writer.vector(
                    self.topics,
                    lambda value: writer.object(
                        value,
                        group_id=0XB926BAD6
                    )
                )
                writer.vector(
                    self.messages,
                    lambda value: writer.object(
                        value,
                        group_id=0X25780A8F
                    )
                )
                writer.vector(
                    self.chats,
                    lambda value: writer.object(
                        value,
                        group_id=0X73A5C0D9
                    )
                )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )
                writer.int(self.pts)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        count_ = reader.int()
        topics_ = reader.vector(
            lambda: reader.object(
                group_id=0XB926BAD6
            )
        )

        messages_ = reader.vector(
            lambda: reader.object(
                group_id=0X25780A8F
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        pts_ = reader.int()

        return cls(
            count=count_,
            topics=topics_,
            messages=messages_,
            chats=chats_,
            users=users_,
            pts=pts_,
            order_by_create_date=flags(0)
        )

TypeMessagesForumTopics = ForumTopics