
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..dialog import TypeDialog
    from ..message import TypeMessage
    from ..updates.state import TypeUpdatesState
    from ....gadgets.byteutils import Reader


class PeerDialogs(TLObject, family='TypeMessagesPeerDialogs'):
    """
    Dialog info of multiple peers
    """

    _id = 0X3371C354
    _group_id = 0XA8D237AD

    def __init__(
        self,
        dialogs: List['TypeDialog'],
        messages: List['TypeMessage'],
        chats: List['TypeChat'],
        users: List['TypeUser'],
        state: 'TypeUpdatesState'
    ):

        """
        Dialog info of multiple peers

        Args:
            dialogs (List['TypeDialog']): Dialog info
            messages (List['TypeMessage']): Messages mentioned in dialog info
            chats (List['TypeChat']): Chats
            users (List['TypeUser']): Users
            state ('TypeUpdatesState'): Current [update state of dialog](https://core.telegram.org/api/updates)
        """

        self.dialogs = dialogs
        self.messages = messages
        self.chats = chats
        self.users = users
        self.state = state

    def to_bytes(self, boxed: bool=True):
        with Writer(b'T\xc3q3' if boxed else b'') as writer:
            writer.vector(
                self.dialogs,
                lambda value: writer.object(
                    value,
                    group_id=0X89A4B5EF
                )
            )
            writer.vector(
                self.messages,
                lambda value: writer.object(
                    value,
                    group_id=0X25780A8F
                )
            )
            writer.vector(
                self.chats,
                lambda value: writer.object(
                    value,
                    group_id=0X73A5C0D9
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )
            writer.object(
                self.state,
                group_id=0X68F21FDA
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        dialogs_ = reader.vector(
            lambda: reader.object(
                group_id=0X89A4B5EF
            )
        )

        messages_ = reader.vector(
            lambda: reader.object(
                group_id=0X25780A8F
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        state_ = reader.object(
            group_id=0X68F21FDA
        )

        return cls(
            dialogs=dialogs_,
            messages=messages_,
            chats=chats_,
            users=users_,
            state=state_
        )

TypeMessagesPeerDialogs = PeerDialogs