
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class MissingInvitee(TLObject, family='TypeMissingInvitee'):
    """
    Info about why a specific user could not be [invited](https://core.telegram.org/api/invites#direct-invites).
    """

    _id = 0X628C9224
    _group_id = 0XDE77E3F7

    def __init__(
        self,
        user_id: int,
        premium_would_allow_invite: bool = False,
        premium_required_for_pm: bool = False
    ):

        """
        Info about why a specific user could not be [invited](https://core.telegram.org/api/invites#direct-invites).

        Args:
            user_id (int): ID of the user. If neither of the flags below are set, we could not add the user because of their privacy settings, and we can create and directly share an [invite link](https://core.telegram.org/api/invites#invite-links) with them using a normal message, instead.
            premium_would_allow_invite (bool, optional): If set, we could not add the user only because the current account needs to purchase a [Telegram Premium](https://core.telegram.org/api/premium) subscription to complete the operation.
            premium_required_for_pm (bool, optional): If set, we could not add the user because of their privacy settings, and additionally, the current account needs to purchase a [Telegram Premium](https://core.telegram.org/api/premium) subscription to directly share an invite link with the user via a private message.
        """

        self.user_id = user_id
        self.premium_would_allow_invite = premium_would_allow_invite
        self.premium_required_for_pm = premium_required_for_pm

    def to_bytes(self, boxed: bool=True):
        with Writer(b'$\x92\x8cb' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.premium_would_allow_invite, 0)
                flags(self.premium_required_for_pm, 1)
                writer.long(self.user_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        user_id_ = reader.long()

        return cls(
            user_id=user_id_,
            premium_would_allow_invite=flags(0),
            premium_required_for_pm=flags(1)
        )

TypeMissingInvitee = MissingInvitee