
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class NearestDc(TLObject, family='TypeNearestDc'):
    """
    Nearest data center, according to geo-ip.
    """

    _id = 0X8E1A1775
    _group_id = 0X68362D36

    def __init__(
        self,
        country: str,
        this_dc: int,
        nearest_dc: int
    ):

        """
        Nearest data center, according to geo-ip.

        Args:
            country (str): Country code determined by geo-ip
            this_dc (int): Number of current data center
            nearest_dc (int): Number of nearest data center
        """

        self.country = country
        self.this_dc = this_dc
        self.nearest_dc = nearest_dc

    def to_bytes(self, boxed: bool=True):
        with Writer(b'u\x17\x1a\x8e' if boxed else b'') as writer:
            writer.string(self.country)
            writer.int(self.this_dc)
            writer.int(self.nearest_dc)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        country_ = reader.string()
        this_dc_ = reader.int()
        nearest_dc_ = reader.int()

        return cls(
            country=country_,
            this_dc=this_dc_,
            nearest_dc=nearest_dc_
        )

TypeNearestDc = NearestDc