
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class PageRelatedArticle(TLObject, family='TypePageRelatedArticle'):
    """
    Related article
    """

    _id = 0XB390DC08
    _group_id = 0XCEDB609A

    def __init__(
        self,
        url: str,
        webpage_id: int,
        title: Optional[str] = None,
        description: Optional[str] = None,
        photo_id: Optional[int] = None,
        author: Optional[str] = None,
        published_date: Optional[int] = None
    ):

        """
        Related article

        Args:
            url (str): URL of article
            webpage_id (int): Webpage ID of generated IV preview
            title (Optional[str], optional): Title
            description (Optional[str], optional): Description
            photo_id (Optional[int], optional): ID of preview photo
            author (Optional[str], optional): Author name
            published_date (Optional[int], optional): Date of publication
        """

        self.url = url
        self.webpage_id = webpage_id
        self.title = title
        self.description = description
        self.photo_id = photo_id
        self.author = author
        self.published_date = published_date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x08\xdc\x90\xb3' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.url)
                writer.long(self.webpage_id)

                if flags(self.title, 0):
                    writer.string(self.title)

                if flags(self.description, 1):
                    writer.string(self.description)

                if flags(self.photo_id, 2):
                    writer.long(self.photo_id)

                if flags(self.author, 3):
                    writer.string(self.author)

                if flags(self.published_date, 4):
                    writer.int(self.published_date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        url_ = reader.string()
        webpage_id_ = reader.long()
        title_ = (
            reader.string()
            if flags(0) else None
        )

        description_ = (
            reader.string()
            if flags(1) else None
        )

        photo_id_ = (
            reader.long()
            if flags(2) else None
        )

        author_ = (
            reader.string()
            if flags(3) else None
        )

        published_date_ = (
            reader.int()
            if flags(4) else None
        )

        return cls(
            url=url_,
            webpage_id=webpage_id_,
            title=title_,
            description=description_,
            photo_id=photo_id_,
            author=author_,
            published_date=published_date_
        )

TypePageRelatedArticle = PageRelatedArticle