
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Union, Optional
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..user import TypeUser
    from ..invoice import TypeInvoice
    from ..web_document import TypeWebDocument
    from ..shipping_option import TypeShippingOption
    from ....gadgets.byteutils import Reader
    from ..payment_requested_info import TypePaymentRequestedInfo


class PaymentReceipt(TLObject, family='TypePaymentsPaymentReceipt'):
    """
    Receipt
    """

    _id = 0X70C4FE03
    _group_id = 0X8FE04511

    def __init__(
        self,
        date: int,
        bot_id: int,
        provider_id: int,
        title: str,
        description: str,
        invoice: 'TypeInvoice',
        currency: str,
        total_amount: int,
        credentials_title: str,
        users: List['TypeUser'],
        photo: Optional['TypeWebDocument'] = None,
        info: Optional['TypePaymentRequestedInfo'] = None,
        shipping: Optional['TypeShippingOption'] = None,
        tip_amount: Optional[int] = None
    ):

        """
        Receipt

        Args:
            date (int): Date of generation
            bot_id (int): Bot ID
            provider_id (int): Provider ID
            title (str): Title
            description (str): Description
            invoice ('TypeInvoice'): Invoice
            currency (str): Three-letter ISO 4217 [currency](https://core.telegram.org/bots/payments#supported-currencies) code
            total_amount (int): Total amount in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
            credentials_title (str): Payment credential name
            users (List['TypeUser']): Users
            photo (Optional['TypeWebDocument'], optional): Photo
            info (Optional['TypePaymentRequestedInfo'], optional): Info
            shipping (Optional['TypeShippingOption'], optional): Selected shipping option
            tip_amount (Optional[int], optional): Tipped amount
        """

        self.date = date
        self.bot_id = bot_id
        self.provider_id = provider_id
        self.title = title
        self.description = description
        self.invoice = invoice
        self.currency = currency
        self.total_amount = total_amount
        self.credentials_title = credentials_title
        self.users = users
        self.photo = photo
        self.info = info
        self.shipping = shipping
        self.tip_amount = tip_amount

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x03\xfe\xc4p' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.int(self.date)
                writer.long(self.bot_id)
                writer.long(self.provider_id)
                writer.string(self.title)
                writer.string(self.description)

                if flags(self.photo, 2):
                    writer.object(
                        self.photo,
                        group_id=0XCDE930D7
                    )
                writer.object(
                    self.invoice,
                    group_id=0X3A02DB4
                )

                if flags(self.info, 0):
                    writer.object(
                        self.info,
                        group_id=0X89AE5563
                    )

                if flags(self.shipping, 1):
                    writer.object(
                        self.shipping,
                        group_id=0X76120353
                    )

                if flags(self.tip_amount, 3):
                    writer.long(self.tip_amount)
                writer.string(self.currency)
                writer.long(self.total_amount)
                writer.string(self.credentials_title)
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        date_ = reader.int()
        bot_id_ = reader.long()
        provider_id_ = reader.long()
        title_ = reader.string()
        description_ = reader.string()
        photo_ = (
            reader.object(
                group_id=0XCDE930D7
            )
            if flags(2) else None
        )

        invoice_ = reader.object(
            group_id=0X3A02DB4
        )

        info_ = (
            reader.object(
                group_id=0X89AE5563
            )
            if flags(0) else None
        )

        shipping_ = (
            reader.object(
                group_id=0X76120353
            )
            if flags(1) else None
        )

        tip_amount_ = (
            reader.long()
            if flags(3) else None
        )

        currency_ = reader.string()
        total_amount_ = reader.long()
        credentials_title_ = reader.string()
        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            date=date_,
            bot_id=bot_id_,
            provider_id=provider_id_,
            title=title_,
            description=description_,
            invoice=invoice_,
            currency=currency_,
            total_amount=total_amount_,
            credentials_title=credentials_title_,
            users=users_,
            photo=photo_,
            info=info_,
            shipping=shipping_,
            tip_amount=tip_amount_
        )

class PaymentReceiptStars(TLObject, family='TypePaymentsPaymentReceipt'):
    """
    Receipt for [payment made using Telegram Stars](https://core.telegram.org/api/stars).
    """

    _id = 0XDABBF83A
    _group_id = 0X8FE04511

    def __init__(
        self,
        date: int,
        bot_id: int,
        title: str,
        description: str,
        invoice: 'TypeInvoice',
        currency: str,
        total_amount: int,
        transaction_id: str,
        users: List['TypeUser'],
        photo: Optional['TypeWebDocument'] = None
    ):

        """
        Receipt for [payment made using Telegram Stars](https://core.telegram.org/api/stars).

        Args:
            date (int): Date of generation
            bot_id (int): Bot ID
            title (str): Title
            description (str): Description
            invoice ('TypeInvoice'): Invoice
            currency (str): Currency, always XTR.
            total_amount (int): Amount of [Telegram Stars](https://core.telegram.org/api/stars).
            transaction_id (str): Transaction ID
            users (List['TypeUser']): Info about users mentioned in the other fields.
            photo (Optional['TypeWebDocument'], optional): Product photo
        """

        self.date = date
        self.bot_id = bot_id
        self.title = title
        self.description = description
        self.invoice = invoice
        self.currency = currency
        self.total_amount = total_amount
        self.transaction_id = transaction_id
        self.users = users
        self.photo = photo

    def to_bytes(self, boxed: bool=True):
        with Writer(b':\xf8\xbb\xda' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.int(self.date)
                writer.long(self.bot_id)
                writer.string(self.title)
                writer.string(self.description)

                if flags(self.photo, 2):
                    writer.object(
                        self.photo,
                        group_id=0XCDE930D7
                    )
                writer.object(
                    self.invoice,
                    group_id=0X3A02DB4
                )
                writer.string(self.currency)
                writer.long(self.total_amount)
                writer.string(self.transaction_id)
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        date_ = reader.int()
        bot_id_ = reader.long()
        title_ = reader.string()
        description_ = reader.string()
        photo_ = (
            reader.object(
                group_id=0XCDE930D7
            )
            if flags(2) else None
        )

        invoice_ = reader.object(
            group_id=0X3A02DB4
        )

        currency_ = reader.string()
        total_amount_ = reader.long()
        transaction_id_ = reader.string()
        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            date=date_,
            bot_id=bot_id_,
            title=title_,
            description=description_,
            invoice=invoice_,
            currency=currency_,
            total_amount=total_amount_,
            transaction_id=transaction_id_,
            users=users_,
            photo=photo_
        )

TypePaymentsPaymentReceipt = Union[
    PaymentReceipt,
    PaymentReceiptStars
]