
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class PhoneConnection(TLObject, family='TypePhoneConnection'):
    """
    Identifies an endpoint that can be used to connect to the other user in a phone call
    """

    _id = 0X9CC123C7
    _group_id = 0X6B3E602

    def __init__(
        self,
        id: int,
        ip: str,
        ipv6: str,
        port: int,
        peer_tag: bytes,
        tcp: bool = False
    ):

        """
        Identifies an endpoint that can be used to connect to the other user in a phone call

        Args:
            id (int): Endpoint ID
            ip (str): IP address of endpoint
            ipv6 (str): IPv6 address of endpoint
            port (int): Port ID
            peer_tag (bytes): Our peer tag
            tcp (bool, optional): Whether TCP should be used
        """

        self.id = id
        self.ip = ip
        self.ipv6 = ipv6
        self.port = port
        self.peer_tag = peer_tag
        self.tcp = tcp

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc7#\xc1\x9c' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.tcp, 0)
                writer.long(self.id)
                writer.string(self.ip)
                writer.string(self.ipv6)
                writer.int(self.port)
                writer.bytes(self.peer_tag)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.long()
        ip_ = reader.string()
        ipv6_ = reader.string()
        port_ = reader.int()
        peer_tag_ = reader.bytes()

        return cls(
            id=id_,
            ip=ip_,
            ipv6=ipv6_,
            port=port_,
            peer_tag=peer_tag_,
            tcp=flags(0)
        )

class PhoneConnectionWebrtc(TLObject, family='TypePhoneConnection'):
    """
    WebRTC connection parameters
    """

    _id = 0X635FE375
    _group_id = 0X6B3E602

    def __init__(
        self,
        id: int,
        ip: str,
        ipv6: str,
        port: int,
        username: str,
        password: str,
        turn: bool = False,
        stun: bool = False
    ):

        """
        WebRTC connection parameters

        Args:
            id (int): Endpoint ID
            ip (str): IP address
            ipv6 (str): IPv6 address
            port (int): Port
            username (str): Username
            password (str): Password
            turn (bool, optional): Whether this is a TURN endpoint
            stun (bool, optional): Whether this is a STUN endpoint
        """

        self.id = id
        self.ip = ip
        self.ipv6 = ipv6
        self.port = port
        self.username = username
        self.password = password
        self.turn = turn
        self.stun = stun

    def to_bytes(self, boxed: bool=True):
        with Writer(b'u\xe3_c' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.turn, 0)
                flags(self.stun, 1)
                writer.long(self.id)
                writer.string(self.ip)
                writer.string(self.ipv6)
                writer.int(self.port)
                writer.string(self.username)
                writer.string(self.password)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.long()
        ip_ = reader.string()
        ipv6_ = reader.string()
        port_ = reader.int()
        username_ = reader.string()
        password_ = reader.string()

        return cls(
            id=id_,
            ip=ip_,
            ipv6=ipv6_,
            port=port_,
            username=username_,
            password=password_,
            turn=flags(0),
            stun=flags(1)
        )

TypePhoneConnection = Union[
    PhoneConnection,
    PhoneConnectionWebrtc
]