
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class PollAnswerVoters(TLObject, family='TypePollAnswerVoters'):
    """
    A poll answer, and how users voted on it
    """

    _id = 0X3B6DDAD2
    _group_id = 0XECF3EC02

    def __init__(
        self,
        option: bytes,
        voters: int,
        chosen: bool = False,
        correct: bool = False
    ):

        """
        A poll answer, and how users voted on it

        Args:
            option (bytes): The param that has to be passed to [messages.sendVote](https://core.telegram.org/method/messages.sendVote).
            voters (int): How many users voted for this option
            chosen (bool, optional): Whether we have chosen this answer
            correct (bool, optional): For quizzes, whether the option we have chosen is correct
        """

        self.option = option
        self.voters = voters
        self.chosen = chosen
        self.correct = correct

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd2\xdam;' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.chosen, 0)
                flags(self.correct, 1)
                writer.bytes(self.option)
                writer.int(self.voters)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        option_ = reader.bytes()
        voters_ = reader.int()

        return cls(
            option=option_,
            voters=voters_,
            chosen=flags(0),
            correct=flags(1)
        )

TypePollAnswerVoters = PollAnswerVoters