
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader
    from .message_report_option import TypeMessageReportOption


class ReportResultChooseOption(TLObject, family='TypeReportResult'):
    """
    The user must choose one of the following options, and then [messages.report](https://core.telegram.org/method/messages.report) must be re-invoked, passing the option's option identifier to [messages.report](https://core.telegram.org/method/messages.report). option.
    """

    _id = 0XF0E4E0B6
    _group_id = 0XAE48EA2A

    def __init__(
        self,
        title: str,
        options: List['TypeMessageReportOption']
    ):

        """
        The user must choose one of the following options, and then [messages.report](https://core.telegram.org/method/messages.report) must be re-invoked, passing the option's option identifier to [messages.report](https://core.telegram.org/method/messages.report). option.

        Args:
            title (str): Title of the option popup
            options (List['TypeMessageReportOption']): Available options, rendered as menu entries.
        """

        self.title = title
        self.options = options

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb6\xe0\xe4\xf0' if boxed else b'') as writer:
            writer.string(self.title)
            writer.vector(
                self.options,
                lambda value: writer.object(
                    value,
                    group_id=0X383B9F0E
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        title_ = reader.string()
        options_ = reader.vector(
            lambda: reader.object(
                group_id=0X383B9F0E
            )
        )

        return cls(
            title=title_,
            options=options_
        )

class ReportResultAddComment(TLObject, family='TypeReportResult'):
    """
    The user should enter an additional comment for the moderators, and then [messages.report](https://core.telegram.org/method/messages.report) must be re-invoked, passing the comment to [messages.report](https://core.telegram.org/method/messages.report). message.
    """

    _id = 0X6F09AC31
    _group_id = 0XAE48EA2A

    def __init__(
        self,
        option: bytes,
        optional: bool = False
    ):

        """
        The user should enter an additional comment for the moderators, and then [messages.report](https://core.telegram.org/method/messages.report) must be re-invoked, passing the comment to [messages.report](https://core.telegram.org/method/messages.report). message.

        Args:
            option (bytes): The [messages.report](https://core.telegram.org/method/messages.report) method must be re-invoked, passing this option to option
            optional (bool, optional): Whether this step can be skipped by the user, passing an empty message to [messages.report](https://core.telegram.org/method/messages.report), or if a non-empty message is mandatory.
        """

        self.option = option
        self.optional = optional

    def to_bytes(self, boxed: bool=True):
        with Writer(b'1\xac\to' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.optional, 0)
                writer.bytes(self.option)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        option_ = reader.bytes()

        return cls(
            option=option_,
            optional=flags(0)
        )

class ReportResultReported(TLObject, family='TypeReportResult'):
    """
    The report was sent successfully, no further actions are required.
    """

    _id = 0X8DB33C4B
    _group_id = 0XAE48EA2A


    def to_bytes(self, boxed: bool=True):
        return b'K<\xb3\x8d' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

TypeReportResult = Union[
    ReportResultChooseOption,
    ReportResultAddComment,
    ReportResultReported
]