
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .stars_amount import TypeStarsAmount
    from ...gadgets.byteutils import Reader


class StarRefProgram(TLObject, family='TypeStarRefProgram'):
    """
    Indo about an [affiliate program offered by a bot](https://core.telegram.org/api/bots/referrals)
    """

    _id = 0XDD0C66F2
    _group_id = 0X1A73AF29

    def __init__(
        self,
        bot_id: int,
        commission_permille: int,
        duration_months: Optional[int] = None,
        end_date: Optional[int] = None,
        daily_revenue_per_user: Optional['TypeStarsAmount'] = None
    ):

        """
        Indo about an [affiliate program offered by a bot](https://core.telegram.org/api/bots/referrals)

        Args:
            bot_id (int): ID of the bot that offers the program
            commission_permille (int): An affiliate gets a commission of [starRefProgram](https://core.telegram.org/constructor/starRefProgram). commission_permille‰ [Telegram Stars](https://core.telegram.org/api/stars) for every mini app transaction made by users they refer
            duration_months (Optional[int], optional): An affiliate gets a commission for every mini app transaction made by users they refer, for duration_months months after a referral link is imported, starting the bot for the first time
            end_date (Optional[int], optional): Point in time (Unix timestamp) when the affiliate program will be closed (optional, if not set the affiliate program isn't scheduled to be closed)
            daily_revenue_per_user (Optional['TypeStarsAmount'], optional): The amount of daily revenue per user in Telegram Stars of the bot that created the affiliate program. To obtain the approximated revenue per referred user, multiply this value by commission_permille and divide by 1000.
        """

        self.bot_id = bot_id
        self.commission_permille = commission_permille
        self.duration_months = duration_months
        self.end_date = end_date
        self.daily_revenue_per_user = daily_revenue_per_user

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf2f\x0c\xdd' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.bot_id)
                writer.int(self.commission_permille)

                if flags(self.duration_months, 0):
                    writer.int(self.duration_months)

                if flags(self.end_date, 1):
                    writer.int(self.end_date)

                if flags(self.daily_revenue_per_user, 2):
                    writer.object(
                        self.daily_revenue_per_user,
                        group_id=0XC3D62A83
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        bot_id_ = reader.long()
        commission_permille_ = reader.int()
        duration_months_ = (
            reader.int()
            if flags(0) else None
        )

        end_date_ = (
            reader.int()
            if flags(1) else None
        )

        daily_revenue_per_user_ = (
            reader.object(
                group_id=0XC3D62A83
            )
            if flags(2) else None
        )

        return cls(
            bot_id=bot_id_,
            commission_permille=commission_permille_,
            duration_months=duration_months_,
            end_date=end_date_,
            daily_revenue_per_user=daily_revenue_per_user_
        )

TypeStarRefProgram = StarRefProgram