
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from .web_document import TypeWebDocument
    from ...gadgets.byteutils import Reader
    from .stars_subscription_pricing import TypeStarsSubscriptionPricing


class StarsSubscription(TLObject, family='TypeStarsSubscription'):
    """
    Represents a [Telegram Star subscription](https://core.telegram.org/api/invites#paid-invite-links).
    """

    _id = 0X2E6EAB1A
    _group_id = 0X857BF81E

    def __init__(
        self,
        id: str,
        peer: 'TypePeer',
        until_date: int,
        pricing: 'TypeStarsSubscriptionPricing',
        canceled: bool = False,
        can_refulfill: bool = False,
        missing_balance: bool = False,
        bot_canceled: bool = False,
        chat_invite_hash: Optional[str] = None,
        title: Optional[str] = None,
        photo: Optional['TypeWebDocument'] = None,
        invoice_slug: Optional[str] = None
    ):

        """
        Represents a [Telegram Star subscription](https://core.telegram.org/api/invites#paid-invite-links).

        Args:
            id (str): Subscription ID.
            peer ('TypePeer'): Identifier of the associated private chat.
            until_date (int): Expiration date of the current subscription period.
            pricing ('TypeStarsSubscriptionPricing'): Pricing of the subscription in Telegram Stars.
            canceled (bool, optional): Whether this subscription was cancelled.
            can_refulfill (bool, optional): Whether we left the associated private channel, but we can still rejoin it using [payments.fulfillStarsSubscription](https://core.telegram.org/method/payments.fulfillStarsSubscription) because the current subscription period hasn't expired yet.
            missing_balance (bool, optional): Whether this subscription has expired because there are not enough stars on the user's balance to extend it.
            bot_canceled (bool, optional): Set if this [bot subscription](https://core.telegram.org/api/subscriptions#bot-subscriptions) was cancelled by the bot
            chat_invite_hash (Optional[str], optional): Invitation link, used to renew the subscription after cancellation or expiration.
            title (Optional[str], optional): For bot subscriptions, the title of the subscription invoice
            photo (Optional['TypeWebDocument'], optional): For bot subscriptions, the photo from the subscription invoice
            invoice_slug (Optional[str], optional): For bot subscriptions, the [identifier](https://core.telegram.org/api/links#invoice-links) of the subscription invoice
        """

        self.id = id
        self.peer = peer
        self.until_date = until_date
        self.pricing = pricing
        self.canceled = canceled
        self.can_refulfill = can_refulfill
        self.missing_balance = missing_balance
        self.bot_canceled = bot_canceled
        self.chat_invite_hash = chat_invite_hash
        self.title = title
        self.photo = photo
        self.invoice_slug = invoice_slug

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1a\xabn.' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.canceled, 0)
                flags(self.can_refulfill, 1)
                flags(self.missing_balance, 2)
                flags(self.bot_canceled, 7)
                writer.string(self.id)
                writer.object(
                    self.peer,
                    group_id=0XB4DECBCA
                )
                writer.int(self.until_date)
                writer.object(
                    self.pricing,
                    group_id=0XB0E97E9F
                )

                if flags(self.chat_invite_hash, 3):
                    writer.string(self.chat_invite_hash)

                if flags(self.title, 4):
                    writer.string(self.title)

                if flags(self.photo, 5):
                    writer.object(
                        self.photo,
                        group_id=0XCDE930D7
                    )

                if flags(self.invoice_slug, 6):
                    writer.string(self.invoice_slug)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.string()
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        until_date_ = reader.int()
        pricing_ = reader.object(
            group_id=0XB0E97E9F
        )

        chat_invite_hash_ = (
            reader.string()
            if flags(3) else None
        )

        title_ = (
            reader.string()
            if flags(4) else None
        )

        photo_ = (
            reader.object(
                group_id=0XCDE930D7
            )
            if flags(5) else None
        )

        invoice_slug_ = (
            reader.string()
            if flags(6) else None
        )

        return cls(
            id=id_,
            peer=peer_,
            until_date=until_date_,
            pricing=pricing_,
            canceled=flags(0),
            can_refulfill=flags(1),
            missing_balance=flags(2),
            bot_canceled=flags(7),
            chat_invite_hash=chat_invite_hash_,
            title=title_,
            photo=photo_,
            invoice_slug=invoice_slug_
        )

TypeStarsSubscription = StarsSubscription