
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, List, Optional
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..public_forward import TypePublicForward
    from ....gadgets.byteutils import Reader


class PublicForwards(TLObject, family='TypeStatsPublicForwards'):
    """
    Contains info about the forwards of a [story](https://core.telegram.org/api/stories) as a message to public chats and reposts by public channels.
    """

    _id = 0X93037E20
    _group_id = 0X1DAE9D9D

    def __init__(
        self,
        count: int,
        forwards: List['TypePublicForward'],
        chats: List['TypeChat'],
        users: List['TypeUser'],
        next_offset: Optional[str] = None
    ):

        """
        Contains info about the forwards of a [story](https://core.telegram.org/api/stories) as a message to public chats and reposts by public channels.

        Args:
            count (int): Total number of results
            forwards (List['TypePublicForward']): Info about the forwards of a story.
            chats (List['TypeChat']): Mentioned chats
            users (List['TypeUser']): Mentioned users
            next_offset (Optional[str], optional): Offset used for [pagination](https://core.telegram.org/api/offsets).
        """

        self.count = count
        self.forwards = forwards
        self.chats = chats
        self.users = users
        self.next_offset = next_offset

    def to_bytes(self, boxed: bool=True):
        with Writer(b' ~\x03\x93' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.int(self.count)
                writer.vector(
                    self.forwards,
                    lambda value: writer.object(
                        value,
                        group_id=0X912BFF85
                    )
                )

                if flags(self.next_offset, 0):
                    writer.string(self.next_offset)
                writer.vector(
                    self.chats,
                    lambda value: writer.object(
                        value,
                        group_id=0X73A5C0D9
                    )
                )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        count_ = reader.int()
        forwards_ = reader.vector(
            lambda: reader.object(
                group_id=0X912BFF85
            )
        )

        next_offset_ = (
            reader.string()
            if flags(0) else None
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            count=count_,
            forwards=forwards_,
            chats=chats_,
            users=users_,
            next_offset=next_offset_
        )

TypeStatsPublicForwards = PublicForwards