
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class WebAuthorization(TLObject, family='TypeWebAuthorization'):
    """
    Represents a bot logged in using the [Telegram login widget](https://core.telegram.org/widgets/login)
    """

    _id = 0XA6F8F452
    _group_id = 0X93656EA3

    def __init__(
        self,
        hash: int,
        bot_id: int,
        domain: str,
        browser: str,
        platform: str,
        date_created: int,
        date_active: int,
        ip: str,
        region: str
    ):

        """
        Represents a bot logged in using the [Telegram login widget](https://core.telegram.org/widgets/login)

        Args:
            hash (int): Authorization hash
            bot_id (int): Bot ID
            domain (str): The domain name of the website on which the user has logged in.
            browser (str): Browser user-agent
            platform (str): Platform
            date_created (int): When was the web session created
            date_active (int): When was the web session last active
            ip (str): IP address
            region (str): Region, determined from IP address
        """

        self.hash = hash
        self.bot_id = bot_id
        self.domain = domain
        self.browser = browser
        self.platform = platform
        self.date_created = date_created
        self.date_active = date_active
        self.ip = ip
        self.region = region

    def to_bytes(self, boxed: bool=True):
        with Writer(b'R\xf4\xf8\xa6' if boxed else b'') as writer:
            writer.long(self.hash)
            writer.long(self.bot_id)
            writer.string(self.domain)
            writer.string(self.browser)
            writer.string(self.platform)
            writer.int(self.date_created)
            writer.int(self.date_active)
            writer.string(self.ip)
            writer.string(self.region)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        hash_ = reader.long()
        bot_id_ = reader.long()
        domain_ = reader.string()
        browser_ = reader.string()
        platform_ = reader.string()
        date_created_ = reader.int()
        date_active_ = reader.int()
        ip_ = reader.string()
        region_ = reader.string()

        return cls(
            hash=hash_,
            bot_id=bot_id_,
            domain=domain_,
            browser=browser_,
            platform=platform_,
            date_created=date_created_,
            date_active=date_active_,
            ip=ip_,
            region=region_
        )

TypeWebAuthorization = WebAuthorization