# mypy-boto3-snowball

[![PyPI - mypy-boto3-snowball](https://img.shields.io/pypi/v/mypy-boto3-snowball.svg?color=blue)](https://pypi.org/project/mypy-boto3-snowball)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-snowball.svg?color=blue)](https://pypi.org/project/mypy-boto3-snowball)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.Snowball 1.16.25](https://boto3.amazonaws.com/v1/documentation/api/1.16.25/reference/services/snowball.html#Snowball) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.3.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-snowball](#mypy-boto3-snowball)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `Snowball` service.

```bash
python -m pip install boto3-stubs[snowball]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[snowball]` in your environment: `python -m pip install 'boto3-stubs[snowball]'`

Both type checking and auto-complete should work for `Snowball` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[snowball]` in your environment: `python -m pip install 'boto3-stubs[snowball]'`

Both type checking and auto-complete should work for `Snowball` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[snowball]` in your environment: `python -m pip install 'boto3-stubs[snowball]'`
- Run `mypy` as usual

Type checking should work for `Snowball` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[snowball]` in your environment: `python -m pip install 'boto3-stubs[snowball]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Snowball` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`SnowballClient` provides annotations for `boto3.client("snowball")`.

```python
import boto3

from mypy_boto3_snowball import SnowballClient

client: SnowballClient = boto3.client("snowball")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: SnowballClient = session.client("snowball")
```

### Paginators annotations

`mypy_boto3_snowball.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_snowball import SnowballClient
from mypy_boto3_snowball.paginator import (
    DescribeAddressesPaginator,
    ListClusterJobsPaginator,
    ListClustersPaginator,
    ListCompatibleImagesPaginator,
    ListJobsPaginator,
)

client: SnowballClient = boto3.client("snowball")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_addresses_paginator: DescribeAddressesPaginator = client.get_paginator("describe_addresses")
list_cluster_jobs_paginator: ListClusterJobsPaginator = client.get_paginator("list_cluster_jobs")
list_clusters_paginator: ListClustersPaginator = client.get_paginator("list_clusters")
list_compatible_images_paginator: ListCompatibleImagesPaginator = client.get_paginator("list_compatible_images")
list_jobs_paginator: ListJobsPaginator = client.get_paginator("list_jobs")
```







### Typed dictionations

`mypy_boto3_snowball.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_snowball.type_defs import (
    AddressTypeDef,
    ClusterListEntryTypeDef,
    ClusterMetadataTypeDef,
    CompatibleImageTypeDef,
    CreateAddressResultTypeDef,
    CreateClusterResultTypeDef,
    CreateJobResultTypeDef,
    CreateReturnShippingLabelResultTypeDef,
    DataTransferTypeDef,
    DescribeAddressesResultTypeDef,
    DescribeAddressResultTypeDef,
    DescribeClusterResultTypeDef,
    DescribeJobResultTypeDef,
    DescribeReturnShippingLabelResultTypeDef,
    DeviceConfigurationTypeDef,
    Ec2AmiResourceTypeDef,
    EventTriggerDefinitionTypeDef,
    GetJobManifestResultTypeDef,
    GetJobUnlockCodeResultTypeDef,
    GetSnowballUsageResultTypeDef,
    GetSoftwareUpdatesResultTypeDef,
    INDTaxDocumentsTypeDef,
    JobListEntryTypeDef,
    JobLogsTypeDef,
    JobMetadataTypeDef,
    JobResourceTypeDef,
    KeyRangeTypeDef,
    LambdaResourceTypeDef,
    ListClusterJobsResultTypeDef,
    ListClustersResultTypeDef,
    ListCompatibleImagesResultTypeDef,
    ListJobsResultTypeDef,
    NotificationTypeDef,
    PaginatorConfigTypeDef,
    S3ResourceTypeDef,
    ShipmentTypeDef,
    ShippingDetailsTypeDef,
    SnowconeDeviceConfigurationTypeDef,
    TaxDocumentsTypeDef,
    WirelessConnectionTypeDef,
)

def get_structure() -> AddressTypeDef:
    return {
      ...
    }
```
