import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementProductTagConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product_tag#api_management_name ApiManagementProductTag#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product_tag#api_management_product_id ApiManagementProductTag#api_management_product_id}
    */
    readonly apiManagementProductId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product_tag#id ApiManagementProductTag#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product_tag#name ApiManagementProductTag#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product_tag#resource_group_name ApiManagementProductTag#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product_tag#timeouts ApiManagementProductTag#timeouts}
    */
    readonly timeouts?: ApiManagementProductTagTimeouts;
}
export interface ApiManagementProductTagTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product_tag#create ApiManagementProductTag#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product_tag#delete ApiManagementProductTag#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product_tag#read ApiManagementProductTag#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product_tag#update ApiManagementProductTag#update}
    */
    readonly update?: string;
}
export declare function apiManagementProductTagTimeoutsToTerraform(struct?: ApiManagementProductTagTimeoutsOutputReference | ApiManagementProductTagTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementProductTagTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementProductTagTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementProductTagTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product_tag azurerm_api_management_product_tag}
*/
export declare class ApiManagementProductTag extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_product_tag";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_product_tag azurerm_api_management_product_tag} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementProductTagConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementProductTagConfig);
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    private _apiManagementProductId?;
    get apiManagementProductId(): string;
    set apiManagementProductId(value: string);
    get apiManagementProductIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApiManagementProductTagTimeoutsOutputReference;
    putTimeouts(value: ApiManagementProductTagTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApiManagementProductTagTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
