import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDnsCnameRecordConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dns_cname_record#id DataAzurermDnsCnameRecord#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dns_cname_record#name DataAzurermDnsCnameRecord#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dns_cname_record#resource_group_name DataAzurermDnsCnameRecord#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dns_cname_record#zone_name DataAzurermDnsCnameRecord#zone_name}
    */
    readonly zoneName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dns_cname_record#timeouts DataAzurermDnsCnameRecord#timeouts}
    */
    readonly timeouts?: DataAzurermDnsCnameRecordTimeouts;
}
export interface DataAzurermDnsCnameRecordTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dns_cname_record#read DataAzurermDnsCnameRecord#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDnsCnameRecordTimeoutsToTerraform(struct?: DataAzurermDnsCnameRecordTimeoutsOutputReference | DataAzurermDnsCnameRecordTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDnsCnameRecordTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDnsCnameRecordTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermDnsCnameRecordTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/dns_cname_record azurerm_dns_cname_record}
*/
export declare class DataAzurermDnsCnameRecord extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_dns_cname_record";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/dns_cname_record azurerm_dns_cname_record} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDnsCnameRecordConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDnsCnameRecordConfig);
    get fqdn(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get record(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    get targetResourceId(): string;
    get ttl(): number;
    private _zoneName?;
    get zoneName(): string;
    set zoneName(value: string);
    get zoneNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermDnsCnameRecordTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDnsCnameRecordTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermDnsCnameRecordTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
