"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MssqlVirtualMachine = exports.MssqlVirtualMachineTimeoutsOutputReference = exports.mssqlVirtualMachineTimeoutsToTerraform = exports.MssqlVirtualMachineStorageConfigurationOutputReference = exports.mssqlVirtualMachineStorageConfigurationToTerraform = exports.MssqlVirtualMachineStorageConfigurationTempDbSettingsOutputReference = exports.mssqlVirtualMachineStorageConfigurationTempDbSettingsToTerraform = exports.MssqlVirtualMachineStorageConfigurationLogSettingsOutputReference = exports.mssqlVirtualMachineStorageConfigurationLogSettingsToTerraform = exports.MssqlVirtualMachineStorageConfigurationDataSettingsOutputReference = exports.mssqlVirtualMachineStorageConfigurationDataSettingsToTerraform = exports.MssqlVirtualMachineKeyVaultCredentialOutputReference = exports.mssqlVirtualMachineKeyVaultCredentialToTerraform = exports.MssqlVirtualMachineAutoPatchingOutputReference = exports.mssqlVirtualMachineAutoPatchingToTerraform = exports.MssqlVirtualMachineAutoBackupOutputReference = exports.mssqlVirtualMachineAutoBackupToTerraform = exports.MssqlVirtualMachineAutoBackupManualScheduleOutputReference = exports.mssqlVirtualMachineAutoBackupManualScheduleToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function mssqlVirtualMachineAutoBackupManualScheduleToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        full_backup_frequency: cdktf.stringToTerraform(struct.fullBackupFrequency),
        full_backup_start_hour: cdktf.numberToTerraform(struct.fullBackupStartHour),
        full_backup_window_in_hours: cdktf.numberToTerraform(struct.fullBackupWindowInHours),
        log_backup_frequency_in_minutes: cdktf.numberToTerraform(struct.logBackupFrequencyInMinutes),
    };
}
exports.mssqlVirtualMachineAutoBackupManualScheduleToTerraform = mssqlVirtualMachineAutoBackupManualScheduleToTerraform;
class MssqlVirtualMachineAutoBackupManualScheduleOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._fullBackupFrequency !== undefined) {
            hasAnyValues = true;
            internalValueResult.fullBackupFrequency = this._fullBackupFrequency;
        }
        if (this._fullBackupStartHour !== undefined) {
            hasAnyValues = true;
            internalValueResult.fullBackupStartHour = this._fullBackupStartHour;
        }
        if (this._fullBackupWindowInHours !== undefined) {
            hasAnyValues = true;
            internalValueResult.fullBackupWindowInHours = this._fullBackupWindowInHours;
        }
        if (this._logBackupFrequencyInMinutes !== undefined) {
            hasAnyValues = true;
            internalValueResult.logBackupFrequencyInMinutes = this._logBackupFrequencyInMinutes;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._fullBackupFrequency = undefined;
            this._fullBackupStartHour = undefined;
            this._fullBackupWindowInHours = undefined;
            this._logBackupFrequencyInMinutes = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._fullBackupFrequency = value.fullBackupFrequency;
            this._fullBackupStartHour = value.fullBackupStartHour;
            this._fullBackupWindowInHours = value.fullBackupWindowInHours;
            this._logBackupFrequencyInMinutes = value.logBackupFrequencyInMinutes;
        }
    }
    get fullBackupFrequency() {
        return this.getStringAttribute('full_backup_frequency');
    }
    set fullBackupFrequency(value) {
        this._fullBackupFrequency = value;
    }
    // Temporarily expose input value. Use with caution.
    get fullBackupFrequencyInput() {
        return this._fullBackupFrequency;
    }
    get fullBackupStartHour() {
        return this.getNumberAttribute('full_backup_start_hour');
    }
    set fullBackupStartHour(value) {
        this._fullBackupStartHour = value;
    }
    // Temporarily expose input value. Use with caution.
    get fullBackupStartHourInput() {
        return this._fullBackupStartHour;
    }
    get fullBackupWindowInHours() {
        return this.getNumberAttribute('full_backup_window_in_hours');
    }
    set fullBackupWindowInHours(value) {
        this._fullBackupWindowInHours = value;
    }
    // Temporarily expose input value. Use with caution.
    get fullBackupWindowInHoursInput() {
        return this._fullBackupWindowInHours;
    }
    get logBackupFrequencyInMinutes() {
        return this.getNumberAttribute('log_backup_frequency_in_minutes');
    }
    set logBackupFrequencyInMinutes(value) {
        this._logBackupFrequencyInMinutes = value;
    }
    // Temporarily expose input value. Use with caution.
    get logBackupFrequencyInMinutesInput() {
        return this._logBackupFrequencyInMinutes;
    }
}
exports.MssqlVirtualMachineAutoBackupManualScheduleOutputReference = MssqlVirtualMachineAutoBackupManualScheduleOutputReference;
_a = JSII_RTTI_SYMBOL_1;
MssqlVirtualMachineAutoBackupManualScheduleOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.mssqlVirtualMachine.MssqlVirtualMachineAutoBackupManualScheduleOutputReference", version: "3.0.11" };
function mssqlVirtualMachineAutoBackupToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        encryption_enabled: cdktf.booleanToTerraform(struct.encryptionEnabled),
        encryption_password: cdktf.stringToTerraform(struct.encryptionPassword),
        retention_period_in_days: cdktf.numberToTerraform(struct.retentionPeriodInDays),
        storage_account_access_key: cdktf.stringToTerraform(struct.storageAccountAccessKey),
        storage_blob_endpoint: cdktf.stringToTerraform(struct.storageBlobEndpoint),
        system_databases_backup_enabled: cdktf.booleanToTerraform(struct.systemDatabasesBackupEnabled),
        manual_schedule: mssqlVirtualMachineAutoBackupManualScheduleToTerraform(struct.manualSchedule),
    };
}
exports.mssqlVirtualMachineAutoBackupToTerraform = mssqlVirtualMachineAutoBackupToTerraform;
class MssqlVirtualMachineAutoBackupOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // manual_schedule - computed: false, optional: true, required: false
        this._manualSchedule = new MssqlVirtualMachineAutoBackupManualScheduleOutputReference(this, "manual_schedule");
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._encryptionEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.encryptionEnabled = this._encryptionEnabled;
        }
        if (this._encryptionPassword !== undefined) {
            hasAnyValues = true;
            internalValueResult.encryptionPassword = this._encryptionPassword;
        }
        if (this._retentionPeriodInDays !== undefined) {
            hasAnyValues = true;
            internalValueResult.retentionPeriodInDays = this._retentionPeriodInDays;
        }
        if (this._storageAccountAccessKey !== undefined) {
            hasAnyValues = true;
            internalValueResult.storageAccountAccessKey = this._storageAccountAccessKey;
        }
        if (this._storageBlobEndpoint !== undefined) {
            hasAnyValues = true;
            internalValueResult.storageBlobEndpoint = this._storageBlobEndpoint;
        }
        if (this._systemDatabasesBackupEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.systemDatabasesBackupEnabled = this._systemDatabasesBackupEnabled;
        }
        if (this._manualSchedule?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.manualSchedule = this._manualSchedule?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._encryptionEnabled = undefined;
            this._encryptionPassword = undefined;
            this._retentionPeriodInDays = undefined;
            this._storageAccountAccessKey = undefined;
            this._storageBlobEndpoint = undefined;
            this._systemDatabasesBackupEnabled = undefined;
            this._manualSchedule.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._encryptionEnabled = value.encryptionEnabled;
            this._encryptionPassword = value.encryptionPassword;
            this._retentionPeriodInDays = value.retentionPeriodInDays;
            this._storageAccountAccessKey = value.storageAccountAccessKey;
            this._storageBlobEndpoint = value.storageBlobEndpoint;
            this._systemDatabasesBackupEnabled = value.systemDatabasesBackupEnabled;
            this._manualSchedule.internalValue = value.manualSchedule;
        }
    }
    get encryptionEnabled() {
        return this.getBooleanAttribute('encryption_enabled');
    }
    set encryptionEnabled(value) {
        this._encryptionEnabled = value;
    }
    resetEncryptionEnabled() {
        this._encryptionEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get encryptionEnabledInput() {
        return this._encryptionEnabled;
    }
    get encryptionPassword() {
        return this.getStringAttribute('encryption_password');
    }
    set encryptionPassword(value) {
        this._encryptionPassword = value;
    }
    resetEncryptionPassword() {
        this._encryptionPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get encryptionPasswordInput() {
        return this._encryptionPassword;
    }
    get retentionPeriodInDays() {
        return this.getNumberAttribute('retention_period_in_days');
    }
    set retentionPeriodInDays(value) {
        this._retentionPeriodInDays = value;
    }
    // Temporarily expose input value. Use with caution.
    get retentionPeriodInDaysInput() {
        return this._retentionPeriodInDays;
    }
    get storageAccountAccessKey() {
        return this.getStringAttribute('storage_account_access_key');
    }
    set storageAccountAccessKey(value) {
        this._storageAccountAccessKey = value;
    }
    // Temporarily expose input value. Use with caution.
    get storageAccountAccessKeyInput() {
        return this._storageAccountAccessKey;
    }
    get storageBlobEndpoint() {
        return this.getStringAttribute('storage_blob_endpoint');
    }
    set storageBlobEndpoint(value) {
        this._storageBlobEndpoint = value;
    }
    // Temporarily expose input value. Use with caution.
    get storageBlobEndpointInput() {
        return this._storageBlobEndpoint;
    }
    get systemDatabasesBackupEnabled() {
        return this.getBooleanAttribute('system_databases_backup_enabled');
    }
    set systemDatabasesBackupEnabled(value) {
        this._systemDatabasesBackupEnabled = value;
    }
    resetSystemDatabasesBackupEnabled() {
        this._systemDatabasesBackupEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get systemDatabasesBackupEnabledInput() {
        return this._systemDatabasesBackupEnabled;
    }
    get manualSchedule() {
        return this._manualSchedule;
    }
    putManualSchedule(value) {
        this._manualSchedule.internalValue = value;
    }
    resetManualSchedule() {
        this._manualSchedule.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get manualScheduleInput() {
        return this._manualSchedule.internalValue;
    }
}
exports.MssqlVirtualMachineAutoBackupOutputReference = MssqlVirtualMachineAutoBackupOutputReference;
_b = JSII_RTTI_SYMBOL_1;
MssqlVirtualMachineAutoBackupOutputReference[_b] = { fqn: "@cdktf/provider-azurerm.mssqlVirtualMachine.MssqlVirtualMachineAutoBackupOutputReference", version: "3.0.11" };
function mssqlVirtualMachineAutoPatchingToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        day_of_week: cdktf.stringToTerraform(struct.dayOfWeek),
        maintenance_window_duration_in_minutes: cdktf.numberToTerraform(struct.maintenanceWindowDurationInMinutes),
        maintenance_window_starting_hour: cdktf.numberToTerraform(struct.maintenanceWindowStartingHour),
    };
}
exports.mssqlVirtualMachineAutoPatchingToTerraform = mssqlVirtualMachineAutoPatchingToTerraform;
class MssqlVirtualMachineAutoPatchingOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._dayOfWeek !== undefined) {
            hasAnyValues = true;
            internalValueResult.dayOfWeek = this._dayOfWeek;
        }
        if (this._maintenanceWindowDurationInMinutes !== undefined) {
            hasAnyValues = true;
            internalValueResult.maintenanceWindowDurationInMinutes = this._maintenanceWindowDurationInMinutes;
        }
        if (this._maintenanceWindowStartingHour !== undefined) {
            hasAnyValues = true;
            internalValueResult.maintenanceWindowStartingHour = this._maintenanceWindowStartingHour;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._dayOfWeek = undefined;
            this._maintenanceWindowDurationInMinutes = undefined;
            this._maintenanceWindowStartingHour = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._dayOfWeek = value.dayOfWeek;
            this._maintenanceWindowDurationInMinutes = value.maintenanceWindowDurationInMinutes;
            this._maintenanceWindowStartingHour = value.maintenanceWindowStartingHour;
        }
    }
    get dayOfWeek() {
        return this.getStringAttribute('day_of_week');
    }
    set dayOfWeek(value) {
        this._dayOfWeek = value;
    }
    // Temporarily expose input value. Use with caution.
    get dayOfWeekInput() {
        return this._dayOfWeek;
    }
    get maintenanceWindowDurationInMinutes() {
        return this.getNumberAttribute('maintenance_window_duration_in_minutes');
    }
    set maintenanceWindowDurationInMinutes(value) {
        this._maintenanceWindowDurationInMinutes = value;
    }
    // Temporarily expose input value. Use with caution.
    get maintenanceWindowDurationInMinutesInput() {
        return this._maintenanceWindowDurationInMinutes;
    }
    get maintenanceWindowStartingHour() {
        return this.getNumberAttribute('maintenance_window_starting_hour');
    }
    set maintenanceWindowStartingHour(value) {
        this._maintenanceWindowStartingHour = value;
    }
    // Temporarily expose input value. Use with caution.
    get maintenanceWindowStartingHourInput() {
        return this._maintenanceWindowStartingHour;
    }
}
exports.MssqlVirtualMachineAutoPatchingOutputReference = MssqlVirtualMachineAutoPatchingOutputReference;
_c = JSII_RTTI_SYMBOL_1;
MssqlVirtualMachineAutoPatchingOutputReference[_c] = { fqn: "@cdktf/provider-azurerm.mssqlVirtualMachine.MssqlVirtualMachineAutoPatchingOutputReference", version: "3.0.11" };
function mssqlVirtualMachineKeyVaultCredentialToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        key_vault_url: cdktf.stringToTerraform(struct.keyVaultUrl),
        name: cdktf.stringToTerraform(struct.name),
        service_principal_name: cdktf.stringToTerraform(struct.servicePrincipalName),
        service_principal_secret: cdktf.stringToTerraform(struct.servicePrincipalSecret),
    };
}
exports.mssqlVirtualMachineKeyVaultCredentialToTerraform = mssqlVirtualMachineKeyVaultCredentialToTerraform;
class MssqlVirtualMachineKeyVaultCredentialOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._keyVaultUrl !== undefined) {
            hasAnyValues = true;
            internalValueResult.keyVaultUrl = this._keyVaultUrl;
        }
        if (this._name !== undefined) {
            hasAnyValues = true;
            internalValueResult.name = this._name;
        }
        if (this._servicePrincipalName !== undefined) {
            hasAnyValues = true;
            internalValueResult.servicePrincipalName = this._servicePrincipalName;
        }
        if (this._servicePrincipalSecret !== undefined) {
            hasAnyValues = true;
            internalValueResult.servicePrincipalSecret = this._servicePrincipalSecret;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._keyVaultUrl = undefined;
            this._name = undefined;
            this._servicePrincipalName = undefined;
            this._servicePrincipalSecret = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._keyVaultUrl = value.keyVaultUrl;
            this._name = value.name;
            this._servicePrincipalName = value.servicePrincipalName;
            this._servicePrincipalSecret = value.servicePrincipalSecret;
        }
    }
    get keyVaultUrl() {
        return this.getStringAttribute('key_vault_url');
    }
    set keyVaultUrl(value) {
        this._keyVaultUrl = value;
    }
    // Temporarily expose input value. Use with caution.
    get keyVaultUrlInput() {
        return this._keyVaultUrl;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get servicePrincipalName() {
        return this.getStringAttribute('service_principal_name');
    }
    set servicePrincipalName(value) {
        this._servicePrincipalName = value;
    }
    // Temporarily expose input value. Use with caution.
    get servicePrincipalNameInput() {
        return this._servicePrincipalName;
    }
    get servicePrincipalSecret() {
        return this.getStringAttribute('service_principal_secret');
    }
    set servicePrincipalSecret(value) {
        this._servicePrincipalSecret = value;
    }
    // Temporarily expose input value. Use with caution.
    get servicePrincipalSecretInput() {
        return this._servicePrincipalSecret;
    }
}
exports.MssqlVirtualMachineKeyVaultCredentialOutputReference = MssqlVirtualMachineKeyVaultCredentialOutputReference;
_d = JSII_RTTI_SYMBOL_1;
MssqlVirtualMachineKeyVaultCredentialOutputReference[_d] = { fqn: "@cdktf/provider-azurerm.mssqlVirtualMachine.MssqlVirtualMachineKeyVaultCredentialOutputReference", version: "3.0.11" };
function mssqlVirtualMachineStorageConfigurationDataSettingsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        default_file_path: cdktf.stringToTerraform(struct.defaultFilePath),
        luns: cdktf.listMapper(cdktf.numberToTerraform, false)(struct.luns),
    };
}
exports.mssqlVirtualMachineStorageConfigurationDataSettingsToTerraform = mssqlVirtualMachineStorageConfigurationDataSettingsToTerraform;
class MssqlVirtualMachineStorageConfigurationDataSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._defaultFilePath !== undefined) {
            hasAnyValues = true;
            internalValueResult.defaultFilePath = this._defaultFilePath;
        }
        if (this._luns !== undefined) {
            hasAnyValues = true;
            internalValueResult.luns = this._luns;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._defaultFilePath = undefined;
            this._luns = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._defaultFilePath = value.defaultFilePath;
            this._luns = value.luns;
        }
    }
    get defaultFilePath() {
        return this.getStringAttribute('default_file_path');
    }
    set defaultFilePath(value) {
        this._defaultFilePath = value;
    }
    // Temporarily expose input value. Use with caution.
    get defaultFilePathInput() {
        return this._defaultFilePath;
    }
    get luns() {
        return this.getNumberListAttribute('luns');
    }
    set luns(value) {
        this._luns = value;
    }
    // Temporarily expose input value. Use with caution.
    get lunsInput() {
        return this._luns;
    }
}
exports.MssqlVirtualMachineStorageConfigurationDataSettingsOutputReference = MssqlVirtualMachineStorageConfigurationDataSettingsOutputReference;
_e = JSII_RTTI_SYMBOL_1;
MssqlVirtualMachineStorageConfigurationDataSettingsOutputReference[_e] = { fqn: "@cdktf/provider-azurerm.mssqlVirtualMachine.MssqlVirtualMachineStorageConfigurationDataSettingsOutputReference", version: "3.0.11" };
function mssqlVirtualMachineStorageConfigurationLogSettingsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        default_file_path: cdktf.stringToTerraform(struct.defaultFilePath),
        luns: cdktf.listMapper(cdktf.numberToTerraform, false)(struct.luns),
    };
}
exports.mssqlVirtualMachineStorageConfigurationLogSettingsToTerraform = mssqlVirtualMachineStorageConfigurationLogSettingsToTerraform;
class MssqlVirtualMachineStorageConfigurationLogSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._defaultFilePath !== undefined) {
            hasAnyValues = true;
            internalValueResult.defaultFilePath = this._defaultFilePath;
        }
        if (this._luns !== undefined) {
            hasAnyValues = true;
            internalValueResult.luns = this._luns;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._defaultFilePath = undefined;
            this._luns = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._defaultFilePath = value.defaultFilePath;
            this._luns = value.luns;
        }
    }
    get defaultFilePath() {
        return this.getStringAttribute('default_file_path');
    }
    set defaultFilePath(value) {
        this._defaultFilePath = value;
    }
    // Temporarily expose input value. Use with caution.
    get defaultFilePathInput() {
        return this._defaultFilePath;
    }
    get luns() {
        return this.getNumberListAttribute('luns');
    }
    set luns(value) {
        this._luns = value;
    }
    // Temporarily expose input value. Use with caution.
    get lunsInput() {
        return this._luns;
    }
}
exports.MssqlVirtualMachineStorageConfigurationLogSettingsOutputReference = MssqlVirtualMachineStorageConfigurationLogSettingsOutputReference;
_f = JSII_RTTI_SYMBOL_1;
MssqlVirtualMachineStorageConfigurationLogSettingsOutputReference[_f] = { fqn: "@cdktf/provider-azurerm.mssqlVirtualMachine.MssqlVirtualMachineStorageConfigurationLogSettingsOutputReference", version: "3.0.11" };
function mssqlVirtualMachineStorageConfigurationTempDbSettingsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        default_file_path: cdktf.stringToTerraform(struct.defaultFilePath),
        luns: cdktf.listMapper(cdktf.numberToTerraform, false)(struct.luns),
    };
}
exports.mssqlVirtualMachineStorageConfigurationTempDbSettingsToTerraform = mssqlVirtualMachineStorageConfigurationTempDbSettingsToTerraform;
class MssqlVirtualMachineStorageConfigurationTempDbSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._defaultFilePath !== undefined) {
            hasAnyValues = true;
            internalValueResult.defaultFilePath = this._defaultFilePath;
        }
        if (this._luns !== undefined) {
            hasAnyValues = true;
            internalValueResult.luns = this._luns;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._defaultFilePath = undefined;
            this._luns = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._defaultFilePath = value.defaultFilePath;
            this._luns = value.luns;
        }
    }
    get defaultFilePath() {
        return this.getStringAttribute('default_file_path');
    }
    set defaultFilePath(value) {
        this._defaultFilePath = value;
    }
    // Temporarily expose input value. Use with caution.
    get defaultFilePathInput() {
        return this._defaultFilePath;
    }
    get luns() {
        return this.getNumberListAttribute('luns');
    }
    set luns(value) {
        this._luns = value;
    }
    // Temporarily expose input value. Use with caution.
    get lunsInput() {
        return this._luns;
    }
}
exports.MssqlVirtualMachineStorageConfigurationTempDbSettingsOutputReference = MssqlVirtualMachineStorageConfigurationTempDbSettingsOutputReference;
_g = JSII_RTTI_SYMBOL_1;
MssqlVirtualMachineStorageConfigurationTempDbSettingsOutputReference[_g] = { fqn: "@cdktf/provider-azurerm.mssqlVirtualMachine.MssqlVirtualMachineStorageConfigurationTempDbSettingsOutputReference", version: "3.0.11" };
function mssqlVirtualMachineStorageConfigurationToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        disk_type: cdktf.stringToTerraform(struct.diskType),
        storage_workload_type: cdktf.stringToTerraform(struct.storageWorkloadType),
        data_settings: mssqlVirtualMachineStorageConfigurationDataSettingsToTerraform(struct.dataSettings),
        log_settings: mssqlVirtualMachineStorageConfigurationLogSettingsToTerraform(struct.logSettings),
        temp_db_settings: mssqlVirtualMachineStorageConfigurationTempDbSettingsToTerraform(struct.tempDbSettings),
    };
}
exports.mssqlVirtualMachineStorageConfigurationToTerraform = mssqlVirtualMachineStorageConfigurationToTerraform;
class MssqlVirtualMachineStorageConfigurationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // data_settings - computed: false, optional: true, required: false
        this._dataSettings = new MssqlVirtualMachineStorageConfigurationDataSettingsOutputReference(this, "data_settings");
        // log_settings - computed: false, optional: true, required: false
        this._logSettings = new MssqlVirtualMachineStorageConfigurationLogSettingsOutputReference(this, "log_settings");
        // temp_db_settings - computed: false, optional: true, required: false
        this._tempDbSettings = new MssqlVirtualMachineStorageConfigurationTempDbSettingsOutputReference(this, "temp_db_settings");
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._diskType !== undefined) {
            hasAnyValues = true;
            internalValueResult.diskType = this._diskType;
        }
        if (this._storageWorkloadType !== undefined) {
            hasAnyValues = true;
            internalValueResult.storageWorkloadType = this._storageWorkloadType;
        }
        if (this._dataSettings?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.dataSettings = this._dataSettings?.internalValue;
        }
        if (this._logSettings?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.logSettings = this._logSettings?.internalValue;
        }
        if (this._tempDbSettings?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.tempDbSettings = this._tempDbSettings?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._diskType = undefined;
            this._storageWorkloadType = undefined;
            this._dataSettings.internalValue = undefined;
            this._logSettings.internalValue = undefined;
            this._tempDbSettings.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._diskType = value.diskType;
            this._storageWorkloadType = value.storageWorkloadType;
            this._dataSettings.internalValue = value.dataSettings;
            this._logSettings.internalValue = value.logSettings;
            this._tempDbSettings.internalValue = value.tempDbSettings;
        }
    }
    get diskType() {
        return this.getStringAttribute('disk_type');
    }
    set diskType(value) {
        this._diskType = value;
    }
    // Temporarily expose input value. Use with caution.
    get diskTypeInput() {
        return this._diskType;
    }
    get storageWorkloadType() {
        return this.getStringAttribute('storage_workload_type');
    }
    set storageWorkloadType(value) {
        this._storageWorkloadType = value;
    }
    // Temporarily expose input value. Use with caution.
    get storageWorkloadTypeInput() {
        return this._storageWorkloadType;
    }
    get dataSettings() {
        return this._dataSettings;
    }
    putDataSettings(value) {
        this._dataSettings.internalValue = value;
    }
    resetDataSettings() {
        this._dataSettings.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataSettingsInput() {
        return this._dataSettings.internalValue;
    }
    get logSettings() {
        return this._logSettings;
    }
    putLogSettings(value) {
        this._logSettings.internalValue = value;
    }
    resetLogSettings() {
        this._logSettings.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get logSettingsInput() {
        return this._logSettings.internalValue;
    }
    get tempDbSettings() {
        return this._tempDbSettings;
    }
    putTempDbSettings(value) {
        this._tempDbSettings.internalValue = value;
    }
    resetTempDbSettings() {
        this._tempDbSettings.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tempDbSettingsInput() {
        return this._tempDbSettings.internalValue;
    }
}
exports.MssqlVirtualMachineStorageConfigurationOutputReference = MssqlVirtualMachineStorageConfigurationOutputReference;
_h = JSII_RTTI_SYMBOL_1;
MssqlVirtualMachineStorageConfigurationOutputReference[_h] = { fqn: "@cdktf/provider-azurerm.mssqlVirtualMachine.MssqlVirtualMachineStorageConfigurationOutputReference", version: "3.0.11" };
function mssqlVirtualMachineTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.mssqlVirtualMachineTimeoutsToTerraform = mssqlVirtualMachineTimeoutsToTerraform;
class MssqlVirtualMachineTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.MssqlVirtualMachineTimeoutsOutputReference = MssqlVirtualMachineTimeoutsOutputReference;
_j = JSII_RTTI_SYMBOL_1;
MssqlVirtualMachineTimeoutsOutputReference[_j] = { fqn: "@cdktf/provider-azurerm.mssqlVirtualMachine.MssqlVirtualMachineTimeoutsOutputReference", version: "3.0.11" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine azurerm_mssql_virtual_machine}
*/
class MssqlVirtualMachine extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine azurerm_mssql_virtual_machine} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MssqlVirtualMachineConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_mssql_virtual_machine',
            terraformGeneratorMetadata: {
                providerName: 'azurerm',
                providerVersion: '3.26.0',
                providerVersionConstraint: '~> 3.10'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // auto_backup - computed: false, optional: true, required: false
        this._autoBackup = new MssqlVirtualMachineAutoBackupOutputReference(this, "auto_backup");
        // auto_patching - computed: false, optional: true, required: false
        this._autoPatching = new MssqlVirtualMachineAutoPatchingOutputReference(this, "auto_patching");
        // key_vault_credential - computed: false, optional: true, required: false
        this._keyVaultCredential = new MssqlVirtualMachineKeyVaultCredentialOutputReference(this, "key_vault_credential");
        // storage_configuration - computed: false, optional: true, required: false
        this._storageConfiguration = new MssqlVirtualMachineStorageConfigurationOutputReference(this, "storage_configuration");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new MssqlVirtualMachineTimeoutsOutputReference(this, "timeouts");
        this._id = config.id;
        this._rServicesEnabled = config.rServicesEnabled;
        this._sqlConnectivityPort = config.sqlConnectivityPort;
        this._sqlConnectivityType = config.sqlConnectivityType;
        this._sqlConnectivityUpdatePassword = config.sqlConnectivityUpdatePassword;
        this._sqlConnectivityUpdateUsername = config.sqlConnectivityUpdateUsername;
        this._sqlLicenseType = config.sqlLicenseType;
        this._tags = config.tags;
        this._virtualMachineId = config.virtualMachineId;
        this._autoBackup.internalValue = config.autoBackup;
        this._autoPatching.internalValue = config.autoPatching;
        this._keyVaultCredential.internalValue = config.keyVaultCredential;
        this._storageConfiguration.internalValue = config.storageConfiguration;
        this._timeouts.internalValue = config.timeouts;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get rServicesEnabled() {
        return this.getBooleanAttribute('r_services_enabled');
    }
    set rServicesEnabled(value) {
        this._rServicesEnabled = value;
    }
    resetRServicesEnabled() {
        this._rServicesEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rServicesEnabledInput() {
        return this._rServicesEnabled;
    }
    get sqlConnectivityPort() {
        return this.getNumberAttribute('sql_connectivity_port');
    }
    set sqlConnectivityPort(value) {
        this._sqlConnectivityPort = value;
    }
    resetSqlConnectivityPort() {
        this._sqlConnectivityPort = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sqlConnectivityPortInput() {
        return this._sqlConnectivityPort;
    }
    get sqlConnectivityType() {
        return this.getStringAttribute('sql_connectivity_type');
    }
    set sqlConnectivityType(value) {
        this._sqlConnectivityType = value;
    }
    resetSqlConnectivityType() {
        this._sqlConnectivityType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sqlConnectivityTypeInput() {
        return this._sqlConnectivityType;
    }
    get sqlConnectivityUpdatePassword() {
        return this.getStringAttribute('sql_connectivity_update_password');
    }
    set sqlConnectivityUpdatePassword(value) {
        this._sqlConnectivityUpdatePassword = value;
    }
    resetSqlConnectivityUpdatePassword() {
        this._sqlConnectivityUpdatePassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sqlConnectivityUpdatePasswordInput() {
        return this._sqlConnectivityUpdatePassword;
    }
    get sqlConnectivityUpdateUsername() {
        return this.getStringAttribute('sql_connectivity_update_username');
    }
    set sqlConnectivityUpdateUsername(value) {
        this._sqlConnectivityUpdateUsername = value;
    }
    resetSqlConnectivityUpdateUsername() {
        this._sqlConnectivityUpdateUsername = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sqlConnectivityUpdateUsernameInput() {
        return this._sqlConnectivityUpdateUsername;
    }
    get sqlLicenseType() {
        return this.getStringAttribute('sql_license_type');
    }
    set sqlLicenseType(value) {
        this._sqlLicenseType = value;
    }
    // Temporarily expose input value. Use with caution.
    get sqlLicenseTypeInput() {
        return this._sqlLicenseType;
    }
    get tags() {
        return this.getStringMapAttribute('tags');
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get virtualMachineId() {
        return this.getStringAttribute('virtual_machine_id');
    }
    set virtualMachineId(value) {
        this._virtualMachineId = value;
    }
    // Temporarily expose input value. Use with caution.
    get virtualMachineIdInput() {
        return this._virtualMachineId;
    }
    get autoBackup() {
        return this._autoBackup;
    }
    putAutoBackup(value) {
        this._autoBackup.internalValue = value;
    }
    resetAutoBackup() {
        this._autoBackup.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoBackupInput() {
        return this._autoBackup.internalValue;
    }
    get autoPatching() {
        return this._autoPatching;
    }
    putAutoPatching(value) {
        this._autoPatching.internalValue = value;
    }
    resetAutoPatching() {
        this._autoPatching.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoPatchingInput() {
        return this._autoPatching.internalValue;
    }
    get keyVaultCredential() {
        return this._keyVaultCredential;
    }
    putKeyVaultCredential(value) {
        this._keyVaultCredential.internalValue = value;
    }
    resetKeyVaultCredential() {
        this._keyVaultCredential.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keyVaultCredentialInput() {
        return this._keyVaultCredential.internalValue;
    }
    get storageConfiguration() {
        return this._storageConfiguration;
    }
    putStorageConfiguration(value) {
        this._storageConfiguration.internalValue = value;
    }
    resetStorageConfiguration() {
        this._storageConfiguration.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageConfigurationInput() {
        return this._storageConfiguration.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            id: cdktf.stringToTerraform(this._id),
            r_services_enabled: cdktf.booleanToTerraform(this._rServicesEnabled),
            sql_connectivity_port: cdktf.numberToTerraform(this._sqlConnectivityPort),
            sql_connectivity_type: cdktf.stringToTerraform(this._sqlConnectivityType),
            sql_connectivity_update_password: cdktf.stringToTerraform(this._sqlConnectivityUpdatePassword),
            sql_connectivity_update_username: cdktf.stringToTerraform(this._sqlConnectivityUpdateUsername),
            sql_license_type: cdktf.stringToTerraform(this._sqlLicenseType),
            tags: cdktf.hashMapper(cdktf.stringToTerraform)(this._tags),
            virtual_machine_id: cdktf.stringToTerraform(this._virtualMachineId),
            auto_backup: mssqlVirtualMachineAutoBackupToTerraform(this._autoBackup.internalValue),
            auto_patching: mssqlVirtualMachineAutoPatchingToTerraform(this._autoPatching.internalValue),
            key_vault_credential: mssqlVirtualMachineKeyVaultCredentialToTerraform(this._keyVaultCredential.internalValue),
            storage_configuration: mssqlVirtualMachineStorageConfigurationToTerraform(this._storageConfiguration.internalValue),
            timeouts: mssqlVirtualMachineTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.MssqlVirtualMachine = MssqlVirtualMachine;
_k = JSII_RTTI_SYMBOL_1;
MssqlVirtualMachine[_k] = { fqn: "@cdktf/provider-azurerm.mssqlVirtualMachine.MssqlVirtualMachine", version: "3.0.11" };
// =================
// STATIC PROPERTIES
// =================
MssqlVirtualMachine.tfResourceType = "azurerm_mssql_virtual_machine";
//# sourceMappingURL=data:application/json;base64,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