'''
# `azurerm_mssql_database_vulnerability_assessment_rule_baseline`

Refer to the Terraform Registory for docs: [`azurerm_mssql_database_vulnerability_assessment_rule_baseline`](https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline).
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from .._jsii import *

import cdktf
import constructs


class MssqlDatabaseVulnerabilityAssessmentRuleBaseline(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-azurerm.mssqlDatabaseVulnerabilityAssessmentRuleBaseline.MssqlDatabaseVulnerabilityAssessmentRuleBaseline",
):
    '''Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline azurerm_mssql_database_vulnerability_assessment_rule_baseline}.'''

    def __init__(
        self,
        scope: constructs.Construct,
        id_: builtins.str,
        *,
        baseline_result: typing.Union[cdktf.IResolvable, typing.Sequence[typing.Union["MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult", typing.Dict[str, typing.Any]]]],
        database_name: builtins.str,
        rule_id: builtins.str,
        server_vulnerability_assessment_id: builtins.str,
        baseline_name: typing.Optional[builtins.str] = None,
        id: typing.Optional[builtins.str] = None,
        timeouts: typing.Optional[typing.Union["MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts", typing.Dict[str, typing.Any]]] = None,
        connection: typing.Optional[typing.Union[typing.Union[cdktf.SSHProvisionerConnection, typing.Dict[str, typing.Any]], typing.Union[cdktf.WinrmProvisionerConnection, typing.Dict[str, typing.Any]]]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        for_each: typing.Optional[cdktf.ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union[cdktf.TerraformResourceLifecycle, typing.Dict[str, typing.Any]]] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[cdktf.FileProvisioner, typing.Dict[str, typing.Any]], typing.Union[cdktf.LocalExecProvisioner, typing.Dict[str, typing.Any]], typing.Union[cdktf.RemoteExecProvisioner, typing.Dict[str, typing.Any]]]]] = None,
    ) -> None:
        '''Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline azurerm_mssql_database_vulnerability_assessment_rule_baseline} Resource.

        :param scope: The scope in which to define this construct.
        :param id_: The scoped construct ID. Must be unique amongst siblings in the same scope
        :param baseline_result: baseline_result block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#baseline_result MssqlDatabaseVulnerabilityAssessmentRuleBaseline#baseline_result}
        :param database_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#database_name MssqlDatabaseVulnerabilityAssessmentRuleBaseline#database_name}.
        :param rule_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#rule_id MssqlDatabaseVulnerabilityAssessmentRuleBaseline#rule_id}.
        :param server_vulnerability_assessment_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#server_vulnerability_assessment_id MssqlDatabaseVulnerabilityAssessmentRuleBaseline#server_vulnerability_assessment_id}.
        :param baseline_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#baseline_name MssqlDatabaseVulnerabilityAssessmentRuleBaseline#baseline_name}.
        :param id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#id MssqlDatabaseVulnerabilityAssessmentRuleBaseline#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param timeouts: timeouts block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#timeouts MssqlDatabaseVulnerabilityAssessmentRuleBaseline#timeouts}
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(MssqlDatabaseVulnerabilityAssessmentRuleBaseline.__init__)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id_", value=id_, expected_type=type_hints["id_"])
        config = MssqlDatabaseVulnerabilityAssessmentRuleBaselineConfig(
            baseline_result=baseline_result,
            database_name=database_name,
            rule_id=rule_id,
            server_vulnerability_assessment_id=server_vulnerability_assessment_id,
            baseline_name=baseline_name,
            id=id,
            timeouts=timeouts,
            connection=connection,
            count=count,
            depends_on=depends_on,
            for_each=for_each,
            lifecycle=lifecycle,
            provider=provider,
            provisioners=provisioners,
        )

        jsii.create(self.__class__, self, [scope, id_, config])

    @jsii.member(jsii_name="putBaselineResult")
    def put_baseline_result(
        self,
        value: typing.Union[cdktf.IResolvable, typing.Sequence[typing.Union["MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult", typing.Dict[str, typing.Any]]]],
    ) -> None:
        '''
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(MssqlDatabaseVulnerabilityAssessmentRuleBaseline.put_baseline_result)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "putBaselineResult", [value]))

    @jsii.member(jsii_name="putTimeouts")
    def put_timeouts(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param create: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#create MssqlDatabaseVulnerabilityAssessmentRuleBaseline#create}.
        :param delete: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#delete MssqlDatabaseVulnerabilityAssessmentRuleBaseline#delete}.
        :param read: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#read MssqlDatabaseVulnerabilityAssessmentRuleBaseline#read}.
        :param update: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#update MssqlDatabaseVulnerabilityAssessmentRuleBaseline#update}.
        '''
        value = MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts(
            create=create, delete=delete, read=read, update=update
        )

        return typing.cast(None, jsii.invoke(self, "putTimeouts", [value]))

    @jsii.member(jsii_name="resetBaselineName")
    def reset_baseline_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetBaselineName", []))

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="resetTimeouts")
    def reset_timeouts(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTimeouts", []))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="tfResourceType")
    def TF_RESOURCE_TYPE(cls) -> builtins.str:
        return typing.cast(builtins.str, jsii.sget(cls, "tfResourceType"))

    @builtins.property
    @jsii.member(jsii_name="baselineResult")
    def baseline_result(
        self,
    ) -> "MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultList":
        return typing.cast("MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultList", jsii.get(self, "baselineResult"))

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(
        self,
    ) -> "MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeoutsOutputReference":
        return typing.cast("MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeoutsOutputReference", jsii.get(self, "timeouts"))

    @builtins.property
    @jsii.member(jsii_name="baselineNameInput")
    def baseline_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "baselineNameInput"))

    @builtins.property
    @jsii.member(jsii_name="baselineResultInput")
    def baseline_result_input(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List["MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult"]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List["MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult"]]], jsii.get(self, "baselineResultInput"))

    @builtins.property
    @jsii.member(jsii_name="databaseNameInput")
    def database_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "databaseNameInput"))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="ruleIdInput")
    def rule_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "ruleIdInput"))

    @builtins.property
    @jsii.member(jsii_name="serverVulnerabilityAssessmentIdInput")
    def server_vulnerability_assessment_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "serverVulnerabilityAssessmentIdInput"))

    @builtins.property
    @jsii.member(jsii_name="timeoutsInput")
    def timeouts_input(
        self,
    ) -> typing.Optional[typing.Union["MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts", cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union["MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts", cdktf.IResolvable]], jsii.get(self, "timeoutsInput"))

    @builtins.property
    @jsii.member(jsii_name="baselineName")
    def baseline_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "baselineName"))

    @baseline_name.setter
    def baseline_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(MssqlDatabaseVulnerabilityAssessmentRuleBaseline, "baseline_name").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "baselineName", value)

    @builtins.property
    @jsii.member(jsii_name="databaseName")
    def database_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "databaseName"))

    @database_name.setter
    def database_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(MssqlDatabaseVulnerabilityAssessmentRuleBaseline, "database_name").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "databaseName", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "id"))

    @id.setter
    def id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(MssqlDatabaseVulnerabilityAssessmentRuleBaseline, "id").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="ruleId")
    def rule_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "ruleId"))

    @rule_id.setter
    def rule_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(MssqlDatabaseVulnerabilityAssessmentRuleBaseline, "rule_id").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "ruleId", value)

    @builtins.property
    @jsii.member(jsii_name="serverVulnerabilityAssessmentId")
    def server_vulnerability_assessment_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "serverVulnerabilityAssessmentId"))

    @server_vulnerability_assessment_id.setter
    def server_vulnerability_assessment_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(MssqlDatabaseVulnerabilityAssessmentRuleBaseline, "server_vulnerability_assessment_id").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "serverVulnerabilityAssessmentId", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-azurerm.mssqlDatabaseVulnerabilityAssessmentRuleBaseline.MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult",
    jsii_struct_bases=[],
    name_mapping={"result": "result"},
)
class MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult:
    def __init__(self, *, result: typing.Sequence[builtins.str]) -> None:
        '''
        :param result: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#result MssqlDatabaseVulnerabilityAssessmentRuleBaseline#result}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult.__init__)
            check_type(argname="argument result", value=result, expected_type=type_hints["result"])
        self._values: typing.Dict[str, typing.Any] = {
            "result": result,
        }

    @builtins.property
    def result(self) -> typing.List[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#result MssqlDatabaseVulnerabilityAssessmentRuleBaseline#result}.'''
        result = self._values.get("result")
        assert result is not None, "Required property 'result' is missing"
        return typing.cast(typing.List[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultList(
    cdktf.ComplexList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-azurerm.mssqlDatabaseVulnerabilityAssessmentRuleBaseline.MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultList",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param wraps_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultList.__init__)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(
        self,
        index: jsii.Number,
    ) -> "MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultOutputReference":
        '''
        :param index: the index of the item to return.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultList.get)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast("MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultOutputReference", jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''The attribute on the parent resource this class is referencing.'''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultList, "_terraform_attribute").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> cdktf.IInterpolatingParent:
        '''The parent resource.'''
        return typing.cast(cdktf.IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: cdktf.IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultList, "_terraform_resource").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''whether the list is wrapping a set (will add tolist() to be able to access an item via an index).'''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultList, "_wraps_set").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[cdktf.IResolvable, typing.List[MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult]]]:
        return typing.cast(typing.Optional[typing.Union[cdktf.IResolvable, typing.List[MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult]]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[cdktf.IResolvable, typing.List[MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultList, "internal_value").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


class MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-azurerm.mssqlDatabaseVulnerabilityAssessmentRuleBaseline.MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_index: jsii.Number,
        complex_object_is_from_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        :param complex_object_index: the index of this item in the list.
        :param complex_object_is_from_set: whether the list is wrapping a set (will add tolist() to be able to access an item via an index).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultOutputReference.__init__)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_index, complex_object_is_from_set])

    @builtins.property
    @jsii.member(jsii_name="resultInput")
    def result_input(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "resultInput"))

    @builtins.property
    @jsii.member(jsii_name="result")
    def result(self) -> typing.List[builtins.str]:
        return typing.cast(typing.List[builtins.str], jsii.get(self, "result"))

    @result.setter
    def result(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultOutputReference, "result").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "result", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult, cdktf.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult, cdktf.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultOutputReference, "internal_value").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-azurerm.mssqlDatabaseVulnerabilityAssessmentRuleBaseline.MssqlDatabaseVulnerabilityAssessmentRuleBaselineConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "connection": "connection",
        "count": "count",
        "depends_on": "dependsOn",
        "for_each": "forEach",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "provisioners": "provisioners",
        "baseline_result": "baselineResult",
        "database_name": "databaseName",
        "rule_id": "ruleId",
        "server_vulnerability_assessment_id": "serverVulnerabilityAssessmentId",
        "baseline_name": "baselineName",
        "id": "id",
        "timeouts": "timeouts",
    },
)
class MssqlDatabaseVulnerabilityAssessmentRuleBaselineConfig(
    cdktf.TerraformMetaArguments,
):
    def __init__(
        self,
        *,
        connection: typing.Optional[typing.Union[typing.Union[cdktf.SSHProvisionerConnection, typing.Dict[str, typing.Any]], typing.Union[cdktf.WinrmProvisionerConnection, typing.Dict[str, typing.Any]]]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[cdktf.ITerraformDependable]] = None,
        for_each: typing.Optional[cdktf.ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union[cdktf.TerraformResourceLifecycle, typing.Dict[str, typing.Any]]] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[cdktf.FileProvisioner, typing.Dict[str, typing.Any]], typing.Union[cdktf.LocalExecProvisioner, typing.Dict[str, typing.Any]], typing.Union[cdktf.RemoteExecProvisioner, typing.Dict[str, typing.Any]]]]] = None,
        baseline_result: typing.Union[cdktf.IResolvable, typing.Sequence[typing.Union[MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult, typing.Dict[str, typing.Any]]]],
        database_name: builtins.str,
        rule_id: builtins.str,
        server_vulnerability_assessment_id: builtins.str,
        baseline_name: typing.Optional[builtins.str] = None,
        id: typing.Optional[builtins.str] = None,
        timeouts: typing.Optional[typing.Union["MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts", typing.Dict[str, typing.Any]]] = None,
    ) -> None:
        '''
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 
        :param baseline_result: baseline_result block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#baseline_result MssqlDatabaseVulnerabilityAssessmentRuleBaseline#baseline_result}
        :param database_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#database_name MssqlDatabaseVulnerabilityAssessmentRuleBaseline#database_name}.
        :param rule_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#rule_id MssqlDatabaseVulnerabilityAssessmentRuleBaseline#rule_id}.
        :param server_vulnerability_assessment_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#server_vulnerability_assessment_id MssqlDatabaseVulnerabilityAssessmentRuleBaseline#server_vulnerability_assessment_id}.
        :param baseline_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#baseline_name MssqlDatabaseVulnerabilityAssessmentRuleBaseline#baseline_name}.
        :param id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#id MssqlDatabaseVulnerabilityAssessmentRuleBaseline#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param timeouts: timeouts block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#timeouts MssqlDatabaseVulnerabilityAssessmentRuleBaseline#timeouts}
        '''
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts(**timeouts)
        if __debug__:
            type_hints = typing.get_type_hints(MssqlDatabaseVulnerabilityAssessmentRuleBaselineConfig.__init__)
            check_type(argname="argument connection", value=connection, expected_type=type_hints["connection"])
            check_type(argname="argument count", value=count, expected_type=type_hints["count"])
            check_type(argname="argument depends_on", value=depends_on, expected_type=type_hints["depends_on"])
            check_type(argname="argument for_each", value=for_each, expected_type=type_hints["for_each"])
            check_type(argname="argument lifecycle", value=lifecycle, expected_type=type_hints["lifecycle"])
            check_type(argname="argument provider", value=provider, expected_type=type_hints["provider"])
            check_type(argname="argument provisioners", value=provisioners, expected_type=type_hints["provisioners"])
            check_type(argname="argument baseline_result", value=baseline_result, expected_type=type_hints["baseline_result"])
            check_type(argname="argument database_name", value=database_name, expected_type=type_hints["database_name"])
            check_type(argname="argument rule_id", value=rule_id, expected_type=type_hints["rule_id"])
            check_type(argname="argument server_vulnerability_assessment_id", value=server_vulnerability_assessment_id, expected_type=type_hints["server_vulnerability_assessment_id"])
            check_type(argname="argument baseline_name", value=baseline_name, expected_type=type_hints["baseline_name"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument timeouts", value=timeouts, expected_type=type_hints["timeouts"])
        self._values: typing.Dict[str, typing.Any] = {
            "baseline_result": baseline_result,
            "database_name": database_name,
            "rule_id": rule_id,
            "server_vulnerability_assessment_id": server_vulnerability_assessment_id,
        }
        if connection is not None:
            self._values["connection"] = connection
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if for_each is not None:
            self._values["for_each"] = for_each
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if provisioners is not None:
            self._values["provisioners"] = provisioners
        if baseline_name is not None:
            self._values["baseline_name"] = baseline_name
        if id is not None:
            self._values["id"] = id
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def connection(
        self,
    ) -> typing.Optional[typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("connection")
        return typing.cast(typing.Optional[typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]], result)

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[cdktf.ITerraformDependable]], result)

    @builtins.property
    def for_each(self) -> typing.Optional[cdktf.ITerraformIterator]:
        '''
        :stability: experimental
        '''
        result = self._values.get("for_each")
        return typing.cast(typing.Optional[cdktf.ITerraformIterator], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[cdktf.TerraformResourceLifecycle], result)

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional[cdktf.TerraformProvider], result)

    @builtins.property
    def provisioners(
        self,
    ) -> typing.Optional[typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provisioners")
        return typing.cast(typing.Optional[typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]], result)

    @builtins.property
    def baseline_result(
        self,
    ) -> typing.Union[cdktf.IResolvable, typing.List[MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult]]:
        '''baseline_result block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#baseline_result MssqlDatabaseVulnerabilityAssessmentRuleBaseline#baseline_result}
        '''
        result = self._values.get("baseline_result")
        assert result is not None, "Required property 'baseline_result' is missing"
        return typing.cast(typing.Union[cdktf.IResolvable, typing.List[MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult]], result)

    @builtins.property
    def database_name(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#database_name MssqlDatabaseVulnerabilityAssessmentRuleBaseline#database_name}.'''
        result = self._values.get("database_name")
        assert result is not None, "Required property 'database_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def rule_id(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#rule_id MssqlDatabaseVulnerabilityAssessmentRuleBaseline#rule_id}.'''
        result = self._values.get("rule_id")
        assert result is not None, "Required property 'rule_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def server_vulnerability_assessment_id(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#server_vulnerability_assessment_id MssqlDatabaseVulnerabilityAssessmentRuleBaseline#server_vulnerability_assessment_id}.'''
        result = self._values.get("server_vulnerability_assessment_id")
        assert result is not None, "Required property 'server_vulnerability_assessment_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def baseline_name(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#baseline_name MssqlDatabaseVulnerabilityAssessmentRuleBaseline#baseline_name}.'''
        result = self._values.get("baseline_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#id MssqlDatabaseVulnerabilityAssessmentRuleBaseline#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def timeouts(
        self,
    ) -> typing.Optional["MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts"]:
        '''timeouts block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#timeouts MssqlDatabaseVulnerabilityAssessmentRuleBaseline#timeouts}
        '''
        result = self._values.get("timeouts")
        return typing.cast(typing.Optional["MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MssqlDatabaseVulnerabilityAssessmentRuleBaselineConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-azurerm.mssqlDatabaseVulnerabilityAssessmentRuleBaseline.MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts",
    jsii_struct_bases=[],
    name_mapping={
        "create": "create",
        "delete": "delete",
        "read": "read",
        "update": "update",
    },
)
class MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[builtins.str] = None,
        delete: typing.Optional[builtins.str] = None,
        read: typing.Optional[builtins.str] = None,
        update: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param create: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#create MssqlDatabaseVulnerabilityAssessmentRuleBaseline#create}.
        :param delete: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#delete MssqlDatabaseVulnerabilityAssessmentRuleBaseline#delete}.
        :param read: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#read MssqlDatabaseVulnerabilityAssessmentRuleBaseline#read}.
        :param update: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#update MssqlDatabaseVulnerabilityAssessmentRuleBaseline#update}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts.__init__)
            check_type(argname="argument create", value=create, expected_type=type_hints["create"])
            check_type(argname="argument delete", value=delete, expected_type=type_hints["delete"])
            check_type(argname="argument read", value=read, expected_type=type_hints["read"])
            check_type(argname="argument update", value=update, expected_type=type_hints["update"])
        self._values: typing.Dict[str, typing.Any] = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if read is not None:
            self._values["read"] = read
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#create MssqlDatabaseVulnerabilityAssessmentRuleBaseline#create}.'''
        result = self._values.get("create")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def delete(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#delete MssqlDatabaseVulnerabilityAssessmentRuleBaseline#delete}.'''
        result = self._values.get("delete")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#read MssqlDatabaseVulnerabilityAssessmentRuleBaseline#read}.'''
        result = self._values.get("read")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def update(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_vulnerability_assessment_rule_baseline#update MssqlDatabaseVulnerabilityAssessmentRuleBaseline#update}.'''
        result = self._values.get("update")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeoutsOutputReference(
    cdktf.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-azurerm.mssqlDatabaseVulnerabilityAssessmentRuleBaseline.MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeoutsOutputReference",
):
    def __init__(
        self,
        terraform_resource: cdktf.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeoutsOutputReference.__init__)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetCreate")
    def reset_create(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCreate", []))

    @jsii.member(jsii_name="resetDelete")
    def reset_delete(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetDelete", []))

    @jsii.member(jsii_name="resetRead")
    def reset_read(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRead", []))

    @jsii.member(jsii_name="resetUpdate")
    def reset_update(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetUpdate", []))

    @builtins.property
    @jsii.member(jsii_name="createInput")
    def create_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "createInput"))

    @builtins.property
    @jsii.member(jsii_name="deleteInput")
    def delete_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "deleteInput"))

    @builtins.property
    @jsii.member(jsii_name="readInput")
    def read_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "readInput"))

    @builtins.property
    @jsii.member(jsii_name="updateInput")
    def update_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "updateInput"))

    @builtins.property
    @jsii.member(jsii_name="create")
    def create(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "create"))

    @create.setter
    def create(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeoutsOutputReference, "create").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "create", value)

    @builtins.property
    @jsii.member(jsii_name="delete")
    def delete(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "delete"))

    @delete.setter
    def delete(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeoutsOutputReference, "delete").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "delete", value)

    @builtins.property
    @jsii.member(jsii_name="read")
    def read(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "read"))

    @read.setter
    def read(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeoutsOutputReference, "read").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "read", value)

    @builtins.property
    @jsii.member(jsii_name="update")
    def update(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "update"))

    @update.setter
    def update(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeoutsOutputReference, "update").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "update", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(
        self,
    ) -> typing.Optional[typing.Union[MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts, cdktf.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts, cdktf.IResolvable]], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[typing.Union[MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts, cdktf.IResolvable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(getattr(MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeoutsOutputReference, "internal_value").fset)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


__all__ = [
    "MssqlDatabaseVulnerabilityAssessmentRuleBaseline",
    "MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult",
    "MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultList",
    "MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultOutputReference",
    "MssqlDatabaseVulnerabilityAssessmentRuleBaselineConfig",
    "MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts",
    "MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeoutsOutputReference",
]

publication.publish()
