# coding: utf-8

"""
    Ethos

    API for Ethos AI

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from typing import Any, Optional

from ethos.ethos_client.models.blob import Blob
from ethos.ethos_client.models.blob_create import BlobCreate

from ethos.ethos_client.api_client import ApiClient
from ethos.ethos_client.api_response import ApiResponse
from ethos.ethos_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class BlobsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_blob(self, blob_create : BlobCreate, expand : Optional[Any] = None, **kwargs) -> Blob:  # noqa: E501
        """Create Blob  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_blob(blob_create, expand, async_req=True)
        >>> result = thread.get()

        :param blob_create: (required)
        :type blob_create: BlobCreate
        :param expand:
        :type expand: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Blob
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_blob_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_blob_with_http_info(blob_create, expand, **kwargs)  # noqa: E501

    @validate_arguments
    def create_blob_with_http_info(self, blob_create : BlobCreate, expand : Optional[Any] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Create Blob  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_blob_with_http_info(blob_create, expand, async_req=True)
        >>> result = thread.get()

        :param blob_create: (required)
        :type blob_create: BlobCreate
        :param expand:
        :type expand: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Blob, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'blob_create',
            'expand'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_blob" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('expand') is not None:  # noqa: E501
            _query_params.append(('expand', _params['expand']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['blob_create'] is not None:
            _body_params = _params['blob_create']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['OAuth2PasswordBearer', 'APIKeyCookie']  # noqa: E501

        _response_types_map = {
            '201': "Blob",
            '422': "HTTPValidationError",
        }

        return self.api_client.call_api(
            '/v1/blobs', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_blob(self, blob : Any, with_signed_download_url : Optional[Any] = None, expand : Optional[Any] = None, **kwargs) -> Blob:  # noqa: E501
        """Get Blob  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_blob(blob, with_signed_download_url, expand, async_req=True)
        >>> result = thread.get()

        :param blob: (required)
        :type blob: object
        :param with_signed_download_url:
        :type with_signed_download_url: object
        :param expand:
        :type expand: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Blob
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_blob_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_blob_with_http_info(blob, with_signed_download_url, expand, **kwargs)  # noqa: E501

    @validate_arguments
    def get_blob_with_http_info(self, blob : Any, with_signed_download_url : Optional[Any] = None, expand : Optional[Any] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Blob  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_blob_with_http_info(blob, with_signed_download_url, expand, async_req=True)
        >>> result = thread.get()

        :param blob: (required)
        :type blob: object
        :param with_signed_download_url:
        :type with_signed_download_url: object
        :param expand:
        :type expand: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Blob, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'blob',
            'with_signed_download_url',
            'expand'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_blob" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['blob']:
            _path_params['blob'] = _params['blob']


        # process the query parameters
        _query_params = []
        if _params.get('with_signed_download_url') is not None:  # noqa: E501
            _query_params.append(('with_signed_download_url', _params['with_signed_download_url']))

        if _params.get('expand') is not None:  # noqa: E501
            _query_params.append(('expand', _params['expand']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['OAuth2PasswordBearer', 'APIKeyCookie']  # noqa: E501

        _response_types_map = {
            '200': "Blob",
            '422': "HTTPValidationError",
        }

        return self.api_client.call_api(
            '/v1/blobs/{blob}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def sync_blob_from_datasource(self, blob : Any, expand : Optional[Any] = None, **kwargs) -> Blob:  # noqa: E501
        """Sync Blob From Datasource  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sync_blob_from_datasource(blob, expand, async_req=True)
        >>> result = thread.get()

        :param blob: (required)
        :type blob: object
        :param expand:
        :type expand: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Blob
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the sync_blob_from_datasource_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.sync_blob_from_datasource_with_http_info(blob, expand, **kwargs)  # noqa: E501

    @validate_arguments
    def sync_blob_from_datasource_with_http_info(self, blob : Any, expand : Optional[Any] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Sync Blob From Datasource  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sync_blob_from_datasource_with_http_info(blob, expand, async_req=True)
        >>> result = thread.get()

        :param blob: (required)
        :type blob: object
        :param expand:
        :type expand: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Blob, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'blob',
            'expand'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method sync_blob_from_datasource" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['blob']:
            _path_params['blob'] = _params['blob']


        # process the query parameters
        _query_params = []
        if _params.get('expand') is not None:  # noqa: E501
            _query_params.append(('expand', _params['expand']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['OAuth2PasswordBearer', 'APIKeyCookie']  # noqa: E501

        _response_types_map = {
            '200': "Blob",
            '422': "HTTPValidationError",
        }

        return self.api_client.call_api(
            '/v1/blobs/{blob}/sync', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
