# coding: utf-8

"""
    Ethos

    API for Ethos AI

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Optional
from pydantic import BaseModel, Field, validator

class Resource(BaseModel):
    """
    Resource
    """
    object: Optional[Any] = Field(...)
    id: Optional[Any] = Field(...)
    name: Optional[Any] = Field(...)
    type: Optional[Any] = Field(...)
    version_tags: Optional[Any] = Field(...)
    tags: Optional[Any] = Field(...)
    created_by: Optional[Any] = Field(...)
    created_at: Optional[Any] = Field(...)
    value: Optional[Any] = Field(...)
    resource_blobs: Optional[Any] = Field(...)
    dataset_schema: Optional[Any] = Field(...)
    __properties = ["object", "id", "name", "type", "version_tags", "tags", "created_by", "created_at", "value", "resource_blobs", "dataset_schema"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('dataset', 'file', 'file_set', 'string', 'string_series', 'string_set', 'integer', 'float', 'float_series', 'boolean', 'datetime'):
            raise ValueError("must be one of enum values ('dataset', 'file', 'file_set', 'string', 'string_series', 'string_set', 'integer', 'float', 'float_series', 'boolean', 'datetime')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Resource:
        """Create an instance of Resource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if object (nullable) is None
        # and __fields_set__ contains the field
        if self.object is None and "object" in self.__fields_set__:
            _dict['object'] = None

        # set to None if id (nullable) is None
        # and __fields_set__ contains the field
        if self.id is None and "id" in self.__fields_set__:
            _dict['id'] = None

        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if type (nullable) is None
        # and __fields_set__ contains the field
        if self.type is None and "type" in self.__fields_set__:
            _dict['type'] = None

        # set to None if version_tags (nullable) is None
        # and __fields_set__ contains the field
        if self.version_tags is None and "version_tags" in self.__fields_set__:
            _dict['version_tags'] = None

        # set to None if tags (nullable) is None
        # and __fields_set__ contains the field
        if self.tags is None and "tags" in self.__fields_set__:
            _dict['tags'] = None

        # set to None if created_by (nullable) is None
        # and __fields_set__ contains the field
        if self.created_by is None and "created_by" in self.__fields_set__:
            _dict['created_by'] = None

        # set to None if created_at (nullable) is None
        # and __fields_set__ contains the field
        if self.created_at is None and "created_at" in self.__fields_set__:
            _dict['created_at'] = None

        # set to None if value (nullable) is None
        # and __fields_set__ contains the field
        if self.value is None and "value" in self.__fields_set__:
            _dict['value'] = None

        # set to None if resource_blobs (nullable) is None
        # and __fields_set__ contains the field
        if self.resource_blobs is None and "resource_blobs" in self.__fields_set__:
            _dict['resource_blobs'] = None

        # set to None if dataset_schema (nullable) is None
        # and __fields_set__ contains the field
        if self.dataset_schema is None and "dataset_schema" in self.__fields_set__:
            _dict['dataset_schema'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Resource:
        """Create an instance of Resource from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Resource.parse_obj(obj)

        _obj = Resource.parse_obj({
            "object": obj.get("object"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "type": obj.get("type"),
            "version_tags": obj.get("version_tags"),
            "tags": obj.get("tags"),
            "created_by": obj.get("created_by"),
            "created_at": obj.get("created_at"),
            "value": obj.get("value"),
            "resource_blobs": obj.get("resource_blobs"),
            "dataset_schema": obj.get("dataset_schema")
        })
        return _obj


