# coding: utf-8

"""
    Ethos

    API for Ethos AI

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Optional
from pydantic import BaseModel, Field, validator
from ethos.ethos_client.models.dataset_schema_create import DatasetSchemaCreate

class ResourceCreate(BaseModel):
    """
    ResourceCreate
    """
    name: Optional[Any] = Field(...)
    type: Optional[Any] = Field(...)
    version_tags: Optional[Any] = None
    tags: Optional[Any] = None
    related: Optional[Any] = Field(...)
    value: Optional[Any] = Field(...)
    dataset_schema: Optional[DatasetSchemaCreate] = None
    __properties = ["name", "type", "version_tags", "tags", "related", "value", "dataset_schema"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('dataset', 'file', 'file_set', 'string', 'string_series', 'string_set', 'integer', 'float', 'float_series', 'boolean', 'datetime'):
            raise ValueError("must be one of enum values ('dataset', 'file', 'file_set', 'string', 'string_series', 'string_set', 'integer', 'float', 'float_series', 'boolean', 'datetime')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ResourceCreate:
        """Create an instance of ResourceCreate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of dataset_schema
        if self.dataset_schema:
            _dict['dataset_schema'] = self.dataset_schema.to_dict()
        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if type (nullable) is None
        # and __fields_set__ contains the field
        if self.type is None and "type" in self.__fields_set__:
            _dict['type'] = None

        # set to None if version_tags (nullable) is None
        # and __fields_set__ contains the field
        if self.version_tags is None and "version_tags" in self.__fields_set__:
            _dict['version_tags'] = None

        # set to None if tags (nullable) is None
        # and __fields_set__ contains the field
        if self.tags is None and "tags" in self.__fields_set__:
            _dict['tags'] = None

        # set to None if related (nullable) is None
        # and __fields_set__ contains the field
        if self.related is None and "related" in self.__fields_set__:
            _dict['related'] = None

        # set to None if value (nullable) is None
        # and __fields_set__ contains the field
        if self.value is None and "value" in self.__fields_set__:
            _dict['value'] = None

        # set to None if dataset_schema (nullable) is None
        # and __fields_set__ contains the field
        if self.dataset_schema is None and "dataset_schema" in self.__fields_set__:
            _dict['dataset_schema'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ResourceCreate:
        """Create an instance of ResourceCreate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ResourceCreate.parse_obj(obj)

        _obj = ResourceCreate.parse_obj({
            "name": obj.get("name"),
            "type": obj.get("type"),
            "version_tags": obj.get("version_tags"),
            "tags": obj.get("tags"),
            "related": obj.get("related"),
            "value": obj.get("value"),
            "dataset_schema": DatasetSchemaCreate.from_dict(obj.get("dataset_schema")) if obj.get("dataset_schema") is not None else None
        })
        return _obj


