/**
 * @file   material_non_local_includes.hh
 *
 * @author Nicolas Richart <nicolas.richart@epfl.ch>
 *
 * @date creation: Wed Oct 31 2012
 * @date last modification: Thu Dec 17 2020
 *
 * @brief  Non local materials includes
 *
 *
 * @section LICENSE
 *
 * Copyright (©) 2010-2021 EPFL (Ecole Polytechnique Fédérale de Lausanne)
 * Laboratory (LSMS - Laboratoire de Simulation en Mécanique des Solides)
 *
 * Akantu is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * Akantu is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Akantu. If not, see <http://www.gnu.org/licenses/>.
 *
 */

/* -------------------------------------------------------------------------- */
#ifndef AKANTU_CMAKE_LIST_MATERIALS
#include "material_marigo_non_local.hh"
#include "material_mazars_non_local.hh"
#include "material_von_mises_mazars_non_local.hh"
#endif

#define AKANTU_DAMAGE_NON_LOCAL_MATERIAL_LIST                                  \
  ((2, (marigo_non_local, MaterialMarigoNonLocal)))(                           \
      (2, (mazars_non_local, MaterialMazarsNonLocal)))(                        \
      (2, (von_mises_mazars_non_local, MaterialVonMisesMazarsNonLocal)))
