"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DenoFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const lambda = require("aws-cdk-lib/aws-lambda");
const deno_layer_1 = require("./deno-layer");
class DenoFunction extends lambda.Function {
    constructor(scope, id, props) {
        const layer = deno_layer_1.DenoLayer.getOrCreate(scope, { version: props.version });
        const layers = props.layers || [];
        layers.unshift(layer);
        const handler = props.handler ?? "index.handler";
        super(scope, id, {
            runtime: lambda.Runtime.PROVIDED_AL2,
            handler: handler,
            ...props,
            layers: layers,
        });
    }
}
exports.DenoFunction = DenoFunction;
_a = JSII_RTTI_SYMBOL_1;
DenoFunction[_a] = { fqn: "@pepperize/cdk-lambda-deno.DenoFunction", version: "0.0.268" };
//# sourceMappingURL=data:application/json;base64,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