#****************************************************************************
#* __main__.py
#*
#* Copyright 2022 Matthew Ballance and Contributors
#*
#* Licensed under the Apache License, Version 2.0 (the "License"); you may 
#* not use this file except in compliance with the License.  
#* You may obtain a copy of the License at:
#*
#*   http://www.apache.org/licenses/LICENSE-2.0
#*
#* Unless required by applicable law or agreed to in writing, software 
#* distributed under the License is distributed on an "AS IS" BASIS, 
#* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  
#* See the License for the specific language governing permissions and 
#* limitations under the License.
#*
#* Created on:
#*     Author: 
#*
#****************************************************************************
import argparse

def getparser():
    parser = argparse.ArgumentParser()
    subparsers = parser.add_subparsers()
    subparsers.required = True

    synth_cmd = subparsers.add_parser("synth",
        help="Process PSS and generate synthesized output")
    synth_cmd.add_argument("style", 
        choices={"c-test", "c-actions"},
        help="Specifies output generator")
    synth_cmd.set_defaults(func=None)
    synth_cmd.add_argument("args", nargs=argparse.REMAINDER)

    return parser

def main():
    parser = getparser()

    args = parser.parse_args()

    pass


if __name__ == "__main__":
    main()
