#
# Copyright © 2012 - 2020 Michal Čihař <michal@cihar.com>
#
# This file is part of Weblate <https://weblate.org/>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#

"""Language data definitions.

This is an automatically generated file, see scripts/generate-language-data

Do not edit, please adjust language definitions in following repository:
https://github.com/WeblateOrg/language-data
"""
# pylint: disable=line-too-long,too-many-lines


# Language names to ignore in same check
LANGUAGES = {
    "aakkâr",
    "aargau",
    "aari",
    "aasáx",
    "abaco",
    "abad",
    "abadi",
    "abaga",
    "abai",
    "abaita",
    "abanyom",
    "abar",
    "abau",
    "abawa",
    "abaza",
    "abaúj",
    "abbès",
    "abellen",
    "aberdeen",
    "aberdeenshire",
    "abertawe",
    "abia",
    "abidji",
    "abim",
    "abinomn",
    "abipon",
    "abishira",
    "abkhazia",
    "abkhazian",
    "abnaki",
    "aboh",
    "abom",
    "abon",
    "aboriginal",
    "aborigines",
    "abra",
    "abron",
    "abruzzo",
    "abu",
    "abua",
    "abui",
    "abuja",
    "abun",
    "abure",
    "abureni",
    "abyaḑ",
    "abyān",
    "abé",
    "abşeron",
    "abū",
    "acatepec",
    "account",
    "accra",
    "aceh",
    "acehnese",
    "achagua",
    "achang",
    "achaïa",
    "ache",
    "acheron",
    "achi",
    "achinese",
    "acholi",
    "achterhoeks",
    "achuar",
    "achumawi",
    "aché",
    "acipa",
    "acklins",
    "acoli",
    "acquaviva",
    "acre",
    "acroá",
    "adabe",
    "adai",
    "adamaoua",
    "adamawa",
    "adamorobe",
    "adan",
    "adana",
    "adang",
    "adangbe",
    "adangme",
    "adara",
    "adasen",
    "adb",
    "adele",
    "adeni",
    "adh",
    "adhola",
    "adi",
    "adige",
    "adilabad",
    "adioukrou",
    "adithinngithigh",
    "adivasi",
    "adiwasi",
    "adjumani",
    "adlam",
    "adnyamathanha",
    "adonara",
    "adrar",
    "aduge",
    "adygei",
    "adygeya",
    "adyghe",
    "adza",
    "adzera",
    "adıyaman",
    "aḑ",
    "aeka",
    "aekyom",
    "aequian",
    "aer",
    "aerodrom",
    "afade",
    "afaka",
    "afar",
    "afars",
    "afghan",
    "afghani",
    "afghanistan",
    "afitti",
    "africa",
    "african",
    "afrihili",
    "afrikaans",
    "afro",
    "afyonkarahisar",
    "agadez",
    "agadir",
    "agalega",
    "agarabi",
    "agariya",
    "agatu",
    "agavotaguerra",
    "agder",
    "aghem",
    "aghu",
    "aghul",
    "aghwan",
    "aghwar",
    "agi",
    "agio",
    "aglonas",
    "agnébi",
    "agob",
    "agoi",
    "agrigento",
    "agta",
    "aguacateco",
    "aguano",
    "aguaruna",
    "aguascalientes",
    "aguna",
    "agusan",
    "agustín",
    "agutaynen",
    "agwagwune",
    "ahafo",
    "ahal",
    "ahanta",
    "aheri",
    "aheu",
    "ahia",
    "ahirani",
    "ahmad",
    "ahmadi",
    "ahmar",
    "ahom",
    "ahras",
    "ahtena",
    "ahuacatlán",
    "ahuachapán",
    "ahuatempan",
    "ahvenanmaan",
    "ahwai",
    "aichi",
    "aiga",
    "aigaio",
    "aighon",
    "aikanã",
    "aiklep",
    "aileu",
    "ailinglaplap",
    "ailuk",
    "aimaq",
    "aimele",
    "aimeliik",
    "aimol",
    "ain",
    "ainaro",
    "ainbai",
    "ainu",
    "aiome",
    "airai",
    "aires",
    "airoran",
    "aisne",
    "aisén",
    "ait",
    "aitolia",
    "aiton",
    "aiwo",
    "aizi",
    "aizkraukles",
    "aizputes",
    "aja",
    "ajaria",
    "ajawa",
    "ajdovščina",
    "ajië",
    "ajmān",
    "ajumbu",
    "ajyíninka",
    "aka",
    "akan",
    "akar",
    "akarnania",
    "akaselem",
    "akawaio",
    "ake",
    "akebu",
    "akei",
    "akershus",
    "akeu",
    "akha",
    "akhvakh",
    "akhḑar",
    "akita",
    "akkadian",
    "akkala",
    "aklan",
    "aklanon",
    "aknīstes",
    "akolet",
    "akoose",
    "akoye",
    "akpa",
    "akpes",
    "akrukay",
    "aksaray",
    "akukem",
    "akuku",
    "akum",
    "akuntsu",
    "akurio",
    "akwa",
    "akyaung",
    "alaa",
    "alaba",
    "alabama",
    "alabat",
    "alacalufan",
    "alacatlatzala",
    "alago",
    "alagoas",
    "alagwa",
    "alajuela",
    "alak",
    "alamblak",
    "alangan",
    "alanic",
    "alaniya",
    "alapmunte",
    "alas",
    "alaska",
    "alaskan",
    "alawa",
    "alba",
    "albacete",
    "albania",
    "albanian",
    "albarradas",
    "albay",
    "alberta",
    "alcozauca",
    "alege",
    "alekano",
    "alemannic",
    "alene",
    "alessandria",
    "aleut",
    "alger",
    "algeria",
    "algerian",
    "algic",
    "algonquian",
    "algonquin",
    "ali",
    "alias",
    "alibata",
    "alibori",
    "alicante",
    "alifu",
    "alladian",
    "allar",
    "allier",
    "almaty",
    "almería",
    "alngith",
    "alo",
    "alojas",
    "alor",
    "aloápam",
    "alpes",
    "alsatian",
    "alsea",
    "also",
    "alsungas",
    "alta",
    "altagracia",
    "altai",
    "altaic",
    "altas",
    "altay",
    "altayskiy",
    "alto",
    "alu",
    "alugu",
    "alumu",
    "alune",
    "aluo",
    "alur",
    "alutor",
    "alviri",
    "alyawarr",
    "alytaus",
    "alūksnes",
    "ama",
    "amacuro",
    "amahai",
    "amahuaca",
    "amaimon",
    "amal",
    "amambay",
    "amami",
    "amanab",
    "amanayé",
    "amapá",
    "amara",
    "amarakaeri",
    "amarasi",
    "amasya",
    "amatas",
    "amatlán",
    "amazonas",
    "amba",
    "ambae",
    "ambai",
    "ambakich",
    "ambala",
    "ambelau",
    "ambele",
    "amblong",
    "ambo",
    "ambonese",
    "ambrak",
    "ambrym",
    "ambu",
    "ambul",
    "ambulas",
    "amdang",
    "amdo",
    "amele",
    "america",
    "american",
    "amganad",
    "amharic",
    "ami",
    "amis",
    "ammóchostos",
    "amnat",
    "amo",
    "amol",
    "amolatar",
    "amoltepec",
    "ampanang",
    "ampari",
    "ampāara",
    "amri",
    "amrān",
    "amto",
    "amundava",
    "amurdak",
    "amuria",
    "amurskaya",
    "amuru",
    "amuzgo",
    "amuzgos",
    "ana",
    "anaang",
    "anabar",
    "anakalangu",
    "anal",
    "anam",
    "anambra",
    "anambé",
    "anamgura",
    "anasi",
    "anatolian",
    "anatoliki",
    "anbar",
    "ancash",
    "ancient",
    "ancona",
    "anda",
    "andaandi",
    "andai",
    "andajin",
    "andalucía",
    "andalusian",
    "andaman",
    "andamanese",
    "andaqui",
    "andarum",
    "andegerebinha",
    "andh",
    "andhra",
    "andi",
    "andijon",
    "andio",
    "andjazîdja",
    "andjouân",
    "andoa",
    "andoque",
    "andorra",
    "andra",
    "andraž",
    "andrew",
    "andria",
    "andrijevica",
    "andros",
    "andrés",
    "aneityum",
    "anem",
    "aneme",
    "anenii",
    "anetan",
    "anfillo",
    "ang",
    "angaataha",
    "angad",
    "angaité",
    "angal",
    "angami",
    "angaur",
    "angguruk",
    "angika",
    "angkamuthi",
    "angkola",
    "anglesey",
    "anglo",
    "angloromani",
    "angola",
    "angolar",
    "angor",
    "angoram",
    "angosturas",
    "anguilla",
    "angus",
    "anguthimri",
    "anha",
    "anhalt",
    "anhui",
    "ani",
    "anibare",
    "anii",
    "animere",
    "anindilyakwa",
    "aniwa",
    "anjam",
    "anjazījah",
    "anjob",
    "anjra",
    "anjwān",
    "ankara",
    "ankave",
    "ankwa",
    "anmatyerre",
    "ann",
    "annaba",
    "anne",
    "annobón",
    "anong",
    "anor",
    "ansabā",
    "anse",
    "anserma",
    "ansus",
    "antakarinya",
    "antalya",
    "antananarivo",
    "antankarana",
    "antarctic",
    "antarctica",
    "antigua",
    "antillean",
    "antilles",
    "antioquia",
    "antique",
    "antofagasta",
    "antrim",
    "antsi",
    "antsiranana",
    "antwerpen",
    "antártica",
    "anu",
    "anuak",
    "anufo",
    "anuki",
    "anurādhapura",
    "anus",
    "anuta",
    "anyan",
    "anyin",
    "anzoátegui",
    "aoheng",
    "aomori",
    "aore",
    "aosta",
    "aousserd",
    "apac",
    "apache",
    "apai",
    "apalachee",
    "apalaí",
    "apali",
    "apasco",
    "apatani",
    "apayao",
    "apayso",
    "apače",
    "ape",
    "apes",
    "api",
    "apiaká",
    "apinayé",
    "apma",
    "apoala",
    "appenzell",
    "applicable",
    "aproumu",
    "apskritis",
    "apure",
    "apurinã",
    "apurucayali",
    "apurímac",
    "aput",
    "aputai",
    "aqmola",
    "aqtöbe",
    "aquila",
    "aquitaine",
    "aquitanian",
    "arab",
    "arabana",
    "arabela",
    "arabia",
    "arabian",
    "arabic",
    "arad",
    "aragacotn",
    "aragonese",
    "aragua",
    "aragón",
    "araki",
    "arakwal",
    "aralle",
    "aramaic",
    "arammba",
    "aranadan",
    "aranama",
    "aranda",
    "arandai",
    "araona",
    "arapaho",
    "arapaso",
    "arapesh",
    "ararandewára",
    "ararat",
    "arauan",
    "arauca",
    "araucanía",
    "arawak",
    "arawakan",
    "araweté",
    "arawum",
    "aračinovo",
    "arbil",
    "arbore",
    "arbëreshë",
    "archi",
    "arctic",
    "ardabīl",
    "ardahan",
    "ardennes",
    "ardhamāgadhī",
    "ards",
    "ardèche",
    "area",
    "areas",
    "areba",
    "arem",
    "arequipa",
    "arezzo",
    "argentina",
    "argentine",
    "argeș",
    "argobba",
    "argolida",
    "arguni",
    "argyll",
    "arhangay",
    "arhe",
    "arhuaco",
    "arhâ",
    "arhö",
    "ari",
    "aria",
    "ariana",
    "ariary",
    "aribwatsa",
    "aribwaung",
    "arica",
    "arifama",
    "arigidi",
    "arikapú",
    "arikara",
    "arikem",
    "arima",
    "arin",
    "aringa",
    "arizona",
    "ariège",
    "arkadia",
    "arkansas",
    "arkhangel",
    "arma",
    "armagh",
    "armavir",
    "armazic",
    "armenia",
    "armenian",
    "armm",
    "armor",
    "arno",
    "aromanian",
    "arop",
    "arosi",
    "arous",
    "arpitan",
    "arrarnta",
    "arrernte",
    "arritinngithigh",
    "arréridj",
    "arsi",
    "arta",
    "artibonite",
    "artificial",
    "artigas",
    "artvin",
    "arua",
    "aruamu",
    "aruba",
    "aruban",
    "aruek",
    "arumanian",
    "arunachal",
    "aruop",
    "arusha",
    "arutani",
    "aruá",
    "arvanitika",
    "arára",
    "asaleleaga",
    "asaro",
    "asas",
    "ascension",
    "ascoli",
    "ash",
    "ashanti",
    "ashe",
    "ashkun",
    "asho",
    "ashtiani",
    "asháninka",
    "ashéninka",
    "asiatic",
    "asilulu",
    "askopan",
    "asmat",
    "asoa",
    "asomtavruli",
    "assa",
    "assaba",
    "assam",
    "assamese",
    "assan",
    "assangori",
    "assigned",
    "assilah",
    "assiniboine",
    "assyrian",
    "astana",
    "astara",
    "asti",
    "astrakhanskaya",
    "asturian",
    "asturias",
    "asturleonese",
    "asu",
    "asue",
    "asumboa",
    "asunción",
    "asuri",
    "asurini",
    "asuriní",
    "aswān",
    "asyūt",
    "asīr",
    "ata",
    "atacama",
    "atakapa",
    "atakora",
    "atampaya",
    "atas",
    "atatláhuca",
    "atayal",
    "atchin",
    "atemble",
    "athapascan",
    "athpariya",
    "ati",
    "atikamekw",
    "atlantic",
    "atlantique",
    "atlantiques",
    "atlas",
    "atlántico",
    "atlántida",
    "atohwaim",
    "atoll",
    "atong",
    "atorada",
    "atroari",
    "atsahuaca",
    "atsam",
    "atsugewi",
    "atta",
    "attapady",
    "attapu",
    "attard",
    "attiki",
    "attié",
    "atua",
    "atyraū",
    "atzingo",
    "aua",
    "aube",
    "auces",
    "auckland",
    "aude",
    "auhelawa",
    "aulua",
    "aur",
    "aurora",
    "aurá",
    "aushi",
    "aushiri",
    "ausserrhoden",
    "aust",
    "austral",
    "australes",
    "australia",
    "australian",
    "austria",
    "austrian",
    "austro",
    "austronesian",
    "austurland",
    "autonomă",
    "autónoma",
    "auvergne",
    "auwe",
    "aux",
    "auye",
    "auyokawa",
    "avar",
    "avaric",
    "avatime",
    "avau",
    "aveiro",
    "avellino",
    "avestan",
    "aveyron",
    "avikam",
    "aviv",
    "avokaya",
    "avtonomnaya",
    "avtonomnyy",
    "avá",
    "awa",
    "awabakal",
    "awad",
    "awadhi",
    "awak",
    "awar",
    "awara",
    "awbono",
    "awdal",
    "aweer",
    "awera",
    "awetí",
    "awing",
    "awiyaana",
    "awjilah",
    "awngi",
    "awngthim",
    "awsaţ",
    "awsaṭ",
    "awtuw",
    "awu",
    "awun",
    "awutu",
    "awyi",
    "awyu",
    "axamb",
    "axi",
    "ayabadhu",
    "ayacucho",
    "ayautla",
    "aydın",
    "ayere",
    "ayerrerenge",
    "ayeyarwady",
    "ayi",
    "ayiwo",
    "ayizi",
    "ayizo",
    "aymara",
    "aymará",
    "ayoquesco",
    "ayoreo",
    "ayrshire",
    "ayta",
    "ayu",
    "ayutla",
    "ayutthaya",
    "azad",
    "azerbaijan",
    "azerbaijani",
    "azerbaijanian",
    "azha",
    "azhe",
    "azilal",
    "azoyú",
    "azraq",
    "aztecan",
    "azua",
    "azuay",
    "az̧",
    "açores",
    "aïn",
    "ağcabədi",
    "ağdam",
    "ağdaş",
    "ağrı",
    "ağstafa",
    "ağsu",
    "aşgabat",
    "aḩmar",
    "baa",
    "baalbek",
    "baan",
    "baangi",
    "baatonum",
    "baba",
    "babalia",
    "babangk",
    "babango",
    "babanki",
    "babar",
    "babatana",
    "babil",
    "babine",
    "bable",
    "babuza",
    "babylonian",
    "babītes",
    "babək",
    "bacama",
    "bacanese",
    "bactrian",
    "bacău",
    "bada",
    "badaga",
    "badajoz",
    "badakhshan",
    "badakhshān",
    "bade",
    "baden",
    "badeshi",
    "badhun",
    "badimaya",
    "badjiri",
    "badui",
    "badulla",
    "badyara",
    "baeggu",
    "baelelea",
    "baetora",
    "bafanji",
    "bafatá",
    "bafaw",
    "bafia",
    "bafing",
    "bafut",
    "baga",
    "bagerhat",
    "baghdad",
    "bagheli",
    "baghlān",
    "bagirmi",
    "bagmati",
    "bago",
    "bagri",
    "bagupi",
    "bagusa",
    "bagvalal",
    "bah",
    "baha",
    "baham",
    "bahama",
    "bahamas",
    "bahamian",
    "baharna",
    "bahau",
    "bahia",
    "bahinemo",
    "bahing",
    "bahnar",
    "bahonsuai",
    "bahoruco",
    "bahr",
    "bahrain",
    "bahraini",
    "baht",
    "bahía",
    "baḩr",
    "bai",
    "baibai",
    "baie",
    "baikeno",
    "baima",
    "baimak",
    "bainouk",
    "baiso",
    "baissa",
    "baiti",
    "baja",
    "bajan",
    "bajau",
    "bajelani",
    "bajo",
    "baka",
    "bakairí",
    "bakaka",
    "bakati",
    "baker",
    "bakhtiari",
    "bakhtīārī",
    "baki",
    "bakoko",
    "bakole",
    "bakool",
    "bakpinka",
    "bakumpai",
    "bakwé",
    "bakı",
    "balaesang",
    "balah",
    "balaka",
    "balakən",
    "balangao",
    "balangingi",
    "balanta",
    "balantak",
    "balar",
    "balau",
    "balboa",
    "baldemu",
    "baldones",
    "bale",
    "balears",
    "balesi",
    "bali",
    "balinese",
    "balkan",
    "balkar",
    "balkarskaya",
    "balkh",
    "balo",
    "balochi",
    "balochistan",
    "baloi",
    "balong",
    "balqā",
    "baltazar",
    "balti",
    "baltic",
    "baltinavas",
    "baltistan",
    "baluan",
    "baluchi",
    "balvu",
    "balzan",
    "balzers",
    "balé",
    "balıkesir",
    "balūchestān",
    "bam",
    "bamako",
    "bamali",
    "bambalang",
    "bambam",
    "bambara",
    "bambari",
    "bambassi",
    "bambili",
    "bambui",
    "bamenyam",
    "bamileke",
    "bamingui",
    "bamu",
    "bamukumbit",
    "bamum",
    "bamun",
    "bamunka",
    "bamwe",
    "ban",
    "bana",
    "banaadir",
    "banao",
    "banaro",
    "banbridge",
    "banda",
    "bandama",
    "bandarban",
    "bandi",
    "bandial",
    "bandjalang",
    "bandundu",
    "bangala",
    "bangandu",
    "bangba",
    "banggai",
    "banggarla",
    "banghāzī",
    "bangi",
    "bangime",
    "bangka",
    "bangkok",
    "bangla",
    "bangladesh",
    "bangolan",
    "bangoran",
    "bangubangu",
    "bangui",
    "bangun",
    "bangwinji",
    "baniva",
    "baniwa",
    "banjar",
    "banjul",
    "bank",
    "bankagooma",
    "bankal",
    "bankan",
    "bankon",
    "banna",
    "bannoni",
    "banskobystrický",
    "bantawa",
    "bantayanon",
    "banteay",
    "banten",
    "bantik",
    "bantoanon",
    "bantu",
    "banwa",
    "banī",
    "baoulé",
    "bar",
    "bara",
    "baraamu",
    "barababaraba",
    "barahona",
    "barai",
    "barakai",
    "baram",
    "barama",
    "barambu",
    "baramu",
    "baranjska",
    "baranya",
    "barapasi",
    "baras",
    "barasana",
    "barat",
    "barbacoas",
    "barbados",
    "barbaram",
    "barbareño",
    "barbuda",
    "barcelona",
    "barclayville",
    "bardi",
    "bare",
    "barein",
    "bareli",
    "bargam",
    "barguna",
    "bari",
    "bariai",
    "bariji",
    "barikanchi",
    "barikewa",
    "barima",
    "barinas",
    "baringo",
    "barisal",
    "barkah",
    "barking",
    "barlavento",
    "barletta",
    "barnet",
    "barnsley",
    "barok",
    "barombi",
    "barro",
    "barrow",
    "barthélemy",
    "bartın",
    "baruga",
    "baruya",
    "barwe",
    "barzani",
    "baré",
    "barí",
    "bas",
    "basa",
    "basap",
    "basarabeasca",
    "basay",
    "basel",
    "bashkardi",
    "bashkir",
    "bashkortostan",
    "basilan",
    "basilicata",
    "basketo",
    "basnāhira",
    "basque",
    "basrah",
    "bassa",
    "bassari",
    "basse",
    "basseterre",
    "bassins",
    "bassossi",
    "bata",
    "batad",
    "batak",
    "batanes",
    "batanga",
    "batangas",
    "batasn",
    "batek",
    "bateri",
    "bathari",
    "bati",
    "batken",
    "batman",
    "batna",
    "bats",
    "battambang",
    "batu",
    "batui",
    "batuley",
    "batyala",
    "batys",
    "bau",
    "baucau",
    "bauchi",
    "baudó",
    "baure",
    "bauria",
    "bauskas",
    "bauwaki",
    "bauzi",
    "bavarian",
    "bawah",
    "bawm",
    "bayadh",
    "bayali",
    "bayan",
    "bayanhongor",
    "baybayanon",
    "baybayin",
    "bayburt",
    "bayelsa",
    "bayern",
    "baygo",
    "bayobiri",
    "bayono",
    "bayot",
    "bayungu",
    "bayḑā",
    "bazar",
    "bazigar",
    "bazèga",
    "baħar",
    "baḩr",
    "baḩrī",
    "baṭḩah",
    "bce",
    "bceao",
    "bea",
    "beac",
    "beami",
    "beau",
    "beaver",
    "beba",
    "bebele",
    "bebeli",
    "bebil",
    "bedawi",
    "bedawiyet",
    "bedford",
    "bedfordshire",
    "bedjond",
    "bedoanas",
    "bedouin",
    "beeke",
    "beele",
    "beembe",
    "beezen",
    "befang",
    "bei",
    "beijing",
    "beja",
    "bekati",
    "bekwarra",
    "bekwel",
    "bel",
    "belait",
    "belanda",
    "belarus",
    "belarusian",
    "belfast",
    "belfort",
    "belgique",
    "belgium",
    "belgorodskaya",
    "belhariya",
    "beli",
    "belitung",
    "belize",
    "bella",
    "bellari",
    "bellona",
    "belluno",
    "beltinci",
    "bemba",
    "bembe",
    "ben",
    "bena",
    "benabena",
    "bench",
    "bende",
    "bendi",
    "benedikt",
    "benevento",
    "benešov",
    "benfro",
    "beng",
    "benga",
    "bengal",
    "bengali",
    "benggoi",
    "bengkala",
    "bengkulu",
    "bengo",
    "benguela",
    "benguet",
    "beni",
    "benin",
    "bennour",
    "benslimane",
    "bentong",
    "benue",
    "benyadu",
    "beograd",
    "beothuk",
    "bepour",
    "bera",
    "berakou",
    "berane",
    "berat",
    "berau",
    "berawan",
    "berber",
    "berbice",
    "berea",
    "bereg",
    "bergamo",
    "beri",
    "berik",
    "berinomo",
    "berkane",
    "berkshire",
    "berlin",
    "bermuda",
    "bermudian",
    "bern",
    "bernardo",
    "berom",
    "beroun",
    "berovo",
    "berrechid",
    "berry",
    "berta",
    "berti",
    "besi",
    "besisi",
    "besme",
    "besoa",
    "bet",
    "betaf",
    "betawi",
    "bete",
    "bethlehem",
    "beti",
    "betsimisaraka",
    "betta",
    "beverīnas",
    "bexley",
    "beyla",
    "beyləqan",
    "beyrouth",
    "bezhta",
    "bhadrawahi",
    "bhaiksuki",
    "bhalay",
    "bharia",
    "bhasa",
    "bhatri",
    "bhattiyali",
    "bhaya",
    "bhele",
    "bheri",
    "bhil",
    "bhilali",
    "bhili",
    "bhojpuri",
    "bhola",
    "bhoti",
    "bhujel",
    "bhunjia",
    "bhutan",
    "biafada",
    "biage",
    "biak",
    "biali",
    "bian",
    "biangai",
    "biao",
    "biatah",
    "biau",
    "bibbulman",
    "bicol",
    "bidayuh",
    "bidhawal",
    "bidiyo",
    "bidyara",
    "bidyogo",
    "biella",
    "biem",
    "bierebo",
    "bieria",
    "biete",
    "biga",
    "bigambal",
    "bihar",
    "bihari",
    "bihor",
    "bihēreseboch",
    "bihēroch",
    "bijelo",
    "bijim",
    "bijori",
    "bikaru",
    "bikol",
    "bikya",
    "bila",
    "bilakura",
    "bilaspuri",
    "bilba",
    "bilbil",
    "bile",
    "bilecik",
    "bilen",
    "bilin",
    "biliran",
    "bilma",
    "bilogorska",
    "biloxi",
    "bilua",
    "bilur",
    "biləsuvar",
    "bima",
    "bimin",
    "bimini",
    "bimoba",
    "bina",
    "binahari",
    "binandere",
    "bindal",
    "bine",
    "bing",
    "bingöl",
    "bini",
    "binji",
    "binongan",
    "bintauna",
    "bintulu",
    "binukid",
    "binukidnon",
    "binumarien",
    "bioko",
    "biombo",
    "bipi",
    "bipim",
    "birale",
    "birao",
    "birgit",
    "birgu",
    "birhor",
    "biri",
    "birifor",
    "biritai",
    "birked",
    "birkirkara",
    "birmingham",
    "birr",
    "birri",
    "birrpayi",
    "birwa",
    "birżebbuġa",
    "bisa",
    "bisaya",
    "biseni",
    "bishkek",
    "bishnupriya",
    "bishuo",
    "bisis",
    "biskra",
    "bislama",
    "bisorio",
    "bissa",
    "bissau",
    "bistrica",
    "bistrița",
    "bisu",
    "bit",
    "bitare",
    "bitlis",
    "bitola",
    "bitur",
    "biwat",
    "biyo",
    "biyom",
    "bizerte",
    "bizkaia",
    "bié",
    "biên",
    "bjelovarsko",
    "blaan",
    "blablanga",
    "black",
    "blackburn",
    "blackpool",
    "blaenau",
    "blafe",
    "blagar",
    "blagoevgrad",
    "blang",
    "blansko",
    "blantyre",
    "blas",
    "bled",
    "blekinge",
    "blida",
    "blin",
    "bliss",
    "blissymbolics",
    "blissymbols",
    "bloke",
    "boa",
    "boaco",
    "boano",
    "boazi",
    "bobo",
    "bobonaro",
    "bobongko",
    "bobot",
    "bocas",
    "bodo",
    "boe",
    "boffa",
    "bofi",
    "boga",
    "bogaya",
    "bogdanci",
    "boghom",
    "bogotá",
    "bogovinje",
    "bogra",
    "boguru",
    "bohinj",
    "bohol",
    "bohtan",
    "bohuai",
    "boi",
    "boikin",
    "boileau",
    "bokha",
    "bokmål",
    "boko",
    "bokobaru",
    "bokoto",
    "bokyi",
    "bokèo",
    "boké",
    "bola",
    "bolama",
    "bolango",
    "bole",
    "boleslav",
    "bolgarian",
    "bolgo",
    "bolia",
    "bolikhamxai",
    "bolinao",
    "bolivarian",
    "bolivia",
    "bolivian",
    "boliviano",
    "bolo",
    "bologna",
    "boloki",
    "bolon",
    "bolondo",
    "bolongan",
    "bolton",
    "bolu",
    "bolyu",
    "bolzano",
    "bolívar",
    "bom",
    "boma",
    "bomberai",
    "bomboli",
    "bomboma",
    "bomet",
    "bomi",
    "bomitaba",
    "bomu",
    "bomwali",
    "bon",
    "bonaire",
    "bonan",
    "bond",
    "bondei",
    "bondo",
    "bondoukou",
    "bondum",
    "bonerate",
    "bonerif",
    "bong",
    "bonggi",
    "bonggo",
    "bongili",
    "bongo",
    "bongu",
    "bonjo",
    "bonkeng",
    "bonkiman",
    "bont",
    "bontok",
    "book",
    "bookan",
    "booli",
    "boon",
    "boor",
    "bopomofo",
    "boquerón",
    "bor",
    "bora",
    "borana",
    "border",
    "borders",
    "bordj",
    "borei",
    "borgo",
    "borgou",
    "borgu",
    "bormla",
    "bornes",
    "borno",
    "boro",
    "borok",
    "borong",
    "borovnica",
    "borski",
    "borsod",
    "boruca",
    "borôro",
    "bosansko",
    "boselewa",
    "bosilovo",
    "bosne",
    "bosngun",
    "bosnia",
    "bosnian",
    "bossangoa",
    "bote",
    "botlikh",
    "boto",
    "botolan",
    "botoșani",
    "botswana",
    "bou",
    "bouaghi",
    "bouches",
    "boucle",
    "bouenza",
    "bougainville",
    "bougouriba",
    "bouira",
    "boujdour",
    "boulemane",
    "boulgou",
    "boulkiemdé",
    "boumerdès",
    "bouna",
    "bourgogne",
    "bourmataguil",
    "bournemouth",
    "bouvet",
    "bouyei",
    "bouzid",
    "bovec",
    "boyacá",
    "bozaba",
    "bozo",
    "bozoum",
    "brabant",
    "bracknell",
    "bradford",
    "braga",
    "bragança",
    "bragat",
    "brahmanbaria",
    "brahmi",
    "brahui",
    "braille",
    "braj",
    "brakna",
    "branco",
    "brandenburg",
    "braničevski",
    "braslovče",
    "brat",
    "bratislavský",
    "brava",
    "brazil",
    "brazilian",
    "brazzaville",
    "brașov",
    "brda",
    "brem",
    "bremen",
    "brent",
    "breri",
    "brescia",
    "bresckaja",
    "bretagne",
    "breton",
    "brezovica",
    "brežice",
    "brianza",
    "bribri",
    "briceni",
    "bridgend",
    "brighton",
    "brindisi",
    "bristol",
    "britain",
    "brithenig",
    "british",
    "brno",
    "bro",
    "brocēnu",
    "brod",
    "brodsko",
    "brokkat",
    "brokopondo",
    "brokpake",
    "brokskat",
    "bromley",
    "bromnya",
    "brong",
    "brooke",
    "broome",
    "bru",
    "brunei",
    "brunswick",
    "bruntál",
    "brussels",
    "bruxelles",
    "brvenica",
    "bryanskaya",
    "brăila",
    "brčko",
    "bua",
    "buada",
    "bualkhaw",
    "buamu",
    "buang",
    "bubanza",
    "bube",
    "bubi",
    "bubia",
    "buckinghamshire",
    "bucurești",
    "budaka",
    "budapest",
    "budeh",
    "budibud",
    "budong",
    "budu",
    "bududa",
    "budukh",
    "buduma",
    "budva",
    "budza",
    "budějovice",
    "buenos",
    "bugan",
    "bugawac",
    "bughotu",
    "buginese",
    "bugiri",
    "buglere",
    "buglé",
    "bugun",
    "buhayrah",
    "buhi",
    "buhid",
    "buhutu",
    "buḩayrah",
    "bujumbura",
    "bukar",
    "bukat",
    "bukedea",
    "bukharic",
    "bukidnon",
    "bukit",
    "bukitan",
    "bukiyip",
    "buksa",
    "bukto",
    "bukusu",
    "bukwa",
    "bukwen",
    "bulacan",
    "bulawayo",
    "bulgan",
    "bulgaria",
    "bulgarian",
    "bulgebi",
    "buli",
    "buliisa",
    "bullom",
    "bulo",
    "bulqizë",
    "bulu",
    "bum",
    "bumaji",
    "bumang",
    "bumbita",
    "bumthang",
    "bumthangkha",
    "bun",
    "buna",
    "bunaba",
    "bunak",
    "bunama",
    "bundeli",
    "bundibugyo",
    "bung",
    "bungain",
    "bunganditj",
    "bungku",
    "bungoma",
    "bungu",
    "bunoge",
    "bunu",
    "bunun",
    "buol",
    "bura",
    "burak",
    "buraka",
    "burarra",
    "burate",
    "buraymī",
    "burdekin",
    "burduna",
    "burdur",
    "bure",
    "burgas",
    "burgenland",
    "burgos",
    "buri",
    "buriat",
    "burji",
    "burkina",
    "burma",
    "burman",
    "burmbar",
    "burmese",
    "burmeso",
    "bursa",
    "burtnieku",
    "buru",
    "burui",
    "burumakok",
    "burun",
    "burundi",
    "burunge",
    "bururi",
    "burushaski",
    "burusu",
    "buruwai",
    "bury",
    "buryatiya",
    "busa",
    "busam",
    "busami",
    "busan",
    "busang",
    "bushenyi",
    "bushi",
    "bushoong",
    "busia",
    "buskerud",
    "buso",
    "busoa",
    "bussa",
    "busuu",
    "butaleja",
    "butbut",
    "bute",
    "butel",
    "butha",
    "buthe",
    "butmas",
    "butuanon",
    "buwal",
    "buxoro",
    "buxton",
    "buyang",
    "buyu",
    "buyuan",
    "buzău",
    "buţnān",
    "bwa",
    "bwaidoka",
    "bwamu",
    "bwanabwana",
    "bwatoo",
    "bwazza",
    "bwe",
    "bwela",
    "bwile",
    "bwilim",
    "bwisi",
    "byangsi",
    "byelorussian",
    "byep",
    "bács",
    "bái",
    "bárbara",
    "bädi",
    "béchar",
    "béja",
    "béjaïa",
    "békés",
    "békéscsaba",
    "béni",
    "béqaa",
    "béte",
    "bété",
    "bình",
    "bío",
    "bādghīs",
    "bāhah",
    "bāmyān",
    "bāqirmī",
    "bāţinah",
    "bălți",
    "bīnshangul",
    "břeclav",
    "būr",
    "būrkū",
    "būshehr",
    "būyer",
    "bərdə",
    "bạc",
    "bắc",
    "bằng",
    "bến",
    "caac",
    "caaguazú",
    "caazapá",
    "cabañas",
    "cabe",
    "cabinda",
    "cabiyarí",
    "cabo",
    "cabécar",
    "cacaloxtepec",
    "cacaopera",
    "cacataibo",
    "cacgia",
    "cacheu",
    "cacua",
    "caddo",
    "caddoan",
    "caerdydd",
    "caerffili",
    "caerphilly",
    "cafundo",
    "cagayan",
    "cagliari",
    "cahuarano",
    "cahuilla",
    "cahul",
    "cai",
    "caicos",
    "caiman",
    "cajamarca",
    "cajatambo",
    "cajonos",
    "cajun",
    "caka",
    "cakchiquel",
    "cakfem",
    "calabarzon",
    "calabria",
    "calais",
    "calamian",
    "caldas",
    "calderdale",
    "calderón",
    "caledonia",
    "caledonian",
    "california",
    "callao",
    "callawalla",
    "caltanissetta",
    "caluyanun",
    "calvados",
    "calédonie",
    "caló",
    "camagüey",
    "camarines",
    "cambodia",
    "cambridgeshire",
    "camden",
    "cameroon",
    "camiguin",
    "camling",
    "camo",
    "campalagian",
    "campania",
    "campeche",
    "campidanese",
    "campidano",
    "campo",
    "campobasso",
    "camsá",
    "camtho",
    "camunic",
    "canada",
    "canadian",
    "canarias",
    "candoshi",
    "canela",
    "canelones",
    "canichana",
    "canillo",
    "canindeyú",
    "cankova",
    "cankuzo",
    "canoeiro",
    "cantabria",
    "cantal",
    "cantemir",
    "canterbury",
    "cao",
    "capanahua",
    "cape",
    "capisterre",
    "capital",
    "capitale",
    "capiz",
    "capiznon",
    "capodistria",
    "cappadocian",
    "caprivi",
    "caquetá",
    "caquinte",
    "car",
    "cara",
    "carabayo",
    "carabobo",
    "caraga",
    "carajos",
    "caramanta",
    "carapana",
    "carazo",
    "caraș",
    "carbonia",
    "carchi",
    "cardiff",
    "cargados",
    "cari",
    "carian",
    "carib",
    "caribbean",
    "carijona",
    "carlo",
    "carlos",
    "carlow",
    "carmarthenshire",
    "carnikavas",
    "carolina",
    "carolinian",
    "carpathian",
    "carrara",
    "carrier",
    "cartago",
    "casablanca",
    "casanare",
    "cascade",
    "cascades",
    "caserta",
    "cashibo",
    "cashinahua",
    "casiguran",
    "casnewydd",
    "castell",
    "castellón",
    "castelo",
    "castilian",
    "castilla",
    "castlereagh",
    "casuarina",
    "cat",
    "catalan",
    "catalina",
    "catalunya",
    "catamarca",
    "catanduanes",
    "catania",
    "catanzaro",
    "catarina",
    "catawba",
    "catherine",
    "catío",
    "cauca",
    "caucasian",
    "causeway",
    "cavally",
    "cavan",
    "cavineña",
    "cavite",
    "cay",
    "cayman",
    "cayo",
    "cayon",
    "cayubaba",
    "cayuga",
    "cayuse",
    "cañar",
    "ca̱hungwa̱rya̱",
    "ceará",
    "cebaara",
    "cebu",
    "cebuano",
    "cedi",
    "celje",
    "celtiberian",
    "celtic",
    "cemet’",
    "cemuhî",
    "cen",
    "cent",
    "centar",
    "central",
    "centre",
    "centro",
    "centúúm",
    "ceredigion",
    "cerklje",
    "cerknica",
    "cerkno",
    "cerkvenjak",
    "cerma",
    "cerro",
    "cesar",
    "cesena",
    "cesvaines",
    "cetinje",
    "ceuta",
    "cfa",
    "cfp",
    "chabu",
    "chachapoyas",
    "chachi",
    "chachoengsao",
    "chaco",
    "chad",
    "chadian",
    "chadic",
    "chadong",
    "chagang",
    "chagatai",
    "chaguanas",
    "chah",
    "chahār",
    "chai",
    "chaima",
    "chain",
    "chaiyaphum",
    "chak",
    "chakali",
    "chakma",
    "chala",
    "chalatenango",
    "chaldean",
    "chalikha",
    "chalkidiki",
    "cham",
    "chamacoco",
    "chamalal",
    "chamari",
    "chambeali",
    "chambri",
    "chamic",
    "chamicuro",
    "chamorro",
    "champasak",
    "chamí",
    "chandigarh",
    "chandpur",
    "chang",
    "changhua",
    "changriwa",
    "changthang",
    "chania",
    "chanthaburi",
    "chantyal",
    "chané",
    "chara",
    "charbi",
    "charente",
    "chargui",
    "charlestown",
    "charlotte",
    "charoen",
    "chatham",
    "chatino",
    "chaudangsi",
    "chaura",
    "chavacano",
    "chayahuita",
    "chayuco",
    "chazumba",
    "che",
    "cheb",
    "chechen",
    "chechenskaya",
    "chefchaouen",
    "chehalis",
    "cheke",
    "chelsea",
    "chelyabinskaya",
    "chemakum",
    "chenapian",
    "chenchu",
    "chenoua",
    "chepang",
    "chepya",
    "cher",
    "cherepon",
    "cherkas",
    "cherkesskaya",
    "chernihivs",
    "chernivets",
    "cherokee",
    "cheshire",
    "chester",
    "chesu",
    "chetco",
    "chetti",
    "chewa",
    "chewong",
    "chey",
    "cheyenne",
    "chhattisgarh",
    "chhattisgarhi",
    "chhintange",
    "chhnang",
    "chhukha",
    "chhulung",
    "chi",
    "chiang",
    "chiangmai",
    "chiapanec",
    "chiapas",
    "chiay",
    "chiayi",
    "chiba",
    "chibcha",
    "chibchan",
    "chicahuaxtla",
    "chichaoua",
    "chichewa",
    "chichicapan",
    "chichimeca",
    "chickasaw",
    "chicomuceltec",
    "chiesanuova",
    "chieti",
    "chiga",
    "chigmecatitlán",
    "chihuahua",
    "chiini",
    "chiki",
    "chikwawa",
    "chilcotin",
    "chile",
    "chilean",
    "chilena",
    "chilisso",
    "chiltepec",
    "chimalapa",
    "chimaltenango",
    "chimariko",
    "chimborazo",
    "chimbu",
    "chimila",
    "chimwera",
    "chin",
    "china",
    "chinali",
    "chinandega",
    "chinantec",
    "chinbon",
    "chincha",
    "chinchipe",
    "chinese",
    "chinook",
    "chios",
    "chipaya",
    "chipewyan",
    "chippewa",
    "chiquihuitlán",
    "chiquimula",
    "chiquitano",
    "chiquián",
    "chiradzulu",
    "chiricahua",
    "chiripá",
    "chiriquí",
    "chiru",
    "chitimacha",
    "chitipa",
    "chitkuli",
    "chittagong",
    "chittagonian",
    "chitwania",
    "chișinău",
    "chlef",
    "choapan",
    "chocangacakha",
    "chochotec",
    "choctaw",
    "chocó",
    "chodri",
    "choiseul",
    "chokri",
    "chokwe",
    "chol",
    "choluteca",
    "cholón",
    "chomutov",
    "chon",
    "chong",
    "chongqing",
    "choni",
    "chontal",
    "chontales",
    "chonyi",
    "chopi",
    "chorasmian",
    "chorote",
    "chortí",
    "chothe",
    "chrau",
    "christ",
    "christmas",
    "chru",
    "chrudim",
    "chtouka",
    "chuadanga",
    "chuang",
    "chuanqiandian",
    "chuave",
    "chubut",
    "chug",
    "chuj",
    "chuka",
    "chukot",
    "chukotskiy",
    "chukwa",
    "chulym",
    "chumburung",
    "chumphon",
    "chungcheongbukdo",
    "chungcheongnamdo",
    "chunk",
    "chuquisaca",
    "churahi",
    "church",
    "chut",
    "chuuk",
    "chuukese",
    "chuvantsy",
    "chuvash",
    "chuvashskaya",
    "chuwabu",
    "chácobo",
    "châu",
    "chí",
    "chü",
    "cia",
    "cibak",
    "cibitoke",
    "ciblas",
    "cicipu",
    "ciego",
    "cienfuegos",
    "cimbrian",
    "cimișlia",
    "cin",
    "cinda",
    "cineni",
    "cinta",
    "cirkulane",
    "cirth",
    "cisalpine",
    "cishingini",
    "citak",
    "citi",
    "city",
    "ciudad",
    "ciwogai",
    "clackmannanshire",
    "clallam",
    "clara",
    "clare",
    "clarendon",
    "claro",
    "classical",
    "cleveland",
    "clipperton",
    "cluj",
    "cluster",
    "coahuila",
    "coahuilteco",
    "coahuitlán",
    "coast",
    "coastal",
    "coatecas",
    "coatepec",
    "coatlán",
    "coatzospan",
    "cocama",
    "cocamilla",
    "cochabamba",
    "cochimi",
    "coclé",
    "cocopa",
    "cocos",
    "code",
    "codes",
    "coeur",
    "cofán",
    "cogui",
    "coimbra",
    "cojedes",
    "col",
    "colima",
    "colle",
    "collines",
    "colognian",
    "colombia",
    "colombian",
    "colon",
    "colonia",
    "colorado",
    "columbia",
    "colón",
    "comaltepec",
    "comanche",
    "comayagua",
    "comecrudo",
    "comilla",
    "commewijne",
    "como",
    "comorian",
    "comoro",
    "comoros",
    "comox",
    "comoé",
    "composite",
    "compostela",
    "comté",
    "comunidad",
    "comunitat",
    "con",
    "conakry",
    "concepción",
    "conchucos",
    "condamine",
    "congo",
    "congolese",
    "conibo",
    "connacht",
    "connecticut",
    "constantine",
    "constanța",
    "content",
    "continental",
    "convertible",
    "conwy",
    "cook",
    "coola",
    "coos",
    "copainalá",
    "copala",
    "copperbelt",
    "coptic",
    "copán",
    "coquille",
    "coquimbo",
    "cora",
    "cordillera",
    "cordoba",
    "corentyne",
    "cori",
    "cork",
    "cornish",
    "cornwall",
    "corongo",
    "coronie",
    "corozal",
    "corrientes",
    "corrèze",
    "corse",
    "corsican",
    "cortés",
    "coruña",
    "cosenza",
    "cosoleacaque",
    "costa",
    "cotabato",
    "cotoname",
    "cotopaxi",
    "couva",
    "cova",
    "covasna",
    "coventry",
    "cowlitz",
    "cox",
    "coyah",
    "coyotepec",
    "coyutla",
    "craigavon",
    "cree",
    "creek",
    "cremona",
    "creole",
    "creoles",
    "creuse",
    "crimean",
    "crioulo",
    "cristi",
    "cristóbal",
    "criuleni",
    "croatia",
    "croatian",
    "crooked",
    "cross",
    "crotone",
    "crow",
    "croydon",
    "cruz",
    "cruzeño",
    "csongrád",
    "cua",
    "cuaiquer",
    "cuando",
    "cuanza",
    "cuba",
    "cuban",
    "cubango",
    "cubeo",
    "cuenca",
    "cuiba",
    "cuicatec",
    "culfa",
    "culina",
    "culture",
    "cumanagoto",
    "cumbria",
    "cumbric",
    "cun",
    "cundinamarca",
    "cuneiform",
    "cunene",
    "cuneo",
    "cung",
    "cunha",
    "cupeño",
    "curaçao",
    "curepipe",
    "curonian",
    "currency",
    "curripaco",
    "cursive",
    "cuscatlán",
    "cusco",
    "cushitic",
    "cusio",
    "cutchi",
    "cuvette",
    "cuvok",
    "cuyamecalco",
    "cuyonon",
    "cuyuni",
    "cuzco",
    "cwi",
    "cymru",
    "cynon",
    "cypriot",
    "cyprus",
    "cyrillic",
    "czech",
    "czechia",
    "czechoslovak",
    "czechoslovakia",
    "cáceres",
    "cádiz",
    "córdoba",
    "côte",
    "côtes",
    "côông",
    "călărași",
    "căușeni",
    "cēsu",
    "cəbrayıl",
    "cəlilabab",
    "cần",
    "daai",
    "daakaka",
    "daantanai",
    "daasanach",
    "daatsʼíin",
    "daba",
    "dabarre",
    "dabe",
    "dabola",
    "dacian",
    "dadi",
    "dadibi",
    "dadiya",
    "dadra",
    "daegu",
    "daejeon",
    "daeng",
    "daga",
    "dagaare",
    "dagaari",
    "dagana",
    "dagara",
    "dagba",
    "dagbani",
    "dagdas",
    "dagenham",
    "dagestan",
    "dagik",
    "dagoman",
    "dah",
    "dahab",
    "dahalik",
    "dahalo",
    "daho",
    "dahomey",
    "dahuk",
    "dai",
    "dair",
    "dairi",
    "dajabón",
    "daju",
    "daka",
    "dakar",
    "dakhla",
    "dakhlet",
    "dakka",
    "dakota",
    "dakpakha",
    "dakuṇu",
    "dalaba",
    "dalabon",
    "dalarnas",
    "dalasi",
    "dalmatian",
    "dalmatinska",
    "daloa",
    "dam",
    "dama",
    "damakawa",
    "damal",
    "daman",
    "damar",
    "dambi",
    "dameli",
    "dampelas",
    "dan",
    "danaru",
    "danau",
    "dandami",
    "dang",
    "dangaléat",
    "dangaura",
    "dani",
    "danilovgrad",
    "danish",
    "dano",
    "danu",
    "danum",
    "dao",
    "daonda",
    "daqahlīyah",
    "dar",
    "darai",
    "dargwa",
    "darhan",
    "dari",
    "darién",
    "darkinyung",
    "darlington",
    "darlong",
    "darmiya",
    "darnah",
    "daro",
    "darussalam",
    "darwen",
    "dass",
    "datooga",
    "dau",
    "daugavpils",
    "daungwurrung",
    "daur",
    "davao",
    "davawenyo",
    "david",
    "daw",
    "dawa",
    "dawawa",
    "daweloor",
    "dawera",
    "dawhah",
    "dawro",
    "day",
    "dayak",
    "dayi",
    "dayr",
    "dazaga",
    "daşkəsən",
    "daşoguz",
    "ddinbych",
    "debar",
    "debarca",
    "debe",
    "debrecen",
    "deccan",
    "dedua",
    "dedza",
    "defaka",
    "defi",
    "defla",
    "deg",
    "degaru",
    "degema",
    "degenan",
    "degexit",
    "dehu",
    "dehwari",
    "deir",
    "dek",
    "del",
    "dela",
    "delaware",
    "delgado",
    "delhi",
    "delo",
    "delta",
    "delvinë",
    "delčevo",
    "dem",
    "dema",
    "deme",
    "demerara",
    "demir",
    "demisa",
    "democratic",
    "demotic",
    "demta",
    "denar",
    "denbighshire",
    "dendi",
    "dene",
    "dengese",
    "dengka",
    "dengsa",
    "denguélé",
    "deni",
    "denigomodu",
    "denis",
    "denizli",
    "denmark",
    "deno",
    "denya",
    "dení",
    "deori",
    "dependencias",
    "dera",
    "derby",
    "derbyshire",
    "derry",
    "des",
    "desano",
    "deseret",
    "desiya",
    "destrnik",
    "deux",
    "devanagari",
    "developer",
    "devoll",
    "devon",
    "dewoin",
    "dey",
    "deyah",
    "dezfuli",
    "dghwede",
    "dhaalu",
    "dhabi",
    "dhaiso",
    "dhaka",
    "dhakhīrah",
    "dhalandji",
    "dhamār",
    "dhangu",
    "dhanki",
    "dhanwar",
    "dhao",
    "dhargari",
    "dharuk",
    "dharumbal",
    "dhatki",
    "dhawalagiri",
    "dhexe",
    "dhi",
    "dhimal",
    "dhivehi",
    "dhodia",
    "dhofari",
    "dhudhuroa",
    "dhundari",
    "dhungaloo",
    "dhurga",
    "dhuwal",
    "dhuwaya",
    "dia",
    "dibabawon",
    "dibiyaso",
    "dibo",
    "dibole",
    "dibër",
    "dicamay",
    "dida",
    "didinga",
    "dido",
    "didán",
    "diego",
    "diekirch",
    "dieri",
    "diffa",
    "diga",
    "digaro",
    "digo",
    "digue",
    "dii",
    "dijim",
    "dikhil",
    "dili",
    "dilling",
    "dima",
    "dimasa",
    "dimashq",
    "dimbong",
    "dime",
    "dimili",
    "dimli",
    "din",
    "dinagat",
    "dinajpur",
    "dinar",
    "ding",
    "dingli",
    "dinguiraye",
    "dinka",
    "dionisio",
    "dios",
    "dioula",
    "diourbel",
    "dirari",
    "dirasha",
    "dirham",
    "diri",
    "diriku",
    "dirim",
    "dirē",
    "disa",
    "district",
    "distrikt",
    "distrito",
    "ditammari",
    "ditidaht",
    "diu",
    "diuwe",
    "diuxi",
    "divača",
    "divehi",
    "division",
    "dixon",
    "diyala",
    "diyarbakır",
    "dizin",
    "djabwurrung",
    "djadjawurrung",
    "djambarrpuyngu",
    "djamindjung",
    "djangu",
    "djangun",
    "djauan",
    "djawi",
    "djeebbana",
    "djelfa",
    "djibouti",
    "djimini",
    "djinang",
    "djinba",
    "djingili",
    "djiwarli",
    "dnipropetrovs",
    "doan",
    "dobel",
    "dobeles",
    "dobje",
    "dobojski",
    "dobra",
    "dobrepolje",
    "dobrich",
    "dobrna",
    "dobronak",
    "dobrova",
    "dobrovnik",
    "dobu",
    "documents",
    "dodekanisos",
    "dodoma",
    "doe",
    "doga",
    "doghoro",
    "dogon",
    "dogoso",
    "dogosé",
    "dogri",
    "dogrib",
    "dogul",
    "dojran",
    "doka",
    "doko",
    "dokolo",
    "dol",
    "dolenjske",
    "dolgan",
    "dolina",
    "dolj",
    "dollar",
    "dolneni",
    "dolnośląskie",
    "dolpo",
    "dom",
    "domaaki",
    "domagnano",
    "domari",
    "domažlice",
    "dombe",
    "domingo",
    "domingos",
    "dominica",
    "dominican",
    "dompo",
    "domu",
    "domung",
    "domžale",
    "don",
    "doncaster",
    "dondo",
    "dondușeni",
    "donegal",
    "donets",
    "dong",
    "donga",
    "dongo",
    "dongotono",
    "dongshanba",
    "dongxiang",
    "donno",
    "doo",
    "doondo",
    "dora",
    "dordogne",
    "dori",
    "dornava",
    "dornod",
    "dornogovi",
    "doromu",
    "dororo",
    "dorset",
    "dorze",
    "dos",
    "doso",
    "dosso",
    "dotyali",
    "doubs",
    "doutai",
    "dowa",
    "down",
    "doyayo",
    "dragomer",
    "dram",
    "drama",
    "dravi",
    "dravidian",
    "dravograd",
    "dravskem",
    "drawing",
    "drenthe",
    "drents",
    "driouch",
    "drochia",
    "dronning",
    "drugovo",
    "drung",
    "drâa",
    "drôme",
    "duala",
    "duano",
    "duarte",
    "duau",
    "dubayy",
    "dubli",
    "dublin",
    "dubrovačko",
    "dubréka",
    "dubu",
    "dubăsari",
    "dudley",
    "dugun",
    "duguri",
    "dugwor",
    "duhwa",
    "duke",
    "dulbu",
    "duli",
    "duma",
    "dumagat",
    "dumaget",
    "dumbea",
    "dumfries",
    "dumi",
    "dumpas",
    "dumun",
    "dumyāt",
    "duna",
    "dunaújváros",
    "dunbartonshire",
    "dundagas",
    "dundee",
    "dundgovi",
    "dungan",
    "dungmali",
    "dungra",
    "dungu",
    "duong",
    "dupaninan",
    "duplek",
    "duployan",
    "dura",
    "durango",
    "durazno",
    "durbes",
    "durham",
    "duri",
    "duriankere",
    "durrës",
    "duruma",
    "duruwa",
    "dusner",
    "dusun",
    "dutch",
    "dutton",
    "duungooma",
    "duupa",
    "duvle",
    "duwai",
    "duwet",
    "dũya",
    "dwang",
    "dyaabugay",
    "dyaberdyaber",
    "dyan",
    "dyangadi",
    "dyirbal",
    "dytiki",
    "dyugun",
    "dyula",
    "dza",
    "dzalakha",
    "dzando",
    "dzao",
    "dzavhan",
    "dzihana",
    "dzodinka",
    "dzongkha",
    "dzùùngoo",
    "dâmbovița",
    "dâw",
    "dévote",
    "díaz",
    "díli",
    "dón",
    "dôme",
    "düzce",
    "dākhilīya",
    "dārfūr",
    "dāykundī",
    "děčín",
    "dương",
    "ḑāli‘",
    "d’azur",
    "ealing",
    "ebira",
    "eblan",
    "ebo",
    "ebon",
    "ebonyi",
    "ebrié",
    "ebughu",
    "ech",
    "ecija",
    "ecuador",
    "ecuadorian",
    "ede",
    "edera",
    "edinburgh",
    "edineț",
    "edirne",
    "edn",
    "edo",
    "edolo",
    "edomite",
    "edopi",
    "edu",
    "eduria",
    "edward",
    "efai",
    "efate",
    "efe",
    "efik",
    "efutop",
    "ega",
    "eger",
    "eggon",
    "egypt",
    "egyptian",
    "ehime",
    "ehom",
    "ehueun",
    "eilean",
    "eipomek",
    "eitiep",
    "ejagham",
    "ejamat",
    "ejja",
    "ekajuk",
    "ekari",
    "eki",
    "ekit",
    "ekiti",
    "ekoka",
    "ekpeye",
    "ela",
    "elamite",
    "elazığ",
    "elbasan",
    "eleme",
    "elena",
    "eleng",
    "elepi",
    "eleuthera",
    "elgeyo",
    "elip",
    "elizabeth",
    "elkei",
    "ellada",
    "ellice",
    "elotepec",
    "eloyi",
    "elseng",
    "elu",
    "elymian",
    "elías",
    "ema",
    "emae",
    "emai",
    "eman",
    "emauga",
    "embaloh",
    "emberá",
    "embu",
    "emerillon",
    "emilia",
    "emilian",
    "emira",
    "emirates",
    "emoji",
    "emplawas",
    "emumu",
    "enawené",
    "encamp",
    "end",
    "ende",
    "enderbury",
    "enen",
    "enets",
    "enewetak",
    "enfield",
    "enga",
    "engdewu",
    "engenni",
    "enggano",
    "england",
    "english",
    "engordany",
    "engures",
    "eni",
    "enlhet",
    "enna",
    "enrekang",
    "entre",
    "entry",
    "enu",
    "enugu",
    "enwan",
    "enxet",
    "enya",
    "epa",
    "epena",
    "epi",
    "epie",
    "epigraphic",
    "equatoria",
    "equatorial",
    "erabu",
    "eravallan",
    "erave",
    "ere",
    "erevan",
    "eritai",
    "eritrea",
    "ermera",
    "erokwanas",
    "erongo",
    "errachidia",
    "erre",
    "erromintxela",
    "ersu",
    "eruwa",
    "erzincan",
    "erzurum",
    "erzya",
    "esan",
    "escaldes",
    "eschen",
    "escudo",
    "escuintla",
    "ese",
    "eshtehardi",
    "esimbi",
    "eskayan",
    "eskimo",
    "eskişehir",
    "esmeraldas",
    "espaillat",
    "esparta",
    "esperanto",
    "espírito",
    "essaouira",
    "esselen",
    "essequibo",
    "essex",
    "essonne",
    "est",
    "estado",
    "estelí",
    "estero",
    "estonia",
    "estonian",
    "estrangelo",
    "estrelleta",
    "estuaire",
    "esuma",
    "eswatini",
    "esztergom",
    "etc",
    "etchemin",
    "etebi",
    "etelä",
    "eten",
    "eteocretan",
    "eteocypriot",
    "ethiopia",
    "ethiopian",
    "ethiopic",
    "etkywan",
    "etoile",
    "eton",
    "etruscan",
    "etulo",
    "eua",
    "eurco",
    "eure",
    "euro",
    "european",
    "euskal",
    "eustatius",
    "evant",
    "even",
    "evenki",
    "eviya",
    "evros",
    "evrytania",
    "evvoias",
    "ewa",
    "ewage",
    "ewe",
    "ewondo",
    "exotique",
    "extremadura",
    "extremaduran",
    "exuma",
    "eyak",
    "eystra",
    "ezaa",
    "eşfahān",
    "faafu",
    "faen",
    "faetano",
    "fagani",
    "fahs",
    "faire",
    "faita",
    "faiwol",
    "fako",
    "fala",
    "falam",
    "falcón",
    "fali",
    "faliscan",
    "falkirk",
    "falkland",
    "fam",
    "fanagalo",
    "fanamaket",
    "fanbak",
    "fang",
    "fania",
    "fanti",
    "far",
    "faranah",
    "farefare",
    "farg",
    "faridpur",
    "faro",
    "faroe",
    "faroese",
    "fars",
    "farwānīyah",
    "farāh",
    "fas",
    "faso",
    "fasu",
    "fataleka",
    "fataluku",
    "fatick",
    "fayu",
    "fayyūm",
    "federacija",
    "federal",
    "federales",
    "federally",
    "federated",
    "federation",
    "fejér",
    "felipe",
    "fembe",
    "feni",
    "fermanagh",
    "fermo",
    "fernandeño",
    "fernando",
    "feroge",
    "ferrara",
    "fflint",
    "fgura",
    "fianarantsoa",
    "fier",
    "fife",
    "figtree",
    "figuig",
    "fiji",
    "fijian",
    "fila",
    "filipe",
    "filipino",
    "filomena",
    "finistère",
    "finland",
    "finnish",
    "finnmark",
    "finno",
    "finongan",
    "fiorentino",
    "fipa",
    "firan",
    "firenze",
    "fiwaga",
    "fjordane",
    "flaaitaal",
    "flacq",
    "flemish",
    "fleuri",
    "flevoland",
    "flinders",
    "flintshire",
    "flores",
    "florești",
    "floriana",
    "florida",
    "florin",
    "florina",
    "flowery",
    "fnideq",
    "foau",
    "foggia",
    "fogo",
    "foi",
    "foia",
    "fokida",
    "folopa",
    "foma",
    "fon",
    "fongoro",
    "fonoti",
    "fontana",
    "fontvieille",
    "fonyi",
    "foodo",
    "for",
    "forak",
    "foral",
    "fordata",
    "fore",
    "forest",
    "forint",
    "forlì",
    "formosa",
    "formosan",
    "fortin",
    "fortsenal",
    "foru",
    "forécariah",
    "fquih",
    "fraktur",
    "fram",
    "franc",
    "franca",
    "france",
    "franche",
    "francisco",
    "franco",
    "francophone",
    "frankish",
    "frankivs",
    "française",
    "françaises",
    "fraser",
    "free",
    "freeport",
    "freetown",
    "french",
    "fria",
    "fribourg",
    "friesland",
    "frisian",
    "friuli",
    "friulian",
    "fromager",
    "frosinone",
    "frýdek",
    "fthiotida",
    "fuego",
    "fujayrah",
    "fujian",
    "fukui",
    "fukuoka",
    "fukushima",
    "fulah",
    "fulfulde",
    "fulham",
    "fuliiru",
    "fulniô",
    "fum",
    "funafuti",
    "fungwa",
    "fur",
    "furu",
    "futuna",
    "fuumu",
    "fuyug",
    "fwe",
    "fwâi",
    "fyam",
    "fyer",
    "fynwy",
    "fès",
    "füzuli",
    "fārs",
    "fāryāb",
    "fălești",
    "fīrā",
    "gaa",
    "gaafu",
    "gaam",
    "gabi",
    "gabon",
    "gabri",
    "gabrielino",
    "gabrovo",
    "gabès",
    "gabú",
    "gadaba",
    "gadang",
    "gaddang",
    "gaddi",
    "gade",
    "gadjerawang",
    "gadsup",
    "gaelic",
    "gaerfyrddin",
    "gafat",
    "gafsa",
    "gaga",
    "gagadu",
    "gagaifomauga",
    "gagauz",
    "gagnoa",
    "gagu",
    "gahri",
    "gaibandha",
    "gaikundi",
    "gail",
    "gaina",
    "gal",
    "galambu",
    "galatian",
    "galați",
    "galbeed",
    "galela",
    "galeya",
    "galguduud",
    "galibi",
    "galice",
    "galicia",
    "galician",
    "galindan",
    "gallen",
    "galloway",
    "gallurese",
    "galo",
    "galolen",
    "galway",
    "galápagos",
    "gamale",
    "gambera",
    "gambia",
    "gambian",
    "gambēla",
    "gamilaraay",
    "gamit",
    "gamkonora",
    "gamo",
    "gampaha",
    "gamprin",
    "gan",
    "gana",
    "ganang",
    "ganda",
    "gandaki",
    "gane",
    "gang",
    "ganggalida",
    "ganglau",
    "gangte",
    "gangulu",
    "ganja",
    "ganjule",
    "gansu",
    "gants",
    "ganza",
    "ganzi",
    "ganzourgou",
    "gao",
    "gaoual",
    "gapapaiwa",
    "garasia",
    "gard",
    "gare",
    "garhwali",
    "garifuna",
    "garig",
    "garingbal",
    "garissa",
    "garkalnes",
    "garlali",
    "garo",
    "garonne",
    "garre",
    "garrwa",
    "garus",
    "garza",
    "gasa",
    "gata",
    "gateshead",
    "gaulish",
    "gauteng",
    "gava",
    "gavak",
    "gavar",
    "gavião",
    "gaw",
    "gawar",
    "gawwada",
    "gayil",
    "gayo",
    "gaza",
    "gazi",
    "gaziantep",
    "gazipur",
    "gbagyi",
    "gbantu",
    "gbanu",
    "gbanziri",
    "gbari",
    "gbaya",
    "gbayi",
    "gbe",
    "gbesi",
    "gbii",
    "gbin",
    "gbiri",
    "gbite",
    "gboloo",
    "geba",
    "gebarentaal",
    "gebe",
    "gedaged",
    "gedeh",
    "gedeo",
    "gedo",
    "geez",
    "gegarkunik",
    "geji",
    "geko",
    "gel",
    "gela",
    "gelao",
    "gelderland",
    "gelimi",
    "geme",
    "gemzek",
    "gen",
    "gende",
    "general",
    "gengle",
    "genova",
    "genève",
    "george",
    "georgia",
    "georgian",
    "gepo",
    "gera",
    "gerais",
    "german",
    "germanic",
    "germany",
    "gers",
    "geruma",
    "geser",
    "gevgelija",
    "gewest",
    "gey",
    "geʻez",
    "ghadamès",
    "ghale",
    "ghana",
    "ghanaian",
    "ghandruk",
    "ghanongga",
    "ghanzi",
    "gharb",
    "gharbī",
    "gharbīyah",
    "ghardaïa",
    "ghari",
    "ghayavi",
    "ghazal",
    "ghaznī",
    "ghazāl",
    "gheg",
    "ghera",
    "ghodoberi",
    "ghomara",
    "ghomálá",
    "ghotuo",
    "ghulfan",
    "ghāt",
    "ghōr",
    "gia",
    "giang",
    "giangan",
    "gibanawa",
    "gibraltar",
    "gidar",
    "gifu",
    "giiwo",
    "gikuyu",
    "gikyode",
    "gilaki",
    "gilbert",
    "gilbertese",
    "gilgit",
    "gilima",
    "gilyak",
    "gimi",
    "gimme",
    "gimnime",
    "gingerland",
    "ginuman",
    "ginyanga",
    "gipuzkoa",
    "girawa",
    "giresun",
    "girona",
    "gironde",
    "giryama",
    "gisborne",
    "gishu",
    "gitega",
    "githabul",
    "gitonga",
    "gitua",
    "gitxsan",
    "gityemerri",
    "giulia",
    "giurgiu",
    "giyug",
    "giziga",
    "gizrra",
    "gjirokastër",
    "gjorče",
    "glacis",
    "glagolitic",
    "glamorgan",
    "glaro",
    "glarus",
    "glasgow",
    "glaud",
    "glavda",
    "glens",
    "glio",
    "glodeni",
    "gloucestershire",
    "gnagna",
    "gnau",
    "gnaviyani",
    "goa",
    "goan",
    "goaria",
    "gobasi",
    "gobu",
    "godié",
    "godwari",
    "goemai",
    "gofa",
    "gogo",
    "gogodala",
    "goiás",
    "gokana",
    "gola",
    "gold",
    "golestān",
    "golin",
    "golpa",
    "gombe",
    "gondi",
    "gone",
    "gongduk",
    "gongwang",
    "gonja",
    "goodenough",
    "gooniyandi",
    "gopalganj",
    "gor",
    "gora",
    "gorakor",
    "goranboy",
    "goranska",
    "gorap",
    "goreng",
    "gorenja",
    "gorenjskem",
    "gorgol",
    "gorica",
    "goricah",
    "gorizia",
    "gorišnica",
    "gorj",
    "gorje",
    "gorkha",
    "gornja",
    "gornji",
    "gorno",
    "gorom",
    "gorontalo",
    "gorovu",
    "gorowa",
    "gostivar",
    "gothic",
    "gotlands",
    "goundo",
    "gourde",
    "gourma",
    "gourmanchéma",
    "govi",
    "gowlan",
    "gowli",
    "gowro",
    "gozarkhani",
    "gracias",
    "grad",
    "gradec",
    "gradsko",
    "gramsh",
    "granada",
    "grand",
    "grande",
    "grangali",
    "granma",
    "grantha",
    "grass",
    "graubünden",
    "great",
    "greater",
    "grebo",
    "greece",
    "greek",
    "green",
    "greenland",
    "greenlandic",
    "greenwich",
    "grenada",
    "grenadian",
    "grenadine",
    "grenadines",
    "gresi",
    "grevena",
    "grevenmacher",
    "gribingui",
    "grobiņas",
    "groma",
    "groningen",
    "gronings",
    "gros",
    "grosseto",
    "grosso",
    "grosuplje",
    "gua",
    "guadalajara",
    "guadalcanal",
    "guadeloupe",
    "guadeloupean",
    "guahibo",
    "guainía",
    "guairá",
    "guajajára",
    "guajira",
    "guajá",
    "guam",
    "guambiano",
    "guana",
    "guanacaste",
    "guanajuato",
    "guanano",
    "guanche",
    "guangdong",
    "guangxi",
    "guantánamo",
    "guanyinqiao",
    "guarani",
    "guaraní",
    "guarayu",
    "guarda",
    "guarequena",
    "guatemala",
    "guatemalan",
    "guató",
    "guaviare",
    "guayabero",
    "guayas",
    "gudang",
    "gudanji",
    "gude",
    "gudhinma",
    "gudja",
    "gudu",
    "guduf",
    "gudur",
    "guelma",
    "guelmim",
    "guercif",
    "guernsey",
    "guerrero",
    "guevea",
    "gugadj",
    "gugu",
    "gugubera",
    "guguyimidjir",
    "guhu",
    "guiana",
    "guianese",
    "guibei",
    "guiberoua",
    "guibian",
    "guidimaka",
    "guilder",
    "guimaras",
    "guinea",
    "guinean",
    "guiqiong",
    "guivini",
    "guiyang",
    "guizhou",
    "gujarat",
    "gujarati",
    "gujari",
    "guji",
    "gula",
    "gulay",
    "gulbenes",
    "gule",
    "gulf",
    "guliguli",
    "gulu",
    "gumalu",
    "gumatj",
    "gumawana",
    "gumna",
    "gumuz",
    "gun",
    "gundi",
    "gunditjmara",
    "gundungurra",
    "gungabula",
    "gungu",
    "gunma",
    "guntai",
    "gunwinggu",
    "gunya",
    "gunyaamolo",
    "gunyuño",
    "gupa",
    "gupapuyngu",
    "gurage",
    "guragone",
    "guramalum",
    "gurani",
    "gurdjar",
    "gureng",
    "gurgula",
    "guria",
    "guriaso",
    "gurindji",
    "gurinji",
    "gurmana",
    "gurmukhi",
    "guro",
    "gurung",
    "guruntum",
    "gusii",
    "gusilay",
    "guwa",
    "guwamu",
    "guya",
    "guyana",
    "guyane",
    "guyanese",
    "guyani",
    "guárico",
    "guékédou",
    "gvoko",
    "gwa",
    "gwahatike",
    "gwak",
    "gwamhi",
    "gwandara",
    "gwang",
    "gwangju",
    "gweda",
    "gweno",
    "gwent",
    "gwere",
    "gwi",
    "gwich",
    "gwichʼin",
    "gwynedd",
    "gyele",
    "gyem",
    "gyeonggido",
    "gyeongsangbukdo",
    "gyeongsangnamdo",
    "győr",
    "gävleborgs",
    "gòn",
    "götalands",
    "göygöl",
    "göyçay",
    "güilá",
    "güisnay",
    "gümüşhane",
    "gālla",
    "gāndhārī",
    "găgăuzia",
    "għajnsielem",
    "għarb",
    "għargħur",
    "għasri",
    "għawdex",
    "għaxaq",
    "gīlān",
    "gżira",
    "gədəbəy",
    "gəncə",
    "haa",
    "habana",
    "habiganj",
    "habu",
    "hackney",
    "hacıqabul",
    "hadarom",
    "hadiyya",
    "hadothi",
    "hadrami",
    "hadza",
    "haeke",
    "hagahai",
    "hahon",
    "hai",
    "haida",
    "haigwai",
    "hainan",
    "hainaut",
    "haiphong",
    "haisla",
    "haiti",
    "haitian",
    "hajdina",
    "hajdú",
    "hajeb",
    "haji",
    "hajong",
    "hakha",
    "hakka",
    "hakkâri",
    "hakö",
    "halab",
    "halang",
    "halbi",
    "halh",
    "halia",
    "halkomelem",
    "hallands",
    "halton",
    "hamadān",
    "hamah",
    "hamap",
    "hamba",
    "hambantŏṭa",
    "hamburg",
    "hamer",
    "hamerkaz",
    "hamgyŏng",
    "hamlets",
    "hammersmith",
    "hampshire",
    "hamra",
    "hamtai",
    "han",
    "hanga",
    "hangaza",
    "hangeul",
    "hangul",
    "hangŭl",
    "hani",
    "hanja",
    "hano",
    "hanoi",
    "hanover",
    "hanunoo",
    "hanunóo",
    "hanzi",
    "haouz",
    "harami",
    "harappan",
    "harare",
    "harari",
    "harbour",
    "hardap",
    "harengan",
    "harghita",
    "harijan",
    "haringey",
    "harjumaa",
    "haroi",
    "harrow",
    "harsusi",
    "hartlepool",
    "haruai",
    "haruku",
    "haryana",
    "haryanvi",
    "harzani",
    "has",
    "hasakah",
    "hasha",
    "haskovo",
    "hassaniyya",
    "hatam",
    "hatay",
    "hato",
    "hatobohei",
    "hatran",
    "hattic",
    "hau",
    "hausa",
    "haut",
    "haute",
    "hautes",
    "hauts",
    "havasupai",
    "haveke",
    "haveli",
    "havering",
    "havlíčkův",
    "havu",
    "hawai",
    "hawaii",
    "hawaiian",
    "hawallī",
    "hawke",
    "haya",
    "hayes",
    "hazafon",
    "hazaragi",
    "hdi",
    "heard",
    "hebei",
    "hebrew",
    "hebrides",
    "hebron",
    "hedmark",
    "hefa",
    "hehe",
    "heiban",
    "heilongjiang",
    "heiltsuk",
    "helambu",
    "helena",
    "helens",
    "helmand",
    "helong",
    "hema",
    "hemba",
    "henan",
    "heneng",
    "hentiy",
    "herceg",
    "hercegovačko",
    "hercegovine",
    "hercule",
    "herdé",
    "heredia",
    "herefordshire",
    "herero",
    "hermel",
    "hermit",
    "hernican",
    "herrera",
    "herria",
    "hertfordshire",
    "herzegovina",
    "herāt",
    "hessen",
    "heves",
    "hewa",
    "heyo",
    "hhohho",
    "hiberno",
    "hibito",
    "hidalgo",
    "hidatsa",
    "hieratic",
    "hieroglyphic",
    "hieroglyphs",
    "higaonon",
    "higgins",
    "high",
    "highland",
    "highlands",
    "hiirsan",
    "hiiumaa",
    "hijazi",
    "hijuk",
    "hiligaynon",
    "hill",
    "hillingdon",
    "himachal",
    "himachali",
    "himarimã",
    "hindi",
    "hindko",
    "hinduri",
    "hindustani",
    "hinukh",
    "hiragana",
    "hiri",
    "hiroshima",
    "hisar",
    "hittite",
    "hitu",
    "hiw",
    "hixkaryána",
    "hiyewe",
    "hizb",
    "hizboch",
    "hkongso",
    "hlai",
    "hlavní",
    "hlepho",
    "hlersu",
    "hmar",
    "hmong",
    "hmwaveke",
    "hng",
    "hoan",
    "hoava",
    "hobyót",
    "hoceïma",
    "hodh",
    "hodonín",
    "hodos",
    "hodoš",
    "hoek",
    "hoia",
    "hoima",
    "hokan",
    "hokkaido",
    "hol",
    "holguín",
    "holikachuk",
    "holiya",
    "holland",
    "holma",
    "holo",
    "holoholo",
    "holstein",
    "holu",
    "holy",
    "homa",
    "homieĺskaja",
    "homs",
    "honduras",
    "hong",
    "hongjin",
    "hongshuihe",
    "honi",
    "honiara",
    "hoofdstedelijk",
    "hoose",
    "hope",
    "hopi",
    "hora",
    "horad",
    "hordaland",
    "horjul",
    "hormozgān",
    "horned",
    "horo",
    "horom",
    "horpa",
    "hote",
    "hoti",
    "houaphan",
    "houet",
    "hounslow",
    "hovd",
    "hove",
    "hovedstaden",
    "hovongan",
    "howland",
    "hoyahoya",
    "hozo",
    "hoà",
    "hoče",
    "hpon",
    "hradec",
    "hradiště",
    "hrangkhol",
    "hrastnik",
    "hre",
    "hrodzienskaja",
    "hrpelje",
    "hruso",
    "hryvnia",
    "hsinchu",
    "hsinchui",
    "hsl",
    "hua",
    "huachipaeri",
    "hualien",
    "huallaga",
    "huamalíes",
    "huambisa",
    "huambo",
    "huancavelica",
    "huarijio",
    "huastec",
    "huasteca",
    "huaulu",
    "huautla",
    "huave",
    "huaxcaleca",
    "huaylas",
    "huaylla",
    "huba",
    "hubei",
    "huehuetenango",
    "huehuetla",
    "huelva",
    "huesca",
    "hugeirat",
    "huichol",
    "huila",
    "huilliche",
    "huishui",
    "huitepec",
    "huitoto",
    "huizhou",
    "huizi",
    "hukumina",
    "hula",
    "hulaulá",
    "huli",
    "hull",
    "hulung",
    "humboldt",
    "humburi",
    "humene",
    "humla",
    "hun",
    "hunan",
    "hunde",
    "hundi",
    "hunedoara",
    "hung",
    "hungana",
    "hungarian",
    "hungary",
    "hunjara",
    "hunnic",
    "hunsrik",
    "hunzib",
    "hupa",
    "hupdë",
    "hupla",
    "hurrian",
    "hus",
    "hut",
    "hutterite",
    "huánuco",
    "huíla",
    "huế",
    "hwana",
    "hwanghae",
    "hya",
    "hyam",
    "hyogo",
    "hãe",
    "häme",
    "hérault",
    "hértevin",
    "hîncești",
    "hòa",
    "hóa",
    "hódmezővásárhely",
    "hõne",
    "höfuðborgarsvæðið",
    "hövsgöl",
    "hārerī",
    "hưng",
    "ḩulwān",
    "hải",
    "hậu",
    "iaai",
    "ialomița",
    "ialoveni",
    "iamalele",
    "iatmul",
    "iau",
    "iași",
    "ibali",
    "ibaloi",
    "iban",
    "ibanag",
    "ibanda",
    "ibani",
    "ibaraki",
    "ibatan",
    "ibb",
    "iberian",
    "ibibio",
    "ibino",
    "ibom",
    "ibu",
    "ibuoro",
    "ibáñez",
    "ica",
    "iceland",
    "icelandic",
    "iceve",
    "iche",
    "ida",
    "idaca",
    "idaho",
    "idakho",
    "idaté",
    "idere",
    "idesa",
    "idi",
    "idlib",
    "ido",
    "idoma",
    "idon",
    "idrija",
    "idu",
    "iduna",
    "iecavas",
    "ifni",
    "ifo",
    "ifrane",
    "ifugao",
    "ifè",
    "igala",
    "igana",
    "iganga",
    "igbo",
    "igede",
    "iglesias",
    "ignaciano",
    "ignacio",
    "igo",
    "iguta",
    "igwe",
    "iha",
    "ihievbe",
    "iii",
    "iiyanh",
    "ija",
    "ije",
    "ijo",
    "ijuw",
    "ika",
    "ikaranggal",
    "ikizu",
    "iklin",
    "iko",
    "ikobi",
    "ikom",
    "ikoma",
    "ikpeng",
    "ikpeshi",
    "ikposo",
    "iku",
    "ikulu",
    "ikwere",
    "ikwo",
    "ikšķiles",
    "ila",
    "ilan",
    "ile",
    "ileia",
    "ilfov",
    "ilgar",
    "ilhas",
    "ili",
    "ilianen",
    "ilinden",
    "ilirska",
    "ille",
    "illes",
    "illinois",
    "illizi",
    "illyrian",
    "ilocos",
    "iloilo",
    "iloko",
    "ilongot",
    "ilue",
    "ilwana",
    "ilūkstes",
    "imathia",
    "imbabura",
    "imbongu",
    "imeret’i",
    "imo",
    "imonda",
    "imperia",
    "imperial",
    "imroing",
    "inabaknon",
    "inagua",
    "inapang",
    "inari",
    "incheon",
    "inchiri",
    "independencia",
    "indi",
    "india",
    "indian",
    "indiana",
    "indic",
    "individual",
    "indo",
    "indonesia",
    "indonesian",
    "indre",
    "indri",
    "indus",
    "inebu",
    "ineseño",
    "inezgane",
    "inga",
    "ingrian",
    "ingush",
    "ingushetiya",
    "inh",
    "inhambane",
    "inherited",
    "ini",
    "injamīnā",
    "inlaod",
    "innerrhoden",
    "innīdī",
    "inoke",
    "inonhan",
    "inor",
    "inpui",
    "inscriptional",
    "insular",
    "interglossa",
    "interlingua",
    "interlingue",
    "international",
    "intha",
    "intibucá",
    "inuinnaqtun",
    "inuit",
    "inuktitut",
    "inupiaq",
    "inupiatun",
    "inverclyde",
    "involved",
    "inés",
    "inčukalna",
    "ioannina",
    "ioba",
    "ionia",
    "iowa",
    "ipalapa",
    "ipeiros",
    "ipiko",
    "ipili",
    "ipulo",
    "iqtelif",
    "iquito",
    "irakleio",
    "iran",
    "iranian",
    "iranun",
    "iraq",
    "iraqi",
    "iraqw",
    "irarutu",
    "iraya",
    "irbid",
    "ireland",
    "iresim",
    "iriga",
    "irigwe",
    "iringa",
    "irish",
    "irkutiskaya",
    "iro",
    "iroquoian",
    "irula",
    "irumu",
    "irántxe",
    "isabel",
    "isabela",
    "isabi",
    "isanzu",
    "isarog",
    "isconahua",
    "isebe",
    "isekiri",
    "isenye",
    "isernia",
    "ishikawa",
    "ishkashimi",
    "isinai",
    "isingiro",
    "isiolo",
    "isirawa",
    "iskandarīyah",
    "isla",
    "islamabad",
    "islamic",
    "island",
    "islander",
    "islands",
    "islas",
    "isle",
    "isles",
    "islington",
    "ismā",
    "isnag",
    "isoko",
    "isola",
    "isparta",
    "israel",
    "israeli",
    "issas",
    "istarska",
    "isthmus",
    "iston",
    "istriot",
    "istro",
    "isu",
    "isukha",
    "isère",
    "italian",
    "italic",
    "italy",
    "itapúa",
    "itawit",
    "itea",
    "itelmen",
    "itene",
    "iteri",
    "itik",
    "itneg",
    "ito",
    "itonama",
    "itu",
    "itundujia",
    "itunyoso",
    "itzá",
    "iuleha",
    "ivano",
    "ivanovskaya",
    "ivančna",
    "ivatan",
    "ivbie",
    "ivindo",
    "ivoire",
    "iwaidja",
    "iwal",
    "iwam",
    "iwate",
    "iwur",
    "ixcatec",
    "ixcatlán",
    "ixil",
    "ixtayutla",
    "ixtenco",
    "ixtlán",
    "iyayu",
    "iyive",
    "iyo",
    "iyojwa",
    "izabal",
    "izere",
    "izii",
    "izola",
    "izon",
    "izora",
    "izz",
    "izzi",
    "iñapari",
    "iğdır",
    "i̇mişli",
    "i̇smayıllı",
    "i̇stanbul",
    "i̇zmir",
    "jabal",
    "jabat",
    "jablanički",
    "jablonec",
    "jabutí",
    "jad",
    "jadgali",
    "jadida",
    "jadīd",
    "jaghbūb",
    "jah",
    "jahanka",
    "jahrrā’",
    "jaintia",
    "jaipurhat",
    "jair",
    "jaitmatang",
    "jakarta",
    "jakati",
    "jakun",
    "jalal",
    "jalapa",
    "jalisco",
    "jalkunan",
    "jaluit",
    "jamaica",
    "jamaican",
    "jamalpur",
    "jamamadí",
    "jambi",
    "james",
    "jamiltepec",
    "jammu",
    "jamo",
    "jamsay",
    "jan",
    "janakpur",
    "jandai",
    "jandavra",
    "janeiro",
    "jangkang",
    "jango",
    "jangshung",
    "janji",
    "janūb",
    "janūbī",
    "janūbīyah",
    "japan",
    "japanese",
    "japrería",
    "jaqaru",
    "jara",
    "jarai",
    "jarash",
    "jarawa",
    "jardin",
    "jargon",
    "jaru",
    "jarvis",
    "jauja",
    "jaunjelgavas",
    "jaunpiebalgas",
    "jaunpils",
    "jaunsari",
    "java",
    "javakhet’i",
    "javanese",
    "javindo",
    "jawa",
    "jawe",
    "jawf",
    "jawi",
    "jaya",
    "jazīrah",
    "jaén",
    "jaíka",
    "jebero",
    "jegunovce",
    "jeh",
    "jehai",
    "jejudo",
    "jejueo",
    "jelgava",
    "jelgavas",
    "jelšah",
    "jemez",
    "jenaama",
    "jendouba",
    "jeng",
    "jenin",
    "jennu",
    "jeonrabukdo",
    "jeonranamdo",
    "jerada",
    "jere",
    "jeri",
    "jericho",
    "jersey",
    "jeru",
    "jerung",
    "jerusalem",
    "jerónimo",
    "jesenice",
    "jeseník",
    "jessore",
    "jewish",
    "jezersko",
    "jhalakati",
    "jhankot",
    "jharkhand",
    "jhenaidah",
    "jiamao",
    "jiangsu",
    "jiangxi",
    "jiao",
    "jiarong",
    "jiba",
    "jibu",
    "jicarilla",
    "jifārah",
    "jigawa",
    "jih",
    "jihlava",
    "jihomoravský",
    "jihočeský",
    "jiiddu",
    "jijel",
    "jilbe",
    "jilim",
    "jilin",
    "jimi",
    "jina",
    "jindřichův",
    "jingpho",
    "jinja",
    "jinotega",
    "jinuo",
    "jinyu",
    "jiongnai",
    "jiparaná",
    "jirel",
    "jiru",
    "jita",
    "jizzax",
    "jičín",
    "jju",
    "joba",
    "jofotek",
    "jogi",
    "john",
    "johnston",
    "johor",
    "jola",
    "jonaz",
    "jongkha",
    "jonglei",
    "jonkor",
    "jor",
    "jordan",
    "jordanian",
    "jorto",
    "jorá",
    "joseph",
    "josé",
    "jowulu",
    "jowzjān",
    "juan",
    "juang",
    "jubbada",
    "judeo",
    "jufrah",
    "jujuy",
    "jukun",
    "julià",
    "jumjum",
    "jumla",
    "jumli",
    "jungle",
    "junín",
    "juquila",
    "jur",
    "jura",
    "juray",
    "jurchen",
    "jurij",
    "jurúna",
    "juršinci",
    "jutiapa",
    "jutish",
    "juventud",
    "juwal",
    "juwoi",
    "juxtlahuaca",
    "juárez",
    "južnobanatski",
    "južnobački",
    "jwira",
    "jász",
    "jämtlands",
    "järvamaa",
    "jèrriais",
    "jõgevamaa",
    "jönköpings",
    "júma",
    "jēkabpils",
    "jīzah",
    "jīzan",
    "jūrmala",
    "kaabong",
    "kaafu",
    "kaamba",
    "kaan",
    "kaang",
    "kaansa",
    "kaapor",
    "kaba",
    "kabalai",
    "kabale",
    "kabardian",
    "kabardino",
    "kabarole",
    "kabatei",
    "kaberamaido",
    "kabiyè",
    "kabola",
    "kabore",
    "kabras",
    "kabunsuwan",
    "kaburi",
    "kabutra",
    "kabuverdianu",
    "kabwa",
    "kabwari",
    "kabyle",
    "kabīr",
    "kacem",
    "kach",
    "kachama",
    "kachari",
    "kachhi",
    "kachi",
    "kachin",
    "kacipo",
    "kaco",
    "kadai",
    "kadar",
    "kadaru",
    "kadazan",
    "kadiogo",
    "kadiwéu",
    "kadu",
    "kadugli",
    "kaduna",
    "kaduo",
    "kadéï",
    "kaeb",
    "kaen",
    "kaeo",
    "kaera",
    "kafa",
    "kaffrine",
    "kafoa",
    "kafr",
    "kagan",
    "kaganga",
    "kagate",
    "kagawa",
    "kagayanen",
    "kagera",
    "kagoma",
    "kagoro",
    "kagoshima",
    "kagulu",
    "kahe",
    "kahramanmaraş",
    "kahua",
    "kai",
    "kaian",
    "kaibobo",
    "kaidipang",
    "kaiep",
    "kaikadi",
    "kaikavian",
    "kaike",
    "kaiku",
    "kaili",
    "kaimbulawa",
    "kaimbé",
    "kaina",
    "kaingang",
    "kaingáng",
    "kainuu",
    "kairak",
    "kairiru",
    "kairouan",
    "kairui",
    "kais",
    "kaitetu",
    "kaithi",
    "kaivi",
    "kaiwá",
    "kaiy",
    "kajakse",
    "kajali",
    "kajaman",
    "kajiado",
    "kakabai",
    "kakabe",
    "kakamega",
    "kakanda",
    "kakhet’i",
    "kaki",
    "kako",
    "kakwa",
    "kala",
    "kalaallisut",
    "kalaamaya",
    "kalabakan",
    "kalabari",
    "kalabra",
    "kalagan",
    "kalaktang",
    "kalam",
    "kalami",
    "kalamsé",
    "kalanadi",
    "kalanga",
    "kalangala",
    "kalanguya",
    "kalao",
    "kalapuya",
    "kalapálo",
    "kalarko",
    "kalasha",
    "kalasin",
    "kalenjin",
    "kalimantan",
    "kalinga",
    "kaliningradskaya",
    "kaliro",
    "kalispel",
    "kalkara",
    "kalkoti",
    "kalkutung",
    "kallahan",
    "kalmar",
    "kalmyk",
    "kalmykiya",
    "kalo",
    "kalou",
    "kaloum",
    "kalpak",
    "kaluli",
    "kalumpang",
    "kaluzhskaya",
    "kam",
    "kamakan",
    "kamang",
    "kamano",
    "kamantan",
    "kamar",
    "kamara",
    "kamarian",
    "kamaru",
    "kamas",
    "kamasa",
    "kamasau",
    "kamayo",
    "kamayurá",
    "kamba",
    "kambaata",
    "kambaira",
    "kambera",
    "kamberau",
    "kambiwá",
    "kamchatskiy",
    "kamenica",
    "kami",
    "kamnik",
    "kamo",
    "kamoro",
    "kampala",
    "kamphaeng",
    "kampong",
    "kampot",
    "kamu",
    "kamula",
    "kamuli",
    "kamviri",
    "kamwe",
    "kamwenge",
    "kan",
    "kanagawa",
    "kanakanabu",
    "kanal",
    "kanamarí",
    "kanan",
    "kanaq",
    "kanashi",
    "kanasi",
    "kanauji",
    "kanchanaburi",
    "kandahār",
    "kandal",
    "kandas",
    "kandavas",
    "kandawo",
    "kande",
    "kanembu",
    "kang",
    "kanga",
    "kangean",
    "kanggape",
    "kangjia",
    "kango",
    "kangri",
    "kangwŏn",
    "kaniet",
    "kanikkaran",
    "kaningdon",
    "kaningi",
    "kaningra",
    "kaninuwa",
    "kanite",
    "kanjari",
    "kanji",
    "kanjobal",
    "kanju",
    "kankan",
    "kankanaey",
    "kankanay",
    "kannada",
    "kano",
    "kanowit",
    "kanoé",
    "kansa",
    "kansai",
    "kansas",
    "kanta",
    "kanton",
    "kantosi",
    "kanu",
    "kanufi",
    "kanum",
    "kanungu",
    "kanuri",
    "kanyok",
    "kao",
    "kaohsiung",
    "kaolack",
    "kaonde",
    "kap",
    "kapampangan",
    "kapchorwa",
    "kapija",
    "kapin",
    "kapinawá",
    "kapingamarangi",
    "kapori",
    "kaposvár",
    "kapriman",
    "kaptiau",
    "kapya",
    "kaqchikel",
    "kara",
    "karaboro",
    "karabük",
    "karachay",
    "karachayevo",
    "karadjeri",
    "karagas",
    "karaim",
    "karajá",
    "karak",
    "karakhanid",
    "karaman",
    "karami",
    "karamojong",
    "karang",
    "karanga",
    "karankawa",
    "karao",
    "karas",
    "karata",
    "karawa",
    "karbala",
    "karbi",
    "karbinci",
    "karditsa",
    "kardzhali",
    "kare",
    "karekare",
    "karelian",
    "kareliya",
    "karen",
    "karenggapa",
    "karey",
    "kari",
    "karim",
    "karingani",
    "karipuna",
    "karipúna",
    "karirí",
    "karitiâna",
    "kariya",
    "kariyarra",
    "karjala",
    "karkar",
    "karkin",
    "karko",
    "karlovarský",
    "karlovačka",
    "karlovy",
    "karnai",
    "karnali",
    "karnataka",
    "karnic",
    "karo",
    "karok",
    "karon",
    "karonga",
    "karore",
    "karpoš",
    "karranga",
    "kars",
    "karuwali",
    "karuzi",
    "karviná",
    "karyaw",
    "kasa",
    "kasai",
    "kasanga",
    "kasem",
    "kasese",
    "kashaya",
    "kashmir",
    "kashmiri",
    "kashubian",
    "kasiguranin",
    "kaska",
    "kaskazini",
    "kaskean",
    "kassalā",
    "kasserine",
    "kastamonu",
    "kastoria",
    "kasua",
    "kasungu",
    "kataang",
    "katabaga",
    "katakana",
    "katakwi",
    "katanga",
    "katarqalai",
    "katawixi",
    "katbol",
    "katcha",
    "kathoriya",
    "kathu",
    "kati",
    "katkari",
    "katla",
    "kato",
    "katsina",
    "katso",
    "katu",
    "katua",
    "katukína",
    "kaulong",
    "kauma",
    "kauno",
    "kaur",
    "kaure",
    "kaurna",
    "kauwera",
    "kavadarci",
    "kavajë",
    "kavala",
    "kavalan",
    "kavet",
    "kawacha",
    "kawaiisu",
    "kawe",
    "kawi",
    "kaxararí",
    "kaxuiâna",
    "kayabí",
    "kayagar",
    "kayah",
    "kayan",
    "kayangel",
    "kayanza",
    "kayapó",
    "kayardild",
    "kayaw",
    "kayeli",
    "kayes",
    "kayin",
    "kayong",
    "kayort",
    "kayseri",
    "kaytetye",
    "kayunga",
    "kayupulau",
    "kazakh",
    "kazakhstan",
    "kazukuru",
    "kaḷutara",
    "keak",
    "keapara",
    "kebbi",
    "kebili",
    "kecskemét",
    "kedah",
    "kedang",
    "kede",
    "keder",
    "keeling",
    "keelung",
    "kef",
    "kefallonia",
    "kehu",
    "kei",
    "keiga",
    "kein",
    "keiyo",
    "kekchí",
    "kela",
    "kelabit",
    "kelantan",
    "kele",
    "keley",
    "keliko",
    "kelo",
    "kelon",
    "kelâa",
    "kemak",
    "kembayan",
    "kemberano",
    "kembra",
    "kemedzung",
    "kemerovskaya",
    "kemi",
    "kemiehua",
    "kemtuik",
    "kenaboi",
    "kenati",
    "kendayan",
    "kendeje",
    "kendem",
    "kenga",
    "keningau",
    "keninjal",
    "kensington",
    "kensiu",
    "kenswei",
    "kent",
    "kentish",
    "kentohe",
    "kentriki",
    "kentucky",
    "kenya",
    "kenyah",
    "kenyan",
    "kenyang",
    "kenyi",
    "kenzi",
    "keoru",
    "kepkiriwát",
    "kepo",
    "kepulauan",
    "kera",
    "kerak",
    "kerala",
    "kereho",
    "kerek",
    "keres",
    "kerewe",
    "kerewo",
    "kericho",
    "kerinci",
    "kerkyra",
    "kermān",
    "kermānshāh",
    "kerry",
    "kerýneia",
    "kerċem",
    "kesawai",
    "keski",
    "ket",
    "ketangalan",
    "kete",
    "ketengban",
    "ketum",
    "keu",
    "kewa",
    "keyagana",
    "keyangan",
    "keynes",
    "kgalagadi",
    "kgatleng",
    "khabarovskiy",
    "khagrachari",
    "khai",
    "khakas",
    "khakasiya",
    "khalaj",
    "khaling",
    "kham",
    "khamba",
    "khammouan",
    "khams",
    "khamti",
    "khamyang",
    "khan",
    "khana",
    "khandesi",
    "khang",
    "khanty",
    "khao",
    "kharam",
    "kharia",
    "kharkivs",
    "kharoshthi",
    "kharţūm",
    "khasi",
    "khatlon",
    "khawr",
    "khaymah",
    "khayo",
    "khazar",
    "khe",
    "khehek",
    "khemisset",
    "khenchela",
    "khengkha",
    "khenifra",
    "khersons",
    "khetrani",
    "khezha",
    "khi",
    "khiamniungan",
    "khimi",
    "khinalugh",
    "khiri",
    "khirwar",
    "khisa",
    "khitan",
    "khlor",
    "khlula",
    "khmel",
    "khmer",
    "khmu",
    "kho",
    "khoekhoe",
    "khoibu",
    "khoisan",
    "khojki",
    "kholok",
    "khomas",
    "khon",
    "khor",
    "khorasani",
    "khorezmian",
    "khorāsān",
    "khotanese",
    "khouribga",
    "khowar",
    "khua",
    "khudawadi",
    "khuen",
    "khulna",
    "khumi",
    "khunsari",
    "khutsuri",
    "khvarshi",
    "khyber",
    "kháng",
    "khánh",
    "khénifra",
    "khün",
    "khōst",
    "khūzestān",
    "kiambu",
    "kibaale",
    "kibet",
    "kibiri",
    "kiboga",
    "kickapoo",
    "kidal",
    "kidričevo",
    "kigali",
    "kigoma",
    "kiini",
    "kikai",
    "kikakui",
    "kikuyu",
    "kildare",
    "kildin",
    "kilenge",
    "kili",
    "kilifi",
    "kilimanjaro",
    "kilinŏchchi",
    "kilis",
    "kilivila",
    "kiliwa",
    "kilkenny",
    "kilkis",
    "kilmeri",
    "kim",
    "kimaama",
    "kimaragang",
    "kimbu",
    "kimbundu",
    "kimki",
    "kimré",
    "kina",
    "kinabalian",
    "kinabatangan",
    "kinalakna",
    "kinamiging",
    "kinaray",
    "kindia",
    "kinga",
    "kingdom",
    "kingman",
    "kingston",
    "kinnauri",
    "kinross",
    "kinshasa",
    "kintaq",
    "kinuku",
    "kinyarwanda",
    "kioko",
    "kiong",
    "kiorr",
    "kiowa",
    "kip",
    "kipsigis",
    "kiput",
    "kir",
    "kirdki",
    "kire",
    "kirghiz",
    "kiri",
    "kiribati",
    "kirike",
    "kirikiri",
    "kirinyaga",
    "kirklees",
    "kirkop",
    "kirmanjki",
    "kirovohrads",
    "kirovskaya",
    "kiruhura",
    "kirundo",
    "kirya",
    "kis",
    "kisa",
    "kisan",
    "kisankasa",
    "kisar",
    "kisela",
    "kishorganj",
    "kisi",
    "kisii",
    "kiskun",
    "kisoro",
    "kissi",
    "kissidougou",
    "kistane",
    "kisumu",
    "kita",
    "kitan",
    "kitembo",
    "kitgum",
    "kitja",
    "kitsai",
    "kitts",
    "kituba",
    "kitui",
    "kiunum",
    "kivu",
    "kiwai",
    "kié",
    "kiên",
    "kičevo",
    "kla",
    "kladno",
    "klaipėdos",
    "klamath",
    "klao",
    "klatovy",
    "kli",
    "klias",
    "klingon",
    "kluet",
    "kmaq",
    "knaanic",
    "kniang",
    "kninska",
    "knowsley",
    "kněžnou",
    "koalib",
    "koasati",
    "koba",
    "kobarid",
    "kobiana",
    "kobilje",
    "koboko",
    "kobol",
    "kobon",
    "kocaeli",
    "koch",
    "kochi",
    "kochila",
    "kocēnu",
    "koda",
    "kodaku",
    "kodava",
    "kodeoha",
    "kodi",
    "kodia",
    "koenoem",
    "kofa",
    "kofei",
    "kofyar",
    "koga",
    "kogi",
    "koguryo",
    "kohgīlūyeh",
    "kohin",
    "kohistani",
    "koho",
    "kohumono",
    "koi",
    "koiali",
    "koiari",
    "koibal",
    "koireng",
    "koitabu",
    "koiwat",
    "kok",
    "kokata",
    "koke",
    "koki",
    "kokneses",
    "koko",
    "kokoda",
    "kokola",
    "kokota",
    "kokturk",
    "kol",
    "kola",
    "kolami",
    "kolašin",
    "kolbila",
    "kolda",
    "koli",
    "kolibugan",
    "kolonjë",
    "kolubarski",
    "koluwawa",
    "kolín",
    "kom",
    "koma",
    "komba",
    "kombai",
    "kombio",
    "komen",
    "komenda",
    "komering",
    "komi",
    "kominimung",
    "kommune",
    "kommuneqarfik",
    "kommunia",
    "komo",
    "komodo",
    "komondjari",
    "kompane",
    "kompienga",
    "komunitatea",
    "komyandaret",
    "komárom",
    "kon",
    "konai",
    "konda",
    "koneraw",
    "kong",
    "kongo",
    "konjice",
    "konjo",
    "konkani",
    "konkomba",
    "konni",
    "kono",
    "konomala",
    "konongo",
    "konso",
    "kontagora",
    "konya",
    "konyak",
    "konyanka",
    "konzo",
    "konzəl",
    "konče",
    "koongo",
    "koonzime",
    "koorete",
    "kopar",
    "koper",
    "kopkaka",
    "koprivničko",
    "kora",
    "korafe",
    "koraga",
    "korak",
    "korana",
    "korandje",
    "kordestān",
    "kordofanian",
    "korea",
    "korean",
    "koreguaje",
    "koresh",
    "korinthia",
    "korku",
    "korlai",
    "koro",
    "koromfé",
    "koromira",
    "koronadal",
    "koroni",
    "korop",
    "koropó",
    "koror",
    "koroshi",
    "korowai",
    "koroškem",
    "korra",
    "korubo",
    "koruna",
    "korupun",
    "korwa",
    "koryak",
    "korçë",
    "kosadle",
    "kosanjevica",
    "kosarek",
    "kosena",
    "koshin",
    "kosi",
    "kosovo",
    "kosovski",
    "kosovsko",
    "kosrae",
    "kosraean",
    "kossi",
    "kostanjevica",
    "kostel",
    "kostromskaya",
    "kota",
    "kotafon",
    "kotava",
    "kotayk",
    "koti",
    "kotido",
    "kotor",
    "kott",
    "kotto",
    "koubia",
    "kouffo",
    "kouilou",
    "koulikoro",
    "koulpélogo",
    "koundara",
    "kouritenga",
    "kouroussa",
    "kourwéogo",
    "kouya",
    "kovai",
    "kove",
    "kowaki",
    "kowiai",
    "koy",
    "koya",
    "koyaga",
    "koyo",
    "koyra",
    "koyraboro",
    "koyukon",
    "kozani",
    "kozina",
    "kozje",
    "kočani",
    "kočevje",
    "košický",
    "kpagua",
    "kpala",
    "kpan",
    "kpasam",
    "kpati",
    "kpatili",
    "kpeego",
    "kpelle",
    "kpessi",
    "kplang",
    "krabi",
    "krache",
    "krachoh",
    "krahn",
    "krahô",
    "kraj",
    "kranj",
    "kranjska",
    "kraol",
    "krapinsko",
    "krasnodarskiy",
    "krasnoyarskiy",
    "kratovo",
    "kray",
    "krenak",
    "krevinian",
    "kreye",
    "krikati",
    "krim",
    "krimuldas",
    "krio",
    "kriol",
    "krisa",
    "kriti",
    "kriva",
    "krivogaštani",
    "križevačka",
    "križevci",
    "krki",
    "krobu",
    "kroměříž",
    "krona",
    "krone",
    "krong",
    "krongo",
    "kronobergs",
    "kru",
    "krujë",
    "krumen",
    "krumlov",
    "krung",
    "krustpils",
    "kruševo",
    "krym",
    "krymchak",
    "kryts",
    "králové",
    "královéhradecký",
    "krāslavas",
    "krško",
    "kshiti",
    "kua",
    "kuala",
    "kuamasi",
    "kuan",
    "kuanhua",
    "kuanua",
    "kuanyama",
    "kube",
    "kubi",
    "kubo",
    "kubu",
    "kucong",
    "kudarat",
    "kudiya",
    "kudmali",
    "kudu",
    "kufrah",
    "kugama",
    "kugbo",
    "kui",
    "kuijau",
    "kuikúro",
    "kujalleq",
    "kujarge",
    "kujawsko",
    "kuk",
    "kukatja",
    "kuke",
    "kukele",
    "kukna",
    "kuku",
    "kukuya",
    "kukës",
    "kula",
    "kulan",
    "kulango",
    "kuldīgas",
    "kulere",
    "kulfa",
    "kulina",
    "kulisusu",
    "kullu",
    "kulon",
    "kulung",
    "kumalu",
    "kumam",
    "kumamoto",
    "kuman",
    "kumanovo",
    "kumaoni",
    "kumarbhag",
    "kumba",
    "kumbainggar",
    "kumbaran",
    "kumbewaha",
    "kumhali",
    "kumi",
    "kumiai",
    "kumukio",
    "kumyk",
    "kumzari",
    "kuna",
    "kunama",
    "kunar",
    "kunbarlang",
    "kunda",
    "kundal",
    "kundi",
    "kunduvadi",
    "kunduz",
    "kunene",
    "kung",
    "kungarakany",
    "kungardutyi",
    "kunggari",
    "kungkari",
    "kungota",
    "kuni",
    "kunigami",
    "kunimaipa",
    "kunja",
    "kunjen",
    "kunyi",
    "kunza",
    "kuo",
    "kuot",
    "kupa",
    "kupang",
    "kupia",
    "kupsabiny",
    "kur",
    "kura",
    "kurama",
    "kuranko",
    "kurbin",
    "kurdish",
    "kurdufān",
    "kurganskaya",
    "kuri",
    "kuria",
    "kurichiya",
    "kurigram",
    "kurmukar",
    "kurnai",
    "kurrama",
    "kurskaya",
    "kurti",
    "kurtokha",
    "kurudu",
    "kurukh",
    "kurumba",
    "kurux",
    "kuruáya",
    "kuruṇægala",
    "kusaal",
    "kusaghe",
    "kushi",
    "kushtia",
    "kusini",
    "kuskokwim",
    "kusu",
    "kusunda",
    "kusuntu",
    "kutai",
    "kutenai",
    "kutep",
    "kuthant",
    "kutná",
    "kutong",
    "kutto",
    "kutu",
    "kuturmi",
    "kuuk",
    "kuuku",
    "kuvale",
    "kuvi",
    "kuwaa",
    "kuwaataay",
    "kuwait",
    "kuwaiti",
    "kuwayt",
    "kuy",
    "kuzma",
    "kuçovë",
    "kven",
    "kwa",
    "kwaami",
    "kwacha",
    "kwadi",
    "kwaio",
    "kwaja",
    "kwajalein",
    "kwakiutl",
    "kwakum",
    "kwale",
    "kwalhioqua",
    "kwama",
    "kwambi",
    "kwamera",
    "kwami",
    "kwamtim",
    "kwang",
    "kwanga",
    "kwangali",
    "kwanja",
    "kwanyama",
    "kwanza",
    "kwara",
    "kwasio",
    "kwaya",
    "kwaza",
    "kwazulu",
    "kwegu",
    "kweneng",
    "kwer",
    "kwerba",
    "kwere",
    "kwerisa",
    "kwese",
    "kwesten",
    "kwini",
    "kwinsu",
    "kwinti",
    "kwoma",
    "kwomtari",
    "kwonci",
    "kxoe",
    "kyak",
    "kyaka",
    "kyan",
    "kyanga",
    "kyat",
    "kyenele",
    "kyenjojo",
    "kyerung",
    "kyklades",
    "kymenlaakso",
    "kyoto",
    "kyrgyz",
    "kyrgyzstan",
    "kyustendil",
    "kyïvs",
    "kâte",
    "kärnten",
    "kægalla",
    "kédougou",
    "kélé",
    "kémo",
    "kénitra",
    "kénédougou",
    "kérouané",
    "köl",
    "kölsch",
    "kürdəmir",
    "kütahya",
    "kābul",
    "kānim",
    "kāpīsā",
    "kārsavas",
    "kībbī",
    "kırklareli",
    "kırıkkale",
    "kırşehir",
    "kŏḷamba",
    "kǝngǝrli",
    "kəlbəcər",
    "kɛlɛngaxo",
    "kạn",
    "k’abeena",
    "k’art’li",
    "k’vemo",
    "laal",
    "laali",
    "laamu",
    "laari",
    "laba",
    "label",
    "labem",
    "labir",
    "labo",
    "labrador",
    "labu",
    "labuan",
    "labuk",
    "labé",
    "lacandon",
    "lachi",
    "lachiguiri",
    "lachixío",
    "lacs",
    "ladakhi",
    "ladhiqiyah",
    "ladin",
    "ladino",
    "ladji",
    "lae",
    "laeko",
    "lafofa",
    "lagaw",
    "laghmān",
    "laghouat",
    "laghu",
    "laghuu",
    "lagos",
    "laguna",
    "lagunes",
    "lagwan",
    "laha",
    "lahanan",
    "lahnda",
    "lahta",
    "lahu",
    "lahul",
    "lai",
    "laikipia",
    "laimbue",
    "laing",
    "laitu",
    "laiyolo",
    "lak",
    "laka",
    "lakalei",
    "lake",
    "lakes",
    "lakha",
    "laki",
    "lakkia",
    "lakon",
    "lakondê",
    "lakonia",
    "lakota",
    "lakshadweep",
    "lakshmipur",
    "lala",
    "lalana",
    "lalia",
    "lalmonirhat",
    "lalo",
    "lalu",
    "lam",
    "lama",
    "lamaholot",
    "lamalera",
    "lamang",
    "lamatuka",
    "lamba",
    "lambadi",
    "lambayeque",
    "lambeth",
    "lambichhong",
    "lamboya",
    "lambya",
    "lame",
    "lamenu",
    "lamet",
    "lamja",
    "lamkang",
    "lamma",
    "lamnso",
    "lamogai",
    "lampang",
    "lamphun",
    "lampung",
    "lamu",
    "lamusong",
    "lamīs",
    "lan",
    "lanao",
    "lanarkshire",
    "lanas",
    "lancashire",
    "land",
    "landes",
    "landoma",
    "landschaft",
    "lang",
    "langam",
    "langbashe",
    "langi",
    "langnian",
    "lango",
    "langobardic",
    "langue",
    "lanima",
    "lanka",
    "lankan",
    "lanna",
    "lanoh",
    "lao",
    "laois",
    "laomian",
    "laopang",
    "laos",
    "lapaguía",
    "lappi",
    "lara",
    "larache",
    "laragia",
    "larantuka",
    "lardil",
    "larevat",
    "larga",
    "large",
    "largo",
    "lari",
    "larike",
    "larisa",
    "laro",
    "larteh",
    "laru",
    "larue",
    "larvotto",
    "las",
    "lasalimu",
    "lasan",
    "lasgerdi",
    "lashi",
    "lasi",
    "lasithi",
    "late",
    "latgalian",
    "latin",
    "latina",
    "latu",
    "latundê",
    "latvia",
    "latvian",
    "lau",
    "laua",
    "lauan",
    "lauje",
    "laura",
    "laurentian",
    "lauricocha",
    "laut",
    "lautem",
    "lautu",
    "lavalleja",
    "lavatbura",
    "lave",
    "laven",
    "laventille",
    "lavukaleve",
    "lawa",
    "lawangan",
    "lawoi",
    "lawrenz",
    "lawu",
    "lawunuia",
    "layakha",
    "laz",
    "lazare",
    "lazio",
    "laâyoune",
    "laçın",
    "laško",
    "lašče",
    "laḩij",
    "lealao",
    "lebanese",
    "lebanon",
    "lebap",
    "lecce",
    "lecco",
    "lech’khumi",
    "leco",
    "ledo",
    "leeds",
    "leelau",
    "lefa",
    "lefkada",
    "lefkosía",
    "lega",
    "legbo",
    "legenyem",
    "legeri",
    "lehali",
    "lehalurup",
    "lehar",
    "leicester",
    "leicestershire",
    "leinong",
    "leinster",
    "leipon",
    "leiria",
    "leitrim",
    "lek",
    "leke",
    "leko",
    "lela",
    "lelak",
    "lele",
    "lelemi",
    "lelepa",
    "lembata",
    "lembena",
    "lemerig",
    "lemesós",
    "lemio",
    "lemnian",
    "lemolang",
    "lemoro",
    "lempira",
    "lenakel",
    "lenart",
    "lenca",
    "lendava",
    "lendu",
    "lendva",
    "lengilu",
    "lengo",
    "lengola",
    "lengua",
    "leningitij",
    "leningradskaya",
    "lenje",
    "lenkau",
    "lenyima",
    "leone",
    "leonese",
    "leova",
    "lepcha",
    "lepki",
    "lepontic",
    "lere",
    "leribe",
    "lerik",
    "les",
    "lese",
    "lesing",
    "lesotho",
    "leste",
    "lesvos",
    "letemboi",
    "leti",
    "letzeburgesch",
    "leu",
    "lev",
    "levantine",
    "levuka",
    "lewisham",
    "lewo",
    "lewotobi",
    "leyigha",
    "leyte",
    "lezghian",
    "lezhë",
    "león",
    "lhamtés",
    "lhaviyani",
    "lhokpu",
    "lhomi",
    "lhuentse",
    "liabuku",
    "liana",
    "liangmai",
    "lianshan",
    "liaoning",
    "lib",
    "liban",
    "liberec",
    "liberecký",
    "liberia",
    "liberian",
    "libertad",
    "libertador",
    "libido",
    "libinza",
    "libon",
    "librazhd",
    "libuat",
    "liburnian",
    "libya",
    "libyan",
    "liechtenstein",
    "lielvārdes",
    "liepāja",
    "ligbi",
    "ligenza",
    "liguria",
    "ligurian",
    "lihir",
    "lija",
    "lijili",
    "lika",
    "liki",
    "likiep",
    "likila",
    "likoma",
    "likouala",
    "likuba",
    "likum",
    "likwala",
    "lilangeni",
    "lilau",
    "lillooet",
    "lilongwe",
    "lima",
    "limassa",
    "limba",
    "limbažu",
    "limbu",
    "limbum",
    "limburg",
    "limburgan",
    "limburger",
    "limburgish",
    "limerick",
    "limi",
    "limilngan",
    "limos",
    "limpopo",
    "limón",
    "lincolnshire",
    "lindi",
    "lindu",
    "line",
    "linear",
    "lingala",
    "lingao",
    "lingarak",
    "lingua",
    "linguistic",
    "lipan",
    "lipetskaya",
    "lipi",
    "lipkovo",
    "lipo",
    "liquiça",
    "lira",
    "lisabata",
    "lisboa",
    "lisburn",
    "lisela",
    "lish",
    "lishana",
    "lishanid",
    "lishán",
    "lisu",
    "literary",
    "lithuania",
    "lithuanian",
    "litija",
    "litiji",
    "litoměřice",
    "litoral",
    "littoral",
    "litzlitz",
    "liujiang",
    "liuqian",
    "liv",
    "livanjski",
    "liverpool",
    "livorno",
    "livvi",
    "liège",
    "liêu",
    "ličko",
    "ljubljana",
    "ljubljani",
    "ljubno",
    "ljutomer",
    "llave",
    "lleida",
    "loarki",
    "lobala",
    "lobaye",
    "lobi",
    "lobu",
    "local",
    "lodhi",
    "lodi",
    "loei",
    "lofa",
    "log",
    "logatec",
    "logba",
    "logo",
    "logol",
    "logooli",
    "logorik",
    "logudorese",
    "lohar",
    "lohorung",
    "loi",
    "loir",
    "loire",
    "loiret",
    "loja",
    "lojban",
    "loka",
    "lokaa",
    "loke",
    "lokep",
    "loko",
    "lokoya",
    "lola",
    "lolak",
    "lole",
    "lolo",
    "loloda",
    "lolopo",
    "loma",
    "lomaiviti",
    "lomavren",
    "lombard",
    "lombardia",
    "lombi",
    "lombo",
    "lomwe",
    "loncong",
    "london",
    "longford",
    "longgu",
    "longto",
    "longuda",
    "loniu",
    "lonwolwol",
    "lonzo",
    "loo",
    "lop",
    "lopa",
    "lopi",
    "lopit",
    "lorang",
    "lorediakarkar",
    "lorestān",
    "loreto",
    "loroum",
    "lory",
    "los",
    "lot",
    "lote",
    "lotha",
    "lothian",
    "loti",
    "lotud",
    "lou",
    "louang",
    "louangphabang",
    "louga",
    "louis",
    "louisiana",
    "loun",
    "louny",
    "loup",
    "lourenço",
    "louth",
    "lovech",
    "lovrenc",
    "low",
    "lower",
    "lowland",
    "loxicha",
    "lozi",
    "lozovo",
    "lozère",
    "loška",
    "loški",
    "lua",
    "luanda",
    "luang",
    "luapula",
    "luba",
    "lubelskie",
    "lubila",
    "lubombo",
    "lubu",
    "lubuagan",
    "lubuskie",
    "lubānas",
    "lucca",
    "luchazi",
    "lucia",
    "lucian",
    "lucumi",
    "lucy",
    "lucía",
    "ludian",
    "ludzas",
    "lue",
    "lufu",
    "luganda",
    "lugbara",
    "lugger",
    "lugo",
    "luguru",
    "luhans",
    "luhu",
    "lui",
    "luimbi",
    "luis",
    "luiseno",
    "luke",
    "lukovica",
    "lukpa",
    "lule",
    "lulua",
    "lumba",
    "lumbee",
    "lumbini",
    "lumbu",
    "lumpur",
    "lumun",
    "luna",
    "lunanakha",
    "lunda",
    "lundayeh",
    "lung",
    "lungalunga",
    "lungga",
    "lungu",
    "luo",
    "luopohe",
    "luqa",
    "luquan",
    "luri",
    "luritja",
    "lusaka",
    "lusengo",
    "lushai",
    "lushnjë",
    "lushootseed",
    "lusi",
    "lusitanian",
    "luton",
    "lutos",
    "luvale",
    "luwati",
    "luwero",
    "luwian",
    "luwo",
    "luxembourg",
    "luxembourgish",
    "luyana",
    "luyia",
    "luzern",
    "luzon",
    "luís",
    "luċija",
    "luče",
    "lwalu",
    "lyantonde",
    "lycian",
    "lydian",
    "lyngngam",
    "lyons",
    "lyélé",
    "lào",
    "láadan",
    "lárnaka",
    "láá",
    "lâm",
    "län",
    "lääne",
    "läänemaa",
    "lékoumou",
    "lélouma",
    "léraba",
    "lípa",
    "lòria",
    "līgatnes",
    "līvānu",
    "lōgar",
    "lūqūn",
    "lənkəran",
    "lạng",
    "lắk",
    "maa",
    "maaka",
    "maakunta",
    "maarten",
    "maasina",
    "maay",
    "maba",
    "mabaale",
    "mabaan",
    "mabaka",
    "mabas",
    "mabire",
    "maca",
    "macaguaje",
    "macaguán",
    "macanese",
    "macao",
    "macedo",
    "macedonia",
    "macedonian",
    "macenta",
    "macerata",
    "machakos",
    "machame",
    "machiguenga",
    "machinere",
    "machinga",
    "maci",
    "maco",
    "macorís",
    "macrolanguage",
    "macuna",
    "macushi",
    "mada",
    "madagascar",
    "madak",
    "madang",
    "madaripur",
    "madaré",
    "madeira",
    "maden",
    "madhe",
    "madhi",
    "madhya",
    "madhyama",
    "madhyamanchal",
    "madi",
    "madngele",
    "madonas",
    "madre",
    "madrid",
    "madriz",
    "madurese",
    "madīnah",
    "madīnat",
    "mae",
    "maek",
    "maeng",
    "maewo",
    "mafa",
    "mafea",
    "mafeteng",
    "mafraq",
    "mag",
    "magadanskaya",
    "magahi",
    "magallanes",
    "magar",
    "magbukun",
    "magdalena",
    "maggiore",
    "magharibi",
    "magnisia",
    "magoma",
    "magori",
    "maguindanao",
    "maguindanaon",
    "magura",
    "magway",
    "magɨyi",
    "maha",
    "mahafaly",
    "mahaica",
    "mahajanga",
    "mahajani",
    "mahakali",
    "mahakam",
    "mahali",
    "mahanuvara",
    "maharashtra",
    "mahasu",
    "mahdia",
    "mahe",
    "mahican",
    "mahilioŭskaja",
    "mahongwe",
    "mahou",
    "mahrah",
    "mahāll",
    "mai",
    "maia",
    "maiadomu",
    "maiani",
    "maidenhead",
    "maidu",
    "maii",
    "mailu",
    "maindo",
    "maine",
    "mainfränkisch",
    "mainstream",
    "maio",
    "mairasi",
    "mairie",
    "maisin",
    "maithili",
    "maiwa",
    "maiwala",
    "majang",
    "majera",
    "majhi",
    "majhwar",
    "majukayang",
    "majuro",
    "majšperk",
    "mak",
    "makaa",
    "makah",
    "makalero",
    "makamba",
    "makasae",
    "makasar",
    "makassar",
    "makayam",
    "makedonia",
    "makedonska",
    "makedonski",
    "makhuwa",
    "makian",
    "makira",
    "makkah",
    "maklew",
    "makole",
    "makolkol",
    "makonde",
    "maku",
    "makueni",
    "makuri",
    "makuráp",
    "makwe",
    "makyan",
    "makú",
    "mal",
    "mala",
    "malaccan",
    "malagasy",
    "malaita",
    "malalamai",
    "malampa",
    "malang",
    "malange",
    "malango",
    "malankuravan",
    "malapandaram",
    "malaryan",
    "malas",
    "malasar",
    "malatya",
    "malavedan",
    "malawi",
    "malay",
    "malayalam",
    "malayic",
    "malaynon",
    "malayo",
    "malaysia",
    "malaysian",
    "malba",
    "malbousquet",
    "maldives",
    "maldivian",
    "maldonado",
    "male",
    "malecite",
    "maleng",
    "maleu",
    "malfaxal",
    "malgana",
    "malgbe",
    "mali",
    "malila",
    "malimba",
    "malimpung",
    "malinaltepec",
    "mallakastër",
    "malo",
    "maloelap",
    "malol",
    "malta",
    "maltese",
    "malua",
    "maluku",
    "malvi",
    "malvinas",
    "malyangapa",
    "maléku",
    "malësi",
    "mam",
    "mama",
    "mamaa",
    "mamaindé",
    "mamanwa",
    "mamara",
    "mamasa",
    "mambae",
    "mambai",
    "mamberamo",
    "mambila",
    "mamboru",
    "mambwe",
    "mambéré",
    "mamelles",
    "mamou",
    "mampruli",
    "mamuju",
    "mamulique",
    "mamusi",
    "mamvu",
    "man",
    "manabí",
    "manado",
    "manafwa",
    "managua",
    "manam",
    "manambu",
    "manangba",
    "manangkari",
    "manat",
    "manatuto",
    "manawatu",
    "mancha",
    "manche",
    "manchester",
    "manchu",
    "manda",
    "mandaean",
    "mandahuaca",
    "mandaic",
    "mandailing",
    "mandalay",
    "mandan",
    "mandandanyi",
    "mandar",
    "mandara",
    "mandari",
    "mandarin",
    "mandaya",
    "mande",
    "mandeali",
    "mander",
    "mandera",
    "mandiana",
    "mandingo",
    "mandinka",
    "mandjak",
    "mandobo",
    "manduri",
    "manem",
    "mang",
    "manga",
    "mangala",
    "mangarayi",
    "mangareva",
    "mangas",
    "mangayat",
    "mangbetu",
    "mangbutu",
    "mangerr",
    "mangga",
    "manggarai",
    "mangghystaū",
    "mangk",
    "mango",
    "mangochi",
    "mangole",
    "mangrove",
    "mangseng",
    "mangue",
    "manguean",
    "manica",
    "manicaland",
    "manichaean",
    "manide",
    "maniema",
    "manihiki",
    "manikganj",
    "manikion",
    "maninka",
    "maninkakan",
    "manipa",
    "manipur",
    "manipuri",
    "manisa",
    "manitoba",
    "mankanya",
    "manna",
    "mannan",
    "mannārama",
    "mano",
    "manobo",
    "manombai",
    "manouba",
    "mansaka",
    "mansi",
    "mansiysky",
    "mansoanka",
    "manta",
    "mantova",
    "mantsi",
    "manufahi",
    "manumanaw",
    "manus",
    "manx",
    "manya",
    "manyara",
    "manyawa",
    "manyika",
    "manza",
    "manzini",
    "manāmah",
    "mao",
    "maonan",
    "maore",
    "maori",
    "mape",
    "mapena",
    "mapia",
    "mapidian",
    "mapos",
    "mapoyo",
    "mapuche",
    "mapudungun",
    "mapun",
    "maputo",
    "maquiritari",
    "mar",
    "mara",
    "maracha",
    "marachi",
    "maradi",
    "maraghei",
    "maragus",
    "marahoué",
    "marakwet",
    "maram",
    "marama",
    "maramba",
    "maramureș",
    "maranao",
    "maranhão",
    "maranunggu",
    "mararit",
    "marathi",
    "marau",
    "marba",
    "marche",
    "marchen",
    "marcos",
    "mardin",
    "mare",
    "maremgi",
    "marenje",
    "marfa",
    "margany",
    "marghi",
    "margibi",
    "margos",
    "margu",
    "mari",
    "maria",
    "mariana",
    "maribor",
    "maricopa",
    "maridan",
    "maridjabin",
    "marijampolės",
    "marik",
    "marimanindji",
    "marind",
    "marinduque",
    "maring",
    "maringarr",
    "marino",
    "mariri",
    "marithiel",
    "maritime",
    "maritimes",
    "maritsauá",
    "mariy",
    "mariyedi",
    "marj",
    "mark",
    "marka",
    "markazī",
    "markets",
    "markovci",
    "markweeta",
    "marlborough",
    "marma",
    "marne",
    "maroon",
    "marovo",
    "marowijne",
    "marqab",
    "marquesan",
    "marrakech",
    "marrevone",
    "marriammu",
    "marrucinian",
    "marsa",
    "marsabit",
    "marsaskala",
    "marsaxlokk",
    "marshall",
    "marshallese",
    "marsian",
    "martha",
    "marti",
    "martin",
    "martinique",
    "martu",
    "martuyhunira",
    "martín",
    "maru",
    "marudu",
    "marwari",
    "mary",
    "maryland",
    "maría",
    "marúbo",
    "masaaba",
    "masadiit",
    "masai",
    "masaka",
    "masalit",
    "masallı",
    "masana",
    "masaya",
    "masbate",
    "masbatenyo",
    "masbuar",
    "mascara",
    "masela",
    "maseru",
    "mashan",
    "mashco",
    "mashi",
    "mashonaland",
    "masikoro",
    "masimasi",
    "masindi",
    "masiwang",
    "maskelynes",
    "maskoy",
    "maslam",
    "masmaje",
    "masqaţ",
    "massa",
    "massachusetts",
    "massalat",
    "massana",
    "massep",
    "masvingo",
    "mat",
    "mata",
    "matabeleland",
    "matagalpa",
    "matal",
    "matam",
    "matanzas",
    "matbat",
    "matengo",
    "mateo",
    "matepi",
    "matera",
    "mathematical",
    "matigsalug",
    "matipuhy",
    "matlatzinca",
    "mato",
    "mator",
    "matrūh",
    "matsés",
    "mattole",
    "matu",
    "matukar",
    "matumbi",
    "matya",
    "matís",
    "mau",
    "maud",
    "maule",
    "maung",
    "mauren",
    "mauritania",
    "mauritian",
    "mauritius",
    "mauwake",
    "mavrovo",
    "mawa",
    "mawak",
    "mawan",
    "mawayana",
    "mawchi",
    "mawes",
    "mawé",
    "maxakalí",
    "maxi",
    "maya",
    "mayaguana",
    "mayaguduna",
    "mayan",
    "mayangna",
    "mayaro",
    "mayawali",
    "mayek",
    "mayeka",
    "mayen",
    "mayenne",
    "mayi",
    "mayo",
    "mayogo",
    "mayor",
    "mayotte",
    "mayoyao",
    "maysan",
    "mayuge",
    "mazagway",
    "mazahua",
    "mazaltepec",
    "mazanderani",
    "mazaruni",
    "mazatec",
    "mazatlán",
    "mazowieckie",
    "mazsalacas",
    "mazurskie",
    "mačvanski",
    "małopolskie",
    "maḍakalapuva",
    "maḩwīt",
    "ma‘ān",
    "mba",
    "mbaaru",
    "mbala",
    "mbalanhu",
    "mbale",
    "mbandja",
    "mbangala",
    "mbangi",
    "mbangwe",
    "mbara",
    "mbarara",
    "mbariman",
    "mbati",
    "mbato",
    "mbay",
    "mbe",
    "mbelime",
    "mbembe",
    "mbere",
    "mbesa",
    "mbeya",
    "mbo",
    "mbodomo",
    "mboi",
    "mboko",
    "mbole",
    "mbomou",
    "mbon",
    "mbonga",
    "mbongno",
    "mbosi",
    "mbowe",
    "mbre",
    "mbrès",
    "mbudum",
    "mbugu",
    "mbugwe",
    "mbuko",
    "mbukushu",
    "mbula",
    "mbule",
    "mbulungish",
    "mbum",
    "mbunda",
    "mbunga",
    "mburku",
    "mbwela",
    "mbyá",
    "mcdonald",
    "mchinji",
    "mdina",
    "meadow",
    "mean",
    "meath",
    "mecayapan",
    "mechi",
    "mecklenburg",
    "medebur",
    "medenine",
    "media",
    "mediak",
    "median",
    "medio",
    "mednyj",
    "medumba",
    "medvode",
    "medway",
    "meemu",
    "meetei",
    "meetto",
    "mefele",
    "megam",
    "meghalaya",
    "megleno",
    "mehedinți",
    "mehek",
    "meherpur",
    "meherrin",
    "mehináku",
    "mehri",
    "meitei",
    "meithei",
    "mejit",
    "mekeo",
    "mekmek",
    "meknès",
    "mekwei",
    "mel",
    "melaka",
    "melanau",
    "mele",
    "melekeok",
    "melilla",
    "mellal",
    "mellieħa",
    "melloul",
    "melo",
    "melpa",
    "memoni",
    "men",
    "menchum",
    "mendalam",
    "mendankwe",
    "mende",
    "mendoza",
    "meneng",
    "mengaka",
    "mengen",
    "mengeš",
    "mengisa",
    "menka",
    "menominee",
    "mentawai",
    "menya",
    "meo",
    "meohang",
    "meoswar",
    "mer",
    "merah",
    "meramera",
    "merap",
    "merei",
    "merey",
    "meriam",
    "merlav",
    "meroitic",
    "mersin",
    "merthyr",
    "merton",
    "meru",
    "merwari",
    "mesaka",
    "mescalero",
    "mese",
    "meskwaki",
    "mesme",
    "mesmes",
    "mesopotamian",
    "mesqan",
    "messapic",
    "messina",
    "messinia",
    "mesto",
    "met",
    "meta",
    "metaʼ",
    "metical",
    "metlatónoc",
    "metlika",
    "meto",
    "metohija",
    "metropolitana",
    "meu",
    "meurthe",
    "meuse",
    "mewari",
    "mewati",
    "mexican",
    "mexico",
    "meyah",
    "mezontla",
    "mezquital",
    "međimurska",
    "mešto",
    "mežica",
    "mfinu",
    "mfumte",
    "mgbolizhia",
    "miahuatlán",
    "miami",
    "mian",
    "miani",
    "miao",
    "miaoli",
    "michael",
    "michif",
    "michigamea",
    "michigan",
    "michoacán",
    "micmac",
    "micronesia",
    "mid",
    "middle",
    "middlesbrough",
    "midelt",
    "midiki",
    "midlands",
    "midlothian",
    "midob",
    "midtjylland",
    "midway",
    "mie",
    "mien",
    "migaama",
    "migabac",
    "migori",
    "miguel",
    "migum",
    "miju",
    "mikasuki",
    "miklavž",
    "mil",
    "mila",
    "milano",
    "mili",
    "milne",
    "milton",
    "miltu",
    "miluk",
    "milyan",
    "mim",
    "mimaropa",
    "min",
    "mina",
    "minaean",
    "minang",
    "minangkabau",
    "minanibai",
    "minas",
    "minaveha",
    "minda",
    "mindanao",
    "minderico",
    "mindiri",
    "mindoro",
    "mingang",
    "mingrelian",
    "mingəçevir",
    "minh",
    "miniafia",
    "minica",
    "minidien",
    "minjungbal",
    "minkin",
    "minnesota",
    "minoan",
    "minokok",
    "minor",
    "minriq",
    "minsk",
    "minskaja",
    "mintil",
    "minyā",
    "minz",
    "minūfīyah",
    "miqie",
    "miquelon",
    "miranda",
    "mirandese",
    "miraya",
    "mirditë",
    "miren",
    "mirgan",
    "miri",
    "miriti",
    "miriwoong",
    "miriwung",
    "mirna",
    "mis",
    "misamis",
    "miship",
    "mishmi",
    "misima",
    "mising",
    "misiones",
    "miskolc",
    "mislinja",
    "mississippi",
    "missouri",
    "mitla",
    "mitlatongo",
    "mitrovački",
    "mittu",
    "mituku",
    "mityana",
    "miu",
    "miwa",
    "miwok",
    "mixe",
    "mixed",
    "mixtec",
    "mixtepec",
    "miya",
    "miyagi",
    "miyako",
    "miyazaki",
    "miyobe",
    "mizoram",
    "mişrātah",
    "mjini",
    "mkhedruli",
    "mlabri",
    "mladá",
    "mlahsö",
    "mlap",
    "mlomp",
    "mmaala",
    "mmen",
    "mnong",
    "moabite",
    "moba",
    "mobilian",
    "mobumrin",
    "mobwa",
    "mochi",
    "mochica",
    "mocho",
    "mocoví",
    "modang",
    "modena",
    "modern",
    "modi",
    "modo",
    "modoc",
    "modole",
    "moere",
    "mofu",
    "mogholi",
    "mogila",
    "mogofin",
    "mogum",
    "mohale",
    "mohammadia",
    "mohave",
    "mohawk",
    "mohegan",
    "moi",
    "moikodi",
    "moingi",
    "moji",
    "mojkovac",
    "mok",
    "moka",
    "moken",
    "mokerang",
    "mokhotlong",
    "mokilese",
    "moklen",
    "mokole",
    "mokpwe",
    "mokronog",
    "moksela",
    "moksha",
    "molale",
    "molbog",
    "moldavian",
    "moldova",
    "moldovan",
    "molengue",
    "molima",
    "molise",
    "molmo",
    "molo",
    "molof",
    "moloko",
    "moluccan",
    "mom",
    "moma",
    "momare",
    "mombasa",
    "mombo",
    "mombum",
    "momina",
    "momuna",
    "mon",
    "monaco",
    "monagas",
    "monaghan",
    "monastic",
    "monastir",
    "mondol",
    "mondropolon",
    "mondé",
    "moneghetti",
    "monetary",
    "mong",
    "monggar",
    "mongo",
    "mongol",
    "mongolia",
    "mongolian",
    "mongondow",
    "moni",
    "moniga",
    "monmouthshire",
    "mono",
    "monom",
    "monpa",
    "monsang",
    "monseñor",
    "mont",
    "montagnais",
    "montagnes",
    "montana",
    "monte",
    "montegiardino",
    "montenegrin",
    "montenegro",
    "monteverde",
    "montevideo",
    "montol",
    "montserrado",
    "montserrat",
    "monumbo",
    "monza",
    "monzombo",
    "moo",
    "moon",
    "moore",
    "moose",
    "mopti",
    "mopán",
    "moquegua",
    "mor",
    "moraid",
    "moravički",
    "moravske",
    "moravskoslezský",
    "moravče",
    "morawa",
    "moray",
    "morazán",
    "morbihan",
    "mordoviya",
    "morelos",
    "morerebi",
    "moresada",
    "moresby",
    "morgannwg",
    "mori",
    "morigi",
    "morisyen",
    "mormon",
    "moro",
    "morobe",
    "moroccan",
    "morocco",
    "morofo",
    "morogoro",
    "morokodo",
    "morom",
    "morona",
    "moronene",
    "morori",
    "moroto",
    "morouas",
    "mortlockese",
    "moru",
    "moselle",
    "mosimo",
    "mosiro",
    "moskona",
    "moskovskaya",
    "moskva",
    "moslavačka",
    "moson",
    "mossi",
    "most",
    "mosta",
    "mostaganem",
    "mosteiros",
    "mota",
    "motembo",
    "motlav",
    "motu",
    "mouhoun",
    "mouk",
    "moulay",
    "moulins",
    "moulvibazar",
    "mount",
    "mountain",
    "mourne",
    "mouwase",
    "movima",
    "moxico",
    "moyadan",
    "moyen",
    "moyo",
    "moyon",
    "mozambican",
    "mozambique",
    "mozarabic",
    "mozirje",
    "moûhîlî",
    "moḍī",
    "mpade",
    "mpalitjanh",
    "mpi",
    "mpiemo",
    "mpigi",
    "mpoto",
    "mpotovoro",
    "mpumalanga",
    "mpumpong",
    "mpuono",
    "mpur",
    "mqabba",
    "mro",
    "mru",
    "mser",
    "msida",
    "msila",
    "mtarfa",
    "mts’khet’a",
    "mtwara",
    "mt’ianet’i",
    "mualang",
    "muara",
    "mubami",
    "mubende",
    "mubi",
    "mubārak",
    "muda",
    "mudburra",
    "mudhili",
    "mudu",
    "mudug",
    "muduga",
    "mufian",
    "mugom",
    "muinane",
    "muji",
    "mukdahan",
    "mukha",
    "mukono",
    "mukulu",
    "mulaha",
    "mulam",
    "mulanje",
    "mulao",
    "mulativ",
    "mulgi",
    "mullu",
    "mullukmulluk",
    "multani",
    "multiple",
    "muluridyi",
    "mum",
    "muminh",
    "mumuye",
    "mun",
    "muna",
    "munda",
    "mundabli",
    "mundang",
    "mundani",
    "mundari",
    "mundat",
    "mundo",
    "mundurukú",
    "mungaka",
    "munggui",
    "mungkan",
    "mungkip",
    "muniche",
    "municipalidad",
    "munit",
    "munji",
    "munsee",
    "munshiganj",
    "munster",
    "munxar",
    "muong",
    "mur",
    "muramvya",
    "murang",
    "muratayak",
    "murcia",
    "mureș",
    "muria",
    "murik",
    "murkim",
    "murle",
    "murmanskaya",
    "murrinh",
    "mursi",
    "murska",
    "murui",
    "murupi",
    "murut",
    "muruwari",
    "murzuq",
    "musak",
    "musandam",
    "musar",
    "musasa",
    "musey",
    "musgu",
    "mushere",
    "mushungulu",
    "musi",
    "muskum",
    "muslim",
    "musom",
    "mussau",
    "muta",
    "muthambi",
    "muthanna",
    "muthuvan",
    "mutu",
    "muya",
    "muyang",
    "muyu",
    "muyuw",
    "muzi",
    "muğla",
    "muş",
    "muḩarraq",
    "mvanip",
    "mvuba",
    "mwaghavul",
    "mwali",
    "mwan",
    "mwani",
    "mwanza",
    "mwaro",
    "mwatebu",
    "mwenga",
    "mwera",
    "mwimbi",
    "myanmar",
    "mycenaean",
    "myene",
    "mykolaïvs",
    "mymensingh",
    "mysian",
    "mzieme",
    "mzimba",
    "mághdì",
    "máku",
    "málaga",
    "médiouna",
    "médéa",
    "ménik",
    "mérida",
    "méxico",
    "mískito",
    "místek",
    "mócheno",
    "môn",
    "møre",
    "mün",
    "mündü",
    "mādabā",
    "māhārāṣṭri",
    "mālpils",
    "māndūl",
    "mārupes",
    "mātale",
    "mātara",
    "māyū",
    "māzandarān",
    "mērsraga",
    "mělník",
    "město",
    "mġarr",
    "mŏṇarāgala",
    "mūhīlī",
    "m’diq",
    "naaba",
    "naama",
    "naami",
    "naasioi",
    "naba",
    "nabak",
    "nabataean",
    "nabatîyé",
    "nabeul",
    "nabi",
    "nablus",
    "nachering",
    "nacional",
    "nad",
    "nador",
    "nadruvian",
    "nadu",
    "nadur",
    "nadëb",
    "nafaanra",
    "nafarroa",
    "nafarroako",
    "nafi",
    "nafri",
    "naftalan",
    "nafusi",
    "naga",
    "nagaland",
    "nagano",
    "nagar",
    "nagarchal",
    "nagari",
    "nagasaki",
    "nage",
    "nago",
    "nagoričane",
    "nagpuri",
    "nagri",
    "nagumi",
    "nagykanizsa",
    "nagykun",
    "nahali",
    "nahari",
    "nahuatl",
    "nai",
    "naira",
    "nairobi",
    "naitasiri",
    "najdi",
    "najef",
    "najin",
    "najrān",
    "naka",
    "nakai",
    "nakame",
    "nakanai",
    "nakapiripirit",
    "nakara",
    "nakaseke",
    "nakasongola",
    "nake",
    "nakfa",
    "nakhi",
    "nakhon",
    "naki",
    "naklo",
    "nakuru",
    "nakwi",
    "nalca",
    "nali",
    "nalik",
    "nalu",
    "naluo",
    "nalögo",
    "nam",
    "nama",
    "namakura",
    "namangan",
    "namat",
    "nambas",
    "nambikuára",
    "nambo",
    "nambya",
    "namdo",
    "namdrik",
    "namentenga",
    "namia",
    "namiae",
    "namibe",
    "namibia",
    "namibian",
    "namla",
    "namo",
    "namonuito",
    "namosi",
    "namtha",
    "namu",
    "namur",
    "namutumba",
    "namuyi",
    "nan",
    "nana",
    "nanai",
    "nancere",
    "nande",
    "nandi",
    "nanerigé",
    "nanga",
    "nangarhār",
    "nankina",
    "nanti",
    "nanticoke",
    "nantou",
    "nanubae",
    "nanumanga",
    "nanumea",
    "nao",
    "naogaon",
    "naouri",
    "napo",
    "napoli",
    "napu",
    "nar",
    "nara",
    "narail",
    "narak",
    "narango",
    "narathiwat",
    "narau",
    "narayanganj",
    "narayani",
    "nari",
    "narim",
    "nariño",
    "naro",
    "narok",
    "narom",
    "narragansett",
    "narrinyeri",
    "narsingdi",
    "narua",
    "narungga",
    "naryn",
    "nasal",
    "nasarian",
    "naskapi",
    "nassarawa",
    "nastaliq",
    "nasu",
    "nasŏn",
    "nat",
    "nata",
    "natal",
    "natanzi",
    "nataoran",
    "natchez",
    "nateni",
    "nathembo",
    "national",
    "natioro",
    "natore",
    "natügu",
    "nauete",
    "naukan",
    "naukšēnu",
    "nauna",
    "nauo",
    "nauru",
    "navaho",
    "navajo",
    "navarra",
    "navassa",
    "navoiy",
    "navut",
    "nawabganj",
    "nawaru",
    "nawathinehena",
    "nawdm",
    "nawuri",
    "nawé",
    "naxi",
    "naxxar",
    "naxçıvan",
    "nayala",
    "nayar",
    "nayarit",
    "nayi",
    "nayini",
    "nayok",
    "nazarje",
    "ncane",
    "nchumbulu",
    "nda",
    "ndai",
    "ndaka",
    "ndaktup",
    "ndali",
    "ndam",
    "ndamba",
    "ndambomo",
    "ndasa",
    "ndau",
    "nde",
    "ndebele",
    "ndemli",
    "ndendeule",
    "ndengereko",
    "nding",
    "ndo",
    "ndobo",
    "ndoe",
    "ndogo",
    "ndolo",
    "ndom",
    "ndombe",
    "ndonde",
    "ndonga",
    "ndoni",
    "ndoola",
    "ndra",
    "nduga",
    "ndumu",
    "ndunda",
    "ndunga",
    "ndut",
    "ndyuka",
    "ndzwani",
    "ndélé",
    "neamț",
    "neapolitan",
    "neath",
    "nebbi",
    "nebraska",
    "necaxa",
    "nedd",
    "nedebang",
    "nefamese",
    "neftçala",
    "negerhollands",
    "negeri",
    "negidal",
    "negotino",
    "negra",
    "negro",
    "negros",
    "nehan",
    "nei",
    "nek",
    "nekgini",
    "neko",
    "neku",
    "nelson",
    "nema",
    "neme",
    "nemi",
    "nen",
    "nend",
    "nenets",
    "nenetskiy",
    "nengone",
    "neno",
    "neo",
    "nepal",
    "nepalese",
    "nepali",
    "nepāla",
    "neretas",
    "neretvanska",
    "neretvanski",
    "nete",
    "netherlands",
    "netrakona",
    "neuchâtel",
    "neuquen",
    "nevada",
    "nevis",
    "nevşehir",
    "newa",
    "newar",
    "newari",
    "newcastle",
    "newfoundland",
    "newham",
    "newport",
    "newry",
    "newtownabbey",
    "neyo",
    "nez",
    "ngaanyatjarra",
    "ngad",
    "ngadjunmaya",
    "ngadjuri",
    "ngaing",
    "ngaju",
    "ngala",
    "ngalakan",
    "ngalum",
    "ngam",
    "ngamambo",
    "ngambay",
    "ngamini",
    "ngamo",
    "ngan",
    "nganakarti",
    "nganasan",
    "ngandi",
    "ngando",
    "ngandyera",
    "ngangam",
    "ngantangarra",
    "nganyaywana",
    "ngaraard",
    "ngarchelong",
    "ngardi",
    "ngardmau",
    "ngarigu",
    "ngarinman",
    "ngarinyin",
    "ngarla",
    "ngarluma",
    "ngas",
    "ngasa",
    "ngathana",
    "ngatik",
    "ngatpang",
    "ngawn",
    "ngawun",
    "ngayawung",
    "ngazidja",
    "ngbaka",
    "ngbandi",
    "ngbee",
    "ngbinda",
    "ngbundu",
    "ngchesar",
    "ngelima",
    "ngemba",
    "ngeq",
    "ngeremlengui",
    "ngete",
    "nggem",
    "nggwahyi",
    "nghệ",
    "ngie",
    "ngiemboon",
    "ngile",
    "ngindo",
    "ngith",
    "ngiti",
    "ngiwal",
    "ngiyambaa",
    "ngizim",
    "ngkâlmpw",
    "ngom",
    "ngomba",
    "ngombale",
    "ngombe",
    "ngonde",
    "ngongo",
    "ngoni",
    "ngoshie",
    "ngounié",
    "ngozi",
    "ngul",
    "ngultrum",
    "ngulu",
    "nguluwan",
    "ngumbi",
    "ngunawal",
    "ngundi",
    "ngundu",
    "ngungwel",
    "ngurimi",
    "ngurmbur",
    "nguyên",
    "nguôn",
    "ngwaba",
    "ngwe",
    "ngwo",
    "ngãi",
    "ngäbere",
    "ngöbe",
    "nhanda",
    "nhangu",
    "nhaŋu",
    "nhengatu",
    "nhirrpi",
    "nhuwala",
    "niamey",
    "niari",
    "nias",
    "niassa",
    "nibok",
    "nicaragua",
    "nicaraguan",
    "nichola",
    "nickerie",
    "nicobar",
    "nicobarese",
    "nicolau",
    "nidwalden",
    "niedersachsen",
    "niederösterreich",
    "niellim",
    "niger",
    "nigeria",
    "nigerian",
    "nihali",
    "nii",
    "niigata",
    "nikole",
    "niksek",
    "nikšić",
    "nila",
    "nilamba",
    "nile",
    "nilo",
    "nilphamari",
    "nimadi",
    "nimanbur",
    "nimba",
    "nimbari",
    "nimboran",
    "nimi",
    "nimo",
    "nimoa",
    "ninam",
    "ninawa",
    "nindem",
    "nindi",
    "ningera",
    "ninggerum",
    "ningi",
    "ningil",
    "ningxia",
    "ningye",
    "ninh",
    "ninia",
    "ninzo",
    "nipsan",
    "niragu",
    "nisa",
    "nisenan",
    "nisga",
    "nisi",
    "nisia",
    "nisou",
    "nisporeni",
    "nistrului",
    "nisu",
    "nithi",
    "nitriansky",
    "niuafo",
    "niuas",
    "niuatoputapu",
    "niue",
    "niuean",
    "niutao",
    "nivaclé",
    "niwer",
    "nixumwak",
    "nizhegorodskaya",
    "nièvre",
    "niğde",
    "nišavski",
    "njalgulgule",
    "njebi",
    "njen",
    "njerep",
    "njua",
    "njyem",
    "nkami",
    "nkangala",
    "nkari",
    "nkem",
    "nkhata",
    "nkhotakota",
    "nkhumbi",
    "nkongho",
    "nkonya",
    "nkoroo",
    "nkoya",
    "nkukoli",
    "nkum",
    "nkutu",
    "nkwen",
    "nnam",
    "noakhali",
    "nobiin",
    "nobonob",
    "nocamán",
    "nochixtlán",
    "nocte",
    "nocten",
    "nogai",
    "noi",
    "noiri",
    "nokuku",
    "nomaande",
    "nomane",
    "nomatsiguenga",
    "nomlaki",
    "nomu",
    "non",
    "nong",
    "nonthaburi",
    "nonuya",
    "nooksack",
    "noon",
    "noone",
    "noonu",
    "noord",
    "nopala",
    "nord",
    "nordjylland",
    "nordland",
    "nordrhein",
    "norfolk",
    "noric",
    "norman",
    "normandie",
    "norn",
    "noronha",
    "norra",
    "norrbottens",
    "norse",
    "norte",
    "northamptonshire",
    "northland",
    "northumberland",
    "norway",
    "norwegian",
    "norðurland",
    "noshan",
    "not",
    "notation",
    "notio",
    "notre",
    "notsi",
    "nottingham",
    "nottinghamshire",
    "nottoway",
    "notu",
    "nouaceur",
    "nouadhibou",
    "nouakchott",
    "nouel",
    "noumbiel",
    "noun",
    "nouvelle",
    "nova",
    "novaci",
    "novads",
    "novara",
    "novgorodskaya",
    "novi",
    "novial",
    "novo",
    "novosibirskaya",
    "nový",
    "noy",
    "nsanje",
    "nsei",
    "nsele",
    "nsenga",
    "nshi",
    "nsi",
    "nsongo",
    "nta",
    "ntcham",
    "ntcheu",
    "ntchisi",
    "ntem",
    "ntomba",
    "ntungamo",
    "nuaulu",
    "nubaca",
    "nubi",
    "nubian",
    "nubri",
    "nuer",
    "nueva",
    "nuevo",
    "nugaal",
    "nugunu",
    "nui",
    "nuk",
    "nukak",
    "nukna",
    "nukufetau",
    "nukuini",
    "nukulaelae",
    "nukumanu",
    "nukunul",
    "nukuoro",
    "nukuria",
    "nulth",
    "numana",
    "numanggang",
    "numbami",
    "numbu",
    "nume",
    "numidian",
    "numpula",
    "numèè",
    "nunavut",
    "nung",
    "nungali",
    "nunggubuyu",
    "nungu",
    "nuni",
    "nuniali",
    "nunku",
    "nuoro",
    "nuosu",
    "nupbikha",
    "nupe",
    "nuqaţ",
    "nusa",
    "nuskhuri",
    "nusu",
    "nuu",
    "nuvara",
    "nyabwa",
    "nyaheun",
    "nyahkur",
    "nyakyusa",
    "nyala",
    "nyali",
    "nyam",
    "nyamal",
    "nyambo",
    "nyamira",
    "nyamusa",
    "nyamwanga",
    "nyamwezi",
    "nyandarua",
    "nyaneka",
    "nyang",
    "nyanga",
    "nyangatom",
    "nyangbo",
    "nyangga",
    "nyangumarta",
    "nyanja",
    "nyankole",
    "nyankpa",
    "nyarafolo",
    "nyasa",
    "nyaturu",
    "nyaw",
    "nyawaygi",
    "nye",
    "nyemba",
    "nyengo",
    "nyenkha",
    "nyeri",
    "nyeu",
    "nyigina",
    "nyiha",
    "nyika",
    "nyindrou",
    "nyindu",
    "nyishi",
    "nyiyaparli",
    "nymburk",
    "nynorsk",
    "nyo",
    "nyokon",
    "nyole",
    "nyong",
    "nyore",
    "nyoro",
    "nyts",
    "nyulnyul",
    "nyunga",
    "nyungwe",
    "nyâlayu",
    "nyíregyháza",
    "nzakambay",
    "nzakara",
    "nzanyi",
    "nzas",
    "nzi",
    "nzikou",
    "nzima",
    "nzoia",
    "nzérékoré",
    "náchod",
    "náà",
    "næ̆gĕnahira",
    "nêlêmwa",
    "nógrád",
    "nông",
    "nüa",
    "nüpode",
    "nüshu",
    "nālūt",
    "năsăud",
    "nīcas",
    "nīl",
    "nīmrōz",
    "nūristān",
    "nẵng",
    "nội",
    "n’ko",
    "oaxaca",
    "obanliku",
    "oberösterreich",
    "obispeño",
    "oblast",
    "obleševo",
    "oblo",
    "oblysy",
    "obo",
    "obock",
    "obokuitai",
    "obolo",
    "obulom",
    "obwalden",
    "ocaina",
    "ocampo",
    "occidental",
    "occitan",
    "occitanie",
    "ocean",
    "och",
    "ocnița",
    "ocotepec",
    "ocotepeque",
    "ocotlán",
    "odes",
    "odham",
    "odia",
    "odiai",
    "odisha",
    "odoodee",
    "odranci",
    "odual",
    "odut",
    "oecussi",
    "oenale",
    "ofayé",
    "offaly",
    "official",
    "ofo",
    "ogbah",
    "ogbia",
    "ogbogolo",
    "ogbronuagum",
    "ogea",
    "ogham",
    "ogliastra",
    "ogooué",
    "ogres",
    "ogun",
    "ogwr",
    "ohangwena",
    "ohio",
    "ohlone",
    "ohrid",
    "oih",
    "oio",
    "oirat",
    "oirata",
    "oise",
    "oita",
    "ojibwa",
    "ojibwe",
    "ojitlán",
    "okanagan",
    "okavango",
    "okayama",
    "oki",
    "okiek",
    "okinawa",
    "okinawan",
    "oklahoma",
    "oko",
    "okobo",
    "okodia",
    "okolod",
    "okpamheri",
    "okpe",
    "okpela",
    "okrug",
    "oksapmin",
    "oku",
    "olaines",
    "olancho",
    "olbia",
    "old",
    "oldham",
    "olekha",
    "olkol",
    "ollar",
    "olmec",
    "olo",
    "oloma",
    "olomouc",
    "olomoucký",
    "olrat",
    "olt",
    "olu",
    "olulumo",
    "oluta",
    "omagh",
    "omagua",
    "omaha",
    "omaheke",
    "oman",
    "omani",
    "ombamba",
    "ombella",
    "ombo",
    "ombre",
    "ometepec",
    "omi",
    "omok",
    "omotic",
    "omotik",
    "omskaya",
    "omurano",
    "omusati",
    "ona",
    "ondo",
    "one",
    "oneida",
    "ong",
    "ongtüstik",
    "onin",
    "onjob",
    "ono",
    "onobasulu",
    "onondaga",
    "ontario",
    "ontenu",
    "ontong",
    "oorlams",
    "oost",
    "opao",
    "opata",
    "opava",
    "oplotnica",
    "opolskie",
    "oppland",
    "opuuo",
    "ora",
    "oran",
    "orang",
    "orange",
    "oraon",
    "ordino",
    "ordu",
    "ordubad",
    "oregon",
    "oreille",
    "orejón",
    "orellana",
    "orenburgskaya",
    "orhei",
    "orhon",
    "oriental",
    "orientale",
    "orientales",
    "oring",
    "oristano",
    "oriya",
    "orizaba",
    "orizari",
    "orkhon",
    "orkney",
    "orlicí",
    "orlovskaya",
    "orma",
    "ormož",
    "ormu",
    "ormuri",
    "orne",
    "oro",
    "oroch",
    "oroha",
    "orok",
    "orokaiva",
    "oroko",
    "orokolo",
    "oromo",
    "oromīya",
    "oroqen",
    "oros",
    "orowe",
    "oruma",
    "oruro",
    "orya",
    "osage",
    "osaka",
    "osatu",
    "osayen",
    "oscan",
    "osetiya",
    "osh",
    "oshana",
    "oshikoto",
    "oshima",
    "osilnica",
    "osing",
    "osječko",
    "oslo",
    "oslomej",
    "osmaniye",
    "osmanya",
    "ososo",
    "ossetian",
    "ossetic",
    "ossola",
    "ostrava",
    "osun",
    "otago",
    "otank",
    "otdar",
    "other",
    "oti",
    "otjozondjupa",
    "otlaltepec",
    "oto",
    "otomi",
    "otomian",
    "otoro",
    "ottawa",
    "ottoman",
    "otuho",
    "otuke",
    "ouaka",
    "ouargla",
    "ouarzazate",
    "oubi",
    "oubritenga",
    "oudalan",
    "oudômxai",
    "oued",
    "ouest",
    "ouezzane",
    "ouguiya",
    "ouham",
    "oujda",
    "oum",
    "ouma",
    "oune",
    "ourense",
    "outlying",
    "ouzou",
    "ouémé",
    "overijssel",
    "owa",
    "owenia",
    "owiniga",
    "oxfordshire",
    "oya",
    "oyam",
    "oyda",
    "oyo",
    "ozolnieku",
    "ozolotepec",
    "ozumacín",
    "oğuz",
    "paakantyi",
    "paama",
    "paasaal",
    "pabir",
    "pabna",
    "pacahuara",
    "pacaraos",
    "pacific",
    "pacoh",
    "padang",
    "pader",
    "padoe",
    "padova",
    "paekche",
    "paelignian",
    "pagi",
    "pagibete",
    "pagu",
    "pahanan",
    "pahang",
    "pahari",
    "paharia",
    "pahawh",
    "pahi",
    "pahlavani",
    "pahlavi",
    "pai",
    "paicî",
    "pailin",
    "paipai",
    "paite",
    "paiute",
    "paiwan",
    "pajapan",
    "pajonal",
    "pak",
    "pakanha",
    "pakaásnovos",
    "pakhtunkhwa",
    "paki",
    "pakistan",
    "paktiyā",
    "paktīkā",
    "paku",
    "pal",
    "palaic",
    "palaka",
    "palanka",
    "palantla",
    "palau",
    "palauan",
    "palauli",
    "palaung",
    "palawan",
    "palawano",
    "palencia",
    "paleni",
    "palenquero",
    "palermo",
    "palestine",
    "palestinian",
    "pali",
    "palikúr",
    "paliyan",
    "palladium",
    "pallanganmiddang",
    "pallisa",
    "palmas",
    "palmetto",
    "palmyra",
    "palmyrene",
    "palor",
    "palpa",
    "palu",
    "paluan",
    "palya",
    "pam",
    "pambia",
    "pame",
    "pamlico",
    "pamona",
    "pamosu",
    "pampa",
    "pampanga",
    "pamplemousses",
    "pamplona",
    "pana",
    "panaeati",
    "panama",
    "panamanian",
    "panamint",
    "panamá",
    "panao",
    "panará",
    "panasuan",
    "panawa",
    "pancana",
    "panchagarh",
    "panchpargania",
    "pande",
    "pando",
    "panevėžio",
    "pangasinan",
    "pangseng",
    "pangutaran",
    "pangwa",
    "pangwali",
    "panim",
    "paniya",
    "panjabi",
    "panjshayr",
    "pankararé",
    "pankararú",
    "pankhu",
    "pannei",
    "pano",
    "panoan",
    "panobo",
    "panyi",
    "panytyima",
    "pao",
    "paola",
    "papantla",
    "papapana",
    "papar",
    "papasena",
    "papel",
    "papi",
    "papiamento",
    "papitalai",
    "papora",
    "papua",
    "papuan",
    "papuma",
    "para",
    "parachi",
    "paraguarí",
    "paraguay",
    "paraguayan",
    "parakanã",
    "paramaribo",
    "paranan",
    "paranawát",
    "paraná",
    "paraujano",
    "parauk",
    "parawen",
    "paraíba",
    "paraíso",
    "parbate",
    "pardhan",
    "pardhi",
    "pardubice",
    "pardubický",
    "pare",
    "parecís",
    "parenga",
    "parinacota",
    "paris",
    "parja",
    "parkari",
    "parkwa",
    "parma",
    "paro",
    "parsi",
    "part",
    "parthian",
    "partial",
    "parwān",
    "parya",
    "pará",
    "pas",
    "pasco",
    "pashai",
    "pashchimanchal",
    "pashto",
    "pasi",
    "pass",
    "passamaquoddy",
    "passoré",
    "pastaza",
    "pataca",
    "patamona",
    "patani",
    "pataxó",
    "patep",
    "patha",
    "pathiya",
    "pathom",
    "pathum",
    "patois",
    "patpatar",
    "patrick",
    "pattani",
    "pattapu",
    "patuakhali",
    "patwin",
    "pau",
    "paul",
    "paulo",
    "paulohi",
    "paumarí",
    "paunaka",
    "pauri",
    "pauserna",
    "pavia",
    "pavlodar",
    "pawaia",
    "pawl",
    "pawnee",
    "paynamar",
    "pays",
    "paysandú",
    "paz",
    "pazardzhik",
    "pazeh",
    "país",
    "paḷāta",
    "pa’anga",
    "pear",
    "pearling",
    "pech",
    "pecheneg",
    "pedernales",
    "pedi",
    "pedro",
    "peere",
    "pehčevo",
    "pei",
    "pekal",
    "pela",
    "pele",
    "peleliu",
    "pelende",
    "pelhřimov",
    "pella",
    "peloponnisos",
    "pemagatshel",
    "pemba",
    "pembroke",
    "pembrokeshire",
    "pemon",
    "pen",
    "penal",
    "penan",
    "penang",
    "penchal",
    "pend",
    "pendau",
    "pendé",
    "peng",
    "penghu",
    "pengo",
    "penh",
    "peninsula",
    "pennsylvania",
    "penrhyn",
    "pentlatch",
    "penzenskaya",
    "people",
    "pepesa",
    "peqin",
    "pequot",
    "perai",
    "perak",
    "peranakan",
    "peravia",
    "perce",
    "perené",
    "peripheral",
    "perlis",
    "permic",
    "permskiy",
    "permyak",
    "pernambuco",
    "pernik",
    "pero",
    "persekutuan",
    "persian",
    "perth",
    "peru",
    "perugia",
    "peruvian",
    "pesaro",
    "pescara",
    "pesnica",
    "peso",
    "pest",
    "petapa",
    "petats",
    "peter",
    "peterborough",
    "peterburg",
    "petjo",
    "petrov",
    "petrovci",
    "petrovec",
    "petén",
    "peñasco",
    "peñoles",
    "pećki",
    "peč",
    "pfaelzisch",
    "pfalz",
    "phaa",
    "phags",
    "phai",
    "phake",
    "phala",
    "phalombe",
    "phalura",
    "phana",
    "phangduwali",
    "phangnga",
    "phanom",
    "phatthalung",
    "phatthaya",
    "phayao",
    "phende",
    "phet",
    "phetchabun",
    "phetchaburi",
    "phichit",
    "philip",
    "philippine",
    "philippines",
    "phimbi",
    "phitsanulok",
    "phnom",
    "phodrang",
    "phoenician",
    "phoenix",
    "phola",
    "pholo",
    "phom",
    "phong",
    "phowa",
    "phra",
    "phrae",
    "phrygian",
    "phu",
    "phuan",
    "phudagi",
    "phuie",
    "phuket",
    "phukha",
    "phuma",
    "phunoi",
    "phuong",
    "phupa",
    "phupha",
    "phuri",
    "phuza",
    "phòng",
    "phôngsali",
    "phú",
    "phúc",
    "phước",
    "piacenza",
    "piamatsina",
    "piame",
    "piapoco",
    "piarco",
    "piaroa",
    "piauí",
    "picard",
    "picene",
    "piceno",
    "pichincha",
    "pichis",
    "pictish",
    "pidgin",
    "pidgins",
    "piedras",
    "piemonte",
    "piemontese",
    "pieria",
    "pierre",
    "pietà",
    "pijao",
    "pije",
    "pijin",
    "pilagá",
    "pileni",
    "pilipino",
    "pima",
    "pimbwe",
    "pinai",
    "pinang",
    "pinar",
    "pingelapese",
    "pingtung",
    "pini",
    "pinigura",
    "pinjarup",
    "pinji",
    "pinotepa",
    "pins",
    "pintiini",
    "pintupi",
    "pinyin",
    "pipil",
    "piqad",
    "pirahã",
    "piran",
    "pirano",
    "piratapuyo",
    "pirate",
    "pirkanmaa",
    "pirlatapa",
    "piro",
    "pirojpur",
    "pirotski",
    "pirriya",
    "pisa",
    "pisabo",
    "pisaflores",
    "piscataway",
    "pisidian",
    "pisin",
    "pistoia",
    "pita",
    "pitcairn",
    "pite",
    "piti",
    "pitjantjatjara",
    "pitta",
    "piu",
    "piura",
    "pivka",
    "piya",
    "piña",
    "plaines",
    "plains",
    "plaisance",
    "planken",
    "plapo",
    "plasnica",
    "plata",
    "plateau",
    "plateaux",
    "platinum",
    "plautdietsch",
    "plav",
    "playero",
    "plenty",
    "pleven",
    "pljevlja",
    "plovdiv",
    "plurinational",
    "plužine",
    "plymouth",
    "plzeň",
    "plzeňský",
    "pnar",
    "pochuri",
    "pochutec",
    "podena",
    "podgorica",
    "podkarpackie",
    "podlaskie",
    "podlehnik",
    "podravska",
    "podrinjski",
    "podunavski",
    "podvelka",
    "podčetrtek",
    "pogolo",
    "pogradec",
    "pohjanmaa",
    "pohjois",
    "pohnpei",
    "pohnpeian",
    "pohorju",
    "point",
    "pointe",
    "pokangá",
    "poke",
    "poko",
    "pokomo",
    "pokot",
    "pokur",
    "polabian",
    "polana",
    "poland",
    "polari",
    "polci",
    "polhov",
    "polish",
    "poljane",
    "polje",
    "polju",
    "poljčane",
    "pollard",
    "polonombauk",
    "poltavs",
    "polynesia",
    "polynesian",
    "polynésie",
    "polzela",
    "pom",
    "pomeroon",
    "pomo",
    "pomoravski",
    "pomorskie",
    "ponam",
    "ponca",
    "pongu",
    "poni",
    "ponosakan",
    "pontevedra",
    "pontic",
    "ponyo",
    "pool",
    "poole",
    "popoloca",
    "popoluca",
    "popti",
    "poqomam",
    "poqomchi",
    "pordenone",
    "porohanon",
    "port",
    "portalegre",
    "portland",
    "porto",
    "portsmouth",
    "portugal",
    "portuguesa",
    "portuguese",
    "posavska",
    "posavski",
    "post",
    "postojna",
    "potaro",
    "potawatomi",
    "potenza",
    "potiguára",
    "potok",
    "potosí",
    "pottangi",
    "potwari",
    "poumei",
    "pound",
    "pousaat",
    "pouye",
    "powari",
    "powhatan",
    "powys",
    "poyanáwa",
    "požeško",
    "prachatice",
    "prachin",
    "prachuap",
    "pradesh",
    "praha",
    "prahova",
    "praia",
    "prakan",
    "prakrit",
    "praslin",
    "prasuni",
    "prato",
    "preah",
    "prebold",
    "preddvor",
    "preiļu",
    "presidente",
    "prevalje",
    "preveza",
    "prey",
    "prešovský",
    "pri",
    "priekules",
    "priekuļu",
    "prilep",
    "primitive",
    "primorskiy",
    "primorsko",
    "prince",
    "princes",
    "principado",
    "principe",
    "principense",
    "private",
    "prizrenski",
    "probištip",
    "progreso",
    "prostějov",
    "provence",
    "provençal",
    "providencia",
    "province",
    "prussian",
    "príncipe",
    "prākrit",
    "psalter",
    "pseudolocale",
    "psikye",
    "pskovskaya",
    "ptuj",
    "puare",
    "pucikwar",
    "puconci",
    "pudtol",
    "puducherry",
    "puebla",
    "puelche",
    "puerto",
    "puget",
    "puglia",
    "puimei",
    "puinave",
    "pukapuka",
    "pukë",
    "pul",
    "pula",
    "pulaar",
    "pulabu",
    "pular",
    "pulau",
    "puluwatese",
    "puma",
    "pumi",
    "pumpokol",
    "pumé",
    "punakha",
    "punan",
    "punic",
    "punjab",
    "punjabi",
    "puno",
    "puntarenas",
    "punthamara",
    "punu",
    "puoc",
    "puquina",
    "puragi",
    "purari",
    "purepecha",
    "puri",
    "purik",
    "purisimeño",
    "puroik",
    "purposes",
    "puruborá",
    "purum",
    "purwanchal",
    "pushto",
    "putai",
    "putoh",
    "putrajaya",
    "puttalama",
    "putukwam",
    "putumayo",
    "puy",
    "puyo",
    "puyuma",
    "pwaamei",
    "pwani",
    "pwapwâ",
    "pwo",
    "pyapun",
    "pye",
    "pyen",
    "pyrénées",
    "pyu",
    "páez",
    "páfos",
    "pááfang",
    "päijät",
    "päri",
    "pärnumaa",
    "pécs",
    "pémono",
    "pénama",
    "pévé",
    "përmet",
    "písek",
    "põlvamaa",
    "pökoot",
    "pārgaujas",
    "pāvilostas",
    "pčinjski",
    "pļaviņu",
    "pŏḷŏnnaruva",
    "přerov",
    "příbram",
    "p’yŏngan",
    "p’yŏngyang",
    "qaasuitsup",
    "qabiao",
    "qacha",
    "qadisiyah",
    "qala",
    "qalqilya",
    "qalyūbīyah",
    "qaqet",
    "qar",
    "qaraghandy",
    "qashqa",
    "qashqadaryo",
    "qatabanian",
    "qatar",
    "qatari",
    "qau",
    "qawasqar",
    "qax",
    "qaywayn",
    "qazaqstan",
    "qazax",
    "qazvīn",
    "qaşīm",
    "qaḑārif",
    "qeqqata",
    "qiandong",
    "qiang",
    "qila",
    "qimant",
    "qinghai",
    "qinā",
    "qiubei",
    "qobustan",
    "qom",
    "qoraqalpog",
    "qormi",
    "qostanay",
    "qrendi",
    "quang",
    "quapaw",
    "quatre",
    "quba",
    "qubadlı",
    "quds",
    "quebec",
    "quechan",
    "quechua",
    "quechuan",
    "queensland",
    "quenya",
    "querétaro",
    "quetzal",
    "quetzaltenango",
    "quetzaltepec",
    "queyu",
    "quezon",
    "quiatoni",
    "quiavicuzas",
    "quichua",
    "quiché",
    "quiegolani",
    "quierí",
    "quileute",
    "quinara",
    "quinault",
    "quindío",
    "quinqui",
    "quintana",
    "quioquitani",
    "quiotepec",
    "quirino",
    "quiripi",
    "qunaytirah",
    "qusar",
    "quthing",
    "quzaqstan",
    "quảng",
    "qyzylorda",
    "qāhirah",
    "qāsh",
    "qīrā",
    "qəbələ",
    "raa",
    "rabat",
    "rabha",
    "racha",
    "rada",
    "rade",
    "radenci",
    "radeče",
    "radgona",
    "radlje",
    "radoviš",
    "radovljica",
    "raetic",
    "rafah",
    "ragged",
    "ragusa",
    "rahambuu",
    "rai",
    "rajah",
    "rajasthan",
    "rajasthani",
    "rajbanshi",
    "rajbari",
    "raji",
    "rajong",
    "rajput",
    "rajshahi",
    "rakahanga",
    "rakai",
    "rakhine",
    "rakovník",
    "ralik",
    "ralte",
    "ram",
    "rama",
    "ramallah",
    "ramoaaina",
    "ramopa",
    "rampi",
    "ramírez",
    "rana",
    "rand",
    "rang",
    "rangamati",
    "rangkas",
    "ranglong",
    "rangpur",
    "rangpuri",
    "rankovce",
    "rano",
    "ranong",
    "rao",
    "rapa",
    "rapanui",
    "raplamaa",
    "rapoisi",
    "rapti",
    "rapting",
    "raqqah",
    "rara",
    "rarotongan",
    "rasawa",
    "rasinski",
    "ratagnon",
    "ratahan",
    "ratak",
    "ratchaburi",
    "ratchasima",
    "ratchathani",
    "rathawi",
    "rathwi",
    "ratnapura",
    "raunas",
    "raute",
    "ravenna",
    "ravne",
    "ravula",
    "rawa",
    "rawang",
    "rawat",
    "rawngtu",
    "rawo",
    "raya",
    "raymah",
    "rayong",
    "rayyan",
    "rayón",
    "razajerdi",
    "razavī",
    "razgrad",
    "razkrižje",
    "rače",
    "raški",
    "ra’s",
    "reab",
    "reading",
    "real",
    "red",
    "redbridge",
    "redcar",
    "redjang",
    "redonda",
    "reef",
    "reel",
    "reggio",
    "regi",
    "região",
    "región",
    "rehamna",
    "rejang",
    "reli",
    "relizane",
    "rema",
    "rembarunga",
    "rembong",
    "remo",
    "remontado",
    "rempart",
    "rempi",
    "remun",
    "rendille",
    "renfrewshire",
    "rengao",
    "rengma",
    "renminbi",
    "rennell",
    "rennellese",
    "renče",
    "repanbitip",
    "republic",
    "republics",
    "republika",
    "rer",
    "rerau",
    "rerep",
    "resen",
    "reserved",
    "reshe",
    "respublika",
    "respublikasi",
    "resígaro",
    "retalhuleu",
    "rethymno",
    "retta",
    "retuarã",
    "reyesano",
    "reykjavík",
    "rezina",
    "rečica",
    "rheinland",
    "rhin",
    "rhode",
    "rhodesia",
    "rhondda",
    "rhône",
    "rial",
    "riang",
    "riantana",
    "riau",
    "rib",
    "ribeira",
    "ribnica",
    "ribun",
    "rica",
    "rican",
    "richmond",
    "rico",
    "riding",
    "riebiņu",
    "riel",
    "rien",
    "rieng",
    "rieti",
    "rif",
    "right",
    "rikbaktsa",
    "rimini",
    "rincon",
    "rinconada",
    "rincón",
    "ringgit",
    "ringgou",
    "rio",
    "rioja",
    "rios",
    "ririo",
    "risaralda",
    "ritarungo",
    "riung",
    "rivas",
    "river",
    "rivera",
    "riverain",
    "rivercess",
    "rivers",
    "rivière",
    "rivnens",
    "riyal",
    "riyāḍ",
    "rizal",
    "rize",
    "roba",
    "rocha",
    "rochdale",
    "roche",
    "rodonia",
    "rodopi",
    "rodrigues",
    "rodríguez",
    "rogaland",
    "rogatec",
    "rogaška",
    "rogašovci",
    "roglai",
    "rogo",
    "rohingya",
    "roi",
    "rojas",
    "rokycany",
    "roma",
    "romagna",
    "romagnol",
    "romam",
    "roman",
    "romana",
    "romance",
    "romani",
    "romania",
    "romanian",
    "romano",
    "romanova",
    "romansh",
    "romany",
    "romblomanon",
    "romblon",
    "rombo",
    "romkun",
    "romsdal",
    "ron",
    "rondônia",
    "ronga",
    "rongelap",
    "rongga",
    "rongmei",
    "rongorongo",
    "rongpo",
    "ronji",
    "roo",
    "roon",
    "ropažu",
    "roraima",
    "roria",
    "rosa",
    "roscommon",
    "rose",
    "rosoman",
    "rostam",
    "rostovskaya",
    "rostuša",
    "rotanak",
    "rotherham",
    "rotokas",
    "rotuma",
    "rotuman",
    "rousse",
    "roviana",
    "rovigo",
    "royale",
    "rožaje",
    "ruble",
    "rucavas",
    "ruching",
    "rudbari",
    "rufiji",
    "rufiyaa",
    "ruga",
    "ruggell",
    "rugāju",
    "rukai",
    "rukul",
    "rukungiri",
    "rukwa",
    "rum",
    "ruma",
    "rumai",
    "rumphi",
    "rumu",
    "rundi",
    "rundāles",
    "runga",
    "rungtu",
    "rungus",
    "rungwa",
    "runic",
    "rupee",
    "rupiah",
    "rural",
    "ruse",
    "russia",
    "russian",
    "rusyn",
    "rutana",
    "rutland",
    "rutul",
    "ruuli",
    "ruund",
    "ruvuma",
    "ruyigi",
    "ruše",
    "rwa",
    "rwanda",
    "ryazanskaya",
    "rychnov",
    "région",
    "réunion",
    "río",
    "ríos",
    "rîșcani",
    "róng",
    "rāziḥī",
    "rēzekne",
    "rēzeknes",
    "rīga",
    "rūjienas",
    "rịa",
    "saafi",
    "saam",
    "saamia",
    "saare",
    "saaremaa",
    "saarland",
    "saaroa",
    "saatlı",
    "saba",
    "sabaean",
    "sabah",
    "sabanê",
    "sabaot",
    "sabaragamuva",
    "sabhā",
    "sabieh",
    "sabine",
    "sabirabad",
    "sabu",
    "sabüm",
    "sacapulteco",
    "sacatepéquez",
    "sachsen",
    "sadri",
    "sadung",
    "saek",
    "saep",
    "safaliba",
    "safeyoka",
    "safi",
    "safwa",
    "saga",
    "sagaing",
    "sagala",
    "sagalla",
    "sagarmatha",
    "sahara",
    "saharan",
    "sahel",
    "saho",
    "sahu",
    "saidi",
    "saint",
    "sainte",
    "saisiyat",
    "saitama",
    "sajalong",
    "sajau",
    "saka",
    "sakachep",
    "sakalava",
    "sakan",
    "sakao",
    "sakarya",
    "sakata",
    "sake",
    "sakha",
    "sakhalinskaya",
    "sakhon",
    "sakia",
    "sakirabiá",
    "sakon",
    "sal",
    "sala",
    "salaam",
    "salacgrīvas",
    "salah",
    "salal",
    "salamanca",
    "salampasu",
    "salar",
    "salas",
    "salasaca",
    "salaspils",
    "salavan",
    "salcedo",
    "salchuq",
    "saldus",
    "saleman",
    "salerno",
    "salfit",
    "salford",
    "salgótarján",
    "saliba",
    "salima",
    "salinan",
    "salish",
    "salishan",
    "sallands",
    "salt",
    "salta",
    "salto",
    "saluan",
    "salumá",
    "salvador",
    "salvadoran",
    "salyan",
    "salzburg",
    "salé",
    "salāmāt",
    "sam",
    "sama",
    "samane",
    "samangān",
    "samaná",
    "samar",
    "samaraskaya",
    "samaritan",
    "samarokena",
    "samarqand",
    "samatao",
    "samay",
    "samba",
    "sambal",
    "sambalpuri",
    "sambe",
    "samberigi",
    "sambuga",
    "samburu",
    "samdrup",
    "samegrelo",
    "samei",
    "sami",
    "samik",
    "samo",
    "samoa",
    "samoan",
    "samogitian",
    "samos",
    "samosa",
    "samoyedic",
    "sampang",
    "samre",
    "samsun",
    "samtao",
    "samtee",
    "samts’khe",
    "samut",
    "samux",
    "samvedi",
    "san",
    "sanaani",
    "sanapaná",
    "sancti",
    "sandaun",
    "sandawe",
    "sandevo",
    "sandwell",
    "sandwich",
    "sandy",
    "saneag",
    "sanga",
    "sanggau",
    "sangha",
    "sangil",
    "sangir",
    "sangisari",
    "sangkong",
    "sanglechi",
    "sango",
    "sangre",
    "sangtam",
    "sangu",
    "sanguié",
    "sani",
    "sanie",
    "saniyo",
    "sanjaq",
    "sankaran",
    "sankt",
    "sanma",
    "sanmatenga",
    "sannat",
    "sansi",
    "sanski",
    "sanskrit",
    "sant",
    "santa",
    "santali",
    "santander",
    "santarém",
    "santiago",
    "santo",
    "santos",
    "sanumá",
    "sao",
    "saparua",
    "sapo",
    "saponi",
    "saposa",
    "sapuan",
    "sapé",
    "sar",
    "sara",
    "saraburi",
    "saraiki",
    "saraj",
    "sarajevo",
    "sarakham",
    "saramacca",
    "saramaccan",
    "sarandë",
    "sarangani",
    "sarasira",
    "sarati",
    "saratovskaya",
    "saraveca",
    "sarawak",
    "sardegna",
    "sardinian",
    "sari",
    "sarikoli",
    "sarli",
    "sarpang",
    "sarsi",
    "sartang",
    "sarthe",
    "sarua",
    "sarudu",
    "saruga",
    "sasak",
    "sasaru",
    "saskatchewan",
    "sassandra",
    "sassarese",
    "sassari",
    "satakunta",
    "satawalese",
    "saterfriesisch",
    "sateré",
    "satkhira",
    "satu",
    "satun",
    "satupa",
    "saudi",
    "saulkrastu",
    "sauraseni",
    "saurashtra",
    "sauri",
    "sauria",
    "sause",
    "sausi",
    "savanes",
    "savannakhét",
    "savanne",
    "savannes",
    "savi",
    "savinji",
    "savo",
    "savoie",
    "savona",
    "savosavo",
    "sawai",
    "sawan",
    "saweru",
    "sawi",
    "sawila",
    "sawknah",
    "saxon",
    "saxwe",
    "saya",
    "sayula",
    "sayyid",
    "saïda",
    "saône",
    "schaan",
    "schaffhausen",
    "schellenberg",
    "schleswig",
    "schwyz",
    "scilly",
    "scotia",
    "scotland",
    "scots",
    "scottish",
    "script",
    "scythian",
    "sdr",
    "sea",
    "seba",
    "sebat",
    "seberuang",
    "sebop",
    "sebuyau",
    "sechelt",
    "secoya",
    "sedang",
    "sedoa",
    "seeku",
    "seenu",
    "sefrou",
    "sefton",
    "segai",
    "segeju",
    "seget",
    "segovia",
    "sehwi",
    "seibo",
    "seimat",
    "seine",
    "seit",
    "sekani",
    "sekapan",
    "sekar",
    "seke",
    "sekele",
    "seki",
    "seko",
    "sekpele",
    "sela",
    "selangor",
    "selaru",
    "selatan",
    "selayar",
    "selee",
    "selenge",
    "selepet",
    "seletar",
    "selian",
    "selkup",
    "selnica",
    "selo",
    "selungai",
    "seluwasan",
    "semai",
    "semandang",
    "semaq",
    "semara",
    "sembaan",
    "sembabule",
    "sembakung",
    "sembilan",
    "semelai",
    "semily",
    "semimi",
    "seminole",
    "semitic",
    "semič",
    "semnam",
    "semnani",
    "semnān",
    "sempan",
    "sena",
    "senara",
    "senaya",
    "sene",
    "seneca",
    "sened",
    "senegal",
    "sengele",
    "senggi",
    "sengo",
    "sengseng",
    "senhaja",
    "senjska",
    "senni",
    "senoufo",
    "sensi",
    "sentani",
    "senthang",
    "sentinel",
    "seoul",
    "sepa",
    "separate",
    "sepedi",
    "sepik",
    "sera",
    "serbia",
    "serbian",
    "serbo",
    "sere",
    "serer",
    "sergipe",
    "seri",
    "serili",
    "sermersooq",
    "seroa",
    "serrano",
    "serravalle",
    "serres",
    "seru",
    "serua",
    "serudung",
    "serui",
    "seselwa",
    "seta",
    "setaman",
    "seti",
    "settat",
    "settla",
    "setúbal",
    "sevastopol",
    "sever",
    "severin",
    "severn",
    "severnaya",
    "severnobanatski",
    "severnobački",
    "sevilla",
    "sevnica",
    "sewa",
    "seybo",
    "seychelles",
    "seze",
    "sežana",
    "sfax",
    "sha",
    "shaanxi",
    "shabak",
    "shabeellaha",
    "shabunda",
    "shabwah",
    "shahi",
    "shahmirzadi",
    "shahrudi",
    "shall",
    "shama",
    "shamal",
    "shamang",
    "shambala",
    "shamāl",
    "shamāliyah",
    "shamālīyah",
    "shan",
    "shandong",
    "shanenawa",
    "shanga",
    "shanghai",
    "shanxi",
    "shapra",
    "sharada",
    "sharanahua",
    "shariatpur",
    "shark",
    "sharq",
    "sharqī",
    "sharqīyah",
    "sharwa",
    "shasta",
    "shatt",
    "shau",
    "shavian",
    "shaviyani",
    "shaw",
    "shawnee",
    "shaykh",
    "she",
    "sheffield",
    "shehri",
    "shekhawati",
    "shekkacho",
    "sheko",
    "shelta",
    "shempire",
    "shemālī",
    "shendu",
    "sheng",
    "sheni",
    "sheqel",
    "sherbro",
    "sherdukpen",
    "sherpa",
    "sherpur",
    "sheshi",
    "shetland",
    "shi",
    "shida",
    "shiga",
    "shihhi",
    "shiki",
    "shilling",
    "shilluk",
    "shima",
    "shimane",
    "shimālī",
    "shina",
    "shinabo",
    "shinyanga",
    "shipibo",
    "shirima",
    "shiselweni",
    "shiwiar",
    "shixing",
    "shizuoka",
    "shkodër",
    "shoals",
    "sholaga",
    "shom",
    "shona",
    "shoo",
    "shor",
    "shorthand",
    "shoshoni",
    "shropshire",
    "shua",
    "shuadit",
    "shuar",
    "shubi",
    "shughni",
    "shumashti",
    "shumcho",
    "shumen",
    "shuswap",
    "shuwa",
    "shwai",
    "shwe",
    "shyghys",
    "shéfa",
    "shāriqah",
    "shārī",
    "shāţiʾ",
    "sialum",
    "siamou",
    "sian",
    "siane",
    "siang",
    "siar",
    "siawari",
    "siawi",
    "siaya",
    "sibe",
    "siberian",
    "sibiu",
    "sibu",
    "sibugay",
    "sicanian",
    "sicel",
    "sichuan",
    "sicilia",
    "sicilian",
    "siculo",
    "sidamo",
    "siddham",
    "siddhamātṛkā",
    "siddhaṃ",
    "sidetic",
    "sidi",
    "sie",
    "siem",
    "siena",
    "sierra",
    "sighu",
    "sign",
    "signes",
    "signwriting",
    "siguiri",
    "siguldas",
    "sihan",
    "sihanouk",
    "sihuas",
    "siirt",
    "sika",
    "sikaiana",
    "sikaritai",
    "sikasso",
    "sikiana",
    "sikkim",
    "sikkimese",
    "siksika",
    "sikule",
    "sila",
    "silacayoapan",
    "sileibi",
    "silesian",
    "siliana",
    "silimo",
    "siliput",
    "silistra",
    "silopi",
    "silt",
    "silver",
    "simaa",
    "simalungun",
    "simba",
    "simbali",
    "simbari",
    "simbiti",
    "simbo",
    "simeku",
    "simeulue",
    "simplified",
    "simte",
    "sinagen",
    "sinaloa",
    "sinasina",
    "sinaugoro",
    "sindarin",
    "sindh",
    "sindhi",
    "sindihui",
    "sing",
    "singa",
    "singapore",
    "singida",
    "singpho",
    "sinhala",
    "sinhalese",
    "sinicahua",
    "sininkere",
    "sinnār",
    "sino",
    "sinoe",
    "sinop",
    "sinsauru",
    "sint",
    "sinte",
    "sinyar",
    "sio",
    "siona",
    "siouan",
    "sipacapense",
    "sipaliwini",
    "siparia",
    "siparuni",
    "siquijor",
    "sir",
    "sira",
    "siracusa",
    "sirajganj",
    "sirak",
    "siraya",
    "sirdaryo",
    "sirenik",
    "siri",
    "siriano",
    "sirionó",
    "sirmauri",
    "siroi",
    "sironko",
    "sisaala",
    "sisačko",
    "sissala",
    "sissano",
    "sissili",
    "sitemu",
    "siuslaw",
    "sivandi",
    "sivas",
    "siwai",
    "siwi",
    "siwu",
    "siyin",
    "siyəzən",
    "siġġiewi",
    "sjælland",
    "skagit",
    "skalvian",
    "skaya",
    "skepi",
    "skhirate",
    "skij",
    "skikda",
    "skiy",
    "skolt",
    "skou",
    "skrapar",
    "skrundas",
    "skrīveru",
    "skåne",
    "slatina",
    "slave",
    "slavey",
    "slavic",
    "slavomolisano",
    "slavonic",
    "slavonska",
    "sliema",
    "sligo",
    "slimane",
    "sliven",
    "slivnica",
    "slough",
    "slovak",
    "slovakia",
    "slovakian",
    "slovenia",
    "slovenian",
    "slovenj",
    "slovenska",
    "slovenske",
    "slovenskih",
    "smiltenes",
    "smolenskaya",
    "smolyan",
    "smärky",
    "snohomish",
    "sobané",
    "sobei",
    "sobota",
    "soccsksargen",
    "sochiapam",
    "socialist",
    "sodražica",
    "sofala",
    "sofia",
    "soga",
    "sogdian",
    "sogn",
    "soi",
    "sok",
    "sokolov",
    "sokoro",
    "sokoto",
    "sol",
    "solano",
    "soli",
    "solihull",
    "sololá",
    "solomon",
    "solong",
    "solos",
    "solothurn",
    "soltüstik",
    "solčava",
    "som",
    "somali",
    "somalia",
    "somba",
    "somerset",
    "somme",
    "somogy",
    "somoni",
    "sompeng",
    "somrai",
    "somray",
    "somyev",
    "son",
    "sonaga",
    "sonde",
    "sondrio",
    "song",
    "songe",
    "songhai",
    "songhay",
    "songkhla",
    "songkhram",
    "songlai",
    "songo",
    "songomeno",
    "songoora",
    "songway",
    "sonha",
    "sonia",
    "soninke",
    "sonora",
    "sonsonate",
    "sonsorol",
    "soo",
    "sool",
    "sop",
    "sopište",
    "sopron",
    "soqotri",
    "sora",
    "sorbian",
    "sori",
    "soria",
    "soriano",
    "sorkhei",
    "soroca",
    "sorothaptic",
    "soroti",
    "sorsoganon",
    "sorsogon",
    "sos",
    "sota",
    "sotavento",
    "sotho",
    "sotli",
    "sou",
    "souk",
    "soum",
    "sound",
    "source",
    "sourou",
    "souss",
    "sousse",
    "southampton",
    "southend",
    "southland",
    "southwark",
    "soviet",
    "sowa",
    "sowanda",
    "soyaltepec",
    "spain",
    "spanish",
    "special",
    "specifically",
    "speech",
    "speedwords",
    "speu",
    "spezia",
    "spiti",
    "splitsko",
    "spokane",
    "spélugues",
    "spíritus",
    "squamish",
    "sraghna",
    "srair",
    "sranan",
    "središče",
    "srednjebanatski",
    "srednjobosanski",
    "sremski",
    "sri",
    "srijemska",
    "srpska",
    "ssr",
    "stadt",
    "staffordshire",
    "standard",
    "stann",
    "stara",
    "staro",
    "start",
    "starče",
    "stavropol",
    "steiermark",
    "stellingwerfs",
    "stenography",
    "sterea",
    "sterling",
    "stieng",
    "stirling",
    "stockholms",
    "stockport",
    "stockton",
    "stod",
    "stodsde",
    "stoke",
    "stoney",
    "stopiņu",
    "strabane",
    "strait",
    "straits",
    "strakonice",
    "straža",
    "strenču",
    "struga",
    "strumica",
    "strășeni",
    "studeničani",
    "stueng",
    "stînga",
    "středočeský",
    "suabo",
    "suain",
    "suarmin",
    "suau",
    "suba",
    "subanen",
    "subanon",
    "subiya",
    "subset",
    "subtiaba",
    "suceava",
    "suchitepéquez",
    "sucre",
    "sucumbíos",
    "sud",
    "sudan",
    "sudanese",
    "sudanic",
    "sudest",
    "sudovian",
    "sudur",
    "suena",
    "suffolk",
    "suga",
    "suganga",
    "sughd",
    "sugut",
    "sui",
    "sukhothai",
    "suki",
    "suku",
    "sukuma",
    "sukur",
    "sukurum",
    "sul",
    "sula",
    "sulawesi",
    "sulaymaniyah",
    "suline",
    "sulka",
    "sulod",
    "sultan",
    "sulu",
    "sum",
    "suma",
    "sumalē",
    "sumariup",
    "sumatera",
    "sumatra",
    "sumau",
    "sumbawa",
    "sumber",
    "sumbwa",
    "sumerian",
    "sumero",
    "sumi",
    "sumqayıt",
    "sums",
    "sumtu",
    "sunam",
    "sunamganj",
    "sundanese",
    "sunderland",
    "sungai",
    "sunwar",
    "suomi",
    "suoy",
    "supenaam",
    "suphan",
    "supyire",
    "sur",
    "surat",
    "surbakhal",
    "surgujia",
    "suri",
    "surigao",
    "surigaonon",
    "surin",
    "surinam",
    "suriname",
    "surjapuri",
    "surrey",
    "sursurunga",
    "surt",
    "suruahá",
    "surubu",
    "suruí",
    "surxondaryo",
    "susquehannock",
    "sussex",
    "susu",
    "susuami",
    "sutton",
    "suundi",
    "suwawa",
    "suwayda",
    "suwayf",
    "suways",
    "suyá",
    "suðurland",
    "suðurnes",
    "svaay",
    "svalbard",
    "svan",
    "svanet’i",
    "sverdlovskaya",
    "sveta",
    "sveti",
    "svitavy",
    "swabian",
    "swahili",
    "swampy",
    "swansea",
    "swati",
    "sweden",
    "swedish",
    "swieqi",
    "swindon",
    "swiss",
    "switzerland",
    "swo",
    "syddanmark",
    "syenara",
    "sylhet",
    "sylheti",
    "syllabaries",
    "syllabics",
    "syloti",
    "symbols",
    "syriac",
    "syrian",
    "syunik",
    "szabolcs",
    "szatmár",
    "szeged",
    "szekszárd",
    "szolnok",
    "szombathely",
    "székesfehérvár",
    "sài",
    "sáliba",
    "sánchez",
    "sázavou",
    "são",
    "sãotomense",
    "sèvres",
    "sédhiou",
    "ségou",
    "séno",
    "sénoufo",
    "sétif",
    "sìcìté",
    "sîngerei",
    "sóc",
    "södermanlands",
    "sühbaatar",
    "sādis",
    "sălaj",
    "sējas",
    "sīlā",
    "sīnā",
    "sīstān",
    "sŏnbong",
    "sūhāj",
    "sơn",
    "sədərək",
    "taabwa",
    "taakaev",
    "tabaa",
    "tabaquite",
    "tabaru",
    "tabasco",
    "tabassaran",
    "tabla",
    "tabo",
    "tabor",
    "tabora",
    "tabriak",
    "tabulahan",
    "tabūk",
    "tac",
    "tacahua",
    "tacana",
    "tachawit",
    "tachelhit",
    "tachoni",
    "tachov",
    "tacna",
    "tacuarembó",
    "tadaksahak",
    "tadjourah",
    "tadyawan",
    "tadó",
    "tae",
    "taf",
    "taff",
    "tafi",
    "tafilalet",
    "taféa",
    "tagabawa",
    "tagakaulo",
    "tagal",
    "tagalaka",
    "tagalog",
    "tagant",
    "tagargrent",
    "tagbanwa",
    "tagbu",
    "tagdal",
    "tagin",
    "tagish",
    "tagoi",
    "tagwana",
    "tahaggart",
    "tahitian",
    "tahltan",
    "tahoua",
    "tai",
    "taiap",
    "taichung",
    "taikat",
    "tainae",
    "tainan",
    "taino",
    "taipei",
    "tairaha",
    "tairora",
    "tairuma",
    "taita",
    "taitung",
    "taiwan",
    "taje",
    "tajik",
    "tajiki",
    "tajikistan",
    "tajio",
    "tajuasohn",
    "tak",
    "taka",
    "takamaka",
    "takelma",
    "takestani",
    "takhār",
    "takia",
    "tako",
    "takri",
    "takua",
    "takum",
    "takutu",
    "takuu",
    "takwane",
    "tal",
    "tala",
    "talantang",
    "talas",
    "talaud",
    "talbot",
    "taliabu",
    "talieng",
    "talinga",
    "talise",
    "talodi",
    "taloki",
    "talondo",
    "talossan",
    "talparo",
    "talsu",
    "talu",
    "talysh",
    "tama",
    "tamagario",
    "tamahaq",
    "tamajaq",
    "tamajeq",
    "taman",
    "tamanaku",
    "tamang",
    "tamanghasset",
    "tamashek",
    "tamasheq",
    "tamaulipas",
    "tamazight",
    "tamazola",
    "tambacounda",
    "tambas",
    "tambora",
    "tambotalo",
    "tambovskaya",
    "tameside",
    "tami",
    "tamil",
    "tamique",
    "tamki",
    "tamnim",
    "tampias",
    "tampuan",
    "tampulma",
    "tan",
    "tana",
    "tanacross",
    "tanahmerah",
    "tanaina",
    "tanana",
    "tanane",
    "tanapag",
    "tandaganon",
    "tandia",
    "tandroy",
    "tanema",
    "tanga",
    "tangail",
    "tangale",
    "tangchangya",
    "tanger",
    "tanggu",
    "tangkhul",
    "tangko",
    "tanglang",
    "tangoa",
    "tanguat",
    "tangut",
    "tanimbili",
    "tanimuca",
    "tanintharyi",
    "tanjijili",
    "tanjong",
    "tanna",
    "tanosy",
    "tanudan",
    "tanzania",
    "tanzanian",
    "taounate",
    "taourirt",
    "taoyuan",
    "tapeba",
    "tapei",
    "tapieté",
    "tapirapé",
    "tapoa",
    "taraba",
    "taraclia",
    "tarahumara",
    "taranaki",
    "tarangan",
    "taranto",
    "tarao",
    "tarapacá",
    "tareng",
    "tarf",
    "tarfaya",
    "targovishte",
    "tariana",
    "tarifit",
    "tarija",
    "tarjumo",
    "tarlac",
    "tarn",
    "tarnovo",
    "tarok",
    "taroko",
    "taromi",
    "taroudant",
    "tarpia",
    "tarrafal",
    "tarragona",
    "tartessian",
    "tartumaa",
    "tartus",
    "taruma",
    "tarxien",
    "tasawaq",
    "tase",
    "tasman",
    "tasmania",
    "tasmanian",
    "tasmate",
    "tat",
    "tata",
    "tatabánya",
    "tataltepec",
    "tatana",
    "tataouine",
    "tatar",
    "tatarstan",
    "tatuyo",
    "tauade",
    "taulil",
    "taungyo",
    "taupota",
    "tauragés",
    "tause",
    "taushiro",
    "tausug",
    "tauya",
    "taveta",
    "tavoyan",
    "tavringer",
    "tavus",
    "tavytera",
    "tawala",
    "tawallammat",
    "tawandê",
    "tawang",
    "tawara",
    "tawbuid",
    "tawi",
    "taworta",
    "tawoyan",
    "tawr",
    "tay",
    "tayabas",
    "tayart",
    "tayo",
    "taza",
    "taznatit",
    "ta’",
    "tboli",
    "tchitchege",
    "tchumbuli",
    "teanu",
    "tearce",
    "tebul",
    "tecpatlán",
    "tecóatl",
    "tedaga",
    "tedim",
    "tee",
    "tees",
    "tefaro",
    "tegali",
    "tege",
    "tegu",
    "tehit",
    "tehrān",
    "tehuelche",
    "teita",
    "tejalapan",
    "teke",
    "tekirdağ",
    "tektiteko",
    "tel",
    "tela",
    "telangana",
    "telefol",
    "telemark",
    "telenești",
    "teleorman",
    "telford",
    "telugu",
    "telšių",
    "tem",
    "temacine",
    "temalacayuca",
    "temascaltepec",
    "tembo",
    "temburong",
    "tembé",
    "teme",
    "temein",
    "temi",
    "temiar",
    "temoaya",
    "temoq",
    "temotu",
    "tempio",
    "temuan",
    "ten",
    "tena",
    "tenango",
    "tene",
    "tenerife",
    "tengah",
    "tenge",
    "tenggara",
    "tenggarong",
    "tengger",
    "tengwar",
    "tenharim",
    "tenino",
    "tenis",
    "tennessee",
    "tennet",
    "teop",
    "teor",
    "tepecano",
    "tepehua",
    "tepehuan",
    "tepelenë",
    "tepetotutla",
    "tepetzintla",
    "tepeuxila",
    "tepinapa",
    "teplice",
    "tepo",
    "ter",
    "tera",
    "teramo",
    "terebu",
    "terei",
    "terengganu",
    "tereno",
    "teresa",
    "teressa",
    "tereweng",
    "teribe",
    "terik",
    "teritorială",
    "termanu",
    "ternate",
    "ternateño",
    "terni",
    "ternopil",
    "terres",
    "territoire",
    "territories",
    "territory",
    "teruel",
    "tesaka",
    "tese",
    "teshenawa",
    "teso",
    "tesu",
    "tete",
    "tetela",
    "tetelcingo",
    "tetete",
    "tetovo",
    "tetum",
    "tetun",
    "teugbyeolsi",
    "teutila",
    "tewa",
    "tewe",
    "texas",
    "texcatepec",
    "texistepec",
    "texmelucan",
    "tey",
    "tezoatlán",
    "tha",
    "thaa",
    "thaana",
    "thaba",
    "thachanadan",
    "thado",
    "thai",
    "thailand",
    "thaiphum",
    "thakali",
    "thakurgaon",
    "thakurti",
    "tham",
    "thames",
    "thammarat",
    "thangal",
    "thangmi",
    "thanh",
    "thani",
    "thao",
    "thar",
    "tharaka",
    "tharnggala",
    "tharu",
    "thawa",
    "thayore",
    "thaypan",
    "the",
    "thep",
    "thesprotia",
    "thessalia",
    "thessaloniki",
    "thiin",
    "thimphu",
    "thiès",
    "thiên",
    "tho",
    "thom",
    "thomas",
    "thompson",
    "thong",
    "thopho",
    "thracian",
    "thraki",
    "thu",
    "thudam",
    "thulung",
    "thurawal",
    "thurgau",
    "thuri",
    "thurrock",
    "thuận",
    "thyolo",
    "thái",
    "tháp",
    "thüringen",
    "thơ",
    "thọ",
    "thừa",
    "tiagbamrin",
    "tiale",
    "tiang",
    "tianjin",
    "tiaret",
    "tibastī",
    "tibea",
    "tibetan",
    "tibeto",
    "tichurong",
    "ticino",
    "ticuna",
    "tidaá",
    "tidikelt",
    "tidore",
    "tidung",
    "tiemacèwè",
    "tiene",
    "tierra",
    "tifal",
    "tifinagh",
    "tigak",
    "tighina",
    "tigon",
    "tigray",
    "tigre",
    "tigrinya",
    "tii",
    "tijaltepec",
    "tikar",
    "tikopia",
    "tilantongo",
    "tilapa",
    "tillabéri",
    "tillamook",
    "tilquiapan",
    "tilung",
    "tima",
    "timbe",
    "timbira",
    "timiș",
    "timne",
    "timor",
    "timucua",
    "timugon",
    "timur",
    "tinani",
    "tindi",
    "tindouf",
    "tinga",
    "tinghir",
    "tingui",
    "tinigua",
    "tinoc",
    "tinputz",
    "tipaza",
    "tippera",
    "tipperary",
    "tira",
    "tirahi",
    "tiranige",
    "tiranë",
    "tirhuta",
    "tiri",
    "tiriki",
    "tiris",
    "tirol",
    "tiruray",
    "tissemsilt",
    "tita",
    "titan",
    "tiv",
    "tivat",
    "tiwa",
    "tiwi",
    "tiyal",
    "tizi",
    "tiznit",
    "tiéfo",
    "tiéyaxo",
    "tišina",
    "tiền",
    "tjurruru",
    "tlachichilco",
    "tlacoapa",
    "tlacoatzintepec",
    "tlacolula",
    "tlacolulita",
    "tlacoyalco",
    "tlahuitoltepec",
    "tlamacazapa",
    "tlatskanai",
    "tlaxcala",
    "tlaxiaco",
    "tlazoyaltepec",
    "tlemcen",
    "tlhingan",
    "tlingit",
    "toamasina",
    "toaripi",
    "toba",
    "tobago",
    "tobagonian",
    "tobanga",
    "tobati",
    "tobelo",
    "tobian",
    "tobilung",
    "tobo",
    "tocantins",
    "tochigi",
    "tocho",
    "toda",
    "todrah",
    "tofanma",
    "tofin",
    "toga",
    "togbo",
    "togdheer",
    "togo",
    "togoyo",
    "tohono",
    "tojolabal",
    "tok",
    "tokano",
    "tokat",
    "tokelau",
    "tokharian",
    "toku",
    "tokushima",
    "tokyo",
    "tol",
    "tola",
    "tolaki",
    "toledo",
    "toliara",
    "tolima",
    "tolmin",
    "tolna",
    "tolomako",
    "tolowa",
    "toma",
    "tomadino",
    "tomaž",
    "tombali",
    "tombelala",
    "tombonuo",
    "tombouctou",
    "tombulu",
    "tome",
    "tomini",
    "tommo",
    "tomo",
    "tomoip",
    "tomskaya",
    "tomé",
    "tondano",
    "tondi",
    "tong",
    "tonga",
    "tongan",
    "tongatapu",
    "tongo",
    "tongwe",
    "tonjon",
    "tonkawa",
    "tonsawang",
    "tonsea",
    "tontemboan",
    "tooro",
    "toplice",
    "topliče",
    "toplički",
    "topoiyo",
    "toposa",
    "tor",
    "toraja",
    "toram",
    "torau",
    "torba",
    "torbay",
    "torfaen",
    "torino",
    "tornedalen",
    "toro",
    "toromono",
    "torona",
    "tororo",
    "torres",
    "torricelli",
    "torwali",
    "torá",
    "toscana",
    "toshkent",
    "tosk",
    "totela",
    "toto",
    "totoli",
    "totomachapan",
    "totonac",
    "totonicapán",
    "totontepec",
    "totoro",
    "tottori",
    "tougué",
    "touo",
    "toura",
    "toussian",
    "tovar",
    "tovuz",
    "towei",
    "tower",
    "town",
    "toyama",
    "tozeur",
    "trabzon",
    "traditional",
    "traeng",
    "trafford",
    "trang",
    "trani",
    "trans",
    "transalpine",
    "trapani",
    "trarza",
    "trashi",
    "trashigang",
    "trat",
    "traveller",
    "trbovlje",
    "tre",
    "trebelno",
    "trebnje",
    "tregami",
    "treinta",
    "trelawny",
    "tremembé",
    "trent",
    "trentino",
    "trento",
    "trenčiansky",
    "tres",
    "treviso",
    "tribal",
    "trieng",
    "triesen",
    "triesenberg",
    "trieste",
    "trikala",
    "trikuṇāmalaya",
    "trimuris",
    "tring",
    "tringgus",
    "trinidad",
    "trinidadian",
    "trinitario",
    "trinity",
    "trio",
    "tripolitanian",
    "tripura",
    "tripuri",
    "triqui",
    "tristan",
    "trió",
    "trnavský",
    "trnovska",
    "trojica",
    "troms",
    "trongsa",
    "tropojë",
    "trujillo",
    "truká",
    "trumai",
    "trutnov",
    "trzin",
    "trà",
    "trøndelag",
    "trăng",
    "tržič",
    "trị",
    "tsaangi",
    "tsaayi",
    "tsakhur",
    "tsakonian",
    "tsakwambo",
    "tsamai",
    "tsat",
    "tseka",
    "tseku",
    "tsetsaut",
    "tshangla",
    "tshopo",
    "tsikimba",
    "tsimané",
    "tsimihety",
    "tsimshian",
    "tsirang",
    "tsishingini",
    "tso",
    "tsoa",
    "tsogo",
    "tsonga",
    "tsotso",
    "tsou",
    "tsucuba",
    "tsum",
    "tsuvadi",
    "tsuvan",
    "tswa",
    "tswana",
    "tswapong",
    "tsáchilas",
    "tuamasaga",
    "tuamotuan",
    "tubar",
    "tubas",
    "tubu",
    "tucano",
    "tucuman",
    "tudful",
    "tugen",
    "tugrik",
    "tugun",
    "tugutil",
    "tui",
    "tujia",
    "tukang",
    "tuki",
    "tukpa",
    "tukudede",
    "tukuma",
    "tukumanféd",
    "tul",
    "tula",
    "tulcea",
    "tulehu",
    "tulishi",
    "tulkarm",
    "tulu",
    "tum",
    "tuma",
    "tumak",
    "tumari",
    "tumbes",
    "tumbuka",
    "tumi",
    "tumleo",
    "tumshuqese",
    "tumtum",
    "tumulung",
    "tumzabt",
    "tunapuna",
    "tunas",
    "tunceli",
    "tundra",
    "tunebo",
    "tunen",
    "tungag",
    "tunggare",
    "tungurahua",
    "tungus",
    "tunia",
    "tunica",
    "tunis",
    "tunisia",
    "tunisian",
    "tunjung",
    "tunni",
    "tunzu",
    "tuotomb",
    "tuparí",
    "tupi",
    "tupinambá",
    "tupinikin",
    "tupuri",
    "tupí",
    "tur",
    "turaka",
    "turi",
    "turiwára",
    "turka",
    "turkana",
    "turkey",
    "turki",
    "turkic",
    "turkish",
    "turkmen",
    "turkmenistan",
    "turks",
    "turnišče",
    "turoyo",
    "turumsa",
    "turung",
    "tuscarora",
    "tusi",
    "tutchone",
    "tutelo",
    "tutong",
    "tutsa",
    "tutuba",
    "tututepec",
    "tututni",
    "tuva",
    "tuvalu",
    "tuvinian",
    "tuwali",
    "tuwari",
    "tuwuli",
    "tuxináwa",
    "tuxá",
    "tuyuca",
    "tuyên",
    "tuzlanski",
    "tverskaya",
    "twabo",
    "twana",
    "twendi",
    "twents",
    "twi",
    "tyap",
    "tyaraity",
    "tydfil",
    "tyee",
    "tyne",
    "tyneside",
    "type",
    "tyumenskaya",
    "tyva",
    "tzeltal",
    "tzotzil",
    "tàu",
    "tày",
    "tábor",
    "táchira",
    "tây",
    "tébessa",
    "télimélé",
    "témara",
    "témouchent",
    "tétouan",
    "téén",
    "töv",
    "tübatulabal",
    "tānjilī",
    "tērvetes",
    "třebíč",
    "tərtər",
    "tỉnh",
    "t’bilisi",
    "uab",
    "uaboe",
    "uae",
    "uamué",
    "uare",
    "uasin",
    "ubaghara",
    "ubang",
    "ubi",
    "ubir",
    "ubon",
    "ubykh",
    "ucar",
    "ucayali",
    "uda",
    "udi",
    "udihe",
    "udine",
    "udmurt",
    "udmurtskaya",
    "udon",
    "uduk",
    "ufim",
    "uganda",
    "ugandan",
    "ugaritic",
    "ugbanh",
    "ughele",
    "ugong",
    "ugrian",
    "uhami",
    "uherské",
    "uighur",
    "uisai",
    "ujae",
    "ujir",
    "ukaan",
    "ukhwejo",
    "ukit",
    "ukpe",
    "ukpet",
    "ukraine",
    "ukrainian",
    "uktūbar",
    "ukue",
    "ukuriguma",
    "ukwa",
    "ukwuani",
    "ulanbaatar",
    "ulau",
    "ulch",
    "ulcinj",
    "ulithian",
    "ullatan",
    "ulsan",
    "ulster",
    "ulukwumi",
    "ulumanda",
    "ulwa",
    "uma",
    "umanakaina",
    "umatilla",
    "umbindhamu",
    "umbria",
    "umbrian",
    "umbu",
    "umbugarla",
    "umbundu",
    "umbuygamu",
    "ume",
    "umeda",
    "umiida",
    "umiray",
    "umm",
    "umon",
    "umotína",
    "umpila",
    "umpqua",
    "una",
    "unami",
    "uncoded",
    "unde",
    "under",
    "undetermined",
    "uneapa",
    "uneme",
    "ung",
    "unggaranggu",
    "unggumi",
    "ungheni",
    "ungu",
    "unguja",
    "unified",
    "union",
    "unit",
    "unitatea",
    "united",
    "unity",
    "unión",
    "unserdeutsch",
    "unsko",
    "unua",
    "unubahe",
    "unwritten",
    "upaa",
    "upon",
    "upper",
    "uppsala",
    "ura",
    "uradhi",
    "urak",
    "urali",
    "uralic",
    "urapmin",
    "urarina",
    "urartian",
    "urat",
    "urbino",
    "urdu",
    "ure",
    "urhobo",
    "uri",
    "urigina",
    "urim",
    "urimo",
    "uripiv",
    "urningangg",
    "uru",
    "uruangnirin",
    "uruava",
    "urubú",
    "uruguay",
    "uruguayan",
    "uruguayo",
    "urum",
    "urumi",
    "uruzgān",
    "usa",
    "usaghade",
    "usan",
    "usarufa",
    "ushojo",
    "usila",
    "usku",
    "uspanteco",
    "ussr",
    "usui",
    "usulután",
    "utah",
    "utara",
    "utarmbung",
    "ute",
    "utenos",
    "uthai",
    "utirik",
    "uto",
    "utrecht",
    "uttar",
    "uttaradit",
    "uttarakhand",
    "utu",
    "utujil",
    "uturu",
    "uturumæ̆da",
    "uul",
    "uun",
    "uusimaa",
    "uvbie",
    "uvean",
    "uvs",
    "uwanh",
    "uya",
    "uyajitaya",
    "uyanga",
    "uyghur",
    "uygur",
    "uzbek",
    "uzbeki",
    "uzbekistan",
    "uzekwe",
    "uzo",
    "uélé",
    "uíge",
    "uşak",
    "vaagri",
    "vaavu",
    "vacoas",
    "vaduz",
    "vafsi",
    "vaghat",
    "vaghri",
    "vaghua",
    "vagla",
    "vah",
    "vai",
    "vaiphei",
    "vaisigano",
    "vaitupu",
    "vaiņodes",
    "vakaga",
    "val",
    "valais",
    "valandovo",
    "vale",
    "valencia",
    "valencian",
    "valenciana",
    "valentia",
    "valgamaa",
    "valkas",
    "valladolid",
    "valle",
    "valletta",
    "valley",
    "vallon",
    "vallée",
    "valman",
    "valmiera",
    "valparaíso",
    "valpei",
    "valverde",
    "valència",
    "vamale",
    "vame",
    "van",
    "vandalic",
    "vangunu",
    "vanimo",
    "vano",
    "vanuatu",
    "vanuma",
    "vao",
    "var",
    "vara",
    "varakļānu",
    "varang",
    "varaždinska",
    "varese",
    "vargas",
    "varhadi",
    "variant",
    "varisi",
    "varli",
    "varna",
    "varsinais",
    "vary",
    "vas",
    "vasavi",
    "vasco",
    "vasilevo",
    "vaslui",
    "vatican",
    "vato",
    "vatu",
    "vaucluse",
    "vaud",
    "vaupés",
    "vava",
    "vavuniyāva",
    "vayamba",
    "vayoc",
    "veaeng",
    "vecpiebalgas",
    "vecumnieku",
    "veddah",
    "vega",
    "vehes",
    "vejoz",
    "velenje",
    "veles",
    "velika",
    "velike",
    "veliko",
    "vella",
    "veluws",
    "vemgo",
    "venda",
    "vendée",
    "venera",
    "venetian",
    "venetic",
    "veneto",
    "venezia",
    "venezuela",
    "venezuelan",
    "vengo",
    "venkov",
    "ventre",
    "ventspils",
    "ventureño",
    "veps",
    "vera",
    "veracruz",
    "veraguas",
    "verapaz",
    "verbano",
    "vercelli",
    "verde",
    "vermont",
    "verona",
    "veržej",
    "vest",
    "vestfirðir",
    "vestfold",
    "vestinian",
    "vestra",
    "vesturland",
    "veszprém",
    "vevčani",
    "viana",
    "vibo",
    "vicente",
    "vicenza",
    "vichada",
    "viciebskaja",
    "viciosa",
    "victoria",
    "vidari",
    "videm",
    "vidin",
    "vidunda",
    "viemo",
    "vienne",
    "vientiane",
    "viesītes",
    "viet",
    "vietnam",
    "vietnamese",
    "vihear",
    "vihiga",
    "vii",
    "viii",
    "vila",
    "vilaine",
    "vilela",
    "vili",
    "viljandimaa",
    "villa",
    "ville",
    "vilniaus",
    "vincent",
    "vincentian",
    "vineyard",
    "vinh",
    "vinica",
    "vinmavis",
    "vinnyts",
    "vinza",
    "vipava",
    "viqueque",
    "virgin",
    "virginia",
    "viri",
    "virovitičko",
    "virumaa",
    "visayas",
    "viseu",
    "vishavan",
    "visible",
    "vista",
    "vitanje",
    "viterbo",
    "viti",
    "vitou",
    "vitu",
    "vivs",
    "vizcaya",
    "viļakas",
    "viļānu",
    "vlaams",
    "vlaamse",
    "vlaanderen",
    "vladimirskaya",
    "vlax",
    "vlorë",
    "voblasć",
    "voda",
    "vodice",
    "vodoun",
    "vodă",
    "vogrsko",
    "voiotia",
    "vojnik",
    "vojvodina",
    "volapük",
    "volgogradskaya",
    "vologodskaya",
    "volscian",
    "volta",
    "volyns",
    "vono",
    "vorarlberg",
    "voreio",
    "voro",
    "voronezhskaya",
    "vorpommern",
    "vosges",
    "votic",
    "vrancea",
    "vraneštica",
    "vransko",
    "vrapčište",
    "vratsa",
    "vrhnika",
    "vrtojba",
    "vsetín",
    "vukovarsko",
    "vumbu",
    "vunapu",
    "vunjo",
    "vurës",
    "vute",
    "vuzenica",
    "vwanji",
    "vysočina",
    "vyškov",
    "vâlcea",
    "värmlands",
    "västerbottens",
    "västernorrlands",
    "västmanlands",
    "västra",
    "võro",
    "võrumaa",
    "východ",
    "vārkavas",
    "vĩnh",
    "vũng",
    "waama",
    "waamwang",
    "waata",
    "wab",
    "wabo",
    "waboda",
    "wachi",
    "waci",
    "wadaginam",
    "waddar",
    "waddāy",
    "wadi",
    "wadikali",
    "wadiyara",
    "wadjabangayi",
    "wadjiginy",
    "wadjigu",
    "wae",
    "waffa",
    "wagawaga",
    "wagaya",
    "wagdi",
    "wageman",
    "wagi",
    "wahau",
    "wahgi",
    "waigali",
    "waigeo",
    "waikato",
    "wailaki",
    "wailapa",
    "waima",
    "waimaha",
    "waimiri",
    "waini",
    "waioli",
    "waiwai",
    "waja",
    "wajarri",
    "wajir",
    "wajuk",
    "wak",
    "waka",
    "wakabunga",
    "wakashan",
    "wakasihu",
    "wakawaka",
    "wakayama",
    "wakde",
    "wake",
    "wakefield",
    "wakhi",
    "wakiso",
    "wakoná",
    "wakrah",
    "wala",
    "walak",
    "walamo",
    "walangama",
    "walapai",
    "wales",
    "wali",
    "waling",
    "walio",
    "walk",
    "walla",
    "wallis",
    "wallisian",
    "wallon",
    "wallonne",
    "walloon",
    "walmajarri",
    "walsall",
    "walser",
    "waltham",
    "walungge",
    "wam",
    "wamas",
    "wambaya",
    "wambon",
    "wambule",
    "wamey",
    "wamin",
    "wampanoag",
    "wampar",
    "wampur",
    "wan",
    "wanambre",
    "wanap",
    "wanca",
    "wancho",
    "wanda",
    "wandala",
    "wandamen",
    "wandarang",
    "wandji",
    "wandsworth",
    "waneci",
    "wanga",
    "wangaaybuwan",
    "wanganui",
    "wangdue",
    "wanggamala",
    "wangganguru",
    "wanggom",
    "wangka",
    "wangkayutyuru",
    "wangkumara",
    "wanica",
    "wanman",
    "wannu",
    "wano",
    "wantoat",
    "wanukaka",
    "wanyi",
    "wané",
    "waorani",
    "wapan",
    "wapishana",
    "wappo",
    "war",
    "wara",
    "warang",
    "warao",
    "warapu",
    "waray",
    "wardak",
    "wardaman",
    "wardandi",
    "warduji",
    "warembori",
    "wares",
    "waris",
    "waritai",
    "wariyangga",
    "warji",
    "warkay",
    "warlmanpa",
    "warlpiri",
    "warluwara",
    "warmińsko",
    "warnang",
    "waropen",
    "warra",
    "warrap",
    "warrgamay",
    "warrington",
    "warrwa",
    "waru",
    "warumungu",
    "waruna",
    "warungu",
    "warwar",
    "warwickshire",
    "wasa",
    "wasco",
    "wasembo",
    "washington",
    "washo",
    "wasit",
    "waskia",
    "wasu",
    "wat",
    "watakataui",
    "watam",
    "waterford",
    "wathawurrung",
    "watiwa",
    "watubela",
    "watut",
    "wau",
    "waube",
    "waurá",
    "wauyai",
    "wawa",
    "wawonii",
    "waxianghua",
    "wayampi",
    "wayana",
    "wayanad",
    "wayoró",
    "wayu",
    "wayuu",
    "wedau",
    "weh",
    "wejewa",
    "wele",
    "weliki",
    "wellington",
    "wells",
    "welsh",
    "wemale",
    "wemba",
    "weme",
    "wenatchi",
    "weondo",
    "wergaia",
    "weri",
    "wersing",
    "westfalen",
    "westmeath",
    "westminster",
    "westmoreland",
    "westphalien",
    "wetamut",
    "wewaw",
    "wexford",
    "weyto",
    "where",
    "white",
    "whitesands",
    "wiarumus",
    "wichita",
    "wichí",
    "wicklow",
    "wielkopolskie",
    "wien",
    "wigan",
    "wight",
    "wik",
    "wikalkan",
    "wikngenchera",
    "wilawila",
    "wilayah",
    "wilhems",
    "wiltshire",
    "win",
    "windsor",
    "windward",
    "wintu",
    "winyé",
    "wipi",
    "wiradhuri",
    "wiraféd",
    "wirangu",
    "wirral",
    "wiru",
    "wisconsin",
    "wishram",
    "with",
    "witu",
    "wiyot",
    "woccon",
    "wogamusin",
    "wogeo",
    "woi",
    "woiwurrung",
    "wojenaka",
    "wokingham",
    "wolane",
    "wolani",
    "wolaytta",
    "woleai",
    "woleaian",
    "woleu",
    "wolio",
    "wolof",
    "wolverhampton",
    "wom",
    "womo",
    "won",
    "wongo",
    "woods",
    "woqooyi",
    "worcestershire",
    "woria",
    "worimi",
    "world",
    "worodougou",
    "worodouqou",
    "woromaipu",
    "worrorra",
    "wotapuri",
    "wotho",
    "wotje",
    "wotjobaluk",
    "wotu",
    "woun",
    "wrecsam",
    "wrekin",
    "wrexham",
    "written",
    "wuding",
    "wudu",
    "wujwa",
    "wuliwuli",
    "wulna",
    "wumboko",
    "wumbvu",
    "wumeng",
    "wunai",
    "wunambal",
    "wunumara",
    "wuri",
    "wurrugu",
    "wusa",
    "wushi",
    "wusi",
    "wusţá",
    "wutung",
    "wutunhua",
    "wuvulu",
    "wuzlam",
    "wyandot",
    "wymysorys",
    "wyoming",
    "wára",
    "wãpha",
    "württemberg",
    "wādī",
    "wāḩāt",
    "xaasongaxango",
    "xadani",
    "xagħra",
    "xaignabouli",
    "xaisômboun",
    "xakriabá",
    "xam",
    "xamtanga",
    "xanaguía",
    "xanica",
    "xankəndi",
    "xanthi",
    "xavánte",
    "xaçmaz",
    "xbiex",
    "xegwi",
    "xerénte",
    "xetá",
    "xewkija",
    "xgħajra",
    "xhosa",
    "xian",
    "xiang",
    "xiangkhouang",
    "xiangxi",
    "xibe",
    "xicotepec",
    "xii",
    "xiii",
    "xinca",
    "xingú",
    "xinjiang",
    "xipaya",
    "xiri",
    "xiriâna",
    "xishanba",
    "xizang",
    "xocalı",
    "xocavənd",
    "xocó",
    "xokleng",
    "xorazm",
    "xukurú",
    "xwela",
    "xwla",
    "xârâcùù",
    "xârâgurè",
    "xékong",
    "xóõ",
    "xızı",
    "yaaku",
    "yabarana",
    "yabaâna",
    "yabem",
    "yaben",
    "yabong",
    "yabula",
    "yace",
    "yacoub",
    "yaeyama",
    "yafi",
    "yagara",
    "yagaria",
    "yagha",
    "yagnobi",
    "yagomi",
    "yagua",
    "yagwoia",
    "yahadian",
    "yahang",
    "yahuna",
    "yak",
    "yaka",
    "yakaikeke",
    "yakama",
    "yakan",
    "yakha",
    "yakkha",
    "yakoma",
    "yakut",
    "yakutiya",
    "yala",
    "yalahatan",
    "yalakalore",
    "yalanji",
    "yalarnnga",
    "yale",
    "yaleba",
    "yali",
    "yalova",
    "yalunka",
    "yalálag",
    "yamagata",
    "yamaguchi",
    "yamalo",
    "yamanashi",
    "yamap",
    "yamba",
    "yambes",
    "yambeta",
    "yambol",
    "yamdena",
    "yameo",
    "yami",
    "yaminahua",
    "yamna",
    "yamongeri",
    "yamphu",
    "yan",
    "yana",
    "yanahuanca",
    "yanda",
    "yandjibara",
    "yandruwandha",
    "yanesha",
    "yang",
    "yangben",
    "yangere",
    "yanggang",
    "yangkam",
    "yangman",
    "yango",
    "yangon",
    "yangtse",
    "yangulam",
    "yangum",
    "yankunytjatjara",
    "yanomamö",
    "yanomámi",
    "yanovskaya",
    "yansi",
    "yanyuwa",
    "yao",
    "yaosakor",
    "yaouré",
    "yap",
    "yapese",
    "yapi",
    "yapunda",
    "yaqay",
    "yaqui",
    "yaracuy",
    "yarawata",
    "yardliyawarra",
    "yardımlı",
    "yareba",
    "yaren",
    "yareni",
    "yarluyandi",
    "yaroamë",
    "yaroslavskaya",
    "yarowilca",
    "yarsun",
    "yasa",
    "yasothon",
    "yassic",
    "yatay",
    "yate",
    "yatee",
    "yatenga",
    "yatzachi",
    "yatzechi",
    "yau",
    "yaul",
    "yauma",
    "yaur",
    "yautepec",
    "yauyos",
    "yavapai",
    "yavitero",
    "yawa",
    "yawalapití",
    "yawanawa",
    "yawarawarga",
    "yaweyuha",
    "yawijibaya",
    "yawiyo",
    "yawuru",
    "yaygir",
    "yazd",
    "yazgulyam",
    "yecuatla",
    "yedebub",
    "yegha",
    "yei",
    "yekhee",
    "yekora",
    "yela",
    "yele",
    "yelmek",
    "yelogu",
    "yemba",
    "yemen",
    "yemeni",
    "yemsa",
    "yen",
    "yendang",
    "yeni",
    "yeniche",
    "yeogsi",
    "yerakai",
    "yeretuar",
    "yerong",
    "yerukula",
    "yerushalayim",
    "yessan",
    "yetfa",
    "yevanic",
    "yevlax",
    "yevreyskaya",
    "yeyi",
    "yiddish",
    "yidgha",
    "yidiny",
    "yil",
    "yimas",
    "yimchungru",
    "yinbaw",
    "yinchia",
    "yindjibarndi",
    "yindjilandji",
    "yine",
    "yinggarda",
    "yinhawangka",
    "yiningayi",
    "yintale",
    "yinwum",
    "yir",
    "yirandali",
    "yirrk",
    "yis",
    "yitha",
    "ynys",
    "yoba",
    "yobe",
    "yocoboué",
    "yogad",
    "yogyakarta",
    "yoidik",
    "yoke",
    "yokuts",
    "yola",
    "yoloxochitl",
    "yolŋu",
    "yom",
    "yombe",
    "yomou",
    "yonaguni",
    "yong",
    "yongbei",
    "yongkom",
    "yongnan",
    "yonne",
    "yopno",
    "yora",
    "york",
    "yorkshire",
    "yoro",
    "yoron",
    "yoront",
    "yorta",
    "yoruba",
    "yosondúa",
    "yotti",
    "youjiang",
    "youle",
    "younuo",
    "youssoufia",
    "yout",
    "yoy",
    "yozgat",
    "ysyk",
    "yuan",
    "yuanga",
    "yucatec",
    "yucateco",
    "yucatán",
    "yuchi",
    "yucuañe",
    "yucuna",
    "yue",
    "yug",
    "yugambal",
    "yugoslavia",
    "yugoslavian",
    "yugra",
    "yugul",
    "yugur",
    "yuhup",
    "yui",
    "yukaghir",
    "yuki",
    "yukon",
    "yukpa",
    "yukuben",
    "yulu",
    "yumbe",
    "yunis",
    "yunlin",
    "yunnan",
    "yupik",
    "yuqui",
    "yuracare",
    "yurats",
    "yuri",
    "yurok",
    "yuru",
    "yurutí",
    "yurúa",
    "yutanduchi",
    "yuwana",
    "yuyu",
    "yvelines",
    "ywom",
    "yámana",
    "yên",
    "yāpanaya",
    "zaachila",
    "zabajkal",
    "zabana",
    "zacapa",
    "zacatecas",
    "zacatepec",
    "zacatlán",
    "zachodniopomorskie",
    "zadarska",
    "zag",
    "zaghawa",
    "zaghouan",
    "zagora",
    "zagorje",
    "zagorska",
    "zagreb",
    "zagrebačka",
    "zaire",
    "zaiwa",
    "zajas",
    "zaječarski",
    "zakarpats",
    "zakhring",
    "zakynthos",
    "zala",
    "zalaegerszeg",
    "zalingei",
    "zamani",
    "zambales",
    "zambezia",
    "zambia",
    "zambian",
    "zamboanga",
    "zamfara",
    "zamora",
    "zan",
    "zanaki",
    "zande",
    "zangskari",
    "zangwal",
    "zaniza",
    "zanjān",
    "zanzan",
    "zapadnobački",
    "zapadnohercegovački",
    "zaporiz",
    "zapotec",
    "zaqatala",
    "zaragoza",
    "zaramo",
    "zari",
    "zarma",
    "zarphatic",
    "zarqā",
    "zauzou",
    "zavrč",
    "zawr",
    "zay",
    "zayein",
    "zayse",
    "zaza",
    "zazaki",
    "zazao",
    "zealand",
    "zeeland",
    "zeem",
    "zeeuws",
    "zelenikovo",
    "zemba",
    "zeme",
    "zemgalian",
    "zemmour",
    "zemo",
    "zemplén",
    "zenag",
    "zenaga",
    "zeničko",
    "zenzontepec",
    "zerenkel",
    "zergulla",
    "zhaba",
    "zhambyl",
    "zhang",
    "zhejiang",
    "zhemgang",
    "zhire",
    "zhoa",
    "zhong",
    "zhuang",
    "zhuangzu",
    "zhung",
    "zhytomyrs",
    "zia",
    "zialo",
    "ziguinchor",
    "zigula",
    "zilupes",
    "zimakani",
    "zimba",
    "zimbabwe",
    "zinder",
    "zinza",
    "zire",
    "ziriya",
    "ziro",
    "zizhiqu",
    "zizilivakan",
    "zlatiborski",
    "zloty",
    "zlín",
    "zlínský",
    "znojmo",
    "zokhuo",
    "zomba",
    "zondoma",
    "zone",
    "zonguldak",
    "zoogocho",
    "zoque",
    "zoroastrian",
    "zotung",
    "zou",
    "zoundwéogo",
    "zreče",
    "zrnovci",
    "zuba",
    "zug",
    "zuid",
    "zulgo",
    "zulia",
    "zulu",
    "zumaya",
    "zumbun",
    "zuni",
    "zuojiang",
    "zwall",
    "zyphe",
    "zyrian",
    "západ",
    "záparo",
    "zürich",
    "zābul",
    "zāwiyah",
    "zəngilan",
    "zərdab",
    "z̧a‘āyin",
    "z̧ufār",
    "z̧āhirah",
    "²ggŏ",
    "¹baw",
    "àhàn",
    "álava",
    "áncá",
    "ávila",
    "åland",
    "çanakkale",
    "çankırı",
    "çorum",
    "équateur",
    "érd",
    "évora",
    "île",
    "ñapa",
    "ñeembucú",
    "órgãos",
    "ölgiy",
    "ömie",
    "ömnögovi",
    "önge",
    "örebro",
    "östergötlands",
    "övörhangay",
    "østfold",
    "ústecký",
    "ústí",
    "ābeba",
    "ādažu",
    "ādīs",
    "āfar",
    "āmara",
    "āzarbāyjān",
    "čair",
    "čaška",
    "česká",
    "české",
    "český",
    "češinovo",
    "črenšovci",
    "črna",
    "črnomelj",
    "čučer",
    "điện",
    "đắc",
    "đắk",
    "định",
    "đồng",
    "ērgļu",
    "ĕliya",
    "ġiljan",
    "ġwann",
    "ħamrun",
    "īlām",
    "īlīyah",
    "ķeguma",
    "ķekavas",
    "łódzkie",
    "śląskie",
    "świętokrzyskie",
    "śāradā",
    "şabran",
    "şahbuz",
    "şamaxı",
    "şan",
    "şanlıurfa",
    "şirvan",
    "şuşa",
    "şırnak",
    "şəki",
    "şəmkir",
    "şərur",
    "šalovci",
    "šavnik",
    "šempeter",
    "šentilj",
    "šentjernej",
    "šentjur",
    "šentrupert",
    "šenčur",
    "šiaulių",
    "šibensko",
    "škocjan",
    "škofja",
    "škofljica",
    "šmarje",
    "šmarjeske",
    "šmartno",
    "šoštanj",
    "štip",
    "štore",
    "šumadijski",
    "šumperk",
    "šuto",
    "ţafīlah",
    "ţarābulus",
    "ūva",
    "żabbar",
    "żebbuġ",
    "żejtun",
    "żurrieq",
    "žabljak",
    "žalec",
    "železniki",
    "želino",
    "žetale",
    "žilinský",
    "žiri",
    "žirovnica",
    "župa",
    "županija",
    "žužemberk",
    "žďár",
    "ǂungkue",
    "șoldănești",
    "ștefan",
    "ȥaby",
    "ḥajjar",
    "ḥudūd",
    "ḩajjah",
    "ḩayāt",
    "ḩaḑramawt",
    "ḩudaydah",
    "ṭākrī",
    "ṭāṅkrī",
    "‘ajlūn",
    "‘ammān",
    "‘aqabah",
    "‘aşimah",
    "‘āşimah",
}
