# Generated by Django 3.0.7 on 2020-07-23 08:41

from django.db import migrations
from django.db.models import F
from django.db.models.functions import Substr


def migrate_componentlist(apps, schema_editor):
    Unit = apps.get_model("trans", "Unit")
    db_alias = schema_editor.connection.alias
    units = Unit.objects.using(db_alias).filter(
        translation__component__file_format__in=(
            "json",
            "arb",
            "go-i18n-json",
            "i18next",
            "webextension",
            "json-nested",
        ),
        context__startswith=".",
    )
    units.update(context=Substr(F("context"), 2))


class Migration(migrations.Migration):

    dependencies = [
        ("trans", "0090_alert_updated"),
    ]

    operations = [
        migrations.RunPython(
            migrate_componentlist, migrations.RunPython.noop, elidable=True
        ),
    ]
