"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk.models.shared import (
    accountingaccount as shared_accountingaccount,
)
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)


class PatchAccountingAccountRequestTypedDict(TypedDict):
    accounting_account: shared_accountingaccount.AccountingAccountTypedDict
    r"""Chart of accounts"""
    connection_id: str
    r"""ID of the connection"""
    id: str
    r"""ID of the Account"""
    fields: NotRequired[List[str]]
    r"""Comma-delimited fields to return"""


class PatchAccountingAccountRequest(BaseModel):
    accounting_account: Annotated[
        shared_accountingaccount.AccountingAccount,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
    r"""Chart of accounts"""

    connection_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the connection"""

    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the Account"""

    fields: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Comma-delimited fields to return"""


class PatchAccountingAccountResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    accounting_account: NotRequired[shared_accountingaccount.AccountingAccountTypedDict]
    r"""Successful"""


class PatchAccountingAccountResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    accounting_account: Optional[shared_accountingaccount.AccountingAccount] = None
    r"""Successful"""
