"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk.models.shared import commerceitem as shared_commerceitem
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)


class PatchCommerceItemRequestTypedDict(TypedDict):
    commerce_item: shared_commerceitem.CommerceItemTypedDict
    connection_id: str
    r"""ID of the connection"""
    id: str
    r"""ID of the Item"""
    fields: NotRequired[List[str]]
    r"""Comma-delimited fields to return"""


class PatchCommerceItemRequest(BaseModel):
    commerce_item: Annotated[
        shared_commerceitem.CommerceItem,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    connection_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the connection"""

    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the Item"""

    fields: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Comma-delimited fields to return"""


class PatchCommerceItemResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    commerce_item: NotRequired[shared_commerceitem.CommerceItemTypedDict]
    r"""Successful"""


class PatchCommerceItemResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    commerce_item: Optional[shared_commerceitem.CommerceItem] = None
    r"""Successful"""
