"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk.models.shared import accountingorder as shared_accountingorder
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)


class UpdateAccountingOrderRequestTypedDict(TypedDict):
    accounting_order: shared_accountingorder.AccountingOrderTypedDict
    connection_id: str
    r"""ID of the connection"""
    id: str
    r"""ID of the Order"""
    fields: NotRequired[List[str]]
    r"""Comma-delimited fields to return"""


class UpdateAccountingOrderRequest(BaseModel):
    accounting_order: Annotated[
        shared_accountingorder.AccountingOrder,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    connection_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the connection"""

    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the Order"""

    fields: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Comma-delimited fields to return"""


class UpdateAccountingOrderResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    accounting_order: NotRequired[shared_accountingorder.AccountingOrderTypedDict]
    r"""Successful"""


class UpdateAccountingOrderResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    accounting_order: Optional[shared_accountingorder.AccountingOrder] = None
    r"""Successful"""
