"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk.models.shared import atsscorecard as shared_atsscorecard
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)


class UpdateAtsScorecardRequestTypedDict(TypedDict):
    ats_scorecard: shared_atsscorecard.AtsScorecardTypedDict
    connection_id: str
    r"""ID of the connection"""
    id: str
    r"""ID of the Scorecard"""
    fields: NotRequired[List[str]]
    r"""Comma-delimited fields to return"""


class UpdateAtsScorecardRequest(BaseModel):
    ats_scorecard: Annotated[
        shared_atsscorecard.AtsScorecard,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    connection_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the connection"""

    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the Scorecard"""

    fields: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Comma-delimited fields to return"""


class UpdateAtsScorecardResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    ats_scorecard: NotRequired[shared_atsscorecard.AtsScorecardTypedDict]
    r"""Successful"""


class UpdateAtsScorecardResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    ats_scorecard: Optional[shared_atsscorecard.AtsScorecard] = None
    r"""Successful"""
