"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk.models.shared import crmlead as shared_crmlead
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)


class UpdateCrmLeadRequestTypedDict(TypedDict):
    crm_lead: shared_crmlead.CrmLeadTypedDict
    connection_id: str
    r"""ID of the connection"""
    id: str
    r"""ID of the Lead"""
    fields: NotRequired[List[str]]
    r"""Comma-delimited fields to return"""


class UpdateCrmLeadRequest(BaseModel):
    crm_lead: Annotated[
        shared_crmlead.CrmLead,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    connection_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the connection"""

    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the Lead"""

    fields: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Comma-delimited fields to return"""


class UpdateCrmLeadResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    crm_lead: NotRequired[shared_crmlead.CrmLeadTypedDict]
    r"""Successful"""


class UpdateCrmLeadResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    crm_lead: Optional[shared_crmlead.CrmLead] = None
    r"""Successful"""
