"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk.models.shared import (
    paymentsubscription as shared_paymentsubscription,
)
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)


class UpdatePaymentSubscriptionRequestTypedDict(TypedDict):
    payment_subscription: shared_paymentsubscription.PaymentSubscriptionTypedDict
    connection_id: str
    r"""ID of the connection"""
    id: str
    r"""ID of the Subscription"""
    fields: NotRequired[List[str]]
    r"""Comma-delimited fields to return"""


class UpdatePaymentSubscriptionRequest(BaseModel):
    payment_subscription: Annotated[
        shared_paymentsubscription.PaymentSubscription,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    connection_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the connection"""

    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the Subscription"""

    fields: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Comma-delimited fields to return"""


class UpdatePaymentSubscriptionResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    payment_subscription: NotRequired[
        shared_paymentsubscription.PaymentSubscriptionTypedDict
    ]
    r"""Successful"""


class UpdatePaymentSubscriptionResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    payment_subscription: Optional[shared_paymentsubscription.PaymentSubscription] = (
        None
    )
    r"""Successful"""
