"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk.models.shared import taskcomment as shared_taskcomment
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    RequestMetadata,
)


class UpdateTaskCommentRequestTypedDict(TypedDict):
    task_comment: shared_taskcomment.TaskCommentTypedDict
    connection_id: str
    r"""ID of the connection"""
    id: str
    r"""ID of the Comment"""
    fields: NotRequired[List[str]]
    r"""Comma-delimited fields to return"""


class UpdateTaskCommentRequest(BaseModel):
    task_comment: Annotated[
        shared_taskcomment.TaskComment,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    connection_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the connection"""

    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the Comment"""

    fields: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Comma-delimited fields to return"""


class UpdateTaskCommentResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    task_comment: NotRequired[shared_taskcomment.TaskCommentTypedDict]
    r"""Successful"""


class UpdateTaskCommentResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    task_comment: Optional[shared_taskcomment.TaskComment] = None
    r"""Successful"""
