"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .atsapplicationanswer import AtsApplicationAnswer, AtsApplicationAnswerTypedDict
from .atsmetadata import AtsMetadata, AtsMetadataTypedDict
from .atsoffer import AtsOffer, AtsOfferTypedDict
from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict
from unified_python_sdk.types import BaseModel


class AtsApplicationStatus(str, Enum):
    NEW = "NEW"
    REVIEWING = "REVIEWING"
    SCREENING = "SCREENING"
    SUBMITTED = "SUBMITTED"
    FIRST_INTERVIEW = "FIRST_INTERVIEW"
    SECOND_INTERVIEW = "SECOND_INTERVIEW"
    THIRD_INTERVIEW = "THIRD_INTERVIEW"
    BACKGROUND_CHECK = "BACKGROUND_CHECK"
    OFFERED = "OFFERED"
    ACCEPTED = "ACCEPTED"
    HIRED = "HIRED"
    REJECTED = "REJECTED"
    DECLINED = "DECLINED"
    WITHDRAWN = "WITHDRAWN"


class AtsApplicationTypedDict(TypedDict):
    answers: NotRequired[List[AtsApplicationAnswerTypedDict]]
    applied_at: NotRequired[datetime]
    candidate_id: NotRequired[str]
    created_at: NotRequired[datetime]
    hired_at: NotRequired[datetime]
    id: NotRequired[str]
    job_id: NotRequired[str]
    metadata: NotRequired[List[AtsMetadataTypedDict]]
    offers: NotRequired[List[AtsOfferTypedDict]]
    original_status: NotRequired[str]
    raw: NotRequired[Dict[str, Any]]
    rejected_at: NotRequired[datetime]
    rejected_reason: NotRequired[str]
    source: NotRequired[str]
    status: NotRequired[AtsApplicationStatus]
    updated_at: NotRequired[datetime]


class AtsApplication(BaseModel):
    answers: Optional[List[AtsApplicationAnswer]] = None

    applied_at: Optional[datetime] = None

    candidate_id: Optional[str] = None

    created_at: Optional[datetime] = None

    hired_at: Optional[datetime] = None

    id: Optional[str] = None

    job_id: Optional[str] = None

    metadata: Optional[List[AtsMetadata]] = None

    offers: Optional[List[AtsOffer]] = None

    original_status: Optional[str] = None

    raw: Optional[Dict[str, Any]] = None

    rejected_at: Optional[datetime] = None

    rejected_reason: Optional[str] = None

    source: Optional[str] = None

    status: Optional[AtsApplicationStatus] = None

    updated_at: Optional[datetime] = None
