"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from unified_python_sdk.types import BaseModel


class IssueStatus(str, Enum):
    COMPLETED = "COMPLETED"
    NEW = "NEW"
    ROADMAP = "ROADMAP"
    IN_PROGRESS = "IN_PROGRESS"
    ON_HOLD = "ON_HOLD"
    VALIDATING = "VALIDATING"
    REJECTED = "REJECTED"
    UP_NEXT = "UP_NEXT"


class IssueTypedDict(TypedDict):
    status: IssueStatus
    ticket_ref: str
    title: str
    workspace_id: str
    created_at: NotRequired[str]
    id: NotRequired[str]
    importance: NotRequired[float]
    resolution_time: NotRequired[float]
    size: NotRequired[float]
    type: NotRequired[List[str]]
    updated_at: NotRequired[str]
    url: NotRequired[str]


class Issue(BaseModel):
    status: IssueStatus

    ticket_ref: str

    title: str

    workspace_id: str

    created_at: Optional[str] = None

    id: Optional[str] = None

    importance: Optional[float] = None

    resolution_time: Optional[float] = None

    size: Optional[float] = None

    type: Optional[List[str]] = None

    updated_at: Optional[str] = None

    url: Optional[str] = None
