"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.P6Namer = void 0;
const fs = require("fs");
const path = require("path");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const lambdajs = require("@aws-cdk/aws-lambda-nodejs");
const cdk = require("@aws-cdk/core");
const cr = require("@aws-cdk/custom-resources");
/**
 * @stability stable
 */
class P6Namer extends cdk.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        const policy = new iam.PolicyStatement({
            actions: ['iam:CreateAccountAlias'],
            resources: ['*'],
            effect: iam.Effect.ALLOW,
        });
        // XXX: https://github.com/aws/aws-cdk/pull/11729
        const entry = fs.existsSync(path.join(__dirname, 'p6namer.p6namer.ts'))
            ? path.join(__dirname, 'p6namer.p6namer.ts') // local development
            : path.join(__dirname, 'p6namer.p6namer.js'); // when published in npm
        const onEvent = new lambdajs.NodejsFunction(this, 'p6namer', {
            entry,
            externalModules: [
                'aws-sdk',
            ],
            minify: true,
            runtime: lambda.Runtime.NODEJS_12_X,
            timeout: cdk.Duration.seconds(2),
            tracing: lambda.Tracing.ACTIVE,
        });
        onEvent.addToRolePolicy(policy);
        const provider = new cr.Provider(this, 'P6Namer/Provider', {
            onEventHandler: onEvent,
        });
        new cdk.CustomResource(this, 'P6Namer/CR', {
            serviceToken: provider.serviceToken,
            properties: {
                AccountAlias: props.accountAlias,
            },
        });
    }
}
exports.P6Namer = P6Namer;
//# sourceMappingURL=data:application/json;base64,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