/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.plugin;

import io.qameta.allure.Extension;
import io.qameta.allure.PluginConfiguration;
import io.qameta.allure.core.Plugin;
import io.qameta.allure.util.CopyVisitor;
import java.io.IOException;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;

public class DefaultPlugin
implements Plugin {
    private final PluginConfiguration configuration;
    private final List<Extension> extensions;
    private final Path pluginDirectory;

    public DefaultPlugin(PluginConfiguration configuration, List<Extension> extensions, Path pluginDirectory) {
        this.configuration = configuration;
        this.extensions = extensions;
        this.pluginDirectory = pluginDirectory;
    }

    public PluginConfiguration getConfig() {
        return this.configuration;
    }

    public void unpackReportStatic(Path outputDirectory) throws IOException {
        Path pluginStatic = this.pluginDirectory.resolve("static");
        if (Files.exists(pluginStatic, new LinkOption[0])) {
            Files.walkFileTree(pluginStatic, (FileVisitor<? super Path>)new CopyVisitor(pluginStatic, outputDirectory));
        }
    }

    public List<Extension> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }
}

