# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/powerbi/s3Config.json
#   timestamp: 2025-02-06T10:15:59+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ......security.credentials import awsCredentials
from . import bucketDetails


class PbitFileConfigType(Enum):
    s3 = 's3'


class S3Config(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    pbitFileConfigType: Annotated[
        Optional[PbitFileConfigType],
        Field(PbitFileConfigType.s3, description='pbit File Configuration type'),
    ]
    securityConfig: Annotated[
        awsCredentials.AWSCredentials, Field(title='S3 Security Config')
    ]
    prefixConfig: Annotated[
        Optional[bucketDetails.BucketDetails], Field(None, title='Prefix Config')
    ]
    pbitFilesExtractDir: Annotated[
        Optional[str],
        Field(
            '/tmp/pbitFiles',
            description='Path of the folder where the .pbit files will be unzipped and datamodel schema will be extracted',
            title='pbit Files Extraction Directory',
        ),
    ]
